/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.Base;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.Configuration;
import org.hl7.fhir.instance.model.Contract;
import org.hl7.fhir.instance.model.DomainResource;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.PositiveIntType;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Reference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Coverage", profile="http://hl7.org/fhir/Profile/Coverage")
public class Coverage
extends DomainResource {
    @Child(name="issuer", type={Organization.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="An identifier for the plan issuer", formalDefinition="The program or plan underwriter or payor.")
    protected Reference issuer;
    protected Organization issuerTarget;
    @Child(name="bin", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="BIN Number", formalDefinition="Business Identification Number (BIN number) used to identify the routing  of eclaims if the insurer themselves don't have a BIN number for all of their business.")
    protected Identifier bin;
    @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Coverage start and end dates", formalDefinition="Time period during which the coverage is in force. A missing start date indicates the start date isn't known, a missing end date means the coverage is continuing to be in force.")
    protected Period period;
    @Child(name="type", type={Coding.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of coverage", formalDefinition="The type of coverage: social program, medical plan, accident coverage (workers compensation, auto), group health.")
    protected Coding type;
    @Child(name="subscriberId", type={Identifier.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Subscriber ID", formalDefinition="The id issued to the subscriber.")
    protected Identifier subscriberId;
    @Child(name="identifier", type={Identifier.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The primary coverage ID", formalDefinition="The main (and possibly only) identifier for the coverage - often referred to as a Member Id, Subscriber Id, Certificate number or Personal Health Number or Case ID.")
    protected List<Identifier> identifier;
    @Child(name="group", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="An identifier for the group", formalDefinition="Identifies a style or collective of coverage issues by the underwriter, for example may be used to identify a class of coverage or employer group. May also be referred to as a Policy or Group ID.")
    protected StringType group;
    @Child(name="plan", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="An identifier for the plan", formalDefinition="Identifies a style or collective of coverage issues by the underwriter, for example may be used to identify a class of coverage or employer group. May also be referred to as a Policy or Group ID.")
    protected StringType plan;
    @Child(name="subPlan", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="An identifier for the subsection of the plan", formalDefinition="Identifies a sub-style or sub-collective of coverage issues by the underwriter, for example may be used to identify a specific employer group within a class of employers. May be referred to as a Section or Division ID.")
    protected StringType subPlan;
    @Child(name="dependent", type={PositiveIntType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The dependent number", formalDefinition="A unique identifier for a dependent under the coverage.")
    protected PositiveIntType dependent;
    @Child(name="sequence", type={PositiveIntType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The plan instance or sequence counter", formalDefinition="An optional counter for a particular instance of the identified coverage which increments upon each renewal.")
    protected PositiveIntType sequence;
    @Child(name="subscriber", type={Patient.class}, order=11, min=0, max=1, modifier=true, summary=false)
    @Description(shortDefinition="Plan holder information", formalDefinition="The party who 'owns' the insurance contractual relationship to the policy or to whom the benefit of the policy is due.")
    protected Reference subscriber;
    protected Patient subscriberTarget;
    @Child(name="network", type={Identifier.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Insurer network", formalDefinition="The identifier for a community of providers.")
    protected Identifier network;
    @Child(name="contract", type={Contract.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract details", formalDefinition="The policy(s) which constitute this insurance coverage.")
    protected List<Reference> contract;
    protected List<Contract> contractTarget;
    private static final long serialVersionUID = -1312031251L;
    @SearchParamDefinition(name="identifier", path="Coverage.identifier", description="The primary identifier of the insured", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="sequence", path="Coverage.sequence", description="Sequence number", type="token")
    public static final String SP_SEQUENCE = "sequence";
    @SearchParamDefinition(name="subplan", path="Coverage.subPlan", description="Sub-plan identifier", type="token")
    public static final String SP_SUBPLAN = "subplan";
    @SearchParamDefinition(name="type", path="Coverage.type", description="The kind of coverage", type="token")
    public static final String SP_TYPE = "type";
    @SearchParamDefinition(name="plan", path="Coverage.plan", description="A plan or policy identifier", type="token")
    public static final String SP_PLAN = "plan";
    @SearchParamDefinition(name="dependent", path="Coverage.dependent", description="Dependent number", type="token")
    public static final String SP_DEPENDENT = "dependent";
    @SearchParamDefinition(name="issuer", path="Coverage.issuer", description="The identity of the insurer", type="reference")
    public static final String SP_ISSUER = "issuer";
    @SearchParamDefinition(name="group", path="Coverage.group", description="Group identifier", type="token")
    public static final String SP_GROUP = "group";

    public Reference getIssuer() {
        if (this.issuer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.issuer");
            }
            if (Configuration.doAutoCreate()) {
                this.issuer = new Reference();
            }
        }
        return this.issuer;
    }

    public boolean hasIssuer() {
        return this.issuer != null && !this.issuer.isEmpty();
    }

    public Coverage setIssuer(Reference value) {
        this.issuer = value;
        return this;
    }

    public Organization getIssuerTarget() {
        if (this.issuerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.issuer");
            }
            if (Configuration.doAutoCreate()) {
                this.issuerTarget = new Organization();
            }
        }
        return this.issuerTarget;
    }

    public Coverage setIssuerTarget(Organization value) {
        this.issuerTarget = value;
        return this;
    }

    public Identifier getBin() {
        if (this.bin == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.bin");
            }
            if (Configuration.doAutoCreate()) {
                this.bin = new Identifier();
            }
        }
        return this.bin;
    }

    public boolean hasBin() {
        return this.bin != null && !this.bin.isEmpty();
    }

    public Coverage setBin(Identifier value) {
        this.bin = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Coverage setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Coding getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Coding();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Coverage setType(Coding value) {
        this.type = value;
        return this;
    }

    public Identifier getSubscriberId() {
        if (this.subscriberId == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.subscriberId");
            }
            if (Configuration.doAutoCreate()) {
                this.subscriberId = new Identifier();
            }
        }
        return this.subscriberId;
    }

    public boolean hasSubscriberId() {
        return this.subscriberId != null && !this.subscriberId.isEmpty();
    }

    public Coverage setSubscriberId(Identifier value) {
        this.subscriberId = value;
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Coverage addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public StringType getGroupElement() {
        if (this.group == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.group");
            }
            if (Configuration.doAutoCreate()) {
                this.group = new StringType();
            }
        }
        return this.group;
    }

    public boolean hasGroupElement() {
        return this.group != null && !this.group.isEmpty();
    }

    public boolean hasGroup() {
        return this.group != null && !this.group.isEmpty();
    }

    public Coverage setGroupElement(StringType value) {
        this.group = value;
        return this;
    }

    public String getGroup() {
        return this.group == null ? null : (String)this.group.getValue();
    }

    public Coverage setGroup(String value) {
        if (Utilities.noString((String)value)) {
            this.group = null;
        } else {
            if (this.group == null) {
                this.group = new StringType();
            }
            this.group.setValue(value);
        }
        return this;
    }

    public StringType getPlanElement() {
        if (this.plan == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.plan");
            }
            if (Configuration.doAutoCreate()) {
                this.plan = new StringType();
            }
        }
        return this.plan;
    }

    public boolean hasPlanElement() {
        return this.plan != null && !this.plan.isEmpty();
    }

    public boolean hasPlan() {
        return this.plan != null && !this.plan.isEmpty();
    }

    public Coverage setPlanElement(StringType value) {
        this.plan = value;
        return this;
    }

    public String getPlan() {
        return this.plan == null ? null : (String)this.plan.getValue();
    }

    public Coverage setPlan(String value) {
        if (Utilities.noString((String)value)) {
            this.plan = null;
        } else {
            if (this.plan == null) {
                this.plan = new StringType();
            }
            this.plan.setValue(value);
        }
        return this;
    }

    public StringType getSubPlanElement() {
        if (this.subPlan == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.subPlan");
            }
            if (Configuration.doAutoCreate()) {
                this.subPlan = new StringType();
            }
        }
        return this.subPlan;
    }

    public boolean hasSubPlanElement() {
        return this.subPlan != null && !this.subPlan.isEmpty();
    }

    public boolean hasSubPlan() {
        return this.subPlan != null && !this.subPlan.isEmpty();
    }

    public Coverage setSubPlanElement(StringType value) {
        this.subPlan = value;
        return this;
    }

    public String getSubPlan() {
        return this.subPlan == null ? null : (String)this.subPlan.getValue();
    }

    public Coverage setSubPlan(String value) {
        if (Utilities.noString((String)value)) {
            this.subPlan = null;
        } else {
            if (this.subPlan == null) {
                this.subPlan = new StringType();
            }
            this.subPlan.setValue(value);
        }
        return this;
    }

    public PositiveIntType getDependentElement() {
        if (this.dependent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.dependent");
            }
            if (Configuration.doAutoCreate()) {
                this.dependent = new PositiveIntType();
            }
        }
        return this.dependent;
    }

    public boolean hasDependentElement() {
        return this.dependent != null && !this.dependent.isEmpty();
    }

    public boolean hasDependent() {
        return this.dependent != null && !this.dependent.isEmpty();
    }

    public Coverage setDependentElement(PositiveIntType value) {
        this.dependent = value;
        return this;
    }

    public int getDependent() {
        return this.dependent == null || this.dependent.isEmpty() ? 0 : (Integer)this.dependent.getValue();
    }

    public Coverage setDependent(int value) {
        if (this.dependent == null) {
            this.dependent = new PositiveIntType();
        }
        this.dependent.setValue((Object)value);
        return this;
    }

    public PositiveIntType getSequenceElement() {
        if (this.sequence == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.sequence");
            }
            if (Configuration.doAutoCreate()) {
                this.sequence = new PositiveIntType();
            }
        }
        return this.sequence;
    }

    public boolean hasSequenceElement() {
        return this.sequence != null && !this.sequence.isEmpty();
    }

    public boolean hasSequence() {
        return this.sequence != null && !this.sequence.isEmpty();
    }

    public Coverage setSequenceElement(PositiveIntType value) {
        this.sequence = value;
        return this;
    }

    public int getSequence() {
        return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
    }

    public Coverage setSequence(int value) {
        if (this.sequence == null) {
            this.sequence = new PositiveIntType();
        }
        this.sequence.setValue((Object)value);
        return this;
    }

    public Reference getSubscriber() {
        if (this.subscriber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.subscriber");
            }
            if (Configuration.doAutoCreate()) {
                this.subscriber = new Reference();
            }
        }
        return this.subscriber;
    }

    public boolean hasSubscriber() {
        return this.subscriber != null && !this.subscriber.isEmpty();
    }

    public Coverage setSubscriber(Reference value) {
        this.subscriber = value;
        return this;
    }

    public Patient getSubscriberTarget() {
        if (this.subscriberTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.subscriber");
            }
            if (Configuration.doAutoCreate()) {
                this.subscriberTarget = new Patient();
            }
        }
        return this.subscriberTarget;
    }

    public Coverage setSubscriberTarget(Patient value) {
        this.subscriberTarget = value;
        return this;
    }

    public Identifier getNetwork() {
        if (this.network == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.network");
            }
            if (Configuration.doAutoCreate()) {
                this.network = new Identifier();
            }
        }
        return this.network;
    }

    public boolean hasNetwork() {
        return this.network != null && !this.network.isEmpty();
    }

    public Coverage setNetwork(Identifier value) {
        this.network = value;
        return this;
    }

    public List<Reference> getContract() {
        if (this.contract == null) {
            this.contract = new ArrayList<Reference>();
        }
        return this.contract;
    }

    public boolean hasContract() {
        if (this.contract == null) {
            return false;
        }
        for (Reference item : this.contract) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addContract() {
        Reference t = new Reference();
        if (this.contract == null) {
            this.contract = new ArrayList<Reference>();
        }
        this.contract.add(t);
        return t;
    }

    public Coverage addContract(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.contract == null) {
            this.contract = new ArrayList<Reference>();
        }
        this.contract.add(t);
        return this;
    }

    public List<Contract> getContractTarget() {
        if (this.contractTarget == null) {
            this.contractTarget = new ArrayList<Contract>();
        }
        return this.contractTarget;
    }

    public Contract addContractTarget() {
        Contract r = new Contract();
        if (this.contractTarget == null) {
            this.contractTarget = new ArrayList<Contract>();
        }
        this.contractTarget.add(r);
        return r;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_ISSUER, "Reference(Organization)", "The program or plan underwriter or payor.", 0, Integer.MAX_VALUE, this.issuer));
        childrenList.add(new Property("bin", "Identifier", "Business Identification Number (BIN number) used to identify the routing  of eclaims if the insurer themselves don't have a BIN number for all of their business.", 0, Integer.MAX_VALUE, this.bin));
        childrenList.add(new Property("period", "Period", "Time period during which the coverage is in force. A missing start date indicates the start date isn't known, a missing end date means the coverage is continuing to be in force.", 0, Integer.MAX_VALUE, this.period));
        childrenList.add(new Property(SP_TYPE, "Coding", "The type of coverage: social program, medical plan, accident coverage (workers compensation, auto), group health.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("subscriberId", "Identifier", "The id issued to the subscriber.", 0, Integer.MAX_VALUE, this.subscriberId));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "The main (and possibly only) identifier for the coverage - often referred to as a Member Id, Subscriber Id, Certificate number or Personal Health Number or Case ID.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_GROUP, "string", "Identifies a style or collective of coverage issues by the underwriter, for example may be used to identify a class of coverage or employer group. May also be referred to as a Policy or Group ID.", 0, Integer.MAX_VALUE, this.group));
        childrenList.add(new Property(SP_PLAN, "string", "Identifies a style or collective of coverage issues by the underwriter, for example may be used to identify a class of coverage or employer group. May also be referred to as a Policy or Group ID.", 0, Integer.MAX_VALUE, this.plan));
        childrenList.add(new Property("subPlan", "string", "Identifies a sub-style or sub-collective of coverage issues by the underwriter, for example may be used to identify a specific employer group within a class of employers. May be referred to as a Section or Division ID.", 0, Integer.MAX_VALUE, this.subPlan));
        childrenList.add(new Property(SP_DEPENDENT, "positiveInt", "A unique identifier for a dependent under the coverage.", 0, Integer.MAX_VALUE, this.dependent));
        childrenList.add(new Property(SP_SEQUENCE, "positiveInt", "An optional counter for a particular instance of the identified coverage which increments upon each renewal.", 0, Integer.MAX_VALUE, this.sequence));
        childrenList.add(new Property("subscriber", "Reference(Patient)", "The party who 'owns' the insurance contractual relationship to the policy or to whom the benefit of the policy is due.", 0, Integer.MAX_VALUE, this.subscriber));
        childrenList.add(new Property("network", "Identifier", "The identifier for a community of providers.", 0, Integer.MAX_VALUE, this.network));
        childrenList.add(new Property("contract", "Reference(Contract)", "The policy(s) which constitute this insurance coverage.", 0, Integer.MAX_VALUE, this.contract));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_ISSUER)) {
            this.issuer = this.castToReference(value);
        } else if (name.equals("bin")) {
            this.bin = this.castToIdentifier(value);
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCoding(value);
        } else if (name.equals("subscriberId")) {
            this.subscriberId = this.castToIdentifier(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_GROUP)) {
            this.group = this.castToString(value);
        } else if (name.equals(SP_PLAN)) {
            this.plan = this.castToString(value);
        } else if (name.equals("subPlan")) {
            this.subPlan = this.castToString(value);
        } else if (name.equals(SP_DEPENDENT)) {
            this.dependent = this.castToPositiveInt(value);
        } else if (name.equals(SP_SEQUENCE)) {
            this.sequence = this.castToPositiveInt(value);
        } else if (name.equals("subscriber")) {
            this.subscriber = this.castToReference(value);
        } else if (name.equals("network")) {
            this.network = this.castToIdentifier(value);
        } else if (name.equals("contract")) {
            this.getContract().add(this.castToReference(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_ISSUER)) {
            this.issuer = new Reference();
            return this.issuer;
        }
        if (name.equals("bin")) {
            this.bin = new Identifier();
            return this.bin;
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_TYPE)) {
            this.type = new Coding();
            return this.type;
        }
        if (name.equals("subscriberId")) {
            this.subscriberId = new Identifier();
            return this.subscriberId;
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_GROUP)) {
            throw new FHIRException("Cannot call addChild on a primitive type Coverage.group");
        }
        if (name.equals(SP_PLAN)) {
            throw new FHIRException("Cannot call addChild on a primitive type Coverage.plan");
        }
        if (name.equals("subPlan")) {
            throw new FHIRException("Cannot call addChild on a primitive type Coverage.subPlan");
        }
        if (name.equals(SP_DEPENDENT)) {
            throw new FHIRException("Cannot call addChild on a primitive type Coverage.dependent");
        }
        if (name.equals(SP_SEQUENCE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Coverage.sequence");
        }
        if (name.equals("subscriber")) {
            this.subscriber = new Reference();
            return this.subscriber;
        }
        if (name.equals("network")) {
            this.network = new Identifier();
            return this.network;
        }
        if (name.equals("contract")) {
            return this.addContract();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Coverage";
    }

    @Override
    public Coverage copy() {
        Coverage dst = new Coverage();
        this.copyValues(dst);
        dst.issuer = this.issuer == null ? null : this.issuer.copy();
        dst.bin = this.bin == null ? null : this.bin.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.type = this.type == null ? null : this.type.copy();
        Identifier identifier = dst.subscriberId = this.subscriberId == null ? null : this.subscriberId.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier2 : this.identifier) {
                dst.identifier.add(identifier2.copy());
            }
        }
        dst.group = this.group == null ? null : this.group.copy();
        dst.plan = this.plan == null ? null : this.plan.copy();
        dst.subPlan = this.subPlan == null ? null : this.subPlan.copy();
        dst.dependent = this.dependent == null ? null : this.dependent.copy();
        dst.sequence = this.sequence == null ? null : this.sequence.copy();
        dst.subscriber = this.subscriber == null ? null : this.subscriber.copy();
        Identifier identifier3 = dst.network = this.network == null ? null : this.network.copy();
        if (this.contract != null) {
            dst.contract = new ArrayList<Reference>();
            for (Reference reference : this.contract) {
                dst.contract.add(reference.copy());
            }
        }
        return dst;
    }

    protected Coverage typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Coverage)) {
            return false;
        }
        Coverage o = (Coverage)other;
        return Coverage.compareDeep(this.issuer, o.issuer, true) && Coverage.compareDeep(this.bin, o.bin, true) && Coverage.compareDeep(this.period, o.period, true) && Coverage.compareDeep(this.type, o.type, true) && Coverage.compareDeep(this.subscriberId, o.subscriberId, true) && Coverage.compareDeep(this.identifier, o.identifier, true) && Coverage.compareDeep(this.group, o.group, true) && Coverage.compareDeep(this.plan, o.plan, true) && Coverage.compareDeep(this.subPlan, o.subPlan, true) && Coverage.compareDeep(this.dependent, o.dependent, true) && Coverage.compareDeep(this.sequence, o.sequence, true) && Coverage.compareDeep(this.subscriber, o.subscriber, true) && Coverage.compareDeep(this.network, o.network, true) && Coverage.compareDeep(this.contract, o.contract, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Coverage)) {
            return false;
        }
        Coverage o = (Coverage)other;
        return Coverage.compareValues(this.group, o.group, true) && Coverage.compareValues(this.plan, o.plan, true) && Coverage.compareValues(this.subPlan, o.subPlan, true) && Coverage.compareValues(this.dependent, o.dependent, true) && Coverage.compareValues(this.sequence, o.sequence, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.issuer != null && !this.issuer.isEmpty() || this.bin != null && !this.bin.isEmpty() || this.period != null && !this.period.isEmpty() || this.type != null && !this.type.isEmpty() || this.subscriberId != null && !this.subscriberId.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.group != null && !this.group.isEmpty() || this.plan != null && !this.plan.isEmpty() || this.subPlan != null && !this.subPlan.isEmpty() || this.dependent != null && !this.dependent.isEmpty() || this.sequence != null && !this.sequence.isEmpty() || this.subscriber != null && !this.subscriber.isEmpty() || this.network != null && !this.network.isEmpty() || this.contract != null && !this.contract.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Coverage;
    }
}

