/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.Base;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.Configuration;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.UriType;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Coding")
public class Coding
extends Type
implements IBaseCoding,
ICompositeType {
    @Child(name="system", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identity of the terminology system", formalDefinition="The identification of the code system that defines the meaning of the symbol in the code.")
    protected UriType system;
    @Child(name="version", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Version of the system - if relevant", formalDefinition="The version of the code system which was used when choosing this code. Note that a well-maintained code system does not need the version reported, because the meaning of codes is consistent across versions. However this cannot consistently be assured. and when the meaning is not guaranteed to be consistent, the version SHOULD be exchanged.")
    protected StringType version;
    @Child(name="code", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Symbol in syntax defined by the system", formalDefinition="A symbol in syntax defined by the system. The symbol may be a predefined code or an expression in a syntax defined by the coding system (e.g. post-coordination).")
    protected CodeType code;
    @Child(name="display", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Representation defined by the system", formalDefinition="A representation of the meaning of the code in the system, following the rules of the system.")
    protected StringType display;
    @Child(name="userSelected", type={BooleanType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If this coding was chosen directly by the user", formalDefinition="Indicates that this coding was chosen by a user directly - i.e. off a pick list of available items (codes or displays).")
    protected BooleanType userSelected;
    private static final long serialVersionUID = -1417514061L;

    public UriType getSystemElement() {
        if (this.system == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coding.system");
            }
            if (Configuration.doAutoCreate()) {
                this.system = new UriType();
            }
        }
        return this.system;
    }

    public boolean hasSystemElement() {
        return this.system != null && !this.system.isEmpty();
    }

    public boolean hasSystem() {
        return this.system != null && !this.system.isEmpty();
    }

    public Coding setSystemElement(UriType value) {
        this.system = value;
        return this;
    }

    public String getSystem() {
        return this.system == null ? null : (String)this.system.getValue();
    }

    public Coding setSystem(String value) {
        if (Utilities.noString((String)value)) {
            this.system = null;
        } else {
            if (this.system == null) {
                this.system = new UriType();
            }
            this.system.setValue(value);
        }
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coding.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public Coding setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public Coding setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public CodeType getCodeElement() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coding.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeType();
            }
        }
        return this.code;
    }

    public boolean hasCodeElement() {
        return this.code != null && !this.code.isEmpty();
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Coding setCodeElement(CodeType value) {
        this.code = value;
        return this;
    }

    public String getCode() {
        return this.code == null ? null : (String)this.code.getValue();
    }

    public Coding setCode(String value) {
        if (Utilities.noString((String)value)) {
            this.code = null;
        } else {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
        }
        return this;
    }

    public StringType getDisplayElement() {
        if (this.display == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coding.display");
            }
            if (Configuration.doAutoCreate()) {
                this.display = new StringType();
            }
        }
        return this.display;
    }

    public boolean hasDisplayElement() {
        return this.display != null && !this.display.isEmpty();
    }

    public boolean hasDisplay() {
        return this.display != null && !this.display.isEmpty();
    }

    public Coding setDisplayElement(StringType value) {
        this.display = value;
        return this;
    }

    public String getDisplay() {
        return this.display == null ? null : (String)this.display.getValue();
    }

    public Coding setDisplay(String value) {
        if (Utilities.noString((String)value)) {
            this.display = null;
        } else {
            if (this.display == null) {
                this.display = new StringType();
            }
            this.display.setValue(value);
        }
        return this;
    }

    public BooleanType getUserSelectedElement() {
        if (this.userSelected == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coding.userSelected");
            }
            if (Configuration.doAutoCreate()) {
                this.userSelected = new BooleanType();
            }
        }
        return this.userSelected;
    }

    public boolean hasUserSelectedElement() {
        return this.userSelected != null && !this.userSelected.isEmpty();
    }

    public boolean hasUserSelected() {
        return this.userSelected != null && !this.userSelected.isEmpty();
    }

    public Coding setUserSelectedElement(BooleanType value) {
        this.userSelected = value;
        return this;
    }

    public boolean getUserSelected() {
        return this.userSelected == null || this.userSelected.isEmpty() ? false : (Boolean)this.userSelected.getValue();
    }

    public Coding setUserSelected(boolean value) {
        if (this.userSelected == null) {
            this.userSelected = new BooleanType();
        }
        this.userSelected.setValue((Object)value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("system", "uri", "The identification of the code system that defines the meaning of the symbol in the code.", 0, Integer.MAX_VALUE, this.system));
        childrenList.add(new Property("version", "string", "The version of the code system which was used when choosing this code. Note that a well-maintained code system does not need the version reported, because the meaning of codes is consistent across versions. However this cannot consistently be assured. and when the meaning is not guaranteed to be consistent, the version SHOULD be exchanged.", 0, Integer.MAX_VALUE, this.version));
        childrenList.add(new Property("code", "code", "A symbol in syntax defined by the system. The symbol may be a predefined code or an expression in a syntax defined by the coding system (e.g. post-coordination).", 0, Integer.MAX_VALUE, this.code));
        childrenList.add(new Property("display", "string", "A representation of the meaning of the code in the system, following the rules of the system.", 0, Integer.MAX_VALUE, this.display));
        childrenList.add(new Property("userSelected", "boolean", "Indicates that this coding was chosen by a user directly - i.e. off a pick list of available items (codes or displays).", 0, Integer.MAX_VALUE, this.userSelected));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("system")) {
            this.system = this.castToUri(value);
        } else if (name.equals("version")) {
            this.version = this.castToString(value);
        } else if (name.equals("code")) {
            this.code = this.castToCode(value);
        } else if (name.equals("display")) {
            this.display = this.castToString(value);
        } else if (name.equals("userSelected")) {
            this.userSelected = this.castToBoolean(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("system")) {
            throw new FHIRException("Cannot call addChild on a primitive type Coding.system");
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a primitive type Coding.version");
        }
        if (name.equals("code")) {
            throw new FHIRException("Cannot call addChild on a primitive type Coding.code");
        }
        if (name.equals("display")) {
            throw new FHIRException("Cannot call addChild on a primitive type Coding.display");
        }
        if (name.equals("userSelected")) {
            throw new FHIRException("Cannot call addChild on a primitive type Coding.userSelected");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Coding";
    }

    @Override
    public Coding copy() {
        Coding dst = new Coding();
        this.copyValues(dst);
        dst.system = this.system == null ? null : this.system.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.display = this.display == null ? null : this.display.copy();
        dst.userSelected = this.userSelected == null ? null : this.userSelected.copy();
        return dst;
    }

    @Override
    protected Coding typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Coding)) {
            return false;
        }
        Coding o = (Coding)other;
        return Coding.compareDeep(this.system, o.system, true) && Coding.compareDeep(this.version, o.version, true) && Coding.compareDeep(this.code, o.code, true) && Coding.compareDeep(this.display, o.display, true) && Coding.compareDeep(this.userSelected, o.userSelected, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Coding)) {
            return false;
        }
        Coding o = (Coding)other;
        return Coding.compareValues(this.system, o.system, true) && Coding.compareValues(this.version, o.version, true) && Coding.compareValues(this.code, o.code, true) && Coding.compareValues(this.display, o.display, true) && Coding.compareValues(this.userSelected, o.userSelected, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.system != null && !this.system.isEmpty() || this.version != null && !this.version.isEmpty() || this.code != null && !this.code.isEmpty() || this.display != null && !this.display.isEmpty() || this.userSelected != null && !this.userSelected.isEmpty());
    }
}

