/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import org.hl7.fhir.instance.model.PrimitiveType;
import org.hl7.fhir.instance.model.api.IBaseBooleanDatatype;

@DatatypeDef(name="boolean")
public class BooleanType
extends PrimitiveType<Boolean>
implements IBaseBooleanDatatype {
    private static final long serialVersionUID = 3L;

    public BooleanType() {
    }

    public BooleanType(boolean theBoolean) {
        this.setValue((Object)theBoolean);
    }

    public BooleanType(Boolean theBoolean) {
        this.setValue(theBoolean);
    }

    public BooleanType(String value) {
        this.setValueAsString(value);
    }

    @Override
    protected Boolean parse(String theValue) {
        String value = theValue.trim();
        if ("true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Invalid boolean string: '" + theValue + "'");
    }

    @Override
    protected String encode(Boolean theValue) {
        if (Boolean.TRUE.equals(theValue)) {
            return "true";
        }
        return "false";
    }

    @Override
    public BooleanType copy() {
        return new BooleanType((Boolean)this.getValue());
    }

    @Override
    public String fhirType() {
        return "boolean";
    }

    public boolean booleanValue() {
        return (Boolean)this.getValue();
    }
}

