/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.support.IContextValidationSupport;
import ca.uhn.fhir.fluentpath.IFluentPath;
import ca.uhn.fhir.model.api.IFhirVersion;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.server.provider.dstu2hl7org.Dstu2Hl7OrgBundleFactory;
import ca.uhn.fhir.util.ReflectionUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.Reference;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.StructureDefinition;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class FhirDstu2Hl7Org
implements IFhirVersion {
    private String myId;

    public IFluentPath createFluentPathExecutor(FhirContext theFhirContext) {
        throw new UnsupportedOperationException("FluentPath is not supported in DSTU2 contexts");
    }

    public IContextValidationSupport<?, ?, ?, ?, ?, ?> createValidationSupport() {
        throw new UnsupportedOperationException("Validation support is not supported in DSTU2 contexts");
    }

    public StructureDefinition generateProfile(RuntimeResourceDefinition theRuntimeResourceDefinition, String theServerBase) {
        StructureDefinition retVal = new StructureDefinition();
        RuntimeResourceDefinition def = theRuntimeResourceDefinition;
        this.myId = def.getId();
        if (StringUtils.isBlank((CharSequence)this.myId)) {
            this.myId = theRuntimeResourceDefinition.getName().toLowerCase();
        }
        retVal.setId(this.myId);
        return retVal;
    }

    public Class<ArrayList> getContainedType() {
        return ArrayList.class;
    }

    public InputStream getFhirVersionPropertiesFile() {
        String path = "/org/hl7/fhir/instance/model/fhirversion.properties";
        InputStream str = FhirDstu2Hl7Org.class.getResourceAsStream(path);
        if (str == null) {
            str = FhirDstu2Hl7Org.class.getResourceAsStream(path.substring(1));
        }
        if (str == null) {
            throw new ConfigurationException("Can not find model property file on classpath: " + path);
        }
        return str;
    }

    public IPrimitiveType<Date> getLastUpdated(IBaseResource theResource) {
        return ((Resource)theResource).getMeta().getLastUpdatedElement();
    }

    public String getPathToSchemaDefinitions() {
        return "/org/hl7/fhir/instance/model/schema";
    }

    public Class<Reference> getResourceReferenceType() {
        return Reference.class;
    }

    public Object getServerVersion() {
        return ReflectionUtil.newInstanceOfFhirServerType((String)"org.hl7.fhir.instance.FhirServerDstu2Hl7Org2");
    }

    public FhirVersionEnum getVersion() {
        return FhirVersionEnum.DSTU2_HL7ORG;
    }

    public IVersionSpecificBundleFactory newBundleFactory(FhirContext theContext) {
        return new Dstu2Hl7OrgBundleFactory(theContext);
    }

    public BaseCodingDt newCodingDt() {
        throw new UnsupportedOperationException();
    }

    public IIdType newIdType() {
        return new IdType();
    }
}

