/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.impl;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.IRuntimeDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.CacheControlDirective;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.PatchTypeEnum;
import ca.uhn.fhir.rest.api.PreferReturnEnum;
import ca.uhn.fhir.rest.api.SearchStyleEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.exceptions.NonFhirResponseException;
import ca.uhn.fhir.rest.client.impl.BaseClient;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.impl.RestfulClientFactory;
import ca.uhn.fhir.rest.client.method.DeleteMethodBinding;
import ca.uhn.fhir.rest.client.method.HistoryMethodBinding;
import ca.uhn.fhir.rest.client.method.HttpDeleteClientInvocation;
import ca.uhn.fhir.rest.client.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.client.method.HttpPatchClientInvocation;
import ca.uhn.fhir.rest.client.method.HttpPostClientInvocation;
import ca.uhn.fhir.rest.client.method.HttpPutClientInvocation;
import ca.uhn.fhir.rest.client.method.HttpSimpleGetClientInvocation;
import ca.uhn.fhir.rest.client.method.IClientResponseHandler;
import ca.uhn.fhir.rest.client.method.MethodUtil;
import ca.uhn.fhir.rest.client.method.OperationMethodBinding;
import ca.uhn.fhir.rest.client.method.ReadMethodBinding;
import ca.uhn.fhir.rest.client.method.SearchMethodBinding;
import ca.uhn.fhir.rest.client.method.SortParameter;
import ca.uhn.fhir.rest.client.method.TransactionMethodBinding;
import ca.uhn.fhir.rest.client.method.ValidateMethodBindingDstu2Plus;
import ca.uhn.fhir.rest.gclient.IBaseQuery;
import ca.uhn.fhir.rest.gclient.IClientExecutable;
import ca.uhn.fhir.rest.gclient.ICreate;
import ca.uhn.fhir.rest.gclient.ICreateTyped;
import ca.uhn.fhir.rest.gclient.ICreateWithQuery;
import ca.uhn.fhir.rest.gclient.ICreateWithQueryTyped;
import ca.uhn.fhir.rest.gclient.ICriterion;
import ca.uhn.fhir.rest.gclient.ICriterionInternal;
import ca.uhn.fhir.rest.gclient.IDelete;
import ca.uhn.fhir.rest.gclient.IDeleteTyped;
import ca.uhn.fhir.rest.gclient.IDeleteWithQuery;
import ca.uhn.fhir.rest.gclient.IDeleteWithQueryTyped;
import ca.uhn.fhir.rest.gclient.IFetchConformanceTyped;
import ca.uhn.fhir.rest.gclient.IFetchConformanceUntyped;
import ca.uhn.fhir.rest.gclient.IGetPage;
import ca.uhn.fhir.rest.gclient.IGetPageTyped;
import ca.uhn.fhir.rest.gclient.IGetPageUntyped;
import ca.uhn.fhir.rest.gclient.IHistory;
import ca.uhn.fhir.rest.gclient.IHistoryTyped;
import ca.uhn.fhir.rest.gclient.IHistoryUntyped;
import ca.uhn.fhir.rest.gclient.IMeta;
import ca.uhn.fhir.rest.gclient.IMetaAddOrDeleteSourced;
import ca.uhn.fhir.rest.gclient.IMetaAddOrDeleteUnsourced;
import ca.uhn.fhir.rest.gclient.IMetaGetUnsourced;
import ca.uhn.fhir.rest.gclient.IOperation;
import ca.uhn.fhir.rest.gclient.IOperationProcessMsg;
import ca.uhn.fhir.rest.gclient.IOperationProcessMsgMode;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import ca.uhn.fhir.rest.gclient.IOperationUntyped;
import ca.uhn.fhir.rest.gclient.IOperationUntypedWithInput;
import ca.uhn.fhir.rest.gclient.IOperationUntypedWithInputAndPartialOutput;
import ca.uhn.fhir.rest.gclient.IParam;
import ca.uhn.fhir.rest.gclient.IPatch;
import ca.uhn.fhir.rest.gclient.IPatchExecutable;
import ca.uhn.fhir.rest.gclient.IPatchWithBody;
import ca.uhn.fhir.rest.gclient.IPatchWithQuery;
import ca.uhn.fhir.rest.gclient.IPatchWithQueryTyped;
import ca.uhn.fhir.rest.gclient.IQuery;
import ca.uhn.fhir.rest.gclient.IRead;
import ca.uhn.fhir.rest.gclient.IReadExecutable;
import ca.uhn.fhir.rest.gclient.IReadIfNoneMatch;
import ca.uhn.fhir.rest.gclient.IReadTyped;
import ca.uhn.fhir.rest.gclient.ISort;
import ca.uhn.fhir.rest.gclient.ITransaction;
import ca.uhn.fhir.rest.gclient.ITransactionTyped;
import ca.uhn.fhir.rest.gclient.IUntypedQuery;
import ca.uhn.fhir.rest.gclient.IUpdate;
import ca.uhn.fhir.rest.gclient.IUpdateExecutable;
import ca.uhn.fhir.rest.gclient.IUpdateTyped;
import ca.uhn.fhir.rest.gclient.IUpdateWithQuery;
import ca.uhn.fhir.rest.gclient.IUpdateWithQueryTyped;
import ca.uhn.fhir.rest.gclient.IValidate;
import ca.uhn.fhir.rest.gclient.IValidateUntyped;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.NotModifiedException;
import ca.uhn.fhir.util.ICallable;
import ca.uhn.fhir.util.ParametersUtil;
import ca.uhn.fhir.util.UrlUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericClient
extends BaseClient
implements IGenericClient {
    private static final String I18N_CANNOT_DETEMINE_RESOURCE_TYPE = GenericClient.class.getName() + ".cannotDetermineResourceTypeFromUri";
    private static final String I18N_INCOMPLETE_URI_FOR_READ = GenericClient.class.getName() + ".incompleteUriForRead";
    private static final String I18N_NO_VERSION_ID_FOR_VREAD = GenericClient.class.getName() + ".noVersionIdForVread";
    private static final Logger ourLog = LoggerFactory.getLogger(GenericClient.class);
    private FhirContext myContext;
    private IHttpRequest myLastRequest;
    private boolean myLogRequestAndResponse;

    public GenericClient(FhirContext theContext, IHttpClient theHttpClient, String theServerBase, RestfulClientFactory theFactory) {
        super(theHttpClient, theServerBase, theFactory);
        this.myContext = theContext;
    }

    public IFetchConformanceUntyped capabilities() {
        return new FetchConformanceInternal();
    }

    public ICreate create() {
        return new CreateInternal();
    }

    public IDelete delete() {
        return new DeleteInternal();
    }

    private <T extends IBaseResource> T doReadOrVRead(Class<T> theType, IIdType theId, boolean theVRead, ICallable<T> theNotModifiedHandler, String theIfVersionMatches, Boolean thePrettyPrint, SummaryEnum theSummary, EncodingEnum theEncoding, Set<String> theSubsetElements) {
        String resName = this.toResourceName(theType);
        IIdType id = theId;
        if (!id.hasBaseUrl()) {
            id = new IdDt(resName, id.getIdPart(), id.getVersionIdPart());
        }
        HttpGetClientInvocation invocation = id.hasBaseUrl() ? (theVRead ? ReadMethodBinding.createAbsoluteVReadInvocation(this.getFhirContext(), id) : ReadMethodBinding.createAbsoluteReadInvocation(this.getFhirContext(), id)) : (theVRead ? ReadMethodBinding.createVReadInvocation(this.getFhirContext(), id, resName) : ReadMethodBinding.createReadInvocation(this.getFhirContext(), id, resName));
        if (this.isKeepResponses()) {
            this.myLastRequest = invocation.asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding(), this.isPrettyPrint());
        }
        if (theIfVersionMatches != null) {
            invocation.addHeader("If-None-Match", '\"' + theIfVersionMatches + '\"');
        }
        boolean allowHtmlResponse = SummaryEnum.TEXT.equals((Object)theSummary);
        BaseClient.ResourceResponseHandler<T> binding = (BaseClient)this.new BaseClient.ResourceResponseHandler<T>(theType, (Class<? extends IBaseResource>)null, id, allowHtmlResponse);
        if (theNotModifiedHandler == null) {
            return (T)((IBaseResource)this.invokeClient(this.myContext, binding, invocation, theEncoding, thePrettyPrint, this.myLogRequestAndResponse, theSummary, theSubsetElements, null));
        }
        try {
            return (T)((IBaseResource)this.invokeClient(this.myContext, binding, invocation, theEncoding, thePrettyPrint, this.myLogRequestAndResponse, theSummary, theSubsetElements, null));
        }
        catch (NotModifiedException e) {
            return (T)((IBaseResource)theNotModifiedHandler.call());
        }
    }

    public IFetchConformanceUntyped fetchConformance() {
        return new FetchConformanceInternal();
    }

    @Override
    public void forceConformanceCheck() {
        super.forceConformanceCheck();
    }

    public FhirContext getFhirContext() {
        return this.myContext;
    }

    public IHttpRequest getLastRequest() {
        return this.myLastRequest;
    }

    public void setLastRequest(IHttpRequest theLastRequest) {
        this.myLastRequest = theLastRequest;
    }

    protected String getPreferredId(IBaseResource theResource, String theId) {
        if (StringUtils.isNotBlank((CharSequence)theId)) {
            return theId;
        }
        return theResource.getIdElement().getIdPart();
    }

    public IHistory history() {
        return new HistoryInternal();
    }

    @Deprecated
    public boolean isLogRequestAndResponse() {
        return this.myLogRequestAndResponse;
    }

    @Deprecated
    public void setLogRequestAndResponse(boolean theLogRequestAndResponse) {
        this.myLogRequestAndResponse = theLogRequestAndResponse;
    }

    public IGetPage loadPage() {
        return new LoadPageInternal();
    }

    public IMeta meta() {
        return new MetaInternal();
    }

    public IOperation operation() {
        return new OperationInternal();
    }

    public IPatch patch() {
        return new PatchInternal();
    }

    public IRead read() {
        return new ReadInternal();
    }

    public <T extends IBaseResource> T read(Class<T> theType, String theId) {
        return this.read(theType, (UriDt)new IdDt(theId));
    }

    public <T extends IBaseResource> T read(Class<T> theType, UriDt theUrl) {
        IdDt id = theUrl instanceof IdDt ? (IdDt)theUrl : new IdDt(theUrl);
        return this.doReadOrVRead(theType, (IIdType)id, false, null, null, false, null, null, null);
    }

    public IBaseResource read(UriDt theUrl) {
        IdDt id = new IdDt(theUrl);
        String resourceType = id.getResourceType();
        if (StringUtils.isBlank((CharSequence)resourceType)) {
            throw new IllegalArgumentException(this.myContext.getLocalizer().getMessage(I18N_INCOMPLETE_URI_FOR_READ, new Object[]{theUrl.getValueAsString()}));
        }
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(resourceType);
        if (def == null) {
            throw new IllegalArgumentException(this.myContext.getLocalizer().getMessage(I18N_CANNOT_DETEMINE_RESOURCE_TYPE, new Object[]{theUrl.getValueAsString()}));
        }
        return this.read(def.getImplementingClass(), (UriDt)id);
    }

    public IUntypedQuery search() {
        return new SearchInternal();
    }

    private String toResourceName(Class<? extends IBaseResource> theType) {
        return this.myContext.getResourceDefinition(theType).getName();
    }

    public ITransaction transaction() {
        return new TransactionInternal();
    }

    public IUpdate update() {
        return new UpdateInternal();
    }

    public MethodOutcome update(IdDt theIdDt, IBaseResource theResource) {
        HttpPutClientInvocation invocation = MethodUtil.createUpdateInvocation(theResource, null, (IIdType)theIdDt, this.myContext);
        if (this.isKeepResponses()) {
            this.myLastRequest = ((BaseHttpClientInvocation)invocation).asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding(), this.isPrettyPrint());
        }
        OutcomeResponseHandler binding = new OutcomeResponseHandler();
        MethodOutcome resp = this.invokeClient(this.myContext, binding, invocation, this.myLogRequestAndResponse);
        return resp;
    }

    public MethodOutcome update(String theId, IBaseResource theResource) {
        return this.update(new IdDt(theId), theResource);
    }

    public IValidate validate() {
        return new ValidateInternal();
    }

    public MethodOutcome validate(IBaseResource theResource) {
        BaseHttpClientInvocation invocation = ValidateMethodBindingDstu2Plus.createValidateInvocation(this.myContext, theResource);
        if (this.isKeepResponses()) {
            this.myLastRequest = invocation.asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding(), this.isPrettyPrint());
        }
        OutcomeResponseHandler binding = new OutcomeResponseHandler();
        MethodOutcome resp = this.invokeClient(this.myContext, binding, invocation, this.myLogRequestAndResponse);
        return resp;
    }

    public <T extends IBaseResource> T vread(Class<T> theType, IdDt theId) {
        if (!theId.hasVersionIdPart()) {
            throw new IllegalArgumentException(this.myContext.getLocalizer().getMessage(I18N_NO_VERSION_ID_FOR_VREAD, new Object[]{theId.getValue()}));
        }
        return this.doReadOrVRead(theType, (IIdType)theId, true, null, null, false, null, null, null);
    }

    public <T extends IBaseResource> T vread(Class<T> theType, String theId, String theVersionId) {
        IdDt resId = new IdDt(this.toResourceName(theType), theId, theVersionId);
        return this.vread(theType, resId);
    }

    private static void addParam(Map<String, List<String>> params, String parameterName, String parameterValue) {
        if (!params.containsKey(parameterName)) {
            params.put(parameterName, new ArrayList());
        }
        params.get(parameterName).add(parameterValue);
    }

    private static void addPreferHeader(PreferReturnEnum thePrefer, BaseHttpClientInvocation theInvocation) {
        if (thePrefer != null) {
            theInvocation.addHeader("Prefer", "return=" + thePrefer.getHeaderValue());
        }
    }

    private static String validateAndEscapeConditionalUrl(String theSearchUrl) {
        Validate.notBlank((CharSequence)theSearchUrl, (String)"Conditional URL can not be blank/null", (Object[])new Object[0]);
        StringBuilder b = new StringBuilder();
        boolean haveHadQuestionMark = false;
        block3: for (int i = 0; i < theSearchUrl.length(); ++i) {
            char nextChar = theSearchUrl.charAt(i);
            if (!haveHadQuestionMark) {
                if (nextChar == '?') {
                    haveHadQuestionMark = true;
                } else if (!Character.isLetter(nextChar)) {
                    throw new IllegalArgumentException("Conditional URL must be in the format \"[ResourceType]?[Params]\" and must not have a base URL - Found: " + theSearchUrl);
                }
                b.append(nextChar);
                continue;
            }
            switch (nextChar) {
                case '$': 
                case ':': 
                case '?': 
                case '|': {
                    b.append(UrlUtil.escapeUrlParam((String)Character.toString(nextChar)));
                    continue block3;
                }
                default: {
                    b.append(nextChar);
                }
            }
        }
        return b.toString();
    }

    private static class SortInternal
    implements ISort {
        private SortOrderEnum myDirection;
        private SearchInternal myFor;
        private String myParamName;
        private String myParamValue;

        public SortInternal(SearchInternal theFor) {
            this.myFor = theFor;
        }

        public SortInternal(SortSpec theSortSpec) {
            if (theSortSpec.getOrder() == null) {
                this.myParamName = "_sort";
            } else if (theSortSpec.getOrder() == SortOrderEnum.ASC) {
                this.myParamName = "_sort:asc";
            } else if (theSortSpec.getOrder() == SortOrderEnum.DESC) {
                this.myParamName = "_sort:desc";
            }
            this.myDirection = theSortSpec.getOrder();
            this.myParamValue = theSortSpec.getParamName();
        }

        public IQuery ascending(IParam theParam) {
            this.myParamName = "_sort:asc";
            this.myDirection = SortOrderEnum.ASC;
            this.myParamValue = theParam.getParamName();
            return this.myFor;
        }

        public IQuery ascending(String theParam) {
            this.myParamName = "_sort:asc";
            this.myDirection = SortOrderEnum.ASC;
            this.myParamValue = theParam;
            return this.myFor;
        }

        public IQuery defaultOrder(IParam theParam) {
            this.myParamName = "_sort";
            this.myDirection = null;
            this.myParamValue = theParam.getParamName();
            return this.myFor;
        }

        public IQuery defaultOrder(String theParam) {
            this.myParamName = "_sort";
            this.myDirection = null;
            this.myParamValue = theParam;
            return this.myFor;
        }

        public IQuery descending(IParam theParam) {
            this.myParamName = "_sort:desc";
            this.myDirection = SortOrderEnum.DESC;
            this.myParamValue = theParam.getParamName();
            return this.myFor;
        }

        public IQuery descending(String theParam) {
            this.myParamName = "_sort:desc";
            this.myDirection = SortOrderEnum.DESC;
            this.myParamValue = theParam;
            return this.myFor;
        }

        public SortOrderEnum getDirection() {
            return this.myDirection;
        }

        public String getParamName() {
            return this.myParamName;
        }

        public String getParamValue() {
            return this.myParamValue;
        }
    }

    private class ValidateInternal
    extends BaseClientExecutable<IValidateUntyped, MethodOutcome>
    implements IValidate,
    IValidateUntyped {
        private IBaseResource myResource;

        private ValidateInternal() {
        }

        public MethodOutcome execute() {
            BaseHttpClientInvocation invocation = ValidateMethodBindingDstu2Plus.createValidateInvocation(GenericClient.this.myContext, this.myResource);
            BaseClient.ResourceResponseHandler handler = new BaseClient.ResourceResponseHandler(null, null);
            IBaseOperationOutcome outcome = (IBaseOperationOutcome)this.invoke(null, handler, invocation);
            MethodOutcome retVal = new MethodOutcome();
            retVal.setOperationOutcome(outcome);
            return retVal;
        }

        public IValidateUntyped resource(IBaseResource theResource) {
            Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
            this.myResource = theResource;
            return this;
        }

        public IValidateUntyped resource(String theResourceRaw) {
            Validate.notBlank((CharSequence)theResourceRaw, (String)"theResourceRaw must not be null or blank", (Object[])new Object[0]);
            this.myResource = this.parseResourceBody(theResourceRaw);
            EncodingEnum enc = EncodingEnum.detectEncodingNoDefault((String)theResourceRaw);
            if (enc == null) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(GenericClient.class, "cantDetermineRequestType", new Object[0]));
            }
            switch (enc) {
                case XML: {
                    this.encodedXml();
                    break;
                }
                case JSON: {
                    this.encodedJson();
                }
            }
            return this;
        }
    }

    private class UpdateInternal
    extends BaseSearch<IUpdateExecutable, IUpdateWithQueryTyped, MethodOutcome>
    implements IUpdate,
    IUpdateTyped,
    IUpdateExecutable,
    IUpdateWithQuery,
    IUpdateWithQueryTyped {
        private boolean myConditional;
        private IIdType myId;
        private PreferReturnEnum myPrefer;
        private IBaseResource myResource;
        private String myResourceBody;
        private String mySearchUrl;

        private UpdateInternal() {
        }

        public IUpdateWithQuery conditional() {
            this.myConditional = true;
            return this;
        }

        public IUpdateTyped conditionalByUrl(String theSearchUrl) {
            this.mySearchUrl = GenericClient.validateAndEscapeConditionalUrl(theSearchUrl);
            return this;
        }

        public MethodOutcome execute() {
            HttpPutClientInvocation invocation;
            if (this.myResource == null) {
                this.myResource = this.parseResourceBody(this.myResourceBody);
            }
            if (this.getParamEncoding() != null) {
                this.myResourceBody = null;
            }
            if (this.mySearchUrl != null) {
                invocation = MethodUtil.createUpdateInvocation(GenericClient.this.myContext, this.myResource, this.myResourceBody, this.mySearchUrl);
            } else if (this.myConditional) {
                invocation = MethodUtil.createUpdateInvocation(GenericClient.this.myContext, this.myResource, this.myResourceBody, this.getParamMap());
            } else {
                if (this.myId == null) {
                    this.myId = this.myResource.getIdElement();
                }
                if (this.myId == null || !this.myId.hasIdPart()) {
                    throw new InvalidRequestException("No ID supplied for resource to update, can not invoke server");
                }
                invocation = MethodUtil.createUpdateInvocation(this.myResource, this.myResourceBody, this.myId, GenericClient.this.myContext);
            }
            GenericClient.addPreferHeader(this.myPrefer, invocation);
            OutcomeResponseHandler binding = new OutcomeResponseHandler(this.myPrefer);
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            return this.invoke(params, binding, invocation);
        }

        public IUpdateExecutable prefer(PreferReturnEnum theReturn) {
            this.myPrefer = theReturn;
            return this;
        }

        public IUpdateTyped resource(IBaseResource theResource) {
            Validate.notNull((Object)theResource, (String)"Resource can not be null", (Object[])new Object[0]);
            this.myResource = theResource;
            return this;
        }

        public IUpdateTyped resource(String theResourceBody) {
            Validate.notBlank((CharSequence)theResourceBody, (String)"Body can not be null or blank", (Object[])new Object[0]);
            this.myResourceBody = theResourceBody;
            return this;
        }

        public IUpdateExecutable withId(IIdType theId) {
            if (theId == null) {
                throw new NullPointerException("theId can not be null");
            }
            if (!theId.hasIdPart()) {
                throw new NullPointerException("theId must not be blank and must contain an ID, found: " + theId.getValue());
            }
            this.myId = theId;
            return this;
        }

        public IUpdateExecutable withId(String theId) {
            if (theId == null) {
                throw new NullPointerException("theId can not be null");
            }
            if (StringUtils.isBlank((CharSequence)theId)) {
                throw new NullPointerException("theId must not be blank and must contain an ID, found: " + theId);
            }
            this.myId = new IdDt(theId);
            return this;
        }
    }

    private final class TransactionInternal
    implements ITransaction {
        private TransactionInternal() {
        }

        public ITransactionTyped<String> withBundle(String theBundle) {
            Validate.notBlank((CharSequence)theBundle, (String)"theBundle must not be null", (Object[])new Object[0]);
            return new TransactionExecutable<String>(theBundle);
        }

        public <T extends IBaseBundle> ITransactionTyped<T> withBundle(T theBundle) {
            Validate.notNull(theBundle, (String)"theBundle must not be null", (Object[])new Object[0]);
            return new TransactionExecutable(theBundle);
        }

        public ITransactionTyped<List<IBaseResource>> withResources(List<? extends IBaseResource> theResources) {
            Validate.notNull(theResources, (String)"theResources must not be null", (Object[])new Object[0]);
            return new TransactionExecutable<List<IBaseResource>>(theResources);
        }
    }

    private final class TransactionExecutable<T>
    extends BaseClientExecutable<ITransactionTyped<T>, T>
    implements ITransactionTyped<T> {
        private IBaseBundle myBaseBundle;
        private String myRawBundle;
        private EncodingEnum myRawBundleEncoding;
        private List<? extends IBaseResource> myResources;

        public TransactionExecutable(IBaseBundle theBundle) {
            this.myBaseBundle = theBundle;
        }

        public TransactionExecutable(List<? extends IBaseResource> theResources) {
            this.myResources = theResources;
        }

        public TransactionExecutable(String theBundle) {
            this.myRawBundle = theBundle;
            this.myRawBundleEncoding = EncodingEnum.detectEncodingNoDefault((String)this.myRawBundle);
            if (this.myRawBundleEncoding == null) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(GenericClient.class, "cantDetermineRequestType", new Object[0]));
            }
        }

        public T execute() {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            if (this.myResources != null) {
                ResourceListResponseHandler binding = new ResourceListResponseHandler();
                BaseHttpClientInvocation invocation = TransactionMethodBinding.createTransactionInvocation(this.myResources, GenericClient.this.myContext);
                return (T)this.invoke(params, binding, invocation);
            }
            if (this.myBaseBundle != null) {
                BaseClient.ResourceResponseHandler binding = new BaseClient.ResourceResponseHandler(this.myBaseBundle.getClass(), this.getPreferResponseTypes());
                BaseHttpClientInvocation invocation = TransactionMethodBinding.createTransactionInvocation(this.myBaseBundle, GenericClient.this.myContext);
                return (T)this.invoke(params, binding, invocation);
            }
            StringResponseHandler binding = new StringResponseHandler();
            if (this.getParamEncoding() != null && EncodingEnum.detectEncodingNoDefault((String)this.myRawBundle) != this.getParamEncoding()) {
                IBaseResource parsed = this.parseResourceBody(this.myRawBundle);
                this.myRawBundle = this.getParamEncoding().newParser(GenericClient.this.getFhirContext()).encodeResourceToString(parsed);
            }
            BaseHttpClientInvocation invocation = TransactionMethodBinding.createTransactionInvocation(this.myRawBundle, GenericClient.this.myContext);
            return (T)this.invoke(params, binding, invocation);
        }
    }

    private final class StringResponseHandler
    implements IClientResponseHandler<String> {
        private StringResponseHandler() {
        }

        @Override
        public String invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws IOException, BaseServerResponseException {
            return IOUtils.toString((Reader)theResponseReader);
        }
    }

    private class SearchInternal<OUTPUT>
    extends BaseSearch<IQuery<OUTPUT>, IQuery<OUTPUT>, OUTPUT>
    implements IQuery<OUTPUT>,
    IUntypedQuery<IQuery<OUTPUT>> {
        private String myCompartmentName;
        private List<Include> myInclude;
        private DateRangeParam myLastUpdated;
        private Integer myParamLimit;
        private List<Collection<String>> myProfiles;
        private String myResourceId;
        private String myResourceName;
        private Class<? extends IBaseResource> myResourceType;
        private Class<? extends IBaseBundle> myReturnBundleType;
        private List<Include> myRevInclude;
        private SearchStyleEnum mySearchStyle;
        private String mySearchUrl;
        private List<TokenParam> mySecurity;
        private List<SortInternal> mySort;
        private List<TokenParam> myTags;
        private SearchTotalModeEnum myTotalMode;

        public SearchInternal() {
            this.myInclude = new ArrayList<Include>();
            this.myProfiles = new ArrayList<Collection<String>>();
            this.myRevInclude = new ArrayList<Include>();
            this.mySecurity = new ArrayList<TokenParam>();
            this.mySort = new ArrayList<SortInternal>();
            this.myTags = new ArrayList<TokenParam>();
            this.myResourceType = null;
            this.myResourceName = null;
            this.mySearchUrl = null;
        }

        public IQuery byUrl(String theSearchUrl) {
            Validate.notBlank((CharSequence)theSearchUrl, (String)"theSearchUrl must not be blank/null", (Object[])new Object[0]);
            if (theSearchUrl.startsWith("http://") || theSearchUrl.startsWith("https://")) {
                this.mySearchUrl = theSearchUrl;
                int qIndex = this.mySearchUrl.indexOf(63);
                if (qIndex != -1) {
                    this.mySearchUrl = this.mySearchUrl.substring(0, qIndex) + GenericClient.validateAndEscapeConditionalUrl(this.mySearchUrl.substring(qIndex));
                }
            } else {
                String searchUrl = theSearchUrl;
                if (searchUrl.startsWith("/")) {
                    searchUrl = searchUrl.substring(1);
                }
                if (!searchUrl.matches("[a-zA-Z]+($|\\?.*)")) {
                    throw new IllegalArgumentException("Search URL must be either a complete URL starting with http: or https:, or a relative FHIR URL in the form [ResourceType]?[Params]");
                }
                int qIndex = searchUrl.indexOf(63);
                this.mySearchUrl = qIndex == -1 ? GenericClient.this.getUrlBase() + '/' + searchUrl : GenericClient.this.getUrlBase() + '/' + GenericClient.validateAndEscapeConditionalUrl(searchUrl);
            }
            return this;
        }

        public IQuery count(int theLimitTo) {
            this.myParamLimit = theLimitTo > 0 ? Integer.valueOf(theLimitTo) : null;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public OUTPUT execute() {
            Map<String, List<String>> params = this.getParamMap();
            for (TokenParam tokenParam : this.myTags) {
                GenericClient.addParam(params, "_tag", tokenParam.getValueAsQueryToken(GenericClient.this.myContext));
            }
            for (TokenParam tokenParam : this.mySecurity) {
                GenericClient.addParam(params, "_security", tokenParam.getValueAsQueryToken(GenericClient.this.myContext));
            }
            for (Collection collection : this.myProfiles) {
                StringBuilder builder = new StringBuilder();
                Iterator profileItr = collection.iterator();
                while (profileItr.hasNext()) {
                    builder.append((String)profileItr.next());
                    if (!profileItr.hasNext()) continue;
                    builder.append(',');
                }
                GenericClient.addParam(params, "_profile", builder.toString());
            }
            for (Include include : this.myInclude) {
                if (include.isRecurse()) {
                    GenericClient.addParam(params, "_include:recurse", include.getValue());
                    continue;
                }
                GenericClient.addParam(params, "_include", include.getValue());
            }
            for (Include include : this.myRevInclude) {
                if (include.isRecurse()) {
                    GenericClient.addParam(params, "_revinclude:recurse", include.getValue());
                    continue;
                }
                GenericClient.addParam(params, "_revinclude", include.getValue());
            }
            if (GenericClient.this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU2)) {
                Iterator<SortInternal> rootSs = null;
                Object var3_12 = null;
                for (SortInternal next : this.mySort) {
                    SortSpec nextSortSpec = new SortSpec();
                    nextSortSpec.setParamName(next.getParamValue());
                    nextSortSpec.setOrder(next.getDirection());
                    if (rootSs == null) {
                        rootSs = nextSortSpec;
                    } else {
                        void var3_13;
                        var3_13.setChain(nextSortSpec);
                    }
                    SortSpec sortSpec = nextSortSpec;
                }
                if (rootSs != null) {
                    GenericClient.addParam(params, "_sort", SortParameter.createSortStringDstu3(rootSs));
                }
            } else {
                for (SortInternal sortInternal : this.mySort) {
                    GenericClient.addParam(params, sortInternal.getParamName(), sortInternal.getParamValue());
                }
            }
            if (this.myParamLimit != null) {
                GenericClient.addParam(params, "_count", Integer.toString(this.myParamLimit));
            }
            if (this.myLastUpdated != null) {
                for (DateParam dateParam : this.myLastUpdated.getValuesAsQueryTokens()) {
                    GenericClient.addParam(params, "_lastUpdated", dateParam.getValueAsQueryToken(GenericClient.this.myContext));
                }
            }
            if (this.myTotalMode != null) {
                GenericClient.addParam(params, "_total", this.myTotalMode.getCode());
            }
            BaseClient.ResourceResponseHandler<? extends IBaseBundle> binding = new BaseClient.ResourceResponseHandler<IBaseBundle>(this.myReturnBundleType, this.getPreferResponseTypes(this.myResourceType));
            IdDt idDt = this.myResourceId != null ? new IdDt(this.myResourceId) : null;
            BaseHttpClientInvocation invocation = this.mySearchUrl != null ? SearchMethodBinding.createSearchInvocation(GenericClient.this.myContext, this.mySearchUrl, params) : SearchMethodBinding.createSearchInvocation(GenericClient.this.myContext, this.myResourceName, params, (IIdType)idDt, this.myCompartmentName, this.mySearchStyle);
            return (OUTPUT)this.invoke(params, binding, invocation);
        }

        public IQuery forAllResources() {
            return this;
        }

        public IQuery forResource(Class theResourceType) {
            this.setType(theResourceType);
            return this;
        }

        public IQuery forResource(String theResourceName) {
            this.setType(theResourceName);
            return this;
        }

        public IQuery include(Include theInclude) {
            this.myInclude.add(theInclude);
            return this;
        }

        public IQuery lastUpdated(DateRangeParam theLastUpdated) {
            this.myLastUpdated = theLastUpdated;
            return this;
        }

        @Deprecated
        public IQuery limitTo(int theLimitTo) {
            return this.count(theLimitTo);
        }

        public IQuery<OUTPUT> totalMode(SearchTotalModeEnum theSearchTotalModeEnum) {
            this.myTotalMode = theSearchTotalModeEnum;
            return this;
        }

        public IQuery returnBundle(Class theClass) {
            if (theClass == null) {
                throw new NullPointerException("theClass must not be null");
            }
            this.myReturnBundleType = theClass;
            return this;
        }

        public IQuery revInclude(Include theInclude) {
            this.myRevInclude.add(theInclude);
            return this;
        }

        private void setType(Class<? extends IBaseResource> theResourceType) {
            this.myResourceType = theResourceType;
            RuntimeResourceDefinition definition = GenericClient.this.myContext.getResourceDefinition(theResourceType);
            this.myResourceName = definition.getName();
        }

        private void setType(String theResourceName) {
            this.myResourceType = GenericClient.this.myContext.getResourceDefinition(theResourceName).getImplementingClass();
            this.myResourceName = theResourceName;
        }

        public ISort sort() {
            SortInternal retVal = new SortInternal(this);
            this.mySort.add(retVal);
            return retVal;
        }

        public IQuery sort(SortSpec theSortSpec) {
            for (SortSpec sortSpec = theSortSpec; sortSpec != null; sortSpec = sortSpec.getChain()) {
                this.mySort.add(new SortInternal(sortSpec));
            }
            return this;
        }

        public IQuery usingStyle(SearchStyleEnum theStyle) {
            this.mySearchStyle = theStyle;
            return this;
        }

        public IQuery withAnyProfile(Collection theProfileUris) {
            Validate.notEmpty((Collection)theProfileUris, (String)"theProfileUris must not be null or empty", (Object[])new Object[0]);
            this.myProfiles.add(theProfileUris);
            return this;
        }

        public IQuery withIdAndCompartment(String theResourceId, String theCompartmentName) {
            this.myResourceId = theResourceId;
            this.myCompartmentName = theCompartmentName;
            return this;
        }

        public IQuery withProfile(String theProfileUri) {
            Validate.notBlank((CharSequence)theProfileUri, (String)"theProfileUri must not be null or empty", (Object[])new Object[0]);
            this.myProfiles.add(Collections.singletonList(theProfileUri));
            return this;
        }

        public IQuery withSecurity(String theSystem, String theCode) {
            Validate.notBlank((CharSequence)theCode, (String)"theCode must not be null or empty", (Object[])new Object[0]);
            this.mySecurity.add(new TokenParam(theSystem, theCode));
            return this;
        }

        public IQuery withTag(String theSystem, String theCode) {
            Validate.notBlank((CharSequence)theCode, (String)"theCode must not be null or empty", (Object[])new Object[0]);
            this.myTags.add(new TokenParam(theSystem, theCode));
            return this;
        }
    }

    private final class ResourceListResponseHandler
    implements IClientResponseHandler<List<IBaseResource>> {
        private ResourceListResponseHandler() {
        }

        @Override
        public List<IBaseResource> invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws BaseServerResponseException {
            Class bundleType = GenericClient.this.myContext.getResourceDefinition("Bundle").getImplementingClass();
            BaseClient.ResourceResponseHandler handler = new BaseClient.ResourceResponseHandler(bundleType);
            Object response = handler.invokeClient(theResponseMimeType, theResponseReader, theResponseStatusCode, theHeaders);
            IVersionSpecificBundleFactory bundleFactory = GenericClient.this.myContext.newBundleFactory();
            bundleFactory.initializeWithBundleResource(response);
            return bundleFactory.toListOfResources();
        }
    }

    private class ReadInternal
    extends BaseClientExecutable
    implements IRead,
    IReadTyped,
    IReadExecutable {
        private IIdType myId;
        private String myIfVersionMatches;
        private ICallable myNotModifiedHandler;
        private RuntimeResourceDefinition myType;

        private ReadInternal() {
        }

        public Object execute() {
            if (this.myId.hasVersionIdPart()) {
                return GenericClient.this.doReadOrVRead(this.myType.getImplementingClass(), this.myId, true, this.myNotModifiedHandler, this.myIfVersionMatches, this.myPrettyPrint, this.mySummaryMode, this.myParamEncoding, this.getSubsetElements());
            }
            return GenericClient.this.doReadOrVRead(this.myType.getImplementingClass(), this.myId, false, this.myNotModifiedHandler, this.myIfVersionMatches, this.myPrettyPrint, this.mySummaryMode, this.myParamEncoding, this.getSubsetElements());
        }

        public IReadIfNoneMatch ifVersionMatches(String theVersion) {
            this.myIfVersionMatches = theVersion;
            return new IReadIfNoneMatch(){

                public IReadExecutable returnNull() {
                    ReadInternal.this.myNotModifiedHandler = new ICallable(){

                        public Object call() {
                            return null;
                        }
                    };
                    return ReadInternal.this;
                }

                public IReadExecutable returnResource(final IBaseResource theInstance) {
                    ReadInternal.this.myNotModifiedHandler = new ICallable(){

                        public Object call() {
                            return theInstance;
                        }
                    };
                    return ReadInternal.this;
                }

                public IReadExecutable throwNotModifiedException() {
                    ReadInternal.this.myNotModifiedHandler = null;
                    return ReadInternal.this;
                }
            };
        }

        private void processUrl() {
            String resourceType = this.myId.getResourceType();
            if (StringUtils.isBlank((CharSequence)resourceType)) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(I18N_INCOMPLETE_URI_FOR_READ, new Object[]{this.myId}));
            }
            this.myType = GenericClient.this.myContext.getResourceDefinition(resourceType);
            if (this.myType == null) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(I18N_CANNOT_DETEMINE_RESOURCE_TYPE, new Object[]{this.myId}));
            }
        }

        public <T extends IBaseResource> IReadTyped<T> resource(Class<T> theResourceType) {
            Validate.notNull(theResourceType, (String)"theResourceType must not be null", (Object[])new Object[0]);
            this.myType = GenericClient.this.myContext.getResourceDefinition(theResourceType);
            if (this.myType == null) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(I18N_CANNOT_DETEMINE_RESOURCE_TYPE, new Object[]{theResourceType}));
            }
            return this;
        }

        public IReadTyped<IBaseResource> resource(String theResourceAsText) {
            Validate.notBlank((CharSequence)theResourceAsText, (String)"You must supply a value for theResourceAsText", (Object[])new Object[0]);
            this.myType = GenericClient.this.myContext.getResourceDefinition(theResourceAsText);
            if (this.myType == null) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(I18N_CANNOT_DETEMINE_RESOURCE_TYPE, new Object[]{theResourceAsText}));
            }
            return this;
        }

        public IReadExecutable withId(IIdType theId) {
            Validate.notNull((Object)theId, (String)"The ID can not be null", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)theId.getIdPart(), (String)"The ID can not be blank", (Object[])new Object[0]);
            this.myId = theId.toUnqualified();
            return this;
        }

        public IReadExecutable withId(Long theId) {
            Validate.notNull((Object)theId, (String)"The ID can not be null", (Object[])new Object[0]);
            this.myId = new IdDt(this.myType.getName(), theId);
            return this;
        }

        public IReadExecutable withId(String theId) {
            Validate.notBlank((CharSequence)theId, (String)"The ID can not be blank", (Object[])new Object[0]);
            this.myId = theId.indexOf(47) == -1 ? new IdDt(this.myType.getName(), theId) : new IdDt(theId);
            return this;
        }

        public IReadExecutable withIdAndVersion(String theId, String theVersion) {
            Validate.notBlank((CharSequence)theId, (String)"The ID can not be blank", (Object[])new Object[0]);
            this.myId = new IdDt(this.myType.getName(), theId, theVersion);
            return this;
        }

        public IReadExecutable withUrl(IIdType theUrl) {
            Validate.notNull((Object)theUrl, (String)"theUrl can not be null", (Object[])new Object[0]);
            this.myId = theUrl;
            this.processUrl();
            return this;
        }

        public IReadExecutable withUrl(String theUrl) {
            this.myId = new IdDt(theUrl);
            this.processUrl();
            return this;
        }
    }

    private class PatchInternal
    extends BaseSearch<IPatchExecutable, IPatchWithQueryTyped, MethodOutcome>
    implements IPatch,
    IPatchWithBody,
    IPatchExecutable,
    IPatchWithQuery,
    IPatchWithQueryTyped {
        private boolean myConditional;
        private IIdType myId;
        private String myPatchBody;
        private PatchTypeEnum myPatchType;
        private PreferReturnEnum myPrefer;
        private String myResourceType;
        private String mySearchUrl;

        private PatchInternal() {
        }

        public IPatchWithQuery conditional(Class<? extends IBaseResource> theClass) {
            Validate.notNull(theClass, (String)"theClass must not be null", (Object[])new Object[0]);
            String resourceType = GenericClient.this.myContext.getResourceDefinition(theClass).getName();
            return this.conditional(resourceType);
        }

        public IPatchWithQuery conditional(String theResourceType) {
            Validate.notBlank((CharSequence)theResourceType, (String)"theResourceType must not be null", (Object[])new Object[0]);
            this.myResourceType = theResourceType;
            this.myConditional = true;
            return this;
        }

        public IPatchWithBody conditionalByUrl(String theSearchUrl) {
            this.mySearchUrl = GenericClient.validateAndEscapeConditionalUrl(theSearchUrl);
            return this;
        }

        public MethodOutcome execute() {
            HttpPatchClientInvocation invocation;
            if (this.myPatchType == null) {
                throw new InvalidRequestException("No patch type supplied, cannot invoke server");
            }
            if (this.myPatchBody == null) {
                throw new InvalidRequestException("No patch body supplied, cannot invoke server");
            }
            if (StringUtils.isNotBlank((CharSequence)this.mySearchUrl)) {
                invocation = MethodUtil.createPatchInvocation(GenericClient.this.myContext, this.mySearchUrl, this.myPatchType, this.myPatchBody);
            } else if (this.myConditional) {
                invocation = MethodUtil.createPatchInvocation(GenericClient.this.myContext, this.myPatchType, this.myPatchBody, this.myResourceType, this.getParamMap());
            } else {
                if (this.myId == null || !this.myId.hasIdPart()) {
                    throw new InvalidRequestException("No ID supplied for resource to patch, can not invoke server");
                }
                invocation = MethodUtil.createPatchInvocation(GenericClient.this.myContext, this.myId, this.myPatchType, this.myPatchBody);
            }
            GenericClient.addPreferHeader(this.myPrefer, invocation);
            OutcomeResponseHandler binding = new OutcomeResponseHandler(this.myPrefer);
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            return this.invoke(params, binding, invocation);
        }

        public IPatchExecutable prefer(PreferReturnEnum theReturn) {
            this.myPrefer = theReturn;
            return this;
        }

        public IPatchWithBody withBody(String thePatchBody) {
            Validate.notBlank((CharSequence)thePatchBody, (String)"thePatchBody must not be blank", (Object[])new Object[0]);
            this.myPatchBody = thePatchBody;
            EncodingEnum encoding = EncodingEnum.detectEncodingNoDefault((String)thePatchBody);
            if (encoding == EncodingEnum.XML) {
                this.myPatchType = PatchTypeEnum.XML_PATCH;
            } else if (encoding == EncodingEnum.JSON) {
                this.myPatchType = PatchTypeEnum.JSON_PATCH;
            } else {
                throw new IllegalArgumentException("Unable to determine encoding of patch");
            }
            return this;
        }

        public IPatchExecutable withId(IIdType theId) {
            if (theId == null) {
                throw new NullPointerException("theId can not be null");
            }
            if (!theId.hasIdPart()) {
                throw new NullPointerException("theId must not be blank and must contain an ID, found: " + theId.getValue());
            }
            this.myId = theId;
            return this;
        }

        public IPatchExecutable withId(String theId) {
            if (theId == null) {
                throw new NullPointerException("theId can not be null");
            }
            if (StringUtils.isBlank((CharSequence)theId)) {
                throw new NullPointerException("theId must not be blank and must contain an ID, found: " + theId);
            }
            this.myId = new IdDt(theId);
            return this;
        }
    }

    private final class OutcomeResponseHandler
    implements IClientResponseHandler<MethodOutcome> {
        private PreferReturnEnum myPrefer;

        private OutcomeResponseHandler() {
        }

        private OutcomeResponseHandler(PreferReturnEnum thePrefer) {
            this();
            this.myPrefer = thePrefer;
        }

        @Override
        public MethodOutcome invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws BaseServerResponseException {
            MethodOutcome response = MethodUtil.process2xxResponse(GenericClient.this.myContext, theResponseStatusCode, theResponseMimeType, theResponseReader, theHeaders);
            if (theResponseStatusCode == 201) {
                response.setCreated(Boolean.valueOf(true));
            }
            if (this.myPrefer == PreferReturnEnum.REPRESENTATION && response.getResource() == null && response.getId() != null && StringUtils.isNotBlank((CharSequence)response.getId().getValue()) && response.getId().hasBaseUrl()) {
                ourLog.info("Server did not return resource for Prefer-representation, going to fetch: {}", (Object)response.getId().getValue());
                IBaseResource resource = (IBaseResource)GenericClient.this.read().resource(response.getId().getResourceType()).withUrl(response.getId()).execute();
                response.setResource(resource);
            }
            return response;
        }
    }

    private final class OperationOutcomeResponseHandler
    implements IClientResponseHandler<IBaseOperationOutcome> {
        private OperationOutcomeResponseHandler() {
        }

        @Override
        public IBaseOperationOutcome invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws BaseServerResponseException {
            IBaseOperationOutcome retVal;
            EncodingEnum respType = EncodingEnum.forContentType((String)theResponseMimeType);
            if (respType == null) {
                return null;
            }
            IParser parser = respType.newParser(GenericClient.this.myContext);
            try {
                retVal = (IBaseOperationOutcome)parser.parseResource(theResponseReader);
            }
            catch (DataFormatException e) {
                ourLog.warn("Failed to parse OperationOutcome response", (Throwable)e);
                return null;
            }
            MethodUtil.parseClientRequestResourceHeaders(null, theHeaders, (IBaseResource)retVal);
            return retVal;
        }
    }

    private class OperationInternal
    extends BaseClientExecutable
    implements IOperation,
    IOperationUnnamed,
    IOperationUntyped,
    IOperationUntypedWithInput,
    IOperationUntypedWithInputAndPartialOutput,
    IOperationProcessMsg,
    IOperationProcessMsgMode {
        private IIdType myId;
        private Boolean myIsAsync;
        private IBaseBundle myMsgBundle;
        private String myOperationName;
        private IBaseParameters myParameters;
        private RuntimeResourceDefinition myParametersDef;
        private String myResponseUrl;
        private Class myReturnResourceType;
        private Class<? extends IBaseResource> myType;
        private boolean myUseHttpGet;

        private OperationInternal() {
        }

        private void addParam(String theName, IBase theValue) {
            BaseRuntimeChildDefinition parameterChild = this.myParametersDef.getChildByName("parameter");
            BaseRuntimeElementCompositeDefinition parameterElem = (BaseRuntimeElementCompositeDefinition)parameterChild.getChildByName("parameter");
            IBase parameter = parameterElem.newInstance();
            parameterChild.getMutator().addValue((Object)this.myParameters, parameter);
            IPrimitiveType name = (IPrimitiveType)GenericClient.this.myContext.getElementDefinition("string").newInstance();
            name.setValue((Object)theName);
            parameterElem.getChildByName("name").getMutator().setValue((Object)parameter, (IBase)name);
            if (theValue instanceof IBaseDatatype) {
                Class profileOf;
                BaseRuntimeElementDefinition datatypeDef = GenericClient.this.myContext.getElementDefinition(theValue.getClass());
                if (datatypeDef instanceof IRuntimeDatatypeDefinition && (profileOf = ((IRuntimeDatatypeDefinition)datatypeDef).getProfileOf()) != null) {
                    datatypeDef = GenericClient.this.myContext.getElementDefinition(profileOf);
                }
                String childElementName = "value" + StringUtils.capitalize((String)datatypeDef.getName());
                BaseRuntimeChildDefinition childByName = parameterElem.getChildByName(childElementName);
                childByName.getMutator().setValue((Object)parameter, theValue);
            } else if (theValue instanceof IBaseResource) {
                parameterElem.getChildByName("resource").getMutator().setValue((Object)parameter, theValue);
            } else {
                throw new IllegalArgumentException("Don't know how to handle parameter of type " + theValue.getClass());
            }
        }

        private void addParam(String theName, IQueryParameterType theValue) {
            IPrimitiveType stringType = ParametersUtil.createString((FhirContext)GenericClient.this.myContext, (String)theValue.getValueAsQueryToken(GenericClient.this.myContext));
            this.addParam(theName, (IBase)stringType);
        }

        public IOperationUntypedWithInputAndPartialOutput andParameter(String theName, IBase theValue) {
            Validate.notEmpty((CharSequence)theName, (String)"theName must not be null", (Object[])new Object[0]);
            Validate.notNull((Object)theValue, (String)"theValue must not be null", (Object[])new Object[0]);
            this.addParam(theName, theValue);
            return this;
        }

        public IOperationUntypedWithInputAndPartialOutput andSearchParameter(String theName, IQueryParameterType theValue) {
            this.addParam(theName, theValue);
            return this;
        }

        public IOperationProcessMsgMode asynchronous(Class theResponseClass) {
            this.myIsAsync = true;
            Validate.notNull((Object)theResponseClass, (String)"theReturnType must not be null", (Object[])new Object[0]);
            Validate.isTrue((boolean)IBaseResource.class.isAssignableFrom(theResponseClass), (String)"theReturnType must be a class which extends from IBaseResource", (Object[])new Object[0]);
            this.myReturnResourceType = theResponseClass;
            return this;
        }

        public Object execute() {
            String version;
            String id;
            String resourceName;
            if (this.myOperationName != null && this.myOperationName.equals("$process-message") && this.myMsgBundle != null) {
                LinkedHashMap<String, List<String>> urlParams = new LinkedHashMap<String, List<String>>();
                if (this.myIsAsync != null) {
                    urlParams.put("async", Arrays.asList(String.valueOf(this.myIsAsync)));
                }
                if (this.myResponseUrl != null && StringUtils.isNotBlank((CharSequence)this.myResponseUrl)) {
                    urlParams.put("response-url", Arrays.asList(String.valueOf(this.myResponseUrl)));
                }
                BaseHttpClientInvocation invocation = OperationMethodBinding.createProcessMsgInvocation(GenericClient.this.myContext, this.myOperationName, this.myMsgBundle, urlParams);
                BaseClient.ResourceResponseHandler handler = new BaseClient.ResourceResponseHandler();
                handler.setPreferResponseTypes(this.getPreferResponseTypes(this.myType));
                Object retVal = this.invoke(null, handler, invocation);
                return retVal;
            }
            if (this.myType != null) {
                resourceName = GenericClient.this.myContext.getResourceDefinition(this.myType).getName();
                id = null;
                version = null;
            } else if (this.myId != null) {
                resourceName = this.myId.getResourceType();
                Validate.notBlank((CharSequence)StringUtils.defaultString((String)resourceName), (String)"Can not invoke operation \"$%s\" on instance \"%s\" - No resource type specified", (Object[])new Object[]{this.myOperationName, this.myId.getValue()});
                id = this.myId.getIdPart();
                version = this.myId.getVersionIdPart();
            } else {
                resourceName = null;
                id = null;
                version = null;
            }
            BaseHttpClientInvocation invocation = OperationMethodBinding.createOperationInvocation(GenericClient.this.myContext, resourceName, id, version, this.myOperationName, this.myParameters, this.myUseHttpGet);
            if (this.myReturnResourceType != null) {
                BaseClient.ResourceResponseHandler handler = new BaseClient.ResourceResponseHandler(this.myReturnResourceType);
                Object retVal = this.invoke(null, handler, invocation);
                return retVal;
            }
            BaseClient.ResourceResponseHandler handler = new BaseClient.ResourceResponseHandler();
            handler.setPreferResponseTypes(this.getPreferResponseTypes(this.myType));
            Object retVal = this.invoke(null, handler, invocation);
            if (GenericClient.this.myContext.getResourceDefinition((IBaseResource)retVal).getName().equals("Parameters")) {
                return retVal;
            }
            RuntimeResourceDefinition def = GenericClient.this.myContext.getResourceDefinition("Parameters");
            IBaseResource parameters = (IBaseResource)def.newInstance();
            BaseRuntimeChildDefinition paramChild = def.getChildByName("parameter");
            BaseRuntimeElementCompositeDefinition paramChildElem = (BaseRuntimeElementCompositeDefinition)paramChild.getChildByName("parameter");
            IBase parameter = paramChildElem.newInstance();
            paramChild.getMutator().addValue((Object)parameters, parameter);
            BaseRuntimeChildDefinition resourceElem = paramChildElem.getChildByName("resource");
            resourceElem.getMutator().addValue((Object)parameter, (IBase)retVal);
            return parameters;
        }

        public IOperationUntyped named(String theName) {
            Validate.notBlank((CharSequence)theName, (String)"theName can not be null", (Object[])new Object[0]);
            this.myOperationName = theName;
            return this;
        }

        public IOperationUnnamed onInstance(IIdType theId) {
            this.myId = theId.toVersionless();
            return this;
        }

        public IOperationUnnamed onInstanceVersion(IIdType theId) {
            this.myId = theId;
            return this;
        }

        public IOperationUnnamed onServer() {
            return this;
        }

        public IOperationUnnamed onType(Class<? extends IBaseResource> theResourceType) {
            this.myType = theResourceType;
            return this;
        }

        public IOperationProcessMsg processMessage() {
            this.myOperationName = "$process-message";
            return this;
        }

        public IOperationUntypedWithInput returnResourceType(Class theReturnType) {
            Validate.notNull((Object)theReturnType, (String)"theReturnType must not be null", (Object[])new Object[0]);
            Validate.isTrue((boolean)IBaseResource.class.isAssignableFrom(theReturnType), (String)"theReturnType must be a class which extends from IBaseResource", (Object[])new Object[0]);
            this.myReturnResourceType = theReturnType;
            return this;
        }

        public IOperationProcessMsgMode setMessageBundle(IBaseBundle theMsgBundle) {
            Validate.notNull((Object)theMsgBundle, (String)"theMsgBundle must not be null", (Object[])new Object[0]);
            this.myMsgBundle = theMsgBundle;
            return this;
        }

        public IOperationProcessMsg setResponseUrlParam(String responseUrl) {
            Validate.notEmpty((CharSequence)responseUrl, (String)"responseUrl must not be null", (Object[])new Object[0]);
            Validate.matchesPattern((CharSequence)responseUrl, (String)"^(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]", (String)"responseUrl must be a valid URL", (Object[])new Object[0]);
            this.myResponseUrl = responseUrl;
            return this;
        }

        public IOperationProcessMsgMode synchronous(Class theResponseClass) {
            this.myIsAsync = false;
            Validate.notNull((Object)theResponseClass, (String)"theReturnType must not be null", (Object[])new Object[0]);
            Validate.isTrue((boolean)IBaseResource.class.isAssignableFrom(theResponseClass), (String)"theReturnType must be a class which extends from IBaseResource", (Object[])new Object[0]);
            this.myReturnResourceType = theResponseClass;
            return this;
        }

        public IOperationUntypedWithInput useHttpGet() {
            this.myUseHttpGet = true;
            return this;
        }

        public <T extends IBaseParameters> IOperationUntypedWithInputAndPartialOutput<T> withNoParameters(Class<T> theOutputParameterType) {
            Validate.notNull(theOutputParameterType, (String)"theOutputParameterType may not be null", (Object[])new Object[0]);
            RuntimeResourceDefinition def = GenericClient.this.myContext.getResourceDefinition(theOutputParameterType);
            if (def == null) {
                throw new IllegalArgumentException("theOutputParameterType must refer to a HAPI FHIR Resource type: " + theOutputParameterType.getName());
            }
            if (!"Parameters".equals(def.getName())) {
                throw new IllegalArgumentException("theOutputParameterType must refer to a HAPI FHIR Resource type for a resource named Parameters - " + theOutputParameterType.getName() + " is a resource named: " + def.getName());
            }
            this.myParameters = (IBaseParameters)def.newInstance();
            return this;
        }

        public <T extends IBaseParameters> IOperationUntypedWithInputAndPartialOutput<T> withParameter(Class<T> theParameterType, String theName, IBase theValue) {
            Validate.notNull(theParameterType, (String)"theParameterType must not be null", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)theName, (String)"theName must not be null", (Object[])new Object[0]);
            Validate.notNull((Object)theValue, (String)"theValue must not be null", (Object[])new Object[0]);
            this.myParametersDef = GenericClient.this.myContext.getResourceDefinition(theParameterType);
            this.myParameters = (IBaseParameters)this.myParametersDef.newInstance();
            this.addParam(theName, theValue);
            return this;
        }

        public IOperationUntypedWithInputAndPartialOutput withParameters(IBaseParameters theParameters) {
            Validate.notNull((Object)theParameters, (String)"theParameters can not be null", (Object[])new Object[0]);
            this.myParameters = theParameters;
            this.myParametersDef = GenericClient.this.myContext.getResourceDefinition(theParameters.getClass());
            return this;
        }

        public <T extends IBaseParameters> IOperationUntypedWithInputAndPartialOutput<T> withSearchParameter(Class<T> theParameterType, String theName, IQueryParameterType theValue) {
            Validate.notNull(theParameterType, (String)"theParameterType must not be null", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)theName, (String)"theName must not be null", (Object[])new Object[0]);
            Validate.notNull((Object)theValue, (String)"theValue must not be null", (Object[])new Object[0]);
            this.myParametersDef = GenericClient.this.myContext.getResourceDefinition(theParameterType);
            this.myParameters = (IBaseParameters)this.myParametersDef.newInstance();
            this.addParam(theName, theValue);
            return this;
        }
    }

    private final class MetaParametersResponseHandler<T extends IBaseMetaType>
    implements IClientResponseHandler<T> {
        private Class<T> myType;

        public MetaParametersResponseHandler(Class<T> theMetaType) {
            this.myType = theMetaType;
        }

        @Override
        public T invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws BaseServerResponseException {
            EncodingEnum respType = EncodingEnum.forContentType((String)theResponseMimeType);
            if (respType == null) {
                throw NonFhirResponseException.newInstance((int)theResponseStatusCode, (String)theResponseMimeType, (Reader)theResponseReader);
            }
            IParser parser = respType.newParser(GenericClient.this.myContext);
            RuntimeResourceDefinition type = GenericClient.this.myContext.getResourceDefinition("Parameters");
            IBaseResource retVal = parser.parseResource(type.getImplementingClass(), theResponseReader);
            BaseRuntimeChildDefinition paramChild = type.getChildByName("parameter");
            BaseRuntimeElementCompositeDefinition paramChildElem = (BaseRuntimeElementCompositeDefinition)paramChild.getChildByName("parameter");
            List parameter = paramChild.getAccessor().getValues((Object)retVal);
            if (parameter == null || parameter.isEmpty()) {
                return (T)((IBaseMetaType)GenericClient.this.myContext.getElementDefinition(this.myType).newInstance());
            }
            IBase param = (IBase)parameter.get(0);
            List meta = paramChildElem.getChildByName("value[x]").getAccessor().getValues((Object)param);
            if (meta.isEmpty()) {
                return (T)((IBaseMetaType)GenericClient.this.myContext.getElementDefinition(this.myType).newInstance());
            }
            return (T)((IBaseMetaType)meta.get(0));
        }
    }

    private class MetaInternal
    extends BaseClientExecutable
    implements IMeta,
    IMetaAddOrDeleteUnsourced,
    IMetaGetUnsourced,
    IMetaAddOrDeleteSourced {
        private IIdType myId;
        private IBaseMetaType myMeta;
        private Class<? extends IBaseMetaType> myMetaType;
        private String myOnType;
        private MetaOperation myOperation;

        private MetaInternal() {
        }

        public IMetaAddOrDeleteUnsourced add() {
            this.myOperation = MetaOperation.ADD;
            return this;
        }

        public IMetaAddOrDeleteUnsourced delete() {
            this.myOperation = MetaOperation.DELETE;
            return this;
        }

        public Object execute() {
            BaseHttpClientInvocation invocation = null;
            IBaseParameters parameters = ParametersUtil.newInstance((FhirContext)GenericClient.this.myContext);
            switch (this.myOperation) {
                case ADD: {
                    ParametersUtil.addParameterToParameters((FhirContext)GenericClient.this.myContext, (IBaseParameters)parameters, (String)"meta", (Object)this.myMeta);
                    invocation = OperationMethodBinding.createOperationInvocation(GenericClient.this.myContext, this.myId.getResourceType(), this.myId.getIdPart(), null, "$meta-add", parameters, false);
                    break;
                }
                case DELETE: {
                    ParametersUtil.addParameterToParameters((FhirContext)GenericClient.this.myContext, (IBaseParameters)parameters, (String)"meta", (Object)this.myMeta);
                    invocation = OperationMethodBinding.createOperationInvocation(GenericClient.this.myContext, this.myId.getResourceType(), this.myId.getIdPart(), null, "$meta-delete", parameters, false);
                    break;
                }
                case GET: {
                    invocation = this.myId != null ? OperationMethodBinding.createOperationInvocation(GenericClient.this.myContext, this.myOnType, this.myId.getIdPart(), null, "$meta", parameters, true) : (this.myOnType != null ? OperationMethodBinding.createOperationInvocation(GenericClient.this.myContext, this.myOnType, null, null, "$meta", parameters, true) : OperationMethodBinding.createOperationInvocation(GenericClient.this.myContext, null, null, null, "$meta", parameters, true));
                }
            }
            if (invocation == null) {
                throw new IllegalStateException();
            }
            MetaParametersResponseHandler<? extends IBaseMetaType> handler = new MetaParametersResponseHandler<IBaseMetaType>(this.myMetaType);
            return this.invoke(null, handler, invocation);
        }

        public IClientExecutable fromResource(IIdType theId) {
            this.setIdInternal(theId);
            return this;
        }

        public IClientExecutable fromServer() {
            return this;
        }

        public IClientExecutable fromType(String theResourceName) {
            Validate.notBlank((CharSequence)theResourceName, (String)"theResourceName must not be blank", (Object[])new Object[0]);
            this.myOnType = theResourceName;
            return this;
        }

        public <T extends IBaseMetaType> IMetaGetUnsourced<T> get(Class<T> theType) {
            this.myMetaType = theType;
            this.myOperation = MetaOperation.GET;
            return this;
        }

        public <T extends IBaseMetaType> IClientExecutable<IClientExecutable<?, T>, T> meta(T theMeta) {
            Validate.notNull(theMeta, (String)"theMeta must not be null", (Object[])new Object[0]);
            this.myMeta = theMeta;
            this.myMetaType = this.myMeta.getClass();
            return this;
        }

        public IMetaAddOrDeleteSourced onResource(IIdType theId) {
            this.setIdInternal(theId);
            return this;
        }

        private void setIdInternal(IIdType theId) {
            Validate.notBlank((CharSequence)theId.getResourceType(), (String)"theId must contain a resource type", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)theId.getIdPart(), (String)"theId must contain an ID part", (Object[])new Object[0]);
            this.myOnType = theId.getResourceType();
            this.myId = theId;
        }
    }

    private final class LoadPageInternal
    implements IGetPage,
    IGetPageUntyped {
        private static final String PREV = "prev";
        private static final String PREVIOUS = "previous";
        private String myPageUrl;

        private LoadPageInternal() {
        }

        public <T extends IBaseBundle> IGetPageTyped andReturnBundle(Class<T> theBundleType) {
            Validate.notNull(theBundleType, (String)"theBundleType must not be null", (Object[])new Object[0]);
            return new GetPageInternal(this.myPageUrl, theBundleType);
        }

        public IGetPageUntyped byUrl(String thePageUrl) {
            if (StringUtils.isBlank((CharSequence)thePageUrl)) {
                throw new IllegalArgumentException("thePagingUrl must not be blank or null");
            }
            this.myPageUrl = thePageUrl;
            return this;
        }

        public <T extends IBaseBundle> IGetPageTyped<T> next(T theBundle) {
            return this.nextOrPrevious("next", theBundle);
        }

        private <T extends IBaseBundle> IGetPageTyped<T> nextOrPrevious(String theWantRel, T theBundle) {
            RuntimeResourceDefinition def = GenericClient.this.myContext.getResourceDefinition(theBundle);
            List links = def.getChildByName("link").getAccessor().getValues(theBundle);
            if (links == null || links.isEmpty()) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(GenericClient.class, "noPagingLinkFoundInBundle", new Object[]{theWantRel}));
            }
            for (IBase nextLink : links) {
                String url;
                List urls;
                String relation;
                BaseRuntimeElementCompositeDefinition linkDef = (BaseRuntimeElementCompositeDefinition)GenericClient.this.myContext.getElementDefinition(nextLink.getClass());
                List rel = linkDef.getChildByName("relation").getAccessor().getValues((Object)nextLink);
                if (rel == null || rel.isEmpty() || !theWantRel.equals(relation = ((IPrimitiveType)rel.get(0)).getValueAsString()) && (theWantRel != PREVIOUS || !PREV.equals(relation)) || (urls = linkDef.getChildByName("url").getAccessor().getValues((Object)nextLink)) == null || urls.isEmpty() || StringUtils.isBlank((CharSequence)(url = ((IPrimitiveType)urls.get(0)).getValueAsString()))) continue;
                return this.byUrl(url).andReturnBundle(theBundle.getClass());
            }
            throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(GenericClient.class, "noPagingLinkFoundInBundle", new Object[]{theWantRel}));
        }

        public <T extends IBaseBundle> IGetPageTyped<T> previous(T theBundle) {
            return this.nextOrPrevious(PREVIOUS, theBundle);
        }
    }

    private class HistoryInternal
    extends BaseClientExecutable
    implements IHistory,
    IHistoryUntyped,
    IHistoryTyped {
        private Integer myCount;
        private IIdType myId;
        private Class<? extends IBaseBundle> myReturnType;
        private IPrimitiveType mySince;
        private Class<? extends IBaseResource> myType;
        private DateRangeParam myAt;

        private HistoryInternal() {
        }

        public IHistoryTyped andReturnBundle(Class theType) {
            Validate.notNull((Object)theType, (String)"theType must not be null on method andReturnBundle(Class)", (Object[])new Object[0]);
            this.myReturnType = theType;
            return this;
        }

        public IHistoryTyped at(DateRangeParam theDateRangeParam) {
            this.myAt = theDateRangeParam;
            return this;
        }

        public IHistoryTyped count(Integer theCount) {
            this.myCount = theCount;
            return this;
        }

        public Object execute() {
            String id;
            String resourceName;
            if (this.myType != null) {
                resourceName = GenericClient.this.myContext.getResourceDefinition(this.myType).getName();
                id = null;
            } else if (this.myId != null) {
                resourceName = this.myId.getResourceType();
                id = this.myId.getIdPart();
            } else {
                resourceName = null;
                id = null;
            }
            HttpGetClientInvocation invocation = HistoryMethodBinding.createHistoryInvocation(GenericClient.this.myContext, resourceName, id, (IPrimitiveType<Date>)this.mySince, this.myCount, this.myAt);
            BaseClient.ResourceResponseHandler<? extends IBaseBundle> handler = new BaseClient.ResourceResponseHandler<IBaseBundle>(this.myReturnType, this.getPreferResponseTypes(this.myType));
            return this.invoke(null, handler, invocation);
        }

        public IHistoryUntyped onInstance(IIdType theId) {
            if (!theId.hasResourceType()) {
                throw new IllegalArgumentException("Resource ID does not have a resource type: " + theId.getValue());
            }
            this.myId = theId;
            return this;
        }

        public IHistoryUntyped onServer() {
            return this;
        }

        public IHistoryUntyped onType(Class<? extends IBaseResource> theResourceType) {
            this.myType = theResourceType;
            return this;
        }

        public IHistoryTyped since(Date theCutoff) {
            this.mySince = theCutoff != null ? new InstantDt(theCutoff) : null;
            return this;
        }

        public IHistoryTyped since(IPrimitiveType theCutoff) {
            this.mySince = theCutoff;
            return this;
        }
    }

    private class GetPageInternal
    extends BaseClientExecutable<IGetPageTyped<Object>, Object>
    implements IGetPageTyped<Object> {
        private Class<? extends IBaseBundle> myBundleType;
        private String myUrl;

        public GetPageInternal(String theUrl, Class<? extends IBaseBundle> theBundleType) {
            this.myUrl = theUrl;
            this.myBundleType = theBundleType;
        }

        public Object execute() {
            BaseClient.ResourceResponseHandler<? extends IBaseBundle> binding = new BaseClient.ResourceResponseHandler<IBaseBundle>(this.myBundleType, this.getPreferResponseTypes());
            HttpSimpleGetClientInvocation invocation = new HttpSimpleGetClientInvocation(GenericClient.this.myContext, this.myUrl);
            Map<String, List<String>> params = null;
            return this.invoke(params, binding, invocation);
        }
    }

    private class FetchConformanceInternal
    extends BaseClientExecutable
    implements IFetchConformanceUntyped,
    IFetchConformanceTyped {
        private RuntimeResourceDefinition myType;

        private FetchConformanceInternal() {
        }

        public Object execute() {
            BaseClient.ResourceResponseHandler binding = new BaseClient.ResourceResponseHandler(this.myType.getImplementingClass());
            FhirContext fhirContext = GenericClient.this.getFhirContext();
            HttpGetClientInvocation invocation = MethodUtil.createConformanceInvocation(fhirContext);
            return super.invoke(null, binding, invocation);
        }

        public <T extends IBaseConformance> IFetchConformanceTyped<T> ofType(Class<T> theResourceType) {
            Validate.notNull(theResourceType, (String)"theResourceType must not be null", (Object[])new Object[0]);
            this.myType = GenericClient.this.myContext.getResourceDefinition(theResourceType);
            if (this.myType == null) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(I18N_CANNOT_DETEMINE_RESOURCE_TYPE, new Object[]{theResourceType}));
            }
            return this;
        }
    }

    private class DeleteInternal
    extends BaseSearch<IDeleteTyped, IDeleteWithQueryTyped, IBaseOperationOutcome>
    implements IDelete,
    IDeleteTyped,
    IDeleteWithQuery,
    IDeleteWithQueryTyped {
        private boolean myConditional;
        private IIdType myId;
        private String myResourceType;
        private String mySearchUrl;

        private DeleteInternal() {
        }

        public IBaseOperationOutcome execute() {
            HttpDeleteClientInvocation invocation = this.myId != null ? DeleteMethodBinding.createDeleteInvocation(GenericClient.this.getFhirContext(), this.myId) : (this.myConditional ? DeleteMethodBinding.createDeleteInvocation(GenericClient.this.getFhirContext(), this.myResourceType, this.getParamMap()) : DeleteMethodBinding.createDeleteInvocation(GenericClient.this.getFhirContext(), this.mySearchUrl));
            OperationOutcomeResponseHandler binding = new OperationOutcomeResponseHandler();
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            return this.invoke(params, binding, invocation);
        }

        public IDeleteTyped resource(IBaseResource theResource) {
            Validate.notNull((Object)theResource, (String)"theResource can not be null", (Object[])new Object[0]);
            IIdType id = theResource.getIdElement();
            Validate.notNull((Object)id, (String)"theResource.getIdElement() can not be null", (Object[])new Object[0]);
            if (!id.hasResourceType() || !id.hasIdPart()) {
                throw new IllegalArgumentException("theResource.getId() must contain a resource type and logical ID at a minimum (e.g. Patient/1234), found: " + id.getValue());
            }
            this.myId = id;
            return this;
        }

        public IDeleteTyped resourceById(IIdType theId) {
            Validate.notNull((Object)theId, (String)"theId can not be null", (Object[])new Object[0]);
            if (!theId.hasResourceType() || !theId.hasIdPart()) {
                throw new IllegalArgumentException("theId must contain a resource type and logical ID at a minimum (e.g. Patient/1234)found: " + theId.getValue());
            }
            this.myId = theId;
            return this;
        }

        public IDeleteTyped resourceById(String theResourceType, String theLogicalId) {
            Validate.notBlank((CharSequence)theResourceType, (String)"theResourceType can not be blank/null", (Object[])new Object[0]);
            if (GenericClient.this.myContext.getResourceDefinition(theResourceType) == null) {
                throw new IllegalArgumentException("Unknown resource type");
            }
            Validate.notBlank((CharSequence)theLogicalId, (String)"theLogicalId can not be blank/null", (Object[])new Object[0]);
            if (theLogicalId.contains("/")) {
                throw new IllegalArgumentException("LogicalId can not contain '/' (should only be the logical ID portion, not a qualified ID)");
            }
            this.myId = new IdDt(theResourceType, theLogicalId);
            return this;
        }

        public IDeleteWithQuery resourceConditionalByType(Class<? extends IBaseResource> theResourceType) {
            Validate.notNull(theResourceType, (String)"theResourceType can not be null", (Object[])new Object[0]);
            this.myConditional = true;
            this.myResourceType = GenericClient.this.myContext.getResourceDefinition(theResourceType).getName();
            return this;
        }

        public IDeleteWithQuery resourceConditionalByType(String theResourceType) {
            Validate.notBlank((CharSequence)theResourceType, (String)"theResourceType can not be blank/null", (Object[])new Object[0]);
            if (GenericClient.this.myContext.getResourceDefinition(theResourceType) == null) {
                throw new IllegalArgumentException("Unknown resource type: " + theResourceType);
            }
            this.myResourceType = theResourceType;
            this.myConditional = true;
            return this;
        }

        public IDeleteTyped resourceConditionalByUrl(String theSearchUrl) {
            this.mySearchUrl = GenericClient.validateAndEscapeConditionalUrl(theSearchUrl);
            return this;
        }
    }

    private class CreateInternal
    extends BaseSearch<ICreateTyped, ICreateWithQueryTyped, MethodOutcome>
    implements ICreate,
    ICreateTyped,
    ICreateWithQuery,
    ICreateWithQueryTyped {
        private boolean myConditional;
        private PreferReturnEnum myPrefer;
        private IBaseResource myResource;
        private String myResourceBody;
        private String mySearchUrl;

        private CreateInternal() {
        }

        public ICreateWithQuery conditional() {
            this.myConditional = true;
            return this;
        }

        public ICreateTyped conditionalByUrl(String theSearchUrl) {
            this.mySearchUrl = GenericClient.validateAndEscapeConditionalUrl(theSearchUrl);
            return this;
        }

        public MethodOutcome execute() {
            if (this.myResource == null) {
                this.myResource = this.parseResourceBody(this.myResourceBody);
            }
            if (this.getParamEncoding() != null) {
                this.myResourceBody = null;
            }
            HttpPostClientInvocation invocation = this.mySearchUrl != null ? MethodUtil.createCreateInvocation(this.myResource, this.myResourceBody, GenericClient.this.myContext, this.mySearchUrl) : (this.myConditional ? MethodUtil.createCreateInvocation(this.myResource, this.myResourceBody, GenericClient.this.myContext, this.getParamMap()) : MethodUtil.createCreateInvocation(this.myResource, this.myResourceBody, GenericClient.this.myContext));
            GenericClient.addPreferHeader(this.myPrefer, invocation);
            OutcomeResponseHandler binding = new OutcomeResponseHandler(this.myPrefer);
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            return this.invoke(params, binding, invocation);
        }

        public ICreateTyped prefer(PreferReturnEnum theReturn) {
            this.myPrefer = theReturn;
            return this;
        }

        public ICreateTyped resource(IBaseResource theResource) {
            Validate.notNull((Object)theResource, (String)"Resource can not be null", (Object[])new Object[0]);
            this.myResource = theResource;
            return this;
        }

        public ICreateTyped resource(String theResourceBody) {
            Validate.notBlank((CharSequence)theResourceBody, (String)"Body can not be null or blank", (Object[])new Object[0]);
            this.myResourceBody = theResourceBody;
            return this;
        }
    }

    private abstract class BaseSearch<EXEC extends IClientExecutable<?, OUTPUT>, QUERY extends IBaseQuery<QUERY>, OUTPUT>
    extends BaseClientExecutable<EXEC, OUTPUT>
    implements IBaseQuery<QUERY> {
        private Map<String, List<String>> myParams;

        private BaseSearch() {
            this.myParams = new LinkedHashMap<String, List<String>>();
        }

        public QUERY and(ICriterion<?> theCriterion) {
            return this.where(theCriterion);
        }

        public Map<String, List<String>> getParamMap() {
            return this.myParams;
        }

        public QUERY where(ICriterion<?> theCriterion) {
            ICriterionInternal criterion = (ICriterionInternal)theCriterion;
            String parameterName = criterion.getParameterName();
            String parameterValue = criterion.getParameterValue(GenericClient.this.myContext);
            if (StringUtils.isNotBlank((CharSequence)parameterValue)) {
                GenericClient.addParam(this.myParams, parameterName, parameterValue);
            }
            return (QUERY)this;
        }

        public QUERY whereMap(Map<String, List<String>> theRawMap) {
            if (theRawMap != null) {
                for (String nextKey : theRawMap.keySet()) {
                    for (String nextValue : theRawMap.get(nextKey)) {
                        GenericClient.addParam(this.myParams, nextKey, nextValue);
                    }
                }
            }
            return (QUERY)this;
        }

        public QUERY where(Map<String, List<IQueryParameterType>> theCriterion) {
            Validate.notNull(theCriterion, (String)"theCriterion must not be null", (Object[])new Object[0]);
            for (Map.Entry<String, List<IQueryParameterType>> nextEntry : theCriterion.entrySet()) {
                String nextKey = nextEntry.getKey();
                List<IQueryParameterType> nextValues = nextEntry.getValue();
                for (IQueryParameterType nextValue : nextValues) {
                    GenericClient.addParam(this.myParams, nextKey, nextValue.getValueAsQueryToken(GenericClient.this.myContext));
                }
            }
            return (QUERY)this;
        }
    }

    private abstract class BaseClientExecutable<T extends IClientExecutable<?, Y>, Y>
    implements IClientExecutable<T, Y> {
        protected EncodingEnum myParamEncoding;
        protected Boolean myPrettyPrint;
        protected SummaryEnum mySummaryMode;
        protected CacheControlDirective myCacheControlDirective;
        private List<Class<? extends IBaseResource>> myPreferResponseTypes;
        private boolean myQueryLogRequestAndResponse;
        private HashSet<String> mySubsetElements;

        private BaseClientExecutable() {
        }

        @Deprecated
        public T andLogRequestAndResponse(boolean theLogRequestAndResponse) {
            this.myQueryLogRequestAndResponse = theLogRequestAndResponse;
            return (T)this;
        }

        public T cacheControl(CacheControlDirective theCacheControlDirective) {
            this.myCacheControlDirective = theCacheControlDirective;
            return (T)this;
        }

        public T elementsSubset(String ... theElements) {
            this.mySubsetElements = theElements != null && theElements.length > 0 ? new HashSet<String>(Arrays.asList(theElements)) : null;
            return (T)this;
        }

        public T encoded(EncodingEnum theEncoding) {
            Validate.notNull((Object)theEncoding, (String)"theEncoding must not be null", (Object[])new Object[0]);
            this.myParamEncoding = theEncoding;
            return (T)this;
        }

        public T encodedJson() {
            this.myParamEncoding = EncodingEnum.JSON;
            return (T)this;
        }

        public T encodedXml() {
            this.myParamEncoding = EncodingEnum.XML;
            return (T)this;
        }

        protected EncodingEnum getParamEncoding() {
            return this.myParamEncoding;
        }

        public List<Class<? extends IBaseResource>> getPreferResponseTypes() {
            return this.myPreferResponseTypes;
        }

        public List<Class<? extends IBaseResource>> getPreferResponseTypes(Class<? extends IBaseResource> theDefault) {
            if (this.myPreferResponseTypes != null) {
                return this.myPreferResponseTypes;
            }
            return BaseClient.toTypeList(theDefault);
        }

        protected HashSet<String> getSubsetElements() {
            return this.mySubsetElements;
        }

        protected <Z> Z invoke(Map<String, List<String>> theParams, IClientResponseHandler<Z> theHandler, BaseHttpClientInvocation theInvocation) {
            if (GenericClient.this.isKeepResponses()) {
                GenericClient.this.myLastRequest = theInvocation.asHttpRequest(GenericClient.this.getServerBase(), theParams, GenericClient.this.getEncoding(), this.myPrettyPrint);
            }
            Z resp = GenericClient.this.invokeClient(GenericClient.this.myContext, theHandler, theInvocation, this.myParamEncoding, this.myPrettyPrint, this.myQueryLogRequestAndResponse || GenericClient.this.myLogRequestAndResponse, this.mySummaryMode, this.mySubsetElements, this.myCacheControlDirective);
            return resp;
        }

        protected IBaseResource parseResourceBody(String theResourceBody) {
            EncodingEnum encoding = EncodingEnum.detectEncodingNoDefault((String)theResourceBody);
            if (encoding == null) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(GenericClient.class, "cantDetermineRequestType", new Object[0]));
            }
            return encoding.newParser(GenericClient.this.myContext).parseResource(theResourceBody);
        }

        public T preferResponseType(Class<? extends IBaseResource> theClass) {
            this.myPreferResponseTypes = null;
            if (theClass != null) {
                this.myPreferResponseTypes = new ArrayList<Class<? extends IBaseResource>>();
                this.myPreferResponseTypes.add(theClass);
            }
            return (T)this;
        }

        public T preferResponseTypes(List<Class<? extends IBaseResource>> theClass) {
            this.myPreferResponseTypes = theClass;
            return (T)this;
        }

        public T prettyPrint() {
            this.myPrettyPrint = true;
            return (T)this;
        }

        public T summaryMode(SummaryEnum theSummary) {
            this.mySummaryMode = theSummary;
            return (T)this;
        }
    }

    private static enum MetaOperation {
        ADD,
        DELETE,
        GET;

    }
}

