/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.impl;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.CacheControlDirective;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.RequestFormatParamStyleEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.client.api.IClientInterceptor;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.rest.client.api.IRestfulClient;
import ca.uhn.fhir.rest.client.exceptions.FhirClientConnectionException;
import ca.uhn.fhir.rest.client.exceptions.InvalidResponseException;
import ca.uhn.fhir.rest.client.exceptions.NonFhirResponseException;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.impl.RestfulClientFactory;
import ca.uhn.fhir.rest.client.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.client.method.IClientResponseHandler;
import ca.uhn.fhir.rest.client.method.IClientResponseHandlerHandlesBinary;
import ca.uhn.fhir.rest.client.method.MethodUtil;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import ca.uhn.fhir.util.XmlDetectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseClient
implements IRestfulClient {
    public static final String HAPI_CLIENT_KEEPRESPONSES = "hapi.client.keepresponses";
    private static final Logger ourLog = LoggerFactory.getLogger(BaseClient.class);
    private final IHttpClient myClient;
    private final RestfulClientFactory myFactory;
    private final String myUrlBase;
    private boolean myDontValidateConformance;
    private EncodingEnum myEncoding = null;
    private List<IClientInterceptor> myInterceptors = new ArrayList<IClientInterceptor>();
    private boolean myKeepResponses = false;
    private IHttpResponse myLastResponse;
    private String myLastResponseBody;
    private Boolean myPrettyPrint = false;
    private SummaryEnum mySummary;
    private RequestFormatParamStyleEnum myRequestFormatParamStyle = RequestFormatParamStyleEnum.SHORT;

    BaseClient(IHttpClient theClient, String theUrlBase, RestfulClientFactory theFactory) {
        this.myClient = theClient;
        this.myUrlBase = theUrlBase;
        this.myFactory = theFactory;
        if ("true".equals(System.getProperty(HAPI_CLIENT_KEEPRESPONSES))) {
            this.setKeepResponses(true);
        }
        if (!XmlDetectionUtil.isStaxPresent()) {
            this.myEncoding = EncodingEnum.JSON;
        }
    }

    protected Map<String, List<String>> createExtraParams() {
        LinkedHashMap<String, List<String>> retVal = new LinkedHashMap<String, List<String>>();
        if (this.myRequestFormatParamStyle == RequestFormatParamStyleEnum.SHORT) {
            if (this.getEncoding() == EncodingEnum.XML) {
                retVal.put("_format", Collections.singletonList("xml"));
            } else if (this.getEncoding() == EncodingEnum.JSON) {
                retVal.put("_format", Collections.singletonList("json"));
            }
        }
        if (this.isPrettyPrint()) {
            retVal.put("_pretty", Collections.singletonList("true"));
        }
        return retVal;
    }

    public <T extends IBaseResource> T fetchResourceFromUrl(Class<T> theResourceType, String theUrl) {
        HttpGetClientInvocation clientInvocation = new HttpGetClientInvocation(this.getFhirContext(), theUrl);
        ResourceResponseHandler<T> binding = new ResourceResponseHandler<T>(theResourceType);
        return (T)((IBaseResource)this.invokeClient(this.getFhirContext(), binding, clientInvocation, null, false, false, null, null, null));
    }

    void forceConformanceCheck() {
        this.myFactory.validateServerBase(this.myUrlBase, this.myClient, this);
    }

    public EncodingEnum getEncoding() {
        return this.myEncoding;
    }

    public void setEncoding(EncodingEnum theEncoding) {
        this.myEncoding = theEncoding;
    }

    public IHttpClient getHttpClient() {
        return this.myClient;
    }

    public List<IClientInterceptor> getInterceptors() {
        return Collections.unmodifiableList(this.myInterceptors);
    }

    public IHttpResponse getLastResponse() {
        return this.myLastResponse;
    }

    public String getLastResponseBody() {
        return this.myLastResponseBody;
    }

    public String getServerBase() {
        return this.myUrlBase;
    }

    public SummaryEnum getSummary() {
        return this.mySummary;
    }

    public void setSummary(SummaryEnum theSummary) {
        this.mySummary = theSummary;
    }

    public String getUrlBase() {
        return this.myUrlBase;
    }

    public void setFormatParamStyle(RequestFormatParamStyleEnum theRequestFormatParamStyle) {
        Validate.notNull((Object)theRequestFormatParamStyle, (String)"theRequestFormatParamStyle must not be null", (Object[])new Object[0]);
        this.myRequestFormatParamStyle = theRequestFormatParamStyle;
    }

    <T> T invokeClient(FhirContext theContext, IClientResponseHandler<T> binding, BaseHttpClientInvocation clientInvocation) {
        return this.invokeClient(theContext, binding, clientInvocation, false);
    }

    <T> T invokeClient(FhirContext theContext, IClientResponseHandler<T> binding, BaseHttpClientInvocation clientInvocation, boolean theLogRequestAndResponse) {
        return this.invokeClient(theContext, binding, clientInvocation, null, null, theLogRequestAndResponse, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T invokeClient(FhirContext theContext, IClientResponseHandler<T> binding, BaseHttpClientInvocation clientInvocation, EncodingEnum theEncoding, Boolean thePrettyPrint, boolean theLogRequestAndResponse, SummaryEnum theSummaryMode, Set<String> theSubsetElements, CacheControlDirective theCacheControlDirective) {
        T t;
        InputStream reader;
        IClientResponseHandlerHandlesBinary handlesBinary;
        if (!this.myDontValidateConformance) {
            this.myFactory.validateServerBaseIfConfiguredToDoSo(this.myUrlBase, this.myClient, this);
        }
        IHttpRequest httpRequest = null;
        IHttpResponse response = null;
        Map<String, List<String>> params = this.createExtraParams();
        if (clientInvocation instanceof HttpGetClientInvocation && this.myRequestFormatParamStyle == RequestFormatParamStyleEnum.SHORT) {
            if (theEncoding == EncodingEnum.XML) {
                params.put("_format", Collections.singletonList("xml"));
            } else if (theEncoding == EncodingEnum.JSON) {
                params.put("_format", Collections.singletonList("json"));
            }
        }
        if (theSummaryMode != null) {
            params.put("_summary", Collections.singletonList(theSummaryMode.getCode()));
        } else if (this.mySummary != null) {
            params.put("_summary", Collections.singletonList(this.mySummary.getCode()));
        }
        if (thePrettyPrint == Boolean.TRUE) {
            params.put("_pretty", Collections.singletonList("true"));
        }
        if (theSubsetElements != null && !theSubsetElements.isEmpty()) {
            params.put("_elements", Collections.singletonList(StringUtils.join(theSubsetElements, (char)',')));
        }
        EncodingEnum encoding = this.getEncoding();
        if (theEncoding != null) {
            encoding = theEncoding;
        }
        httpRequest = clientInvocation.asHttpRequest(this.myUrlBase, params, encoding, thePrettyPrint);
        if (theCacheControlDirective != null) {
            StringBuilder b = new StringBuilder();
            this.addToCacheControlHeader(b, "no-cache", theCacheControlDirective.isNoCache());
            this.addToCacheControlHeader(b, "no-store", theCacheControlDirective.isNoStore());
            if (theCacheControlDirective.getMaxResults() != null) {
                this.addToCacheControlHeader(b, "max-results=" + Integer.toString(theCacheControlDirective.getMaxResults()), true);
            }
            if (b.length() > 0) {
                httpRequest.addHeader("Cache-Control", b.toString());
            }
        }
        if (theLogRequestAndResponse) {
            ourLog.info("Client invoking: {}", (Object)httpRequest);
            Iterator<IClientInterceptor> body = httpRequest.getRequestBodyFromStream();
            if (body != null) {
                ourLog.info("Client request body: {}", (Object)body);
            }
        }
        for (IClientInterceptor nextInterceptor : this.myInterceptors) {
            nextInterceptor.interceptRequest(httpRequest);
        }
        response = httpRequest.execute();
        for (IClientInterceptor nextInterceptor : this.myInterceptors) {
            nextInterceptor.interceptResponse(response);
        }
        String mimeType = 204 == response.getStatus() ? null : response.getMimeType();
        Map headers = response.getAllHeaders();
        if (response.getStatus() < 200 || response.getStatus() > 299) {
            String body = null;
            Reader reader2 = null;
            try {
                reader2 = response.createReader();
                body = IOUtils.toString((Reader)reader2);
            }
            catch (Exception e) {
                ourLog.debug("Failed to read input stream", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader2);
            }
            String message = "HTTP " + response.getStatus() + " " + response.getStatusInfo();
            IBaseOperationOutcome oo = null;
            if ("text/plain".equals(mimeType)) {
                message = message + ": " + body;
            } else {
                EncodingEnum enc = EncodingEnum.forContentType((String)mimeType);
                if (enc != null) {
                    IParser p = enc.newParser(theContext);
                    try {
                        oo = (IBaseOperationOutcome)p.parseResource(body);
                        String details = OperationOutcomeUtil.getFirstIssueDetails((FhirContext)this.getFhirContext(), (IBaseOperationOutcome)oo);
                        if (StringUtils.isNotBlank((CharSequence)details)) {
                            message = message + ": " + details;
                        }
                    }
                    catch (Exception e) {
                        ourLog.debug("Failed to process OperationOutcome response");
                    }
                }
            }
            this.keepResponseAndLogIt(theLogRequestAndResponse, response, body);
            BaseServerResponseException exception = BaseServerResponseException.newInstance((int)response.getStatus(), (String)message);
            exception.setOperationOutcome(oo);
            if (body == null) throw exception;
            exception.setResponseBody(body);
            throw exception;
        }
        if (binding instanceof IClientResponseHandlerHandlesBinary && (handlesBinary = (IClientResponseHandlerHandlesBinary)binding).isBinary()) {
            reader = response.readEntity();
            Object t2 = handlesBinary.invokeClient(mimeType, reader, response.getStatus(), (Map<String, List<String>>)headers);
            return t2;
        }
        Reader reader3 = response.createReader();
        if (ourLog.isTraceEnabled() || this.myKeepResponses || theLogRequestAndResponse) {
            String responseString = IOUtils.toString((Reader)reader3);
            this.keepResponseAndLogIt(theLogRequestAndResponse, response, responseString);
            reader3 = new StringReader(responseString);
        }
        try {
            t = binding.invokeClient(mimeType, reader3, response.getStatus(), headers);
        }
        catch (Throwable throwable) {
            String msg;
            try {
                IOUtils.closeQuietly((Reader)reader3);
                throw throwable;
            }
            catch (DataFormatException e) {
                if (httpRequest != null) {
                    msg = this.getFhirContext().getLocalizer().getMessage(BaseClient.class, "failedToParseResponse", new Object[]{httpRequest.getHttpVerbName(), httpRequest.getUri(), e.toString()});
                    throw new FhirClientConnectionException(msg, (Throwable)e);
                }
                msg = this.getFhirContext().getLocalizer().getMessage(BaseClient.class, "failedToParseResponse", new Object[]{"UNKNOWN", "UNKNOWN", e.toString()});
                throw new FhirClientConnectionException(msg, (Throwable)e);
            }
            catch (IllegalStateException e) {
                throw new FhirClientConnectionException((Throwable)e);
            }
            catch (IOException e) {
                msg = this.getFhirContext().getLocalizer().getMessage(BaseClient.class, "failedToParseResponse", new Object[]{httpRequest.getHttpVerbName(), httpRequest.getUri(), e.toString()});
                throw new FhirClientConnectionException(msg, (Throwable)e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {}
            throw new FhirClientConnectionException((Throwable)e);
            finally {
                IOUtils.closeQuietly((InputStream)reader);
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        IOUtils.closeQuietly((Reader)reader3);
        return t;
    }

    private void addToCacheControlHeader(StringBuilder theBuilder, String theDirective, boolean theActive) {
        if (theActive) {
            if (theBuilder.length() > 0) {
                theBuilder.append(", ");
            }
            theBuilder.append(theDirective);
        }
    }

    public boolean isKeepResponses() {
        return this.myKeepResponses;
    }

    public void setKeepResponses(boolean theKeepResponses) {
        this.myKeepResponses = theKeepResponses;
    }

    public boolean isPrettyPrint() {
        return Boolean.TRUE.equals(this.myPrettyPrint);
    }

    public void setPrettyPrint(Boolean thePrettyPrint) {
        this.myPrettyPrint = thePrettyPrint;
    }

    private void keepResponseAndLogIt(boolean theLogRequestAndResponse, IHttpResponse response, String responseString) {
        if (this.myKeepResponses) {
            this.myLastResponse = response;
            this.myLastResponseBody = responseString;
        }
        if (theLogRequestAndResponse) {
            String message = "HTTP " + response.getStatus() + " " + response.getStatusInfo();
            if (StringUtils.isNotBlank((CharSequence)responseString)) {
                ourLog.info("Client response: {}\n{}", (Object)message, (Object)responseString);
            } else {
                ourLog.info("Client response: {}", (Object)message, (Object)responseString);
            }
        } else {
            ourLog.trace("FHIR response:\n{}\n{}", (Object)response, (Object)responseString);
        }
    }

    public void registerInterceptor(IClientInterceptor theInterceptor) {
        Validate.notNull((Object)theInterceptor, (String)"Interceptor can not be null", (Object[])new Object[0]);
        this.myInterceptors.add(theInterceptor);
    }

    public void setDontValidateConformance(boolean theDontValidateConformance) {
        this.myDontValidateConformance = theDontValidateConformance;
    }

    public void unregisterInterceptor(IClientInterceptor theInterceptor) {
        Validate.notNull((Object)theInterceptor, (String)"Interceptor can not be null", (Object[])new Object[0]);
        this.myInterceptors.remove(theInterceptor);
    }

    static ArrayList<Class<? extends IBaseResource>> toTypeList(Class<? extends IBaseResource> thePreferResponseType) {
        ArrayList<Class<? extends IBaseResource>> preferResponseTypes = null;
        if (thePreferResponseType != null) {
            preferResponseTypes = new ArrayList<Class<? extends IBaseResource>>(1);
            preferResponseTypes.add(thePreferResponseType);
        }
        return preferResponseTypes;
    }

    protected final class ResourceResponseHandler<T extends IBaseResource>
    implements IClientResponseHandler<T> {
        private boolean myAllowHtmlResponse;
        private IIdType myId;
        private List<Class<? extends IBaseResource>> myPreferResponseTypes;
        private Class<T> myReturnType;

        public ResourceResponseHandler() {
            this(null);
        }

        public ResourceResponseHandler(Class<T> theReturnType) {
            this(theReturnType, null, null);
        }

        public ResourceResponseHandler(Class<T> theReturnType, Class<? extends IBaseResource> thePreferResponseType, IIdType theId) {
            this(theReturnType, thePreferResponseType, theId, false);
        }

        public ResourceResponseHandler(Class<T> theReturnType, Class<? extends IBaseResource> thePreferResponseType, IIdType theId, boolean theAllowHtmlResponse) {
            this(theReturnType, BaseClient.toTypeList(thePreferResponseType), theId, theAllowHtmlResponse);
        }

        public ResourceResponseHandler(Class<T> theClass, List<Class<? extends IBaseResource>> thePreferResponseTypes) {
            this(theClass, thePreferResponseTypes, null, false);
        }

        public ResourceResponseHandler(Class<T> theReturnType, List<Class<? extends IBaseResource>> thePreferResponseTypes, IIdType theId, boolean theAllowHtmlResponse) {
            this.myReturnType = theReturnType;
            this.myId = theId;
            this.myPreferResponseTypes = thePreferResponseTypes;
            this.myAllowHtmlResponse = theAllowHtmlResponse;
        }

        @Override
        public T invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws BaseServerResponseException {
            EncodingEnum respType = EncodingEnum.forContentType((String)theResponseMimeType);
            if (respType == null) {
                if (this.myAllowHtmlResponse && theResponseMimeType.toLowerCase().contains("text/html") && this.myReturnType != null) {
                    return this.readHtmlResponse(theResponseReader);
                }
                throw NonFhirResponseException.newInstance((int)theResponseStatusCode, (String)theResponseMimeType, (Reader)theResponseReader);
            }
            IParser parser = respType.newParser(BaseClient.this.getFhirContext());
            parser.setServerBaseUrl(BaseClient.this.getUrlBase());
            if (this.myPreferResponseTypes != null) {
                parser.setPreferTypes(this.myPreferResponseTypes);
            }
            IBaseResource retVal = parser.parseResource(this.myReturnType, theResponseReader);
            MethodUtil.parseClientRequestResourceHeaders(this.myId, theHeaders, retVal);
            return (T)retVal;
        }

        private T readHtmlResponse(Reader theResponseReader) {
            RuntimeResourceDefinition resDef = BaseClient.this.getFhirContext().getResourceDefinition(this.myReturnType);
            IBaseResource instance = (IBaseResource)resDef.newInstance();
            BaseRuntimeChildDefinition textChild = resDef.getChildByName("text");
            BaseRuntimeElementCompositeDefinition textElement = (BaseRuntimeElementCompositeDefinition)textChild.getChildByName("text");
            IBase textInstance = textElement.newInstance();
            textChild.getMutator().addValue((Object)instance, textInstance);
            BaseRuntimeChildDefinition divChild = textElement.getChildByName("div");
            BaseRuntimeElementDefinition divElement = divChild.getChildByName("div");
            IPrimitiveType divInstance = (IPrimitiveType)divElement.newInstance();
            try {
                divInstance.setValueAsString(IOUtils.toString((Reader)theResponseReader));
            }
            catch (Exception e) {
                throw new InvalidResponseException(400, "Failed to process HTML response from server: " + e.getMessage(), (Throwable)e);
            }
            divChild.getMutator().addValue((Object)textInstance, (IBase)divInstance);
            return (T)instance;
        }

        public void setPreferResponseTypes(List<Class<? extends IBaseResource>> thePreferResponseTypes) {
            this.myPreferResponseTypes = thePreferResponseTypes;
        }
    }
}

