/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.apache;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.api.Header;
import ca.uhn.fhir.rest.client.api.HttpClientUtil;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.method.MethodUtil;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseBinary;

public abstract class BaseHttpClient
implements IHttpClient {
    private final List<Header> myHeaders;
    private final Map<String, List<String>> myIfNoneExistParams;
    private final String myIfNoneExistString;
    protected final RequestTypeEnum myRequestType;
    protected final StringBuilder myUrl;

    public BaseHttpClient(StringBuilder theUrl, Map<String, List<String>> theIfNoneExistParams, String theIfNoneExistString, RequestTypeEnum theRequestType, List<Header> theHeaders) {
        this.myUrl = theUrl;
        this.myIfNoneExistParams = theIfNoneExistParams;
        this.myIfNoneExistString = theIfNoneExistString;
        this.myRequestType = theRequestType;
        this.myHeaders = theHeaders;
    }

    private void addHeaderIfNoneExist(IHttpRequest result) {
        StringBuilder b;
        if (this.myIfNoneExistParams != null) {
            BaseHttpClientInvocation.appendExtraParamsWithQuestionMark(this.myIfNoneExistParams, b, (b = this.newHeaderBuilder(this.myUrl)).indexOf("?") == -1);
            result.addHeader("If-None-Exist", b.toString());
        }
        if (this.myIfNoneExistString != null) {
            b.append((b = this.newHeaderBuilder(this.myUrl)).indexOf("?") == -1 ? (char)'?' : '&');
            b.append(this.myIfNoneExistString.substring(this.myIfNoneExistString.indexOf(63) + 1));
            result.addHeader("If-None-Exist", b.toString());
        }
    }

    public void addHeadersToRequest(IHttpRequest theHttpRequest, EncodingEnum theEncoding, FhirContext theContext) {
        if (this.myHeaders != null) {
            for (Header next : this.myHeaders) {
                theHttpRequest.addHeader(next.getName(), next.getValue());
            }
        }
        theHttpRequest.addHeader("User-Agent", HttpClientUtil.createUserAgentString((FhirContext)theContext, (String)"apache"));
        theHttpRequest.addHeader("Accept-Charset", "utf-8");
        theHttpRequest.addHeader("Accept-Encoding", "gzip");
        this.addHeaderIfNoneExist(theHttpRequest);
        MethodUtil.addAcceptHeaderToRequest(theEncoding, theHttpRequest, theContext);
    }

    public IHttpRequest createBinaryRequest(FhirContext theContext, IBaseBinary theBinary) {
        byte[] content = theBinary.getContent();
        IHttpRequest retVal = this.createHttpRequest(content);
        this.addHeadersToRequest(retVal, null, theContext);
        retVal.addHeader("Content-Type", theBinary.getContentType());
        return retVal;
    }

    public IHttpRequest createByteRequest(FhirContext theContext, String theContents, String theContentType, EncodingEnum theEncoding) {
        IHttpRequest retVal = this.createHttpRequest(theContents);
        this.addHeadersToRequest(retVal, theEncoding, theContext);
        retVal.addHeader("Content-Type", theContentType + "; charset=UTF-8");
        return retVal;
    }

    public IHttpRequest createGetRequest(FhirContext theContext, EncodingEnum theEncoding) {
        IHttpRequest retVal = this.createHttpRequest();
        this.addHeadersToRequest(retVal, theEncoding, theContext);
        return retVal;
    }

    protected abstract IHttpRequest createHttpRequest();

    protected abstract IHttpRequest createHttpRequest(byte[] var1);

    protected abstract IHttpRequest createHttpRequest(Map<String, List<String>> var1);

    protected abstract IHttpRequest createHttpRequest(String var1);

    public IHttpRequest createParamRequest(FhirContext theContext, Map<String, List<String>> theParams, EncodingEnum theEncoding) {
        IHttpRequest retVal = this.createHttpRequest(theParams);
        this.addHeadersToRequest(retVal, theEncoding, theContext);
        return retVal;
    }

    private StringBuilder newHeaderBuilder(StringBuilder theUrlBase) {
        StringBuilder b = new StringBuilder();
        b.append((CharSequence)theUrlBase);
        if (theUrlBase.length() > 0 && theUrlBase.charAt(theUrlBase.length() - 1) == '/') {
            b.deleteCharAt(b.length() - 1);
        }
        return b;
    }
}

