/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.gclient;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.rest.gclient.BaseClientParam;
import ca.uhn.fhir.rest.gclient.ICriterion;
import ca.uhn.fhir.rest.gclient.ICriterionInternal;
import ca.uhn.fhir.rest.gclient.IParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DateClientParam
extends BaseClientParam
implements IParam {
    private String myParamName;

    @Override
    public String getParamName() {
        return this.myParamName;
    }

    public DateClientParam(String theParamName) {
        this.myParamName = theParamName;
    }

    public IDateSpecifier after() {
        return new DateWithPrefix(ParamPrefixEnum.GREATERTHAN);
    }

    public IDateSpecifier afterOrEquals() {
        return new DateWithPrefix(ParamPrefixEnum.GREATERTHAN_OR_EQUALS);
    }

    public IDateSpecifier before() {
        return new DateWithPrefix(ParamPrefixEnum.LESSTHAN);
    }

    public IDateSpecifier beforeOrEquals() {
        return new DateWithPrefix(ParamPrefixEnum.LESSTHAN_OR_EQUALS);
    }

    public IDateSpecifier exactly() {
        return new DateWithPrefix(ParamPrefixEnum.EQUAL);
    }

    public static interface IDateCriterion
    extends ICriterion<DateClientParam> {
        public IDateSpecifier orAfter();

        public IDateSpecifier orAfterOrEquals();

        public IDateSpecifier orBefore();

        public IDateSpecifier orBeforeOrEquals();

        public IDateSpecifier orExactly();
    }

    public static interface IDateSpecifier {
        public IDateCriterion day(Date var1);

        public IDateCriterion day(String var1);

        public IDateCriterion now();

        public IDateCriterion second(Date var1);

        public IDateCriterion second(String var1);
    }

    private class DateWithPrefix
    implements IDateSpecifier {
        private ParamPrefixEnum myPrefix;
        private Criterion previous = null;

        public DateWithPrefix(ParamPrefixEnum thePrefix, Criterion previous) {
            this.myPrefix = thePrefix;
            this.previous = previous;
        }

        public DateWithPrefix(ParamPrefixEnum thePrefix) {
            this.myPrefix = thePrefix;
        }

        @Override
        public IDateCriterion day(Date theValue) {
            DateTimeDt dt = new DateTimeDt(theValue);
            dt.setPrecision(TemporalPrecisionEnum.DAY);
            return this.constructCriterion(dt);
        }

        @Override
        public IDateCriterion day(String theValue) {
            DateTimeDt dt = new DateTimeDt(theValue);
            dt.setPrecision(TemporalPrecisionEnum.DAY);
            return this.constructCriterion(dt);
        }

        @Override
        public IDateCriterion now() {
            DateTimeDt dt = DateTimeDt.withCurrentTime();
            dt.setPrecision(TemporalPrecisionEnum.SECOND);
            return this.constructCriterion(dt);
        }

        @Override
        public IDateCriterion second(Date theValue) {
            DateTimeDt dt = new DateTimeDt(theValue);
            dt.setPrecision(TemporalPrecisionEnum.SECOND);
            return this.constructCriterion(dt);
        }

        @Override
        public IDateCriterion second(String theValue) {
            DateTimeDt dt = new DateTimeDt(theValue);
            dt.setPrecision(TemporalPrecisionEnum.SECOND);
            return this.constructCriterion(dt);
        }

        private IDateCriterion constructCriterion(DateTimeDt dt) {
            String valueAsString = dt.getValueAsString();
            Criterion criterion = new Criterion(this.myPrefix, valueAsString);
            if (this.previous != null) {
                criterion.orCriterion = this.previous;
            }
            return criterion;
        }
    }

    private class Criterion
    implements IDateCriterion,
    ICriterionInternal {
        private String myValue;
        private ParamPrefixEnum myPrefix;
        private Criterion orCriterion;

        public Criterion(ParamPrefixEnum thePrefix, String theValue) {
            this.myPrefix = thePrefix;
            this.myValue = theValue;
        }

        @Override
        public String getParameterName() {
            return DateClientParam.this.myParamName;
        }

        @Override
        public String getParameterValue(FhirContext theContext) {
            String orValue;
            StringBuilder b = new StringBuilder();
            if (this.orCriterion != null && StringUtils.isNotBlank((CharSequence)(orValue = this.orCriterion.getParameterValue(theContext)))) {
                b.append(orValue);
            }
            if (StringUtils.isNotBlank((CharSequence)this.myValue)) {
                if (b.length() > 0) {
                    b.append(',');
                }
                if (this.myPrefix != null && this.myPrefix != ParamPrefixEnum.EQUAL) {
                    b.append(this.myPrefix.getValue());
                }
                b.append(this.myValue);
            }
            return b.toString();
        }

        @Override
        public IDateSpecifier orAfter() {
            return new DateWithPrefix(ParamPrefixEnum.GREATERTHAN, this);
        }

        @Override
        public IDateSpecifier orAfterOrEquals() {
            return new DateWithPrefix(ParamPrefixEnum.GREATERTHAN_OR_EQUALS, this);
        }

        @Override
        public IDateSpecifier orBefore() {
            return new DateWithPrefix(ParamPrefixEnum.LESSTHAN, this);
        }

        @Override
        public IDateSpecifier orBeforeOrEquals() {
            return new DateWithPrefix(ParamPrefixEnum.LESSTHAN_OR_EQUALS, this);
        }

        @Override
        public IDateSpecifier orExactly() {
            return new DateWithPrefix(ParamPrefixEnum.EQUAL, this);
        }
    }
}

