/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.StrictErrorHandler;
import ca.uhn.fhir.parser.json.JsonLikeValue;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LenientErrorHandler
implements IParserErrorHandler {
    private static final Logger ourLog = LoggerFactory.getLogger(LenientErrorHandler.class);
    private static final StrictErrorHandler STRICT_ERROR_HANDLER = new StrictErrorHandler();
    private boolean myErrorOnInvalidValue = true;
    private boolean myLogErrors;

    public LenientErrorHandler() {
        this.myLogErrors = true;
    }

    public LenientErrorHandler(boolean theLogErrors) {
        this.myLogErrors = theLogErrors;
    }

    @Override
    public void containedResourceWithNoId(IParserErrorHandler.IParseLocation theLocation) {
        if (this.myLogErrors) {
            ourLog.warn("Resource has contained child resource with no ID");
        }
    }

    @Override
    public void incorrectJsonType(IParserErrorHandler.IParseLocation theLocation, String theElementName, JsonLikeValue.ValueType theExpected, JsonLikeValue.ScalarType theExpectedScalarType, JsonLikeValue.ValueType theFound, JsonLikeValue.ScalarType theFoundScalarType) {
        if (this.myLogErrors && ourLog.isWarnEnabled()) {
            String message = LenientErrorHandler.createIncorrectJsonTypeMessage(theElementName, theExpected, theExpectedScalarType, theFound, theFoundScalarType);
            ourLog.warn(message);
        }
    }

    @Override
    public void invalidValue(IParserErrorHandler.IParseLocation theLocation, String theValue, String theError) {
        if (StringUtils.isBlank((CharSequence)theValue) || !this.myErrorOnInvalidValue) {
            if (this.myLogErrors) {
                ourLog.warn("Invalid attribute value \"{}\": {}", (Object)theValue, (Object)theError);
            }
        } else {
            STRICT_ERROR_HANDLER.invalidValue(theLocation, theValue, theError);
        }
    }

    public boolean isErrorOnInvalidValue() {
        return this.myErrorOnInvalidValue;
    }

    @Override
    public void missingRequiredElement(IParserErrorHandler.IParseLocation theLocation, String theElementName) {
        if (this.myLogErrors) {
            ourLog.warn("Resource is missing required element: {}", (Object)theElementName);
        }
    }

    public LenientErrorHandler setErrorOnInvalidValue(boolean theErrorOnInvalidValue) {
        this.myErrorOnInvalidValue = theErrorOnInvalidValue;
        return this;
    }

    @Override
    public void unexpectedRepeatingElement(IParserErrorHandler.IParseLocation theLocation, String theElementName) {
        if (this.myLogErrors) {
            ourLog.warn("Multiple repetitions of non-repeatable element '{}' found while parsing", (Object)theElementName);
        }
    }

    @Override
    public void unknownAttribute(IParserErrorHandler.IParseLocation theLocation, String theElementName) {
        if (this.myLogErrors) {
            ourLog.warn("Unknown attribute '{}' found while parsing", (Object)theElementName);
        }
    }

    @Override
    public void unknownElement(IParserErrorHandler.IParseLocation theLocation, String theElementName) {
        if (this.myLogErrors) {
            ourLog.warn("Unknown element '{}' found while parsing", (Object)theElementName);
        }
    }

    @Override
    public void unknownReference(IParserErrorHandler.IParseLocation theLocation, String theReference) {
        if (this.myLogErrors) {
            ourLog.warn("Resource has invalid reference: {}", (Object)theReference);
        }
    }

    @Override
    public void extensionContainsValueAndNestedExtensions(IParserErrorHandler.IParseLocation theLocation) {
        if (this.myLogErrors) {
            ourLog.warn("Extension contains both a value and nested extensions: {}", (Object)theLocation);
        }
    }

    public static String createIncorrectJsonTypeMessage(String theElementName, JsonLikeValue.ValueType theExpected, JsonLikeValue.ScalarType theExpectedScalarType, JsonLikeValue.ValueType theFound, JsonLikeValue.ScalarType theFoundScalarType) {
        StringBuilder b = new StringBuilder();
        b.append("Found incorrect type for element ");
        b.append(theElementName);
        b.append(" - Expected ");
        b.append(theExpected.name());
        if (theExpectedScalarType != null) {
            b.append(" (");
            b.append(theExpectedScalarType.name());
            b.append(")");
        }
        b.append(" and found ");
        b.append(theFound.name());
        if (theFoundScalarType != null) {
            b.append(" (");
            b.append(theFoundScalarType.name());
            b.append(")");
        }
        String message = b.toString();
        return message;
    }
}

