/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.trie;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.matheclipse.parser.trie.Trie;
import org.matheclipse.parser.trie.TrieMatch;

public class TrieSet<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Object FLAG = new Object();
    public static final Object FLAG_NONE = null;
    protected Trie<E, Object> trie;

    public TrieSet(Trie<E, Object> trie) {
        this.trie = trie;
        this.trie.setDefaultValue(FLAG_NONE);
        this.trie.setDefaultMatch(TrieMatch.EXACT);
    }

    public Trie<E, Object> trie() {
        return this.trie;
    }

    @Override
    public boolean add(E value) {
        return this.trie.put(value, FLAG) == FLAG_NONE;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean changed = false;
        for (E element : collection) {
            changed |= this.add(element);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.trie.clear();
    }

    @Override
    public boolean contains(Object value) {
        return this.trie.containsKey(value);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object element : collection) {
            if (this.trie.containsKey(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.trie.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.trie.keySet().iterator();
    }

    @Override
    public boolean remove(Object value) {
        return this.trie.remove(value) == FLAG;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object element : collection) {
            changed |= this.remove(element);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        int previousSize = this.trie.size();
        Trie<E, Object> newTrie = this.trie.newEmptyClone();
        for (Object element : collection) {
            if (!this.trie.containsKey(element)) continue;
            newTrie.put((E)element, FLAG);
        }
        this.trie = newTrie;
        return previousSize != this.trie.size();
    }

    @Override
    public int size() {
        return this.trie.size();
    }

    @Override
    public Object[] toArray() {
        return this.trie.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] arr) {
        return this.trie.keySet().toArray(arr);
    }
}

