/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.trie;

import java.io.Serializable;
import java.util.Map;
import java.util.function.Function;
import org.matheclipse.parser.trie.PerfectHashMap;
import org.matheclipse.parser.trie.TrieSequencer;

public class TrieNode<S, T>
implements Map.Entry<S, T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected TrieNode<S, T> parent;
    protected T value;
    protected S sequence;
    protected int start;
    protected int end;
    protected PerfectHashMap<TrieNode<S, T>> children = null;
    protected int size;

    protected TrieNode() {
    }

    protected TrieNode(TrieNode<S, T> parent, T value, S sequence, int start, int end, PerfectHashMap<TrieNode<S, T>> children) {
        this.parent = parent;
        this.sequence = sequence;
        this.start = start;
        this.end = end;
        this.children = children;
        this.size = this.calculateSize(children);
        this.setValue(value);
    }

    protected TrieNode<S, T> split(int index, T newValue, TrieSequencer<S> sequencer) {
        TrieNode<S, T> c = new TrieNode<S, T>(this, this.value, this.sequence, index + this.start, this.end, this.children);
        c.registerAsParent();
        this.setValue((T)null);
        this.setValue(newValue);
        this.end = index + this.start;
        this.children = null;
        this.add(c, sequencer);
        return c;
    }

    protected void add(TrieNode<S, T> child, TrieSequencer<S> sequencer) {
        int hash = sequencer.hashOf(child.sequence, this.end);
        if (this.children == null) {
            this.children = new PerfectHashMap<TrieNode<S, TrieNode<S, T>>>(hash, child);
        } else {
            this.children.put(hash, child);
        }
    }

    protected void remove(TrieSequencer<S> sequencer) {
        int childCount;
        this.setValue((T)null);
        int n = childCount = this.children == null ? 0 : this.children.size();
        if (childCount == 0) {
            this.parent.children.remove(sequencer.hashOf(this.sequence, this.start));
        } else if (childCount == 1) {
            TrieNode<S, T> child = this.children.valueAt(0);
            this.children = child.children;
            this.value = child.value;
            this.sequence = child.sequence;
            this.end = child.end;
            child.children = null;
            child.parent = null;
            child.sequence = null;
            child.value = null;
            this.registerAsParent();
        }
    }

    private void addSize(int amount) {
        TrieNode<S, T> curr = this;
        while (curr != null) {
            curr.size += amount;
            curr = curr.parent;
        }
    }

    private int calculateSize(PerfectHashMap<TrieNode<S, T>> nodes) {
        int size = 0;
        if (nodes != null) {
            for (int i = nodes.capacity() - 1; i >= 0; --i) {
                TrieNode<S, T> n = nodes.valueAt(i);
                if (n == null) continue;
                size += n.size;
            }
        }
        return size;
    }

    private void registerAsParent() {
        if (this.children != null) {
            for (int i = 0; i < this.children.capacity(); ++i) {
                TrieNode<S, T> c = this.children.valueAt(i);
                if (c == null) continue;
                c.parent = this;
            }
        }
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public TrieNode<S, T> getParent() {
        return this.parent;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public S getSequence() {
        return this.sequence;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getSize() {
        return this.size;
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public TrieNode<S, T> getRoot() {
        TrieNode<S, T> n = this.parent;
        while (n.parent != null) {
            n = n.parent;
        }
        return n;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isNaked() {
        return this.value == null;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public S getKey() {
        return this.sequence;
    }

    @Override
    public T setValue(T newValue) {
        return (T)this.update(previousValue -> newValue);
    }

    public T update(Function<T, T> updater) {
        T previousValue = this.value;
        this.value = updater.apply(previousValue);
        if (previousValue == null && this.value != null) {
            this.addSize(1);
        } else if (previousValue != null && this.value == null) {
            this.addSize(-1);
        }
        return previousValue;
    }

    @Override
    public int hashCode() {
        return (this.sequence == null ? 0 : this.sequence.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
    }

    public String toString() {
        return this.sequence + "=" + this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof TrieNode)) {
            return false;
        }
        TrieNode node = (TrieNode)o;
        return (this.sequence == node.sequence || this.sequence.equals(node.sequence)) && (this.value == node.value || this.value != null && node.value != null && this.value.equals(node.value));
    }
}

