/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.trie;

import java.util.Collection;
import java.util.function.Supplier;
import org.matheclipse.parser.trie.Trie;
import org.matheclipse.parser.trie.TrieMatch;
import org.matheclipse.parser.trie.TrieNode;
import org.matheclipse.parser.trie.TrieSequencer;

public class TrieCollection<S, T, C extends Collection<T>>
extends Trie<S, C> {
    private static final long serialVersionUID = 1L;
    protected Supplier<C> supplier;
    protected boolean defaultCollection;

    protected TrieCollection() {
    }

    public TrieCollection(TrieSequencer<S> sequencer, Supplier<C> supplier) {
        this(sequencer, supplier, false);
    }

    public TrieCollection(TrieSequencer<S> sequencer, Supplier<C> supplier, boolean defaultCollection) {
        super(sequencer);
        this.supplier = supplier;
        this.defaultCollection = defaultCollection;
    }

    public TrieCollection<S, T, C> newEmptyClone() {
        TrieCollection<S, T, C> t = new TrieCollection<S, T, C>(this.sequencer, this.supplier, this.defaultCollection);
        t.defaultMatch = this.defaultMatch;
        return t;
    }

    @Override
    public C getDefaultValue() {
        return (C)(this.defaultCollection ? (Collection)this.supplier.get() : (Collection)super.getDefaultValue());
    }

    public C add(S query, T value) {
        return this.add(query, value, this.defaultMatch);
    }

    public C add(S query, T value, TrieMatch match) {
        Collection collection;
        TrieNode node = this.search(this.root, query, match);
        Collection collection2 = collection = node != null ? (Collection)node.value : null;
        if (collection == null) {
            collection = (Collection)this.supplier.get();
            this.put(query, collection);
        }
        collection.add(value);
        return (C)collection;
    }

    public C addAll(S query, Iterable<T> values) {
        return this.addAll(query, values, this.defaultMatch);
    }

    public C addAll(S query, Iterable<T> values, TrieMatch match) {
        Collection collection;
        TrieNode node = this.search(this.root, query, match);
        Collection collection2 = collection = node != null ? (Collection)node.value : null;
        if (collection == null) {
            collection = (Collection)this.supplier.get();
            this.put(query, collection);
        }
        for (T value : values) {
            collection.add(value);
        }
        return (C)collection;
    }

    public int totalSize() {
        int total = 0;
        for (Collection values : this.values()) {
            total += values.size();
        }
        return total;
    }
}

