/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.trie;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import java.util.function.Supplier;
import org.matheclipse.parser.trie.Trie;
import org.matheclipse.parser.trie.TrieCollection;
import org.matheclipse.parser.trie.TrieMatch;
import org.matheclipse.parser.trie.TrieSequencer;
import org.matheclipse.parser.trie.TrieSequencerByteArray;
import org.matheclipse.parser.trie.TrieSequencerByteBuffer;
import org.matheclipse.parser.trie.TrieSequencerCharArray;
import org.matheclipse.parser.trie.TrieSequencerCharArrayCaseInsensitive;
import org.matheclipse.parser.trie.TrieSequencerCharSequence;
import org.matheclipse.parser.trie.TrieSequencerCharSequenceCaseInsensitive;
import org.matheclipse.parser.trie.TrieSequencerIntArray;
import org.matheclipse.parser.trie.TrieSequencerLongArray;
import org.matheclipse.parser.trie.TrieSequencerShortArray;

public class TrieBuilder<S, T, C extends Collection<T>> {
    protected TrieSequencer<S> sequencer;
    protected TrieMatch match;
    protected Supplier<C> supplier;
    protected boolean defaultEmptyCollection;
    protected T defaultValue;

    public static <T> TrieBuilder<String, T, ArrayList<T>> create() {
        return new TrieBuilder<String, Object, ArrayList>(TrieSequencerCharSequence.INSTANCE, TrieMatch.STARTS_WITH, () -> new ArrayList(), null, false);
    }

    public static <T> TrieBuilder<String, T, ArrayList<T>> create(Class<T> clazz) {
        return new TrieBuilder<String, Object, ArrayList>(TrieSequencerCharSequence.INSTANCE, TrieMatch.STARTS_WITH, () -> new ArrayList(), null, false);
    }

    public TrieBuilder(TrieSequencer<S> sequencer, TrieMatch match, Supplier<C> supplier, T defaultValue, boolean defaultEmptyCollection) {
        this.sequencer = sequencer;
        this.match = match;
        this.supplier = supplier;
        this.defaultValue = defaultValue;
        this.defaultEmptyCollection = defaultEmptyCollection;
    }

    public <CS extends CharSequence> TrieBuilder<CS, T, C> forCharSequence() {
        return new TrieBuilder(new TrieSequencerCharSequence(), this.match, this.supplier, this.defaultValue, this.defaultEmptyCollection);
    }

    public <CS extends CharSequence> TrieBuilder<CS, T, C> forCharSequence(Class<CS> clazz) {
        return new TrieBuilder(new TrieSequencerCharSequence(), this.match, this.supplier, this.defaultValue, this.defaultEmptyCollection);
    }

    public <CS extends CharSequence> TrieBuilder<CS, T, C> forInsensitiveCharSequence() {
        return new TrieBuilder(new TrieSequencerCharSequenceCaseInsensitive(), this.match, this.supplier, this.defaultValue, this.defaultEmptyCollection);
    }

    public <CS extends CharSequence> TrieBuilder<CS, T, C> forInsensitiveCharSequence(Class<CS> clazz) {
        return new TrieBuilder(new TrieSequencerCharSequenceCaseInsensitive(), this.match, this.supplier, this.defaultValue, this.defaultEmptyCollection);
    }

    public TrieBuilder<ByteBuffer, T, C> forByteBuffers() {
        return new TrieBuilder<ByteBuffer, T, C>(TrieSequencerByteBuffer.INSTANCE, this.match, this.supplier, this.defaultValue, this.defaultEmptyCollection);
    }

    public TrieBuilder<String, T, C> forStrings() {
        return new TrieBuilder<String, T, C>(TrieSequencerCharSequence.INSTANCE, this.match, this.supplier, this.defaultValue, this.defaultEmptyCollection);
    }

    public TrieBuilder<String, T, C> forInsensitiveStrings() {
        return new TrieBuilder<String, T, C>(TrieSequencerCharSequenceCaseInsensitive.INSTANCE, this.match, this.supplier, this.defaultValue, this.defaultEmptyCollection);
    }

    public TrieBuilder<byte[], T, C> forBytes() {
        return new TrieBuilder<byte[], T, C>(TrieSequencerByteArray.INSTANCE, this.match, this.supplier, this.defaultValue, this.defaultEmptyCollection);
    }

    public TrieBuilder<char[], T, C> forChars() {
        return new TrieBuilder<char[], T, C>(TrieSequencerCharArray.INSTANCE, this.match, this.supplier, this.defaultValue, this.defaultEmptyCollection);
    }

    public TrieBuilder<char[], T, C> forInsensitiveChars() {
        return new TrieBuilder<char[], T, C>(TrieSequencerCharArrayCaseInsensitive.INSTANCE, this.match, this.supplier, this.defaultValue, this.defaultEmptyCollection);
    }

    public TrieBuilder<int[], T, C> forInts() {
        return new TrieBuilder<int[], T, C>(TrieSequencerIntArray.INSTANCE, this.match, this.supplier, this.defaultValue, this.defaultEmptyCollection);
    }

    public TrieBuilder<long[], T, C> forLongs() {
        return new TrieBuilder<long[], T, C>(TrieSequencerLongArray.INSTANCE, this.match, this.supplier, this.defaultValue, this.defaultEmptyCollection);
    }

    public TrieBuilder<short[], T, C> forShorts() {
        return new TrieBuilder<short[], T, C>(TrieSequencerShortArray.INSTANCE, this.match, this.supplier, this.defaultValue, this.defaultEmptyCollection);
    }

    public <NS, NQ extends TrieSequencer<NS>> TrieBuilder<NS, T, C> withSequencer(NQ sequencer) {
        return new TrieBuilder<S, T, C>(sequencer, this.match, this.supplier, this.defaultValue, this.defaultEmptyCollection);
    }

    public <V> TrieBuilder<S, V, ArrayList<V>> forType(Class<V> clazz) {
        return new TrieBuilder<S, Object, ArrayList>(this.sequencer, this.match, () -> new ArrayList(), null, this.defaultEmptyCollection);
    }

    public TrieBuilder<S, T, C> withMatch(TrieMatch match) {
        return new TrieBuilder<S, T, C>(this.sequencer, match, this.supplier, this.defaultValue, this.defaultEmptyCollection);
    }

    public <NC extends Collection<T>> TrieBuilder<S, T, NC> withCollections(Supplier<NC> supplier) {
        return new TrieBuilder<S, T, NC>(this.sequencer, this.match, supplier, this.defaultValue, this.defaultEmptyCollection);
    }

    public TrieBuilder<S, T, Set<T>> forSets() {
        return new TrieBuilder<S, T, Set>(this.sequencer, this.match, () -> new HashSet(), this.defaultValue, this.defaultEmptyCollection);
    }

    public TrieBuilder<S, T, LinkedList<T>> forLinkedLists() {
        return new TrieBuilder<S, T, LinkedList>(this.sequencer, this.match, () -> new LinkedList(), this.defaultValue, this.defaultEmptyCollection);
    }

    public TrieBuilder<S, T, ArrayList<T>> forArrayLists() {
        return new TrieBuilder<S, T, ArrayList>(this.sequencer, this.match, () -> new ArrayList(), this.defaultValue, this.defaultEmptyCollection);
    }

    public TrieBuilder<S, T, Vector<T>> forVectors() {
        return new TrieBuilder<S, T, Vector>(this.sequencer, this.match, () -> new Vector(), this.defaultValue, this.defaultEmptyCollection);
    }

    public TrieBuilder<S, T, C> withDefaultEmptyCollection() {
        return new TrieBuilder<S, T, C>(this.sequencer, this.match, this.supplier, this.defaultValue, true);
    }

    public TrieBuilder<S, T, C> withDefaultValue(T defaultValue) {
        return new TrieBuilder<S, T, C>(this.sequencer, this.match, this.supplier, defaultValue, this.defaultEmptyCollection);
    }

    public Trie<S, T> build() {
        Trie<S, T> trie = new Trie<S, T>(this.sequencer, this.defaultValue);
        trie.defaultMatch = this.match;
        return trie;
    }

    public TrieCollection<S, T, C> buildForCollection() {
        TrieCollection trie = new TrieCollection(this.sequencer, this.supplier, this.defaultEmptyCollection);
        trie.defaultMatch = this.match;
        return trie;
    }
}

