/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.trie;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.matheclipse.parser.trie.PerfectHashMap;
import org.matheclipse.parser.trie.TrieMatch;
import org.matheclipse.parser.trie.TrieNode;
import org.matheclipse.parser.trie.TrieSequencer;

public class Trie<S, T>
implements Map<S, T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final EmptyContainer<?> EMPTY_CONTAINER = new EmptyContainer();
    protected final TrieNode<S, T> root;
    protected TrieSequencer<S> sequencer;
    protected TrieMatch defaultMatch = TrieMatch.STARTS_WITH;
    protected transient SequenceSet sequences;
    protected transient ValueCollection values;
    protected transient EntrySet entries;
    protected transient NodeSet nodes;

    protected Trie() {
        this(null, null);
    }

    public Trie(TrieSequencer<S> sequencer) {
        this(sequencer, null);
    }

    public Trie(TrieSequencer<S> sequencer, T defaultValue) {
        this.root = new TrieNode<Object, T>(null, defaultValue, null, 0, 0, new PerfectHashMap());
        this.sequences = new SequenceSet(this.root);
        this.values = new ValueCollection(this.root);
        this.entries = new EntrySet(this.root);
        this.nodes = new NodeSet(this.root);
        this.sequencer = sequencer;
    }

    public void setDefaultValue(T defaultValue) {
        this.root.value = defaultValue;
    }

    public T getDefaultValue() {
        return this.root.value;
    }

    public Trie<S, T> newEmptyClone() {
        Trie<S, T> t = new Trie<S, T>(this.sequencer, this.getDefaultValue());
        t.defaultMatch = this.defaultMatch;
        return t;
    }

    @Override
    public T put(S query, T value) {
        return this.put(query, previousValue -> value, null);
    }

    @Override
    public T put(S query, Function<T, T> updater) {
        return this.put(query, updater, null);
    }

    public T put(S query, Function<T, T> updater, T defaultPrevious) {
        int queryLength = this.sequencer.lengthOf(query);
        if (queryLength == 0) {
            return null;
        }
        int queryOffset = 0;
        TrieNode<S, T> node = this.root.children.get(this.sequencer.hashOf(query, 0));
        if (node == null) {
            return this.putReturnNull(this.root, updater.apply(defaultPrevious), query, queryOffset, queryLength);
        }
        while (node != null) {
            Object nodeSequence = node.sequence;
            int nodeLength = node.end - node.start;
            int max = Math.min(nodeLength, queryLength - queryOffset);
            int matches = this.sequencer.matches(nodeSequence, node.start, query, queryOffset, max);
            queryOffset += matches;
            if (matches != max) {
                node.split(matches, null, this.sequencer);
                return this.putReturnNull(node, updater.apply(defaultPrevious), query, queryOffset, queryLength);
            }
            if (max < nodeLength) {
                node.split(max, updater.apply(defaultPrevious), this.sequencer);
                node.sequence = query;
                return null;
            }
            if (queryOffset == queryLength) {
                node.sequence = query;
                return node.update(updater);
            }
            if (node.children == null) {
                return this.putReturnNull(node, updater.apply(defaultPrevious), query, queryOffset, queryLength);
            }
            TrieNode next = node.children.get(this.sequencer.hashOf(query, queryOffset));
            if (next == null) {
                return this.putReturnNull(node, updater.apply(defaultPrevious), query, queryOffset, queryLength);
            }
            node = next;
        }
        return null;
    }

    private T putReturnNull(TrieNode<S, T> node, T value, S query, int queryOffset, int queryLength) {
        node.add(new TrieNode<S, T>(node, value, query, queryOffset, queryLength, null), this.sequencer);
        return null;
    }

    public T get(S sequence, TrieMatch match) {
        TrieNode<S, T> n = this.search(this.root, sequence, match);
        return n != null ? n.value : this.getDefaultValue();
    }

    @Override
    public T get(Object sequence) {
        return this.get(sequence, this.defaultMatch);
    }

    public boolean has(S sequence, TrieMatch match) {
        return this.hasAfter(this.root, sequence, match);
    }

    public boolean has(S sequence) {
        return this.hasAfter(this.root, sequence, this.defaultMatch);
    }

    protected boolean hasAfter(TrieNode<S, T> root, S sequence, TrieMatch match) {
        return this.search(root, sequence, match) != null;
    }

    @Override
    public T remove(Object sequence) {
        return this.removeAfter(this.root, sequence);
    }

    protected T removeAfter(TrieNode<S, T> root, S sequence) {
        TrieNode<S, T> n = this.search(root, sequence, TrieMatch.EXACT);
        if (n == null) {
            return null;
        }
        Object value = n.value;
        n.remove(this.sequencer);
        return value;
    }

    @Override
    public int size() {
        return this.root.getSize();
    }

    @Override
    public boolean isEmpty() {
        return this.root.getSize() == 0;
    }

    public TrieMatch getDefaultMatch() {
        return this.defaultMatch;
    }

    public void setDefaultMatch(TrieMatch match) {
        this.defaultMatch = match;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.has(key);
    }

    @Override
    public boolean containsValue(Object value) {
        ValueIterator values = new ValueIterator(this.root);
        for (Object v : values) {
            if (v != value && (v == null || value == null || !v.equals(values))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<S, T>> entrySet() {
        return this.entries;
    }

    public Set<Map.Entry<S, T>> entrySet(S sequence) {
        return this.entrySet(sequence, this.defaultMatch);
    }

    public Set<Map.Entry<S, T>> entrySet(S sequence, TrieMatch match) {
        TrieNode<S, T> node = this.search(this.root, sequence, match);
        return node == null ? EMPTY_CONTAINER : new EntrySet(node);
    }

    public Set<TrieNode<S, T>> nodeSet() {
        return this.nodes;
    }

    public Set<TrieNode<S, T>> nodeSet(S sequence) {
        return this.nodeSet(sequence, this.defaultMatch);
    }

    public Set<TrieNode<S, T>> nodeSet(S sequence, TrieMatch match) {
        TrieNode<S, T> node = this.search(this.root, sequence, match);
        return node == null ? EMPTY_CONTAINER : new NodeSet(node);
    }

    public Iterable<TrieNode<S, T>> nodeSetAll() {
        return new NodeAllIterator(this.root);
    }

    public Iterable<TrieNode<S, T>> nodeSetAll(S sequence) {
        return this.nodeSetAll(sequence, this.defaultMatch);
    }

    public Iterable<TrieNode<S, T>> nodeSetAll(S sequence, TrieMatch match) {
        TrieNode<S, T> node = this.search(this.root, sequence, match);
        return node == null ? EMPTY_CONTAINER : new NodeAllIterator(this.root);
    }

    @Override
    public Set<S> keySet() {
        return this.sequences;
    }

    public Set<S> keySet(S sequence) {
        return this.keySet(sequence, this.defaultMatch);
    }

    public Set<S> keySet(S sequence, TrieMatch match) {
        TrieNode<S, T> node = this.search(this.root, sequence, match);
        return node == null ? EMPTY_CONTAINER : new SequenceSet(node);
    }

    @Override
    public Collection<T> values() {
        return this.values;
    }

    public Collection<T> values(S sequence) {
        return this.values(sequence, this.defaultMatch);
    }

    public Collection<T> values(S sequence, TrieMatch match) {
        TrieNode<S, T> node = this.search(this.root, sequence, match);
        return node == null ? null : new ValueCollection(node);
    }

    @Override
    public void putAll(Map<? extends S, ? extends T> map) {
        for (Map.Entry<S, T> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.root.children.clear();
        this.root.size = 0;
    }

    protected TrieNode<S, T> search(TrieNode<S, T> root, S query, TrieMatch match) {
        int queryLength = this.sequencer.lengthOf(query);
        if (queryLength == 0 || match == null || queryLength < root.end) {
            return null;
        }
        if (root.sequence != null) {
            int matches = this.sequencer.matches(root.sequence, 0, query, 0, root.end);
            if (matches == queryLength) {
                return root;
            }
            if (matches < root.end) {
                return null;
            }
        }
        int queryOffset = root.end;
        TrieNode node = root.children.get(this.sequencer.hashOf(query, queryOffset));
        while (node != null) {
            TrieNode next;
            int nodeLength = node.end - node.start;
            int max = Math.min(nodeLength, queryLength - queryOffset);
            int matches = this.sequencer.matches(node.sequence, node.start, query, queryOffset, max);
            queryOffset += matches;
            if (matches != max) {
                return null;
            }
            if (max != nodeLength) {
                return match != TrieMatch.PARTIAL ? null : node;
            }
            if (queryOffset == queryLength || node.children == null || (next = node.children.get(this.sequencer.hashOf(query, queryOffset))) == null) break;
            node = next;
        }
        if (node != null && match == TrieMatch.EXACT) {
            if (node.value == null || node.end != queryLength) {
                return null;
            }
            if (this.sequencer.matches(node.sequence, 0, query, 0, node.end) != node.end) {
                return null;
            }
        }
        return node;
    }

    private static class EmptyContainer<T>
    extends AbstractCollection<T>
    implements Set<T>,
    Iterator<T> {
        private EmptyContainer() {
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }

    private abstract class AbstractIterator<K>
    implements Iterable<K>,
    Iterator<K> {
        private final TrieNode<S, T> root;
        private TrieNode<S, T> previous;
        private TrieNode<S, T> current;
        private int depth;
        private int[] indices = new int[32];

        public AbstractIterator(TrieNode<S, T> root) {
            this.root = root;
            this.reset();
        }

        public AbstractIterator<K> reset() {
            this.depth = 0;
            this.indices[0] = -1;
            if (this.root.value == null) {
                this.previous = this.root;
                this.current = this.findNext();
            } else {
                this.previous = null;
                this.current = this.root;
            }
            return this;
        }

        protected boolean isAnyNode() {
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        public TrieNode<S, T> nextNode() {
            this.previous = this.current;
            this.current = this.findNext();
            return this.previous;
        }

        @Override
        public void remove() {
            this.previous.remove(Trie.this.sequencer);
        }

        private TrieNode<S, T> findNext() {
            if (this.indices[0] == this.root.children.capacity()) {
                return null;
            }
            TrieNode node = this.previous;
            boolean foundValue = false;
            if (node.children == null) {
                node = node.parent;
            }
            while (!foundValue) {
                int id;
                PerfectHashMap children = node.children;
                int childCapacity = children.capacity();
                for (id = this.indices[this.depth] + 1; id < childCapacity && children.valueAt(id) == null; ++id) {
                }
                if (id == childCapacity) {
                    node = node.parent;
                    --this.depth;
                    if (this.depth != -1) continue;
                    node = null;
                    foundValue = true;
                    continue;
                }
                this.indices[this.depth] = id;
                node = children.valueAt(id);
                if (node.hasChildren()) {
                    this.indices[++this.depth] = -1;
                }
                if (node.value == null && !this.isAnyNode()) continue;
                foundValue = true;
            }
            return node;
        }

        @Override
        public Iterator<K> iterator() {
            return this;
        }
    }

    private class NodeAllIterator
    extends AbstractIterator<TrieNode<S, T>> {
        public NodeAllIterator(TrieNode<S, T> root) {
            super(root);
        }

        @Override
        public TrieNode<S, T> next() {
            return this.nextNode();
        }

        @Override
        protected boolean isAnyNode() {
            return true;
        }
    }

    private class NodeIterator
    extends AbstractIterator<TrieNode<S, T>> {
        public NodeIterator(TrieNode<S, T> root) {
            super(root);
        }

        @Override
        public TrieNode<S, T> next() {
            return this.nextNode();
        }
    }

    private class EntryIterator
    extends AbstractIterator<Map.Entry<S, T>> {
        public EntryIterator(TrieNode<S, T> root) {
            super(root);
        }

        @Override
        public Map.Entry<S, T> next() {
            return this.nextNode();
        }
    }

    private class ValueIterator
    extends AbstractIterator<T> {
        public ValueIterator(TrieNode<S, T> root) {
            super(root);
        }

        @Override
        public T next() {
            return this.nextNode().value;
        }
    }

    private class SequenceIterator
    extends AbstractIterator<S> {
        public SequenceIterator(TrieNode<S, T> root) {
            super(root);
        }

        @Override
        public S next() {
            return this.nextNode().sequence;
        }
    }

    private class NodeSet
    extends AbstractSet<TrieNode<S, T>> {
        private final TrieNode<S, T> root;

        public NodeSet(TrieNode<S, T> root) {
            this.root = root;
        }

        @Override
        public Iterator<TrieNode<S, T>> iterator() {
            return new NodeIterator(this.root);
        }

        @Override
        public boolean remove(Object entry) {
            boolean removable;
            TrieNode node = (TrieNode)entry;
            boolean bl = removable = node.getRoot() == Trie.this.root;
            if (removable) {
                node.remove(Trie.this.sequencer);
            }
            return removable;
        }

        @Override
        public boolean contains(Object entry) {
            TrieNode node = (TrieNode)entry;
            return node.getRoot() == Trie.this.root;
        }

        @Override
        public int size() {
            return this.root.getSize();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<S, T>> {
        private final TrieNode<S, T> root;

        public EntrySet(TrieNode<S, T> root) {
            this.root = root;
        }

        @Override
        public Iterator<Map.Entry<S, T>> iterator() {
            return new EntryIterator(this.root);
        }

        @Override
        public boolean remove(Object entry) {
            boolean removable;
            TrieNode node = (TrieNode)entry;
            boolean bl = removable = node.getRoot() == Trie.this.root;
            if (removable) {
                node.remove(Trie.this.sequencer);
            }
            return removable;
        }

        @Override
        public boolean contains(Object entry) {
            TrieNode node = (TrieNode)entry;
            return node.getRoot() == Trie.this.root;
        }

        @Override
        public int size() {
            return this.root.getSize();
        }
    }

    private class SequenceSet
    extends AbstractSet<S> {
        private final TrieNode<S, T> root;

        public SequenceSet(TrieNode<S, T> root) {
            this.root = root;
        }

        @Override
        public Iterator<S> iterator() {
            return new SequenceIterator(this.root);
        }

        @Override
        public boolean remove(Object sequence) {
            return Trie.this.removeAfter(this.root, sequence) != null;
        }

        @Override
        public boolean contains(Object sequence) {
            return Trie.this.hasAfter(this.root, sequence, TrieMatch.EXACT);
        }

        @Override
        public int size() {
            return this.root.getSize();
        }
    }

    private class ValueCollection
    extends AbstractCollection<T> {
        private final TrieNode<S, T> root;

        public ValueCollection(TrieNode<S, T> root) {
            this.root = root;
        }

        @Override
        public Iterator<T> iterator() {
            return new ValueIterator(this.root);
        }

        @Override
        public int size() {
            return this.root.getSize();
        }
    }
}

