/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.trie;

import java.io.Serializable;
import java.util.Arrays;

public class PerfectHashMap<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int min;
    private int size;
    private T[] values;

    public PerfectHashMap() {
        this.clear();
    }

    public PerfectHashMap(int firstKey, T firstValue) {
        this.putFirst(firstKey, firstValue);
    }

    public boolean exists(int key) {
        int i = this.relativeIndex(key);
        return i >= 0 && i < this.values.length && this.values[i] != null;
    }

    public T get(int key) {
        int i = this.relativeIndex(key);
        return i < 0 || i >= this.values.length ? null : (T)this.values[i];
    }

    public T put(int key, T value) {
        if (this.size == 0) {
            this.putFirst(key, value);
            return null;
        }
        T previousValue = null;
        int i = this.relativeIndex(key);
        if (i < 0) {
            this.prepend(-i);
            this.values[0] = value;
            this.min = key;
            ++this.size;
        } else if (i >= this.values.length) {
            this.resize(i + 1);
            this.values[i] = value;
            ++this.size;
        } else {
            previousValue = this.values[i];
            if (previousValue == null) {
                ++this.size;
            }
            this.values[i] = value;
        }
        return previousValue;
    }

    private void prepend(int spaces) {
        int length = this.values.length;
        this.values = Arrays.copyOf(this.values, length + spaces);
        System.arraycopy(this.values, 0, this.values, spaces, length);
    }

    private void resize(int size) {
        this.values = Arrays.copyOf(this.values, size);
    }

    private void putFirst(int firstKey, T firstValue) {
        this.min = firstKey;
        this.values = new Object[1];
        this.values[0] = firstValue;
        this.size = 1;
    }

    public void clear() {
        this.min = 0;
        this.values = new Object[0];
        this.size = 0;
    }

    public boolean remove(int key) {
        int i = this.relativeIndex(key);
        if (this.size == 1) {
            boolean match;
            boolean bl = match = i == 0;
            if (match) {
                this.clear();
            }
            return match;
        }
        int valuesMax = this.values.length - 1;
        if (i < 0 || i > valuesMax) {
            return false;
        }
        if (i == 0) {
            while (++i <= valuesMax && this.values[i] == null) {
            }
            this.values = Arrays.copyOfRange(this.values, i, this.values.length);
            this.min += i;
        } else if (i == valuesMax) {
            while (--i > 0 && this.values[i] == null) {
            }
            this.values = Arrays.copyOf(this.values, i + 1);
        } else {
            if (this.values[i] == null) {
                return false;
            }
            this.values[i] = null;
        }
        --this.size;
        return true;
    }

    private final int relativeIndex(int key) {
        return key - this.min;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.min + this.values.length - 1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.values.length;
    }

    public T valueAt(int index) {
        return this.values[index];
    }
}

