/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.client.operator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.matheclipse.parser.client.Characters;
import org.matheclipse.parser.client.ParserConfig;
import org.matheclipse.parser.client.Scanner;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.ast.FloatNode;
import org.matheclipse.parser.client.ast.FractionNode;
import org.matheclipse.parser.client.ast.FunctionNode;
import org.matheclipse.parser.client.ast.INodeParserFactory;
import org.matheclipse.parser.client.ast.IntegerNode;
import org.matheclipse.parser.client.ast.Pattern2Node;
import org.matheclipse.parser.client.ast.Pattern3Node;
import org.matheclipse.parser.client.ast.PatternNode;
import org.matheclipse.parser.client.ast.StringNode;
import org.matheclipse.parser.client.ast.SymbolNode;
import org.matheclipse.parser.client.operator.InfixOperator;
import org.matheclipse.parser.client.operator.Operator;
import org.matheclipse.parser.client.operator.PostfixOperator;
import org.matheclipse.parser.client.operator.PrefixOperator;
import org.matheclipse.parser.trie.Trie;
import org.matheclipse.parser.trie.TrieMatch;

public class ASTNodeFactory
implements INodeParserFactory {
    public static String OPERATOR_CHARACTERS = null;
    static final String[] HEADER_STRINGS = new String[]{"MessageName", "Get", "PatternTest", "MapAll", "TimesBy", "Plus", "UpSet", "CompoundExpression", "Apply", "Map", "Unset", "Apply", "Apply", "ReplaceRepeated", "Less", "And", "Divide", "Set", "Increment", "Factorial2", "LessEqual", "NonCommutativeMultiply", "Factorial", "Times", "Power", "Dot", "Not", "PreMinus", "SameQ", "RuleDelayed", "GreaterEqual", "Condition", "//", "DivideBy", "Or", "Span", "Equal", "StringJoin", "Unequal", "Decrement", "SubtractFrom", "PrePlus", "RepeatedNull", "UnsameQ", "Rule", "UpSetDelayed", "PreIncrement", "Function", "Function", "Greater", "PreDecrement", "Subtract", "SetDelayed", "Alternatives", "AddTo", "Repeated", "ReplaceAll", "TagSet", "Composition", "RightComposition", "StringExpression", "Pattern", "TwoWayRule", "TwoWayRule", "DirectedEdge", "UndirectedEdge", "CenterDot", "CircleDot", "CircleTimes", "Distributed", "Element", "Intersection", "NotEqual", "Wedge", "TensorProduct", "Equivalent", "Implies", "\u00a7TILDE\u00a7"};
    static final String[] OPERATOR_STRINGS = new String[]{"::", "<<", "?", "//@", "*=", "+", "^=", ";", "@", "/@", "=.", "@@", "@@@", "//.", "<", "&&", "/", "=", "++", "!!", "<=", "**", "!", "*", "^", ".", "!", "-", "===", ":>", ">=", "/;", "//", "/=", "||", ";;", "==", "<>", "!=", "--", "-=", "+", "...", "=!=", "->", "^:=", "++", "|->", "&", ">", "--", "-", ":=", "|", "+=", "..", "/.", "/:", "@*", "/*", "~~", ":", "<->", "\uf120", "\uf3d5", "\uf3d4", "\u00b7", "\u2299", "\u2297", "\uf3d2", "\u2208", "\u22c2", "\u2260", "\u22c0", "\uf3da", "\u29e6", "\uf523", "~"};
    public static final ApplyOperator APPLY_HEAD_OPERATOR = new ApplyOperator("@", "Apply", 621, 1);
    public static final ApplyOperator APPLY_OPERATOR = new ApplyOperator("@@", "Apply", 620, 1);
    public static final ApplyOperator APPLY_LEVEL_OPERATOR = new ApplyOperator("@@@", "Apply", 620, 1);
    public static final TagSetOperator TAG_SET_OPERATOR = new TagSetOperator("/:", "TagSet", 40, 0);
    private static Operator[] OPERATORS;
    public static final ASTNodeFactory MMA_STYLE_FACTORY;
    public static final ASTNodeFactory RELAXED_STYLE_FACTORY;
    private static Trie<String, Operator> fOperatorMap;
    private static Trie<String, ArrayList<Operator>> fOperatorTokenStartSet;
    protected final boolean fIgnoreCase;

    @Override
    public boolean isOperatorChar(char ch) {
        return OPERATOR_CHARACTERS != null && OPERATOR_CHARACTERS.indexOf(ch) >= 0;
    }

    public ASTNodeFactory(boolean ignoreCase) {
        this.fIgnoreCase = ignoreCase;
    }

    public static void addOperator(Map<String, Operator> operatorMap, Map<String, ArrayList<Operator>> operatorTokenStartSet, String operatorStr, String headStr, Operator oper) {
        operatorMap.put(headStr, oper);
        ArrayList<Operator> list = operatorTokenStartSet.get(operatorStr);
        if (list == null) {
            list = new ArrayList(2);
            list.add(oper);
            operatorTokenStartSet.put(operatorStr, list);
        } else {
            list.add(oper);
        }
    }

    public Map<String, Operator> getIdentifier2OperatorMap() {
        return fOperatorMap;
    }

    @Override
    public Operator get(String identifier) {
        return fOperatorMap.get(identifier);
    }

    @Override
    public Map<String, ArrayList<Operator>> getOperator2ListMap() {
        return fOperatorTokenStartSet;
    }

    @Override
    public List<Operator> getOperatorList(String key) {
        return fOperatorTokenStartSet.get(key);
    }

    public static InfixOperator createInfixOperator(String operatorStr, String headStr, int precedence, int grouping) {
        if (headStr.equals("Apply")) {
            return new ApplyOperator(operatorStr, headStr, precedence, grouping);
        }
        if (headStr.equals("Divide")) {
            return new DivideOperator(operatorStr, headStr, precedence, grouping);
        }
        if (headStr.equals("Subtract")) {
            return new SubtractOperator(operatorStr, headStr, precedence, grouping);
        }
        return new InfixOperator(operatorStr, headStr, precedence, grouping);
    }

    public static PrefixOperator createPrefixOperator(String operatorStr, String headStr, int precedence) {
        if (headStr.equals("PreMinus")) {
            return new PreMinusOperator(operatorStr, headStr, precedence);
        }
        if (headStr.equals("PrePlus")) {
            return new PrePlusOperator(operatorStr, headStr, precedence);
        }
        return new PrefixOperator(operatorStr, headStr, precedence);
    }

    public static PostfixOperator createPostfixOperator(String operatorStr, String headStr, int precedence) {
        return new PostfixOperator(operatorStr, headStr, precedence);
    }

    @Override
    public ASTNode createDouble(String doubleString) {
        return new FloatNode(doubleString);
    }

    @Override
    public FunctionNode createFunction(SymbolNode head) {
        return new FunctionNode(head);
    }

    @Override
    public FunctionNode createFunction(SymbolNode head, ASTNode arg0) {
        return new FunctionNode(head, arg0);
    }

    @Override
    public FunctionNode createFunction(SymbolNode head, ASTNode arg1, ASTNode arg2) {
        return new FunctionNode(head, arg1, arg2);
    }

    @Override
    public FunctionNode createFunction(SymbolNode head, ASTNode arg1, ASTNode arg2, ASTNode arg3) {
        return new FunctionNode(head, arg1, arg2, arg3);
    }

    @Override
    public FunctionNode createAST(ASTNode headExpr) {
        return new FunctionNode(headExpr);
    }

    @Override
    public FunctionNode unaryAST(ASTNode head, ASTNode arg0) {
        return new FunctionNode(head, arg0);
    }

    @Override
    public IntegerNode createInteger(String integerString, int numberFormat) {
        return new IntegerNode(integerString, numberFormat);
    }

    @Override
    public IntegerNode createInteger(int intValue) {
        return new IntegerNode(intValue);
    }

    @Override
    public FractionNode createFraction(IntegerNode numerator, IntegerNode denominator) {
        return new FractionNode(numerator, denominator);
    }

    @Override
    public PatternNode createPattern(SymbolNode patternName, ASTNode check) {
        return new PatternNode(patternName, check);
    }

    @Override
    public PatternNode createPattern(SymbolNode patternName, ASTNode check, boolean optional) {
        return new PatternNode(patternName, check, optional);
    }

    @Override
    public PatternNode createPattern(SymbolNode patternName, ASTNode check, ASTNode defaultValue) {
        return new PatternNode(patternName, check, defaultValue);
    }

    @Override
    public PatternNode createPattern2(SymbolNode patternName, ASTNode check) {
        return new Pattern2Node(patternName, check);
    }

    @Override
    public PatternNode createPattern3(SymbolNode patternName, ASTNode check) {
        return new Pattern3Node(patternName, check);
    }

    @Override
    public StringNode createString(StringBuilder buffer) {
        return new StringNode(buffer.toString());
    }

    @Override
    public SymbolNode createSymbol(String symbolName, String context) {
        String name = symbolName;
        if (this.fIgnoreCase && name.length() > 1) {
            name = symbolName.toLowerCase();
        }
        return new SymbolNode(name);
    }

    @Override
    public SymbolNode createSymbol(String symbolName) {
        return this.createSymbol(symbolName, "");
    }

    @Override
    public boolean isValidIdentifier(String identifier) {
        return true;
    }

    static {
        MMA_STYLE_FACTORY = new ASTNodeFactory(false);
        RELAXED_STYLE_FACTORY = new ASTNodeFactory(true);
        Initializer.init();
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            OPERATORS = new Operator[]{new MessageNameOperator("::", "MessageName", 750, 0), new PrefixOperator("<<", "Get", 720), new InfixOperator("?", "PatternTest", 680, 0), new InfixOperator("//@", "MapAll", 620, 1), new InfixOperator("*=", "TimesBy", 100, 1), new InfixOperator("+", "Plus", 310, 0), new InfixOperator("^=", "UpSet", 40, 1), new InfixOperator(";", "CompoundExpression", 10, 0), APPLY_HEAD_OPERATOR, new InfixOperator("/@", "Map", 620, 1), new PostfixOperator("=.", "Unset", 670), APPLY_OPERATOR, APPLY_LEVEL_OPERATOR, new InfixOperator("//.", "ReplaceRepeated", 110, 2), new InfixOperator("<", "Less", 290, 0), new InfixOperator("&&", "And", 215, 0), new DivideOperator("/", "Divide", 470, 2), new InfixOperator("=", "Set", 40, 1), new PostfixOperator("++", "Increment", 660), new PostfixOperator("!!", "Factorial2", 610), new InfixOperator("<=", "LessEqual", 290, 0), new InfixOperator("**", "NonCommutativeMultiply", 510, 0), new PostfixOperator("!", "Factorial", 610), new InfixOperator("*", "Times", 400, 0), new InfixOperator("^", "Power", 590, 1), new InfixOperator(".", "Dot", 490, 0), new PrefixOperator("!", "Not", 230), new PreMinusOperator("-", "PreMinus", 485), new InfixOperator("===", "SameQ", 290, 0), new InfixOperator(":>", "RuleDelayed", 120, 1), new InfixOperator(">=", "GreaterEqual", 290, 0), new InfixOperator("/;", "Condition", 130, 2), new InfixOperator("//", "//", 70, 2), new InfixOperator("/=", "DivideBy", 100, 1), new InfixOperator("||", "Or", 213, 0), new InfixOperator(";;", "Span", 305, 0), new InfixOperator("==", "Equal", 290, 0), new InfixOperator("<>", "StringJoin", 600, 0), new InfixOperator("!=", "Unequal", 290, 0), new PostfixOperator("--", "Decrement", 660), new InfixOperator("-=", "SubtractFrom", 100, 1), new PrePlusOperator("+", "PrePlus", 670), new PostfixOperator("...", "RepeatedNull", 170), new InfixOperator("=!=", "UnsameQ", 290, 0), new InfixOperator("->", "Rule", 120, 1), new InfixOperator("^:=", "UpSetDelayed", 40, 1), new PrefixOperator("++", "PreIncrement", 660), new InfixOperator("|->", "Function", 90, 1), new PostfixOperator("&", "Function", 90), new InfixOperator(">", "Greater", 290, 0), new PrefixOperator("--", "PreDecrement", 660), new SubtractOperator("-", "Subtract", 310, 2), new InfixOperator(":=", "SetDelayed", 40, 1), new InfixOperator("|", "Alternatives", 160, 0), new InfixOperator("+=", "AddTo", 100, 1), new PostfixOperator("..", "Repeated", 170), new InfixOperator("/.", "ReplaceAll", 110, 2), TAG_SET_OPERATOR, new InfixOperator("@*", "Composition", 625, 0), new InfixOperator("/*", "RightComposition", 648, 0), new InfixOperator("~~", "StringExpression", 135, 0), new PatternOperator(":", "Pattern", 150, 0), new InfixOperator("<->", "TwoWayRule", 125, 1), new InfixOperator("\uf120", "TwoWayRule", 125, 1), new InfixOperator("\uf3d5", "DirectedEdge", 120, 1), new InfixOperator("\uf3d4", "UndirectedEdge", 120, 1), new InfixOperator("\u00b7", "CenterDot", 410, 0), new InfixOperator("\u2299", "CircleDot", 520, 0), new InfixOperator("\u2297", "CircleTimes", 420, 0), new InfixOperator("\uf3d2", "Distributed", 250, 0), new InfixOperator("\u2208", "Element", 250, 0), new InfixOperator("\u22c2", "Intersection", 305, 0), new InfixOperator("\u2260", "Unequal", 290, 0), new InfixOperator("\u22c0", "Wedge", 440, 0), new InfixOperator("\uf3da", "TensorProduct", 495, 0), new InfixOperator("\u29e6", "Equivalent", 205, 0), new InfixOperator("\uf523", "Implies", 200, 1), new TildeOperator("~", "\u00a7TILDE\u00a7", 630, 0)};
            StringBuilder buf = new StringBuilder(".-:=<>*+;!^|&/@?~");
            fOperatorMap = ParserConfig.TRIE_STRING2OPERATOR_BUILDER.withMatch(TrieMatch.EXACT).build();
            fOperatorTokenStartSet = ParserConfig.TRIE_STRING2OPERATORLIST_BUILDER.withMatch(TrieMatch.EXACT).build();
            for (int i = 0; i < HEADER_STRINGS.length; ++i) {
                ASTNodeFactory.addOperator(fOperatorMap, fOperatorTokenStartSet, OPERATOR_STRINGS[i], HEADER_STRINGS[i], OPERATORS[i]);
                String unicodeChar = Characters.NamedCharactersMap.get(HEADER_STRINGS[i]);
                if (unicodeChar == null) continue;
                ASTNodeFactory.addOperator(fOperatorMap, fOperatorTokenStartSet, unicodeChar, HEADER_STRINGS[i], OPERATORS[i]);
                buf.append(unicodeChar);
            }
            OPERATOR_CHARACTERS = buf.toString();
        }
    }

    private static class SubtractOperator
    extends InfixOperator {
        public SubtractOperator(String oper, String functionName, int precedence, int grouping) {
            super(oper, functionName, precedence, grouping);
        }

        @Override
        public ASTNode createFunction(INodeParserFactory factory, ASTNode lhs, ASTNode rhs) {
            return factory.createFunction(factory.createSymbol("Plus"), lhs, factory.createFunction(factory.createSymbol("Times"), factory.createInteger(-1), rhs));
        }
    }

    private static class PrePlusOperator
    extends PrefixOperator {
        public PrePlusOperator(String oper, String functionName, int precedence) {
            super(oper, functionName, precedence);
        }

        @Override
        public ASTNode createFunction(INodeParserFactory factory, ASTNode argument) {
            return argument;
        }
    }

    private static class PreMinusOperator
    extends PrefixOperator {
        public PreMinusOperator(String oper, String functionName, int precedence) {
            super(oper, functionName, precedence);
        }

        @Override
        public ASTNode createFunction(INodeParserFactory factory, ASTNode argument) {
            return factory.createFunction(factory.createSymbol("Times"), factory.createInteger(-1), argument);
        }
    }

    private static class MessageNameOperator
    extends InfixOperator {
        public MessageNameOperator(String oper, String functionName, int precedence, int grouping) {
            super(oper, functionName, precedence, grouping);
        }

        @Override
        public ASTNode createFunction(INodeParserFactory factory, ASTNode lhs, ASTNode rhs) {
            if (rhs instanceof SymbolNode) {
                return factory.createFunction(factory.createSymbol(this.getFunctionName()), lhs, new StringNode(rhs.toString()));
            }
            return factory.createFunction(factory.createSymbol(this.getFunctionName()), lhs, rhs);
        }
    }

    private static class TildeOperator
    extends InfixOperator {
        public TildeOperator(String oper, String functionName, int precedence, int grouping) {
            super(oper, functionName, precedence, grouping);
        }

        @Override
        public ASTNode createFunction(INodeParserFactory factory, ASTNode lhs, ASTNode rhs) {
            return factory.createFunction(factory.createSymbol("\u00a7TILDE\u00a7"), lhs, rhs);
        }

        @Override
        public FunctionNode endFunction(INodeParserFactory factory, FunctionNode function, Scanner scanner) {
            int size = function.size();
            if (size < 4 || (size & 1) != 0) {
                scanner.throwSyntaxError("Operator ~ requires even number of arguments");
            }
            FunctionNode result = factory.createAST(function.get(2));
            result.add(function.get(1));
            result.add(function.get(3));
            for (int i = 4; i < size; i += 2) {
                FunctionNode temp = factory.createAST(function.get(i));
                temp.add(result);
                temp.add(function.get(i + 1));
                result = temp;
            }
            return result;
        }
    }

    private static class PatternOperator
    extends InfixOperator {
        public PatternOperator(String oper, String functionName, int precedence, int grouping) {
            super(oper, functionName, precedence, grouping);
        }

        @Override
        public ASTNode createFunction(INodeParserFactory factory, ASTNode lhs, ASTNode rhs) {
            if (lhs instanceof SymbolNode) {
                FunctionNode pn2;
                FunctionNode pn1;
                if (rhs instanceof FunctionNode && (pn1 = (FunctionNode)rhs).size() == 3 && pn1.get(0).equals(factory.createSymbol("Pattern")) && pn1.get(1) instanceof SymbolNode && pn1.get(2) instanceof FunctionNode && (pn2 = (FunctionNode)pn1.get(2)).size() == 3 && pn2.get(0).equals(factory.createSymbol("Pattern"))) {
                    return factory.createFunction(factory.createSymbol("Optional"), factory.createFunction(factory.createSymbol("Pattern"), lhs, pn1.get(1)), pn2);
                }
                return factory.createFunction(factory.createSymbol("Pattern"), lhs, rhs);
            }
            return factory.createFunction(factory.createSymbol("Optional"), lhs, rhs);
        }
    }

    private static class DivideOperator
    extends InfixOperator {
        public DivideOperator(String oper, String functionName, int precedence, int grouping) {
            super(oper, functionName, precedence, grouping);
        }

        @Override
        public ASTNode createFunction(INodeParserFactory factory, ASTNode lhs, ASTNode rhs) {
            if (rhs instanceof IntegerNode) {
                if (lhs instanceof IntegerNode) {
                    return new FractionNode((IntegerNode)lhs, (IntegerNode)rhs);
                }
                return factory.createFunction(factory.createSymbol("Times"), new FractionNode(IntegerNode.C1, (IntegerNode)rhs), lhs);
            }
            if (lhs.equals(IntegerNode.C1)) {
                return factory.createFunction(factory.createSymbol("Power"), rhs, factory.createInteger(-1));
            }
            return factory.createFunction(factory.createSymbol("Times"), lhs, factory.createFunction(factory.createSymbol("Power"), rhs, factory.createInteger(-1)));
        }
    }

    private static class TagSetOperator
    extends InfixOperator {
        public TagSetOperator(String oper, String functionName, int precedence, int grouping) {
            super(oper, functionName, precedence, grouping);
        }

        @Override
        public ASTNode createFunction(INodeParserFactory factory, ASTNode lhs, ASTNode rhs) {
            FunctionNode r;
            if (rhs instanceof FunctionNode && (r = (FunctionNode)rhs).size() == 3) {
                if (r.get(0).equals(factory.createSymbol("Set"))) {
                    return factory.createFunction(factory.createSymbol("TagSet"), lhs, r.get(1), r.get(2));
                }
                if (r.get(0).equals(factory.createSymbol("SetDelayed"))) {
                    return factory.createFunction(factory.createSymbol("TagSetDelayed"), lhs, r.get(1), r.get(2));
                }
            }
            return factory.createFunction(factory.createSymbol("TagSet"), lhs, rhs);
        }
    }

    private static class ApplyOperator
    extends InfixOperator {
        public ApplyOperator(String oper, String functionName, int precedence, int grouping) {
            super(oper, functionName, precedence, grouping);
        }

        @Override
        public ASTNode createFunction(INodeParserFactory factory, ASTNode lhs, ASTNode rhs) {
            if (this.fOperatorString.equals("@")) {
                return factory.unaryAST(lhs, rhs);
            }
            FunctionNode fn = factory.createFunction(factory.createSymbol("Apply"), lhs, rhs);
            if (this.fOperatorString.equals("@@")) {
                return fn;
            }
            fn.add(factory.createFunction(factory.createSymbol("List"), factory.createInteger(1)));
            return fn;
        }
    }
}

