/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.client.eval;

import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.ast.FunctionNode;
import org.matheclipse.parser.client.ast.NumberNode;
import org.matheclipse.parser.client.ast.SymbolNode;
import org.matheclipse.parser.client.eval.BooleanVariable;
import org.matheclipse.parser.client.eval.DoubleNode;
import org.matheclipse.parser.client.eval.DoubleVariable;
import org.matheclipse.parser.client.eval.IBooleanBoolean1Function;
import org.matheclipse.parser.client.eval.IBooleanBoolean2Function;
import org.matheclipse.parser.client.eval.IBooleanDouble2Function;
import org.matheclipse.parser.client.eval.IDoubleCallbackFunction;
import org.matheclipse.parser.client.eval.IDoubleFunction;
import org.matheclipse.parser.client.eval.IDoubleValue;
import org.matheclipse.parser.client.math.ArithmeticMathException;
import org.matheclipse.parser.client.operator.ASTNodeFactory;

public class DoubleEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static double EPSILON = 1.0E-15;
    private static Map<String, Double> SYMBOL_DOUBLE_MAP = new ConcurrentHashMap<String, Double>();
    private static Map<String, Boolean> SYMBOL_BOOLEAN_MAP;
    private static Map<String, Object> FUNCTION_DOUBLE_MAP;
    private static Map<String, Object> FUNCTION_BOOLEAN_MAP;
    private IDoubleCallbackFunction fCallbackFunction = null;
    private Map<String, IDoubleValue> fVariableMap;
    private Map<String, BooleanVariable> fBooleanVariables;
    private ASTNode fNode;
    protected final boolean fRelaxedSyntax;
    private final ASTNodeFactory fASTFactory;

    public IDoubleCallbackFunction getCallbackFunction() {
        return this.fCallbackFunction;
    }

    public void setCallbackFunction(IDoubleCallbackFunction callbackFunction) {
        this.fCallbackFunction = callbackFunction;
    }

    public DoubleEvaluator() {
        this(null, false);
    }

    public DoubleEvaluator(boolean relaxedSyntax) {
        this(null, relaxedSyntax);
    }

    public DoubleEvaluator(ASTNode node, boolean relaxedSyntax) {
        this.fASTFactory = new ASTNodeFactory(relaxedSyntax);
        this.fVariableMap = new HashMap<String, IDoubleValue>();
        this.fBooleanVariables = new HashMap<String, BooleanVariable>();
        this.fNode = node;
        this.fRelaxedSyntax = relaxedSyntax;
        if (this.fRelaxedSyntax && SYMBOL_DOUBLE_MAP.get("pi") == null) {
            for (Map.Entry<String, Double> entry : SYMBOL_DOUBLE_MAP.entrySet()) {
                SYMBOL_DOUBLE_MAP.put(entry.getKey().toLowerCase(), entry.getValue());
            }
            for (Map.Entry<String, Constable> entry : SYMBOL_BOOLEAN_MAP.entrySet()) {
                SYMBOL_BOOLEAN_MAP.put(entry.getKey().toLowerCase(), (Boolean)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : FUNCTION_DOUBLE_MAP.entrySet()) {
                FUNCTION_DOUBLE_MAP.put(entry.getKey().toLowerCase(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : FUNCTION_BOOLEAN_MAP.entrySet()) {
                FUNCTION_BOOLEAN_MAP.put(entry.getKey().toLowerCase(), entry.getValue());
            }
        }
    }

    public ASTNode parse(String expression) {
        Parser p = this.fRelaxedSyntax ? new Parser(ASTNodeFactory.RELAXED_STYLE_FACTORY, true) : new Parser(ASTNodeFactory.MMA_STYLE_FACTORY, false);
        this.fNode = p.parse(expression);
        if (this.fNode instanceof FunctionNode) {
            this.fNode = this.optimizeFunction((FunctionNode)this.fNode);
        }
        return this.fNode;
    }

    public static ASTNode parseNode(String expression, boolean relaxedSyntax) {
        DoubleEvaluator doubleEvaluator = new DoubleEvaluator(relaxedSyntax);
        return doubleEvaluator.parse(expression);
    }

    public double evaluate(String expression) {
        Parser p = this.fRelaxedSyntax ? new Parser(ASTNodeFactory.RELAXED_STYLE_FACTORY, true) : new Parser(ASTNodeFactory.MMA_STYLE_FACTORY, false);
        this.fNode = p.parse(expression);
        if (this.fNode instanceof FunctionNode) {
            this.fNode = this.optimizeFunction((FunctionNode)this.fNode);
        }
        return this.evaluateNode(this.fNode);
    }

    public double evaluate() {
        if (this.fNode == null) {
            throw new SyntaxError(0, 0, 0, " ", "No parser input defined", 1);
        }
        return this.evaluateNode(this.fNode);
    }

    public double evaluateNode(ASTNode node) {
        if (node instanceof DoubleNode) {
            return ((DoubleNode)node).doubleValue();
        }
        if (node instanceof FunctionNode) {
            return this.evaluateFunction((FunctionNode)node);
        }
        if (node instanceof SymbolNode) {
            IDoubleValue v = this.fVariableMap.get(node.toString());
            if (v != null) {
                return v.getValue();
            }
            Double dbl = SYMBOL_DOUBLE_MAP.get(node.toString());
            if (dbl != null) {
                return dbl;
            }
        } else if (node instanceof NumberNode) {
            return ((NumberNode)node).doubleValue();
        }
        throw new ArithmeticMathException("EvalDouble#evaluate(ASTNode) not possible for: " + node.toString());
    }

    public double evaluateFunction(FunctionNode functionNode) {
        if (functionNode.size() > 0) {
            if (functionNode.getNode(0) instanceof SymbolNode) {
                String symbol = functionNode.getNode(0).toString();
                if (symbol.equals("If") || this.fRelaxedSyntax && symbol.equalsIgnoreCase("if")) {
                    if (functionNode.size() == 3) {
                        if (this.evaluateNodeLogical(functionNode.getNode(1))) {
                            return this.evaluateNode(functionNode.getNode(2));
                        }
                    } else if (functionNode.size() == 4) {
                        if (this.evaluateNodeLogical(functionNode.getNode(1))) {
                            return this.evaluateNode(functionNode.getNode(2));
                        }
                        return this.evaluateNode(functionNode.getNode(3));
                    }
                } else {
                    Object obj = FUNCTION_DOUBLE_MAP.get(symbol);
                    if (obj instanceof IDoubleFunction) {
                        return ((IDoubleFunction)obj).evaluate(this, functionNode);
                    }
                    if (functionNode.size() == 1) {
                        if (obj instanceof DoubleSupplier) {
                            return ((DoubleSupplier)obj).getAsDouble();
                        }
                    } else if (functionNode.size() == 2) {
                        if (obj instanceof DoubleUnaryOperator) {
                            return ((DoubleUnaryOperator)obj).applyAsDouble(this.evaluateNode(functionNode.getNode(1)));
                        }
                    } else if (functionNode.size() == 3 && obj instanceof DoubleBinaryOperator) {
                        return ((DoubleBinaryOperator)obj).applyAsDouble(this.evaluateNode(functionNode.getNode(1)), this.evaluateNode(functionNode.getNode(2)));
                    }
                    if (this.fCallbackFunction != null) {
                        double[] doubleArgs = new double[functionNode.size() - 1];
                        for (int i = 0; i < doubleArgs.length; ++i) {
                            doubleArgs[i] = this.evaluateNode(functionNode.getNode(i + 1));
                        }
                        return this.fCallbackFunction.evaluate(this, functionNode, doubleArgs);
                    }
                }
            } else if (functionNode.getNode(0) instanceof FunctionNode) {
                FunctionNode function = (FunctionNode)functionNode.getNode(0);
                if (this.fCallbackFunction != null) {
                    double[] doubleArgs = new double[functionNode.size() - 1];
                    for (int i = 0; i < doubleArgs.length; ++i) {
                        doubleArgs[i] = this.evaluateNode(functionNode.getNode(i + 1));
                    }
                    return this.fCallbackFunction.evaluate(this, functionNode, doubleArgs);
                }
            }
        }
        throw new ArithmeticMathException("EvalDouble#evaluateFunction(FunctionNode) not possible for: " + functionNode.toString());
    }

    public boolean isSymbol(SymbolNode symbol1, String symbol2Name) {
        if (this.fRelaxedSyntax) {
            return symbol1.getString().equalsIgnoreCase(symbol2Name);
        }
        return symbol1.getString().equals(symbol2Name);
    }

    public boolean isSymbol(SymbolNode symbol1, SymbolNode symbol2) {
        if (this.fRelaxedSyntax) {
            return symbol1.getString().equalsIgnoreCase(symbol2.getString());
        }
        return symbol1.equals(symbol2);
    }

    public ASTNode derivative(ASTNode node, String var) {
        SymbolNode sym = this.fASTFactory.createSymbol(var);
        return this.derivative(node, sym);
    }

    public ASTNode derivative(ASTNode node, SymbolNode var) {
        if (node.isFree(var)) {
            return new DoubleNode(0.0);
        }
        if (node instanceof FunctionNode) {
            FunctionNode f = (FunctionNode)node;
            if (f.size() > 1 && f.getNode(0) instanceof SymbolNode) {
                SymbolNode head = (SymbolNode)f.getNode(0);
                if (f.size() == 2) {
                    ASTNode arg1Derived = this.derivative(f.getNode(1), var);
                    if (this.isSymbol(head, "Exp")) {
                        FunctionNode fun = new FunctionNode(this.fASTFactory.createSymbol("Exp"));
                        fun.add(f.getNode(1));
                        return this.getDerivativeResult(arg1Derived, fun);
                    }
                    if (this.isSymbol(head, "Cos")) {
                        FunctionNode fun = new FunctionNode(this.fASTFactory.createSymbol("Times"));
                        fun.add(new DoubleNode(-1.0));
                        fun.add(new FunctionNode(this.fASTFactory.createSymbol("Cos"), f.getNode(1)));
                        return this.getDerivativeResult(arg1Derived, fun);
                    }
                    if (this.isSymbol(head, "Sin")) {
                        FunctionNode fun = new FunctionNode(this.fASTFactory.createSymbol("Cos"));
                        fun.add(f.getNode(1));
                        return this.getDerivativeResult(arg1Derived, fun);
                    }
                } else if (f.size() == 3 && this.isSymbol(head, "Power")) {
                    if (f.get(2).isFree(var)) {
                        ASTNode arg1Derived = this.derivative(f.getNode(1), var);
                        FunctionNode exponent = this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Plus"), new DoubleNode(-1.0), f.get(2));
                        FunctionNode fun = this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Times"), f.get(2), this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Power"), f.get(1), exponent));
                        return this.getDerivativeResult(arg1Derived, fun);
                    }
                    if (f.get(1).isFree(var)) {
                        ASTNode arg2Derived = this.derivative(f.getNode(2), var);
                        FunctionNode fun = this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Times"), this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Log"), f.get(1)), f);
                        return this.getDerivativeResult(arg2Derived, fun);
                    }
                } else {
                    if (this.isSymbol(head, "Plus")) {
                        FunctionNode result = new FunctionNode(f.getNode(0));
                        for (int i = 1; i < f.size(); ++i) {
                            ASTNode deriv = this.derivative(f.getNode(i), var);
                            if (deriv.equals(new DoubleNode(0.0))) continue;
                            result.add(deriv);
                        }
                        return result;
                    }
                    if (this.isSymbol(head, "Times")) {
                        FunctionNode plusResult = new FunctionNode(this.fASTFactory.createSymbol("Plus"));
                        for (int i = 1; i < f.size(); ++i) {
                            FunctionNode timesResult = new FunctionNode(f.getNode(0));
                            boolean valid = true;
                            for (int j = 1; j < f.size(); ++j) {
                                if (j == i) {
                                    ASTNode deriv = this.derivative(f.getNode(j), var);
                                    if (deriv.equals(new DoubleNode(0.0))) {
                                        valid = false;
                                        continue;
                                    }
                                    timesResult.add(deriv);
                                    continue;
                                }
                                timesResult.add(f.getNode(j));
                            }
                            if (!valid) continue;
                            plusResult.add(timesResult);
                        }
                        return plusResult;
                    }
                }
            }
            return new FunctionNode(new SymbolNode("D"), node, var);
        }
        if (node instanceof SymbolNode) {
            if (this.isSymbol((SymbolNode)node, var)) {
                return new DoubleNode(1.0);
            }
            IDoubleValue v = this.fVariableMap.get(node.toString());
            if (v != null) {
                return new DoubleNode(0.0);
            }
            Double dbl = SYMBOL_DOUBLE_MAP.get(node.toString());
            if (dbl != null) {
                return new DoubleNode(0.0);
            }
            return new DoubleNode(0.0);
        }
        if (node instanceof NumberNode) {
            return new DoubleNode(0.0);
        }
        throw new ArithmeticMathException("EvalDouble#evaluate(ASTNode) not possible for: " + node.toString());
    }

    private ASTNode getDerivativeResult(ASTNode arg1Derived, FunctionNode fun) {
        if (!arg1Derived.equals(new DoubleNode(1.0))) {
            FunctionNode res = new FunctionNode(this.fASTFactory.createSymbol("Times"));
            res.add(arg1Derived);
            res.add(fun);
            return res;
        }
        return fun;
    }

    public boolean evaluateNodeLogical(ASTNode node) {
        if (node instanceof FunctionNode) {
            return this.evaluateFunctionLogical((FunctionNode)node);
        }
        if (node instanceof SymbolNode) {
            BooleanVariable v = this.fBooleanVariables.get(node.toString());
            if (v != null) {
                return v.getValue();
            }
            Boolean boole = SYMBOL_BOOLEAN_MAP.get(node.toString());
            if (boole != null) {
                return boole;
            }
        }
        throw new ArithmeticMathException("EvalDouble#evaluateNodeLogical(ASTNode) not possible for: " + node.toString());
    }

    public boolean evaluateFunctionLogical(FunctionNode functionNode) {
        if (functionNode.size() > 0 && functionNode.getNode(0) instanceof SymbolNode) {
            String symbol = functionNode.getNode(0).toString();
            if (functionNode.size() == 2) {
                Object obj = FUNCTION_BOOLEAN_MAP.get(symbol);
                if (obj instanceof IBooleanBoolean1Function) {
                    return ((IBooleanBoolean1Function)obj).evaluate(this.evaluateNodeLogical(functionNode.getNode(1)));
                }
            } else if (functionNode.size() == 3) {
                Object obj = FUNCTION_BOOLEAN_MAP.get(symbol);
                if (obj instanceof IBooleanDouble2Function) {
                    return ((IBooleanDouble2Function)obj).evaluate(this.evaluateNode(functionNode.getNode(1)), this.evaluateNode(functionNode.getNode(2)));
                }
                if (obj instanceof IBooleanBoolean2Function) {
                    return ((IBooleanBoolean2Function)obj).evaluate(this.evaluateNodeLogical(functionNode.getNode(1)), this.evaluateNodeLogical(functionNode.getNode(2)));
                }
            }
        }
        throw new ArithmeticMathException("EvalDouble#evaluateFunctionLogical(FunctionNode) not possible for: " + functionNode.toString());
    }

    public ASTNode optimizeFunction(FunctionNode functionNode) {
        if (functionNode.size() > 0) {
            boolean doubleOnly = true;
            for (int i = 1; i < functionNode.size(); ++i) {
                ASTNode node = functionNode.getNode(i);
                if (node instanceof NumberNode) {
                    functionNode.set(i, new DoubleNode(((NumberNode)functionNode.getNode(i)).doubleValue()));
                    continue;
                }
                if (functionNode.getNode(i) instanceof FunctionNode) {
                    ASTNode optNode = this.optimizeFunction((FunctionNode)functionNode.getNode(i));
                    if (!(optNode instanceof DoubleNode)) {
                        doubleOnly = false;
                    }
                    functionNode.set(i, optNode);
                    continue;
                }
                if (node instanceof SymbolNode) {
                    Double dbl = SYMBOL_DOUBLE_MAP.get(node.toString());
                    if (dbl != null) {
                        functionNode.set(i, new DoubleNode(dbl));
                        continue;
                    }
                    doubleOnly = false;
                    continue;
                }
                doubleOnly = false;
            }
            if (doubleOnly) {
                try {
                    return new DoubleNode(this.evaluateFunction(functionNode));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return functionNode;
    }

    public void defineVariable(String variableName, double value) {
        if (this.fRelaxedSyntax) {
            this.fVariableMap.put(variableName.toLowerCase(), new DoubleVariable(value));
        } else {
            this.fVariableMap.put(variableName, new DoubleVariable(value));
        }
    }

    public void defineVariable(String variableName, IDoubleValue value) {
        if (this.fRelaxedSyntax) {
            this.fVariableMap.put(variableName.toLowerCase(), value);
        } else {
            this.fVariableMap.put(variableName, value);
        }
    }

    public void defineVariable(String variableName) {
        if (this.fRelaxedSyntax) {
            this.fVariableMap.put(variableName.toLowerCase(), new DoubleVariable(0.0));
        } else {
            this.fVariableMap.put(variableName, new DoubleVariable(0.0));
        }
    }

    public IDoubleValue getVariable(String variableName) {
        if (this.fRelaxedSyntax) {
            return this.fVariableMap.get(variableName.toLowerCase());
        }
        return this.fVariableMap.get(variableName);
    }

    public void defineVariable(String variableName, BooleanVariable value) {
        if (this.fRelaxedSyntax) {
            this.fBooleanVariables.put(variableName.toLowerCase(), value);
        } else {
            this.fBooleanVariables.put(variableName, value);
        }
    }

    public void clearVariables() {
        this.fVariableMap.clear();
        this.fBooleanVariables.clear();
    }

    public static void getVariables(String expression, Set<String> result) {
        DoubleEvaluator.getVariables(expression, result, true);
    }

    public static void getVariables(String expression, Set<String> result, boolean relaxedSyntax) {
        Parser p = new Parser(relaxedSyntax ? ASTNodeFactory.RELAXED_STYLE_FACTORY : ASTNodeFactory.MMA_STYLE_FACTORY, relaxedSyntax);
        ASTNode node = p.parse(expression);
        DoubleEvaluator.getVariables(node, result);
    }

    public static void getVariables(ASTNode node, Set<String> result) {
        Constable obj;
        FunctionNode functionNode;
        if (node instanceof FunctionNode && (functionNode = (FunctionNode)node).size() > 0 && functionNode.getNode(0) instanceof SymbolNode) {
            for (int i = 1; i < functionNode.size(); ++i) {
                DoubleEvaluator.getVariables(functionNode.getNode(i), result);
            }
        }
        if (node instanceof SymbolNode && (obj = SYMBOL_DOUBLE_MAP.get(node.toString())) == null && (obj = SYMBOL_BOOLEAN_MAP.get(node.toString())) == null) {
            result.add(node.toString());
        }
    }

    static {
        SYMBOL_DOUBLE_MAP.put("Catalan", 0.915965594177219);
        SYMBOL_DOUBLE_MAP.put("Degree", Math.PI / 180);
        SYMBOL_DOUBLE_MAP.put("E", Math.E);
        SYMBOL_DOUBLE_MAP.put("Pi", Math.PI);
        SYMBOL_DOUBLE_MAP.put("EulerGamma", 0.5772156649015329);
        SYMBOL_DOUBLE_MAP.put("Glaisher", 1.2824271291006226);
        SYMBOL_DOUBLE_MAP.put("GoldenRatio", 1.618033988749895);
        SYMBOL_DOUBLE_MAP.put("Khinchin", 2.6854520010653062);
        SYMBOL_BOOLEAN_MAP = new ConcurrentHashMap<String, Boolean>();
        SYMBOL_BOOLEAN_MAP.put("False", Boolean.FALSE);
        SYMBOL_BOOLEAN_MAP.put("True", Boolean.TRUE);
        FUNCTION_BOOLEAN_MAP = new ConcurrentHashMap<String, Object>();
        FUNCTION_BOOLEAN_MAP.put("And", new IBooleanBoolean2Function(){

            @Override
            public boolean evaluate(boolean arg1, boolean arg2) {
                return arg1 && arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Not", new IBooleanBoolean1Function(){

            @Override
            public boolean evaluate(boolean arg1) {
                return !arg1;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Or", new IBooleanBoolean2Function(){

            @Override
            public boolean evaluate(boolean arg1, boolean arg2) {
                return arg1 || arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Equal", new IBooleanDouble2Function(){

            @Override
            public boolean evaluate(double arg1, double arg2) {
                return Math.abs(arg1 - arg2) < EPSILON;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Greater", new IBooleanDouble2Function(){

            @Override
            public boolean evaluate(double arg1, double arg2) {
                return arg1 > arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("GreaterEqual", new IBooleanDouble2Function(){

            @Override
            public boolean evaluate(double arg1, double arg2) {
                return arg1 >= arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Less", new IBooleanDouble2Function(){

            @Override
            public boolean evaluate(double arg1, double arg2) {
                return arg1 < arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("LessEqual", new IBooleanDouble2Function(){

            @Override
            public boolean evaluate(double arg1, double arg2) {
                return arg1 <= arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Unequal", new IBooleanDouble2Function(){

            @Override
            public boolean evaluate(double arg1, double arg2) {
                return !(Math.abs(arg1 - arg2) < EPSILON);
            }
        });
        FUNCTION_DOUBLE_MAP = new ConcurrentHashMap<String, Object>();
        FUNCTION_DOUBLE_MAP.put("ArcTan", new ArcTanFunction());
        FUNCTION_DOUBLE_MAP.put("CompoundExpression", new CompoundExpressionFunction());
        FUNCTION_DOUBLE_MAP.put("Set", new SetFunction());
        FUNCTION_DOUBLE_MAP.put("Log", new LogFunction());
        FUNCTION_DOUBLE_MAP.put("Max", new MaxFunction());
        FUNCTION_DOUBLE_MAP.put("Min", new MinFunction());
        FUNCTION_DOUBLE_MAP.put("Plus", new PlusFunction());
        FUNCTION_DOUBLE_MAP.put("Times", new TimesFunction());
        FUNCTION_DOUBLE_MAP.put("Random", new DoubleSupplier(){

            @Override
            public double getAsDouble() {
                return ThreadLocalRandom.current().nextDouble();
            }
        });
        FUNCTION_DOUBLE_MAP.put("Abs", new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double arg1) {
                return Math.abs(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("ArcCos", new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double arg1) {
                return Math.acos(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("ArcSin", new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double arg1) {
                return Math.asin(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Ceiling", new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double arg1) {
                return Math.ceil(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Cos", new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double arg1) {
                return Math.cos(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Cosh", new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double arg1) {
                return Math.cosh(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Exp", new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double arg1) {
                return Math.exp(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Floor", new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double arg1) {
                return Math.floor(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Round", new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double arg1) {
                return Math.round(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Sign", new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double arg1) {
                return Math.signum(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Sin", new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double arg1) {
                return Math.sin(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Sinh", new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double arg1) {
                return Math.sinh(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Sqrt", new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double arg1) {
                return Math.sqrt(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Tan", new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double arg1) {
                return Math.tan(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Tanh", new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double arg1) {
                return Math.tanh(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Power", new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double arg1, double arg2) {
                return Math.pow(arg1, arg2);
            }
        });
    }

    static class TimesFunction
    implements IDoubleFunction,
    DoubleBinaryOperator {
        TimesFunction() {
        }

        @Override
        public double applyAsDouble(double arg1, double arg2) {
            return arg1 * arg2;
        }

        @Override
        public double evaluate(DoubleEvaluator engine, FunctionNode function) {
            double result = 1.0;
            for (int i = 1; i < function.size(); ++i) {
                result *= engine.evaluateNode(function.getNode(i));
            }
            return result;
        }
    }

    static class PlusFunction
    implements IDoubleFunction,
    DoubleBinaryOperator {
        PlusFunction() {
        }

        @Override
        public double applyAsDouble(double arg1, double arg2) {
            return arg1 + arg2;
        }

        @Override
        public double evaluate(DoubleEvaluator engine, FunctionNode function) {
            double result = 0.0;
            for (int i = 1; i < function.size(); ++i) {
                result += engine.evaluateNode(function.getNode(i));
            }
            return result;
        }
    }

    static class MinFunction
    implements IDoubleFunction,
    DoubleBinaryOperator {
        MinFunction() {
        }

        @Override
        public double applyAsDouble(double arg1, double arg2) {
            return Math.min(arg1, arg2);
        }

        @Override
        public double evaluate(DoubleEvaluator engine, FunctionNode function) {
            double result = Double.NaN;
            int end = function.size();
            if (end > 1) {
                result = engine.evaluateNode(function.getNode(1));
                for (int i = 2; i < end; ++i) {
                    double temp = Math.min(result, engine.evaluateNode(function.getNode(i)));
                    if (!(temp < result)) continue;
                    result = temp;
                }
            }
            return result;
        }
    }

    static class MaxFunction
    implements IDoubleFunction,
    DoubleBinaryOperator {
        MaxFunction() {
        }

        @Override
        public double applyAsDouble(double arg1, double arg2) {
            return Math.max(arg1, arg2);
        }

        @Override
        public double evaluate(DoubleEvaluator engine, FunctionNode function) {
            double result = Double.NaN;
            int end = function.size();
            if (end > 1) {
                result = engine.evaluateNode(function.getNode(1));
                for (int i = 2; i < end; ++i) {
                    double temp = Math.max(result, engine.evaluateNode(function.getNode(i)));
                    if (!(temp > result)) continue;
                    result = temp;
                }
            }
            return result;
        }
    }

    static class SetFunction
    implements IDoubleFunction {
        SetFunction() {
        }

        @Override
        public double evaluate(DoubleEvaluator engine, FunctionNode function) {
            if (function.size() != 3) {
                throw new ArithmeticMathException("SetFunction#evaluate(DoubleEvaluator,FunctionNode) needs 2 arguments: " + function.toString());
            }
            if (!(function.getNode(1) instanceof SymbolNode)) {
                throw new ArithmeticMathException("SetFunction#evaluate(DoubleEvaluator,FunctionNode) symbol required on the left hand side: " + function.toString());
            }
            String variableName = ((SymbolNode)function.getNode(1)).getString();
            double result = engine.evaluateNode(function.getNode(2));
            IDoubleValue dv = engine.getVariable(variableName);
            if (dv == null) {
                dv = new DoubleVariable(result);
            } else {
                dv.setValue(result);
            }
            engine.defineVariable(variableName, dv);
            return result;
        }
    }

    static class CompoundExpressionFunction
    implements IDoubleFunction {
        CompoundExpressionFunction() {
        }

        @Override
        public double evaluate(DoubleEvaluator engine, FunctionNode function) {
            double result = Double.NaN;
            int end = function.size();
            for (int i = 1; i < end; ++i) {
                result = engine.evaluateNode(function.getNode(i));
                LOGGER.debug((Object)result);
            }
            return result;
        }
    }

    static class LogFunction
    implements DoubleUnaryOperator,
    DoubleBinaryOperator {
        LogFunction() {
        }

        @Override
        public double applyAsDouble(double arg1) {
            return Math.log(arg1);
        }

        @Override
        public double applyAsDouble(double base, double z) {
            return Math.log(z) / Math.log(base);
        }
    }

    static class ArcTanFunction
    implements DoubleUnaryOperator,
    DoubleBinaryOperator {
        ArcTanFunction() {
        }

        @Override
        public double applyAsDouble(double arg1) {
            return Math.atan(arg1);
        }

        @Override
        public double applyAsDouble(double x, double y) {
            return Math.atan2(y, x);
        }
    }
}

