/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.client;

import java.util.List;
import java.util.Stack;
import org.matheclipse.parser.client.Characters;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.operator.Operator;

public abstract class Scanner {
    protected static final int TT_EOF = 0;
    protected static final int TT_ASSOCIATION_OPEN = 10;
    protected static final int TT_ASSOCIATION_CLOSE = 11;
    protected static final int TT_ARGUMENTS_OPEN = 12;
    protected static final int TT_ARGUMENTS_CLOSE = 13;
    protected static final int TT_PRECEDENCE_OPEN = 14;
    protected static final int TT_PRECEDENCE_CLOSE = 15;
    protected static final int TT_LIST_OPEN = 16;
    protected static final int TT_LIST_CLOSE = 17;
    protected static final int TT_PARTOPEN = 18;
    protected static final int TT_PARTCLOSE = 19;
    protected static final int TT_SPAN = 30;
    protected static final int TT_OPERATOR = 31;
    protected static final int TT_COMMA = 134;
    protected static final int TT_PERCENT = 135;
    protected static final int TT_STRING = 136;
    protected static final int TT_IDENTIFIER = 137;
    protected static final int TT_DIGIT = 138;
    protected static final int TT_SLOT = 140;
    protected static final int TT_SLOTSEQUENCE = 141;
    protected static final int TT_BLANK = 142;
    protected static final int TT_BLANK_BLANK = 143;
    protected static final int TT_BLANK_BLANK_BLANK = 144;
    protected static final int TT_BLANK_OPTIONAL = 145;
    protected static final int TT_BLANK_COLON = 146;
    protected static final int TT_DERIVATIVE = 147;
    protected static final int TT_NEWLINE = 150;
    private static final String string_a = "a";
    private static final String string_b = "b";
    private static final String string_c = "c";
    private static final String string_d = "d";
    private static final String string_e = "e";
    private static final String string_f = "f";
    private static final String string_g = "g";
    private static final String string_h = "h";
    private static final String string_i = "i";
    private static final String string_j = "j";
    private static final String string_k = "k";
    private static final String string_l = "l";
    private static final String string_m = "m";
    private static final String string_n = "n";
    private static final String string_o = "o";
    private static final String string_p = "p";
    private static final String string_q = "q";
    private static final String string_r = "r";
    private static final String string_s = "s";
    private static final String string_t = "t";
    private static final String string_u = "u";
    private static final String string_v = "v";
    private static final String string_w = "w";
    private static final String string_x = "x";
    private static final String string_y = "y";
    private static final String string_z = "z";
    private static final String string_A = "A";
    private static final String string_B = "B";
    private static final String string_C = "C";
    private static final String string_D = "D";
    private static final String string_E = "E";
    private static final String string_F = "F";
    private static final String string_G = "G";
    private static final String string_H = "H";
    private static final String string_I = "I";
    private static final String string_J = "J";
    private static final String string_K = "K";
    private static final String string_L = "L";
    private static final String string_M = "M";
    private static final String string_N = "N";
    private static final String string_O = "O";
    private static final String string_P = "P";
    private static final String string_Q = "Q";
    private static final String string_R = "R";
    private static final String string_S = "S";
    private static final String string_T = "T";
    private static final String string_U = "U";
    private static final String string_V = "V";
    private static final String string_W = "W";
    private static final String string_X = "X";
    private static final String string_Y = "Y";
    private static final String string_Z = "Z";
    private static final String var_a = "$a";
    private static final String var_b = "$b";
    private static final String var_c = "$c";
    private static final String var_d = "$d";
    private static final String var_e = "$e";
    private static final String var_f = "$f";
    private static final String var_g = "$g";
    private static final String var_h = "$h";
    private static final String var_i = "$i";
    private static final String var_j = "$j";
    private static final String var_k = "$k";
    private static final String var_l = "$l";
    private static final String var_m = "$m";
    private static final String var_n = "$n";
    private static final String var_o = "$o";
    private static final String var_p = "$p";
    private static final String var_q = "$q";
    private static final String var_r = "$r";
    private static final String var_s = "$s";
    private static final String var_t = "$t";
    private static final String var_u = "$u";
    private static final String var_v = "$v";
    private static final String var_w = "$w";
    private static final String var_x = "$x";
    private static final String var_y = "$y";
    private static final String var_z = "$z";
    protected char[] fInputString;
    protected int fRecursionDepth;
    protected char fCurrentChar;
    protected int fCurrentPosition;
    protected int fToken;
    protected String fOperatorString;
    protected List<Operator> fOperList;
    protected int fRowCounter;
    protected boolean fPackageMode = false;
    protected int fCurrentColumnStartPosition;
    protected final boolean fExplicitTimes;

    public static String balanceCode(CharSequence sourceCode) {
        char ch;
        Stack<Character> openBracketStack = new Stack<Character>();
        block11: for (int j = 0; j < sourceCode.length(); ++j) {
            ch = sourceCode.charAt(j);
            switch (ch) {
                case '(': 
                case '[': 
                case '{': {
                    openBracketStack.push(Character.valueOf(ch));
                    continue block11;
                }
                case '}': {
                    if (openBracketStack.isEmpty()) {
                        return null;
                    }
                    ch = ((Character)openBracketStack.pop()).charValue();
                    if (ch == '{') continue block11;
                    return null;
                }
                case ')': {
                    if (openBracketStack.isEmpty()) {
                        return null;
                    }
                    ch = ((Character)openBracketStack.pop()).charValue();
                    if (ch == '(') continue block11;
                    return null;
                }
                case ']': {
                    if (openBracketStack.isEmpty()) {
                        return null;
                    }
                    ch = ((Character)openBracketStack.pop()).charValue();
                    if (ch == '[') continue block11;
                    return null;
                }
            }
        }
        if (!openBracketStack.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            ch = '\u0000';
            while (!openBracketStack.isEmpty()) {
                ch = ((Character)openBracketStack.pop()).charValue();
                switch (ch) {
                    case '{': {
                        builder.append('}');
                        break;
                    }
                    case '(': {
                        builder.append(')');
                        break;
                    }
                    case '[': {
                        builder.append(']');
                    }
                }
            }
            return builder.toString();
        }
        return "";
    }

    public static String appendMissingBrackets(String sourceCode) {
        String balanceCode = Scanner.balanceCode(sourceCode);
        if (balanceCode != null && balanceCode.length() > 0) {
            return sourceCode + balanceCode;
        }
        return sourceCode;
    }

    public static int isBalancedCode(CharSequence sourceCode) {
        Stack<Character> openBracketStack = new Stack<Character>();
        int length = sourceCode.length();
        block8: for (int j = 0; j < length; ++j) {
            char ch = sourceCode.charAt(j);
            switch (ch) {
                case '(': 
                case '[': 
                case '{': {
                    openBracketStack.push(Character.valueOf(ch));
                    continue block8;
                }
                case '<': {
                    if (j >= length - 1 || sourceCode.charAt(j + 1) != '|') continue block8;
                    openBracketStack.push(Character.valueOf(ch));
                    continue block8;
                }
                case '}': {
                    if (openBracketStack.isEmpty()) {
                        return 1;
                    }
                    ch = ((Character)openBracketStack.pop()).charValue();
                    if (ch == '{') continue block8;
                    return 1;
                }
                case ')': {
                    if (openBracketStack.isEmpty()) {
                        return 1;
                    }
                    ch = ((Character)openBracketStack.pop()).charValue();
                    if (ch == '(') continue block8;
                    return 1;
                }
                case ']': {
                    if (openBracketStack.isEmpty()) {
                        return 1;
                    }
                    ch = ((Character)openBracketStack.pop()).charValue();
                    if (ch == '[') continue block8;
                    return 1;
                }
                case '|': {
                    if (j >= length - 1 || sourceCode.charAt(j + 1) != '>') continue block8;
                    if (openBracketStack.isEmpty()) {
                        return 1;
                    }
                    ch = ((Character)openBracketStack.pop()).charValue();
                    if (ch == '<') continue block8;
                    return 1;
                }
            }
        }
        if (!openBracketStack.isEmpty()) {
            return -1;
        }
        return 0;
    }

    protected Scanner(boolean packageMode, boolean explicitTimes) {
        this.fPackageMode = packageMode;
        this.fExplicitTimes = explicitTimes;
        this.initializeNullScanner();
    }

    protected final char charAtPosition() {
        return this.fInputString[this.fCurrentPosition];
    }

    protected static StringBuilder createPowersOf10(int nonNegativeExponent) {
        StringBuilder buf = new StringBuilder(nonNegativeExponent + 1);
        buf.append("1");
        for (int i = 0; i < nonNegativeExponent; ++i) {
            buf.append('0');
        }
        return buf;
    }

    protected void getChar() {
        if (this.isValidPosition()) {
            this.getNextChar();
            return;
        }
        this.fCurrentPosition = this.fInputString.length + 1;
        this.fCurrentChar = (char)32;
        this.fToken = 0;
    }

    private void getComment() {
        int startPosition = this.fCurrentPosition++;
        int level = 0;
        try {
            while (true) {
                if (this.charAtPosition() == '*' && this.fInputString[this.fCurrentPosition + 1] == ')') {
                    ++this.fCurrentPosition;
                    ++this.fCurrentPosition;
                    if (level != 0) {
                        --level;
                        continue;
                    }
                    break;
                }
                if (this.charAtPosition() == '(' && this.fInputString[this.fCurrentPosition + 1] == '*') {
                    ++this.fCurrentPosition;
                    ++this.fCurrentPosition;
                    ++level;
                    continue;
                }
                if (this.charAtPosition() == '\n') {
                    ++this.fRowCounter;
                    this.fCurrentColumnStartPosition = ++this.fCurrentPosition;
                    continue;
                }
                ++this.fCurrentPosition;
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.fCurrentPosition = startPosition;
            this.throwSyntaxError("Comment doesn't end with '*)' (open multiline comment)");
        }
    }

    private String getErrorLine() {
        if (this.fInputString.length < this.fCurrentPosition) {
            --this.fCurrentPosition;
        }
        int eol = this.fCurrentPosition;
        while (this.fInputString.length > eol) {
            this.fCurrentChar = this.fInputString[eol++];
            if (this.fCurrentChar != '\n') continue;
            --eol;
            break;
        }
        return new String(this.fInputString, this.fCurrentColumnStartPosition, eol - this.fCurrentColumnStartPosition);
    }

    protected String[] getIdentifier() {
        int length;
        int startPosition = this.fCurrentPosition - 1;
        this.getChar();
        if (this.fCurrentChar == '$') {
            this.getChar();
        }
        int contextIndex = -1;
        while (Characters.isSymjaIdentifierPart(this.fCurrentChar)) {
            if (this.fCurrentChar == '`') {
                contextIndex = this.fCurrentPosition - 1;
            }
            this.getChar();
        }
        while (Characters.isSymjaIdentifierPart(this.fCurrentChar)) {
            if (this.fCurrentChar == '`') {
                contextIndex = this.fCurrentPosition - 1;
            }
            this.getChar();
        }
        String context = "";
        if (contextIndex > 0) {
            context = new String(this.fInputString, startPosition, contextIndex - startPosition + 1);
            startPosition = contextIndex + 1;
        }
        int endPosition = this.fCurrentPosition--;
        if ((length = --endPosition - startPosition) == 1) {
            String name = this.optimizedCurrentTokenSource1(startPosition);
            if (name == null && (name = Characters.CharacterNamesMap.get(String.valueOf(this.fInputString[startPosition]))) != null) {
                return new String[]{name, context};
            }
            return new String[]{new String(this.fInputString, startPosition, 1), context};
        }
        if (length == 2 && this.fInputString[startPosition] == '$') {
            return new String[]{this.optimizedCurrentTokenSource2(startPosition), context};
        }
        return new String[]{new String(this.fInputString, startPosition, endPosition - startPosition), context};
    }

    protected int getJavaInt() throws SyntaxError {
        String number = this.getIntegerString();
        int intValue = 0;
        try {
            intValue = Integer.parseInt(number, 10);
        }
        catch (NumberFormatException e) {
            this.throwSyntaxError("Number format error (not an int type): " + number, number.length());
        }
        this.getNextToken();
        return intValue;
    }

    protected long getJavaLong() throws SyntaxError {
        String number = this.getIntegerString();
        long longValue = 0L;
        try {
            longValue = Long.parseLong(number, 10);
        }
        catch (NumberFormatException e) {
            this.throwSyntaxError("Number format error (not an int type): " + number, number.length());
        }
        this.getNextToken();
        return longValue;
    }

    protected String getIntegerString() {
        int startPosition = this.fCurrentPosition - 1;
        this.getChar();
        while (Character.isDigit(this.fCurrentChar)) {
            this.getChar();
        }
        int endPosition = this.fCurrentPosition--;
        return new String(this.fInputString, startPosition, --endPosition - startPosition);
    }

    private boolean getNextChar() {
        this.fCurrentChar = this.fInputString[this.fCurrentPosition++];
        if (this.fCurrentChar == '\\' && this.isValidPosition()) {
            char ch;
            if ((ch = this.fInputString[this.fCurrentPosition++]) == '\n') {
                ++this.fRowCounter;
                this.fCurrentColumnStartPosition = this.fCurrentPosition;
                if (this.isValidPosition()) {
                    this.fCurrentChar = this.fInputString[this.fCurrentPosition++];
                    return true;
                }
            } else if (ch == '\r' && this.isValidPosition() && (ch = this.fInputString[this.fCurrentPosition++]) == '\n') {
                ++this.fRowCounter;
                this.fCurrentColumnStartPosition = this.fCurrentPosition;
                if (this.isValidPosition()) {
                    this.fCurrentChar = this.fInputString[this.fCurrentPosition++];
                    return true;
                }
            }
        }
        return false;
    }

    protected void getNextToken() throws SyntaxError {
        while (this.isValidPosition()) {
            this.getNextChar();
            this.fToken = 0;
            if (this.fCurrentChar == '\t' || this.fCurrentChar == '\r' || this.fCurrentChar == ' ') continue;
            if (this.fCurrentChar == '\n') {
                ++this.fRowCounter;
                this.fCurrentColumnStartPosition = this.fCurrentPosition;
                if (!this.fPackageMode || this.fRecursionDepth != 0) continue;
                this.fToken = 150;
                return;
            }
            if (Characters.isSymjaIdentifierStart(this.fCurrentChar)) {
                this.fToken = 137;
                return;
            }
            if (Character.isDigit(this.fCurrentChar)) {
                this.fToken = 138;
                return;
            }
            if (this.fCurrentChar == '.' && Character.isDigit(this.charAtPosition())) {
                this.fToken = 138;
                return;
            }
            if (this.fCurrentChar == '(' && this.isValidPosition() && this.charAtPosition() == '*') {
                this.getComment();
                continue;
            }
            switch (this.fCurrentChar) {
                case '(': {
                    this.fToken = 14;
                    this.skipWhitespace();
                    break;
                }
                case ')': {
                    this.fToken = 15;
                    break;
                }
                case '{': {
                    this.fToken = 16;
                    this.skipWhitespace();
                    break;
                }
                case '}': {
                    this.fToken = 17;
                    break;
                }
                case '[': {
                    this.fToken = 12;
                    this.skipWhitespace();
                    if (!this.isValidPosition() || this.charAtPosition() != '[') break;
                    ++this.fCurrentPosition;
                    this.fToken = 18;
                    break;
                }
                case ']': {
                    this.fToken = 13;
                    break;
                }
                case '\u301a': {
                    this.fToken = 18;
                    break;
                }
                case '\u301b': {
                    this.fToken = 19;
                    break;
                }
                case '.': {
                    if (this.isValidPosition() && Character.isDigit(this.charAtPosition())) {
                        this.fToken = 138;
                        this.skipWhitespace();
                        break;
                    }
                    if (!this.isOperatorCharacters()) break;
                    this.fOperList = this.getOperator();
                    this.fToken = 31;
                    return;
                }
                case '<': {
                    if (this.isValidPosition() && this.charAtPosition() == '|') {
                        ++this.fCurrentPosition;
                        this.fToken = 10;
                        this.skipWhitespace();
                        break;
                    }
                    if (!this.isOperatorCharacters()) break;
                    this.fOperList = this.getOperator();
                    this.fToken = 31;
                    return;
                }
                case ':': {
                    if (!this.isOperatorCharacters()) break;
                    this.fOperList = this.getOperator();
                    this.fToken = 31;
                    return;
                }
                case ';': {
                    if (this.isValidPosition() && this.charAtPosition() == ';') {
                        ++this.fCurrentPosition;
                        this.fToken = 30;
                        break;
                    }
                    if (!this.isOperatorCharacters()) break;
                    this.fOperList = this.getOperator();
                    this.fToken = 31;
                    return;
                }
                case '|': {
                    if (this.isValidPosition() && this.charAtPosition() == '>') {
                        ++this.fCurrentPosition;
                        this.fToken = 11;
                        break;
                    }
                    if (!this.isOperatorCharacters()) break;
                    this.fOperList = this.getOperator();
                    this.fToken = 31;
                    return;
                }
                case ',': {
                    this.fToken = 134;
                    break;
                }
                case '_': {
                    this.fToken = 142;
                    if (!this.isValidPosition()) break;
                    if (this.charAtPosition() == '_') {
                        ++this.fCurrentPosition;
                        if (this.isValidPosition() && this.charAtPosition() == '_') {
                            ++this.fCurrentPosition;
                            this.fToken = 144;
                            break;
                        }
                        this.fToken = 143;
                        break;
                    }
                    if (this.charAtPosition() == '.') {
                        ++this.fCurrentPosition;
                        this.fToken = 145;
                        break;
                    }
                    if (this.charAtPosition() != ':') break;
                    ++this.fCurrentPosition;
                    if (!this.isValidPosition()) break;
                    if (this.charAtPosition() == '>') {
                        --this.fCurrentPosition;
                        break;
                    }
                    this.fToken = 146;
                    break;
                }
                case '\"': {
                    this.fToken = 136;
                    break;
                }
                case '\'': {
                    this.fToken = 147;
                    break;
                }
                case '%': {
                    this.fToken = 135;
                    break;
                }
                case '#': {
                    this.fToken = 140;
                    if (!this.isValidPosition() || this.charAtPosition() != '#') break;
                    ++this.fCurrentPosition;
                    this.fToken = 141;
                    break;
                }
                default: {
                    String str;
                    int codePoint;
                    String str2;
                    if (this.isOperatorCharacters()) {
                        this.fOperList = this.getOperator();
                        this.fToken = 31;
                        return;
                    }
                    if (Characters.CharacterNamesMap.containsKey(String.valueOf(this.fCurrentChar))) {
                        this.fToken = 137;
                        return;
                    }
                    if (this.isValidPosition() && (str2 = Characters.unicodePoint(codePoint = Character.codePointAt(this.fInputString, this.fCurrentPosition - 1))) != null) {
                        this.throwSyntaxError("unexpected (named unicode) character: '\\[" + str2 + "]'");
                    }
                    if ((str = Characters.unicodeName(this.fCurrentChar)) != null) {
                        this.throwSyntaxError("unexpected (named unicode) character: '\\[" + str + "]'");
                    }
                    this.throwSyntaxError("unexpected character: '" + this.fCurrentChar + "'");
                }
            }
            if (this.fToken == 0) {
                this.throwSyntaxError("token not found");
            }
            return;
        }
        this.fCurrentPosition = this.fInputString.length + 1;
        this.fCurrentChar = (char)32;
        this.fToken = 0;
    }

    protected Object[] getNumberString() {
        int indx;
        String numberStr;
        Object[] result = new Object[3];
        result[2] = "1";
        int numFormat = 10;
        int startPosition = this.fCurrentPosition - 1;
        char firstCh = this.fCurrentChar;
        boolean isFloatPointNumber = firstCh == '.';
        this.getChar();
        if (this.fExplicitTimes && firstCh == '0') {
            switch (this.fCurrentChar) {
                case 'b': {
                    numFormat = 2;
                    startPosition = this.fCurrentPosition;
                    this.getChar();
                    break;
                }
                case 'B': {
                    numFormat = 2;
                    startPosition = this.fCurrentPosition;
                    this.getChar();
                    break;
                }
                case 'o': {
                    numFormat = 8;
                    startPosition = this.fCurrentPosition;
                    this.getChar();
                    break;
                }
                case 'O': {
                    numFormat = 8;
                    startPosition = this.fCurrentPosition;
                    this.getChar();
                    break;
                }
                case 'x': {
                    numFormat = 16;
                    startPosition = this.fCurrentPosition;
                    this.getChar();
                    break;
                }
                case 'X': {
                    numFormat = 16;
                    startPosition = this.fCurrentPosition;
                    this.getChar();
                }
            }
        }
        boolean backslash = false;
        if (numFormat == 10) {
            char nextChar;
            while (Character.isDigit(this.fCurrentChar) || this.fCurrentChar == '.') {
                if (this.fCurrentChar == '.') {
                    if (isFloatPointNumber) break;
                    isFloatPointNumber = true;
                }
                if (this.isValidPosition()) {
                    if (!this.getNextChar()) continue;
                    backslash = true;
                    if (Character.isDigit(this.fCurrentChar) || this.fCurrentChar == '.') continue;
                    this.throwSyntaxError("error in number - unknown character after back-slash.");
                    continue;
                }
                this.fCurrentPosition = this.fInputString.length + 1;
                this.fCurrentChar = (char)32;
                this.fToken = 0;
            }
            if (isFloatPointNumber) {
                numFormat = -1;
            }
            if (numFormat == 10 && this.fCurrentChar == '^' && this.isValidPosition() && (nextChar = this.fInputString[this.fCurrentPosition]) == '^') {
                try {
                    numberStr = new String(this.fInputString, startPosition, this.fCurrentPosition - startPosition - 1);
                    if (backslash) {
                        numberStr = this.sanitizeBackslash(numberStr);
                    }
                    if ((numFormat = Integer.parseInt(numberStr)) <= 0 || numFormat > 36) {
                        this.throwSyntaxError("Base " + numFormat + "^^... is invalid. Only bases between 1 and 36 are allowed");
                    }
                    ++this.fCurrentPosition;
                    startPosition = this.fCurrentPosition;
                    boolean evaled = false;
                    this.getChar();
                    while (Character.isDigit(this.fCurrentChar) || this.fCurrentChar >= 'a' && this.fCurrentChar <= 'z' || this.fCurrentChar >= 'A' && this.fCurrentChar <= 'Z') {
                        evaled = true;
                        this.getChar();
                    }
                    if (evaled && numFormat > 0 && numFormat <= 36) {
                        int endPosition = this.fCurrentPosition--;
                        result[0] = new String(this.fInputString, startPosition, --endPosition - startPosition);
                        result[1] = numFormat;
                        return result;
                    }
                }
                catch (RuntimeException numberStr2) {
                    // empty catch block
                }
                this.throwSyntaxError("Base " + numFormat + "^^... is invalid. Only bases between 1 and 36 are allowed");
            }
            if (this.fCurrentChar == 'E' || this.fCurrentChar == 'e') {
                if (this.fExplicitTimes) {
                    numFormat = -1;
                    this.getChar();
                    if (this.fCurrentChar == '+' || this.fCurrentChar == '-') {
                        this.getChar();
                    }
                    while (Character.isDigit(this.fCurrentChar)) {
                        this.getChar();
                    }
                }
            } else if ((numFormat < 0 || numFormat == 10) && this.fCurrentChar == '*') {
                int lastPosition = this.fCurrentPosition;
                this.getChar();
                if (this.fCurrentChar == '^') {
                    this.getChar();
                    if (this.fCurrentChar == '+' || this.fCurrentChar == '-') {
                        this.getChar();
                    }
                    if (Character.isDigit(this.fCurrentChar)) {
                        do {
                            this.getChar();
                        } while (Character.isDigit(this.fCurrentChar));
                    } else {
                        this.fCurrentPosition = lastPosition;
                    }
                } else {
                    this.fCurrentPosition = lastPosition;
                }
            }
        } else if (numFormat == 16) {
            while (Character.isDigit(this.fCurrentChar) || this.fCurrentChar >= 'a' && this.fCurrentChar <= 'f' || this.fCurrentChar >= 'A' && this.fCurrentChar <= 'F') {
                this.getChar();
            }
        } else if (numFormat == 2) {
            while (this.fCurrentChar == '0' || this.fCurrentChar == '1') {
                this.getChar();
            }
        } else if (numFormat == 8) {
            while (this.fCurrentChar >= '0' && this.fCurrentChar <= '7') {
                this.getChar();
            }
        }
        int endPosition = this.fCurrentPosition--;
        numberStr = new String(this.fInputString, startPosition, --endPosition - startPosition);
        if (backslash) {
            numberStr = this.sanitizeBackslash(numberStr);
        }
        if (numFormat == 10 && (indx = numberStr.indexOf("*^")) > 0) {
            result[0] = numberStr.substring(0, indx);
            result[1] = numFormat;
            result[2] = numberStr.substring(indx + 2);
            return result;
        }
        result[0] = numberStr;
        result[1] = numFormat;
        return result;
    }

    private String sanitizeBackslash(String numberStr) {
        StringBuilder buf = new StringBuilder(numberStr.length() - 2);
        for (int i = 0; i < numberStr.length(); ++i) {
            char ch = numberStr.charAt(i);
            if (ch == '\\' || ch == '\r' || ch == '\n') continue;
            buf.append(ch);
        }
        numberStr = buf.toString();
        return numberStr;
    }

    protected abstract List<Operator> getOperator();

    protected StringBuilder getStringBuilder() throws SyntaxError {
        StringBuilder ident = new StringBuilder();
        if (this.isValidPosition()) {
            this.fCurrentChar = this.fInputString[this.fCurrentPosition++];
        } else {
            this.throwSyntaxError("string - end of string not reached.");
        }
        if (this.fCurrentChar == '\n' || this.fToken == 0) {
            this.throwSyntaxError("string -" + ident.toString() + "- contains no character.");
        }
        block9: while (this.fCurrentChar != '\"' && this.isValidPosition()) {
            if (this.fCurrentChar == '\\') {
                if (this.isValidPosition()) {
                    this.fCurrentChar = this.fInputString[this.fCurrentPosition++];
                    switch (this.fCurrentChar) {
                        case '\\': {
                            ident.append(this.fCurrentChar);
                            break;
                        }
                        case 'n': {
                            ident.append('\n');
                            break;
                        }
                        case 'r': {
                            ident.append('\r');
                            break;
                        }
                        case 't': {
                            ident.append('\t');
                            break;
                        }
                        case '\"': {
                            ident.append('\"');
                            break;
                        }
                        case '\n': {
                            ++this.fRowCounter;
                            this.fCurrentColumnStartPosition = this.fCurrentPosition;
                            continue block9;
                        }
                        case '\r': {
                            if (this.isValidPosition() && this.fInputString[this.fCurrentPosition] == '\n') continue block9;
                            this.throwSyntaxError("string - unknown character after back-slash.");
                        }
                    }
                } else {
                    this.throwSyntaxError("string - unknown character after back-slash.");
                }
                if (this.isValidPosition()) {
                    this.fCurrentChar = this.fInputString[this.fCurrentPosition++];
                    continue;
                }
                this.throwSyntaxError("string - end of string not reached.");
                continue;
            }
            if (this.fToken == 0) {
                this.throwSyntaxError("string -" + ident.toString() + "- not closed.");
            }
            ident.append(this.fCurrentChar);
            if (this.fCurrentChar == '\n') {
                ++this.fRowCounter;
                this.fCurrentColumnStartPosition = this.fCurrentPosition;
            }
            if (this.isValidPosition()) {
                this.fCurrentChar = this.fInputString[this.fCurrentPosition++];
                continue;
            }
            this.throwSyntaxError("string - end of string not reached.");
        }
        return ident;
    }

    protected void initialize(String s) throws SyntaxError {
        this.initializeNullScanner();
        this.fInputString = Characters.substituteCharacters(s).toCharArray();
        this.getNextToken();
    }

    private void initializeNullScanner() {
        this.fInputString = null;
        this.fToken = 0;
        this.fCurrentPosition = 0;
        this.fRowCounter = 0;
        this.fCurrentColumnStartPosition = 0;
        this.fRecursionDepth = 0;
    }

    protected abstract boolean isOperatorCharacters();

    protected abstract boolean isOperatorCharacters(char var1);

    public static boolean isIdentifier(String ident) {
        if (ident.length() == 0) {
            return false;
        }
        char ch = ident.charAt(0);
        if (Character.isJavaIdentifierStart(ch) && ch != '_' || ch == '$') {
            for (int i = 1; i < ident.length(); ++i) {
                ch = ident.charAt(i);
                if (Character.isJavaIdentifierPart(ch) && ch != '_' || ch == '$' || ch == '`') continue;
                return false;
            }
        }
        return true;
    }

    protected static final boolean isComparatorOperator(String operatorString) {
        return operatorString.equals("==") || operatorString.equals("!=") || operatorString.equals(">") || operatorString.equals(">=") || operatorString.equals("<") || operatorString.equals("<=");
    }

    protected boolean isValidPosition() {
        return this.fInputString.length > this.fCurrentPosition;
    }

    protected boolean isWhitespace() {
        if (this.isValidPosition()) {
            return Character.isWhitespace(this.charAtPosition());
        }
        return false;
    }

    protected void skipWhitespace() {
        if (this.isValidPosition()) {
            char ch = this.charAtPosition();
            if (!Character.isWhitespace(ch)) {
                return;
            }
            ++this.fCurrentPosition;
            if (ch == '\n') {
                ++this.fRowCounter;
                this.fCurrentColumnStartPosition = this.fCurrentPosition;
            }
        }
    }

    private final String optimizedCurrentTokenSource1(int startPosition) {
        switch (this.fInputString[startPosition]) {
            case 'a': {
                return string_a;
            }
            case 'b': {
                return string_b;
            }
            case 'c': {
                return string_c;
            }
            case 'd': {
                return string_d;
            }
            case 'e': {
                return string_e;
            }
            case 'f': {
                return string_f;
            }
            case 'g': {
                return string_g;
            }
            case 'h': {
                return string_h;
            }
            case 'i': {
                return string_i;
            }
            case 'j': {
                return string_j;
            }
            case 'k': {
                return string_k;
            }
            case 'l': {
                return string_l;
            }
            case 'm': {
                return string_m;
            }
            case 'n': {
                return string_n;
            }
            case 'o': {
                return string_o;
            }
            case 'p': {
                return string_p;
            }
            case 'q': {
                return string_q;
            }
            case 'r': {
                return string_r;
            }
            case 's': {
                return string_s;
            }
            case 't': {
                return string_t;
            }
            case 'u': {
                return string_u;
            }
            case 'v': {
                return string_v;
            }
            case 'w': {
                return string_w;
            }
            case 'x': {
                return string_x;
            }
            case 'y': {
                return string_y;
            }
            case 'z': {
                return string_z;
            }
            case 'A': {
                return string_A;
            }
            case 'B': {
                return string_B;
            }
            case 'C': {
                return string_C;
            }
            case 'D': {
                return string_D;
            }
            case 'E': {
                return string_E;
            }
            case 'F': {
                return string_F;
            }
            case 'G': {
                return string_G;
            }
            case 'H': {
                return string_H;
            }
            case 'I': {
                return string_I;
            }
            case 'J': {
                return string_J;
            }
            case 'K': {
                return string_K;
            }
            case 'L': {
                return string_L;
            }
            case 'M': {
                return string_M;
            }
            case 'N': {
                return string_N;
            }
            case 'O': {
                return string_O;
            }
            case 'P': {
                return string_P;
            }
            case 'Q': {
                return string_Q;
            }
            case 'R': {
                return string_R;
            }
            case 'S': {
                return string_S;
            }
            case 'T': {
                return string_T;
            }
            case 'U': {
                return string_U;
            }
            case 'V': {
                return string_V;
            }
            case 'W': {
                return string_W;
            }
            case 'X': {
                return string_X;
            }
            case 'Y': {
                return string_Y;
            }
            case 'Z': {
                return string_Z;
            }
        }
        return null;
    }

    private final String optimizedCurrentTokenSource2(int startPosition) {
        switch (this.fInputString[startPosition + 1]) {
            case 'a': {
                return var_a;
            }
            case 'b': {
                return var_b;
            }
            case 'c': {
                return var_c;
            }
            case 'd': {
                return var_d;
            }
            case 'e': {
                return var_e;
            }
            case 'f': {
                return var_f;
            }
            case 'g': {
                return var_g;
            }
            case 'h': {
                return var_h;
            }
            case 'i': {
                return var_i;
            }
            case 'j': {
                return var_j;
            }
            case 'k': {
                return var_k;
            }
            case 'l': {
                return var_l;
            }
            case 'm': {
                return var_m;
            }
            case 'n': {
                return var_n;
            }
            case 'o': {
                return var_o;
            }
            case 'p': {
                return var_p;
            }
            case 'q': {
                return var_q;
            }
            case 'r': {
                return var_r;
            }
            case 's': {
                return var_s;
            }
            case 't': {
                return var_t;
            }
            case 'u': {
                return var_u;
            }
            case 'v': {
                return var_v;
            }
            case 'w': {
                return var_w;
            }
            case 'x': {
                return var_x;
            }
            case 'y': {
                return var_y;
            }
            case 'z': {
                return var_z;
            }
        }
        return new String(this.fInputString, startPosition, 2);
    }

    public void throwSyntaxError(String error) throws SyntaxError {
        throw new SyntaxError(this.fCurrentPosition - 1, this.fRowCounter, this.fCurrentPosition - this.fCurrentColumnStartPosition, this.getErrorLine(), error, 1);
    }

    protected void throwSyntaxError(String error, int errorLength) throws SyntaxError {
        throw new SyntaxError(this.fCurrentPosition - errorLength, this.fRowCounter, this.fCurrentPosition - this.fCurrentColumnStartPosition, this.getErrorLine(), error, errorLength);
    }

    public String toString() {
        if (this.fInputString == null || this.fCurrentPosition < 0) {
            return "<undefined scanner>";
        }
        try {
            int eol = this.fCurrentPosition;
            while (this.fInputString.length > eol) {
                char ch;
                if ((ch = this.fInputString[eol++]) != '\n') continue;
                --eol;
                break;
            }
            String line = new String(this.fInputString, this.fCurrentColumnStartPosition, eol - this.fCurrentColumnStartPosition);
            StringBuilder buf = new StringBuilder(line.length() + 256);
            buf.append(line);
            buf.append("\n");
            int indx = this.fCurrentPosition - this.fCurrentColumnStartPosition;
            for (int i = 0; i < indx; ++i) {
                buf.append(' ');
            }
            buf.append("^(");
            buf.append(Scanner.tokenToString(this.fToken));
            buf.append("-");
            buf.append(this.fToken);
            buf.append(")\n");
            return buf.toString();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "<end-of-line>";
        }
    }

    private static String tokenToString(int token) {
        switch (token) {
            case 0: {
                return "TT_EOF";
            }
            case 10: {
                return "TT_ASSOCIATION_OPEN";
            }
            case 11: {
                return "TT_ASSOCIATION_CLOSE";
            }
            case 12: {
                return "TT_ARGUMENTS_OPEN";
            }
            case 13: {
                return "TT_ARGUMENTS_CLOSE";
            }
            case 14: {
                return "TT_PRECEDENCE_OPEN";
            }
            case 15: {
                return "TT_PRECEDENCE_CLOSE";
            }
            case 16: {
                return "TT_LIST_OPEN";
            }
            case 17: {
                return "TT_LIST_CLOSE";
            }
            case 18: {
                return "TT_PARTOPEN";
            }
            case 19: {
                return "TT_PARTCLOSE";
            }
            case 30: {
                return "TT_SPAN";
            }
            case 31: {
                return "TT_OPERATOR";
            }
            case 134: {
                return "TT_COMMA";
            }
            case 135: {
                return "TT_PERCENT";
            }
            case 136: {
                return "TT_STRING";
            }
            case 137: {
                return "TT_IDENTIFIER";
            }
            case 138: {
                return "TT_DIGIT";
            }
            case 140: {
                return "TT_SLOT";
            }
            case 141: {
                return "TT_SLOTSEQUENCE";
            }
            case 142: {
                return "TT_BLANK";
            }
            case 143: {
                return "TT_BLANK_BLANK";
            }
            case 144: {
                return "TT_BLANK_BLANK_BLANK";
            }
            case 145: {
                return "TT_BLANK_OPTIONAL";
            }
            case 146: {
                return "TT_BLANK_COLON";
            }
            case 147: {
                return "TT_DERIVATIVE";
            }
            case 150: {
                return "TT_NEWLINE";
            }
        }
        return "token undefined";
    }
}

