/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.client;

import java.util.ArrayList;
import java.util.List;
import org.matheclipse.parser.client.ParserConfig;
import org.matheclipse.parser.client.Scanner;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.ast.FunctionNode;
import org.matheclipse.parser.client.ast.INodeParserFactory;
import org.matheclipse.parser.client.ast.IntegerNode;
import org.matheclipse.parser.client.ast.NumberNode;
import org.matheclipse.parser.client.ast.SymbolNode;
import org.matheclipse.parser.client.operator.ASTNodeFactory;
import org.matheclipse.parser.client.operator.InfixOperator;
import org.matheclipse.parser.client.operator.Operator;
import org.matheclipse.parser.client.operator.PostfixOperator;
import org.matheclipse.parser.client.operator.PrefixOperator;

public class Parser
extends Scanner {
    public static final SymbolNode DERIVATIVE = new SymbolNode("Derivative");
    private final boolean fRelaxedSyntax;
    protected INodeParserFactory fFactory;
    private List<ASTNode> fNodeList = null;

    public Parser() {
        this(ASTNodeFactory.MMA_STYLE_FACTORY, false, false);
    }

    public Parser(boolean relaxedSyntax) {
        this(ASTNodeFactory.MMA_STYLE_FACTORY, relaxedSyntax);
    }

    public Parser(boolean relaxedSyntax, boolean packageMode) {
        this(ASTNodeFactory.MMA_STYLE_FACTORY, relaxedSyntax, packageMode);
    }

    public Parser(INodeParserFactory factory, boolean relaxedSyntax) {
        this(factory, relaxedSyntax, false);
    }

    public Parser(INodeParserFactory factory, boolean relaxedSyntax, boolean packageMode) {
        super(packageMode, ParserConfig.EXPLICIT_TIMES_OPERATOR);
        this.fRelaxedSyntax = relaxedSyntax;
        this.fFactory = factory;
        if (packageMode) {
            this.fNodeList = new ArrayList<ASTNode>(256);
        }
    }

    private InfixOperator determineBinaryOperator() {
        for (int i = 0; i < this.fOperList.size(); ++i) {
            Operator oper = (Operator)this.fOperList.get(i);
            if (!(oper instanceof InfixOperator)) continue;
            return (InfixOperator)oper;
        }
        return null;
    }

    private PostfixOperator determinePostfixOperator() {
        for (int i = 0; i < this.fOperList.size(); ++i) {
            Operator oper = (Operator)this.fOperList.get(i);
            if (!(oper instanceof PostfixOperator)) continue;
            return (PostfixOperator)oper;
        }
        return null;
    }

    private PrefixOperator determinePrefixOperator() {
        for (int i = 0; i < this.fOperList.size(); ++i) {
            Operator oper = (Operator)this.fOperList.get(i);
            if (!(oper instanceof PrefixOperator)) continue;
            return (PrefixOperator)oper;
        }
        return null;
    }

    private void getArguments(FunctionNode function) throws SyntaxError {
        block1: {
            do {
                function.add(this.parseExpression());
                if (this.fToken != 134) break block1;
                this.getNextToken();
            } while (this.fToken != 15 && this.fToken != 13);
            function.add(this.fFactory.createSymbol("Null"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ASTNode getFactor(int min_precedence) throws SyntaxError {
        ASTNode temp = null;
        switch (this.fToken) {
            case 137: {
                SymbolNode symbol = this.getSymbol();
                temp = this.fToken >= 142 && this.fToken <= 146 ? this.getBlankPatterns(symbol) : symbol;
                return this.parseArguments(temp);
            }
            case 14: {
                ++this.fRecursionDepth;
                try {
                    this.getNextToken();
                    temp = this.parseExpression();
                    if (this.fToken != 15) {
                        this.throwSyntaxError("')' expected.");
                    }
                }
                finally {
                    --this.fRecursionDepth;
                }
                this.getNextToken();
                if (this.fToken == 14 && !ParserConfig.EXPLICIT_TIMES_OPERATOR) {
                    Operator oper = this.fFactory.get("Times");
                    if (ParserConfig.DOMINANT_IMPLICIT_TIMES || oper.getPrecedence() >= min_precedence) {
                        return this.getTimesImplicit(temp);
                    }
                }
                if (this.fToken == 12) {
                    return this.getFunctionArguments(temp);
                }
                return temp;
            }
            case 16: {
                return this.parseArguments(this.getList());
            }
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: {
                return this.getBlanks(temp);
            }
            case 138: {
                return this.getNumber(false);
            }
            case 136: {
                ASTNode str = this.getString();
                return this.parseArguments(str);
            }
            case 135: {
                FunctionNode out = this.fFactory.createFunction(this.fFactory.createSymbol("Out"));
                int countPercent = 1;
                this.getNextToken();
                if (this.fToken == 138) {
                    countPercent = this.getJavaInt();
                    out.add(this.fFactory.createInteger(countPercent));
                    return out;
                }
                while (this.fToken == 135) {
                    ++countPercent;
                    this.getNextToken();
                }
                out.add(this.fFactory.createInteger(-countPercent));
                return this.parseArguments(out);
            }
            case 140: {
                this.getNextToken();
                FunctionNode slot = this.fFactory.createFunction(this.fFactory.createSymbol("Slot"));
                if (this.fToken == 138) {
                    slot.add(this.fFactory.createInteger(this.getJavaInt()));
                } else if (this.fToken == 137) {
                    slot.add(this.getSymbol());
                } else if (this.fToken == 136) {
                    slot.add(this.getString());
                } else {
                    slot.add(this.fFactory.createInteger(1));
                }
                return this.parseArguments(slot);
            }
            case 141: {
                this.getNextToken();
                FunctionNode slotSequencce = this.fFactory.createFunction(this.fFactory.createSymbol("SlotSequence"));
                if (this.fToken == 138) {
                    slotSequencce.add(this.getNumber(false));
                } else {
                    slotSequencce.add(this.fFactory.createInteger(1));
                }
                return this.parseArguments(slotSequencce);
            }
            case 10: {
                FunctionNode function = this.fFactory.createFunction(this.fFactory.createSymbol("List"));
                ++this.fRecursionDepth;
                try {
                    this.getNextToken();
                    if (this.fToken != 11) {
                        while (true) {
                            function.add(this.parseExpression());
                            if (this.fToken != 134) break;
                            this.getNextToken();
                        }
                        if (this.fToken != 11) {
                            this.throwSyntaxError("'|>' expected.");
                        }
                    }
                    FunctionNode assoc = this.fFactory.createFunction(this.fFactory.createSymbol("Association"));
                    assoc.add(function);
                    temp = assoc;
                    this.getNextToken();
                    if (this.fToken == 14 && !this.fExplicitTimes) {
                        Operator oper = this.fFactory.get("Times");
                        if (ParserConfig.DOMINANT_IMPLICIT_TIMES || oper.getPrecedence() >= min_precedence) {
                            ASTNode aSTNode = this.getTimesImplicit(temp);
                            return aSTNode;
                        }
                    }
                    if (this.fToken == 12) {
                        FunctionNode functionNode = this.getFunctionArguments(temp);
                        return functionNode;
                    }
                }
                finally {
                    --this.fRecursionDepth;
                }
                return temp;
            }
            case 15: {
                this.throwSyntaxError("Too much closing ) in factor.");
                break;
            }
            case 17: {
                this.throwSyntaxError("Too much closing } in factor.");
                break;
            }
            case 13: {
                this.throwSyntaxError("Too much closing ] in factor.");
                break;
            }
            case 11: {
                this.throwSyntaxError("Too much closing |> in factor.");
            }
        }
        this.throwSyntaxError("Error in factor at character: '" + this.fCurrentChar + "' (Token:" + this.fToken + " \\u" + Integer.toHexString(this.fCurrentChar | 0x10000).substring(1) + ")");
        return null;
    }

    private ASTNode getBlanks(ASTNode temp) {
        FunctionNode function;
        ASTNode defaultValue;
        SymbolNode check;
        if (this.fToken == 142) {
            if (this.isWhitespace()) {
                this.getNextToken();
                temp = this.fFactory.createPattern(null, null);
            } else {
                this.getNextToken();
                if (this.isSymbolIdentifier()) {
                    check = this.getSymbol();
                    temp = this.fFactory.createPattern(null, check);
                } else {
                    temp = this.fFactory.createPattern(null, null);
                }
            }
        } else if (this.fToken == 143) {
            if (this.isWhitespace()) {
                this.getNextToken();
                temp = this.fFactory.createPattern2(null, null);
            } else {
                this.getNextToken();
                if (this.isSymbolIdentifier()) {
                    check = this.getSymbol();
                    temp = this.fFactory.createPattern2(null, check);
                } else {
                    temp = this.fFactory.createPattern2(null, null);
                }
            }
        } else if (this.fToken == 144) {
            if (this.isWhitespace()) {
                this.getNextToken();
                temp = this.fFactory.createPattern3(null, null);
            } else {
                this.getNextToken();
                if (this.isSymbolIdentifier()) {
                    check = this.getSymbol();
                    temp = this.fFactory.createPattern3(null, check);
                } else {
                    temp = this.fFactory.createPattern3(null, null);
                }
            }
        } else if (this.fToken == 145) {
            if (this.isWhitespace()) {
                this.getNextToken();
                temp = this.fFactory.createPattern(null, null, true);
            } else {
                this.getNextToken();
                if (this.isSymbolIdentifier()) {
                    check = this.getSymbol();
                    temp = this.fFactory.createPattern(null, (ASTNode)check, true);
                } else {
                    temp = this.fFactory.createPattern(null, null, true);
                }
            }
        } else if (this.fToken == 146) {
            this.getNextToken();
            defaultValue = this.parseExpression();
            function = this.fFactory.createAST(this.fFactory.createSymbol("Optional"));
            function.add(this.fFactory.createPattern(null, null, false));
            function.add(defaultValue);
            temp = function;
        }
        if (this.fToken == 31 && this.fOperatorString.equals(":")) {
            this.getNextToken();
            defaultValue = this.parseExpression();
            function = this.fFactory.createAST(this.fFactory.createSymbol("Optional"));
            function.add(temp);
            function.add(defaultValue);
            temp = function;
        }
        return this.parseArguments(temp);
    }

    private ASTNode getBlankPatterns(SymbolNode symbol) {
        ASTNode defaultValue;
        SymbolNode check;
        ASTNode temp = null;
        if (this.fToken == 142) {
            if (this.isWhitespace()) {
                temp = this.fFactory.createPattern(symbol, null);
                this.getNextToken();
            } else {
                this.getNextToken();
                if (this.isSymbolIdentifier()) {
                    check = this.getSymbol();
                    temp = this.fFactory.createPattern(symbol, check);
                } else {
                    temp = this.fFactory.createPattern(symbol, null);
                }
            }
        } else if (this.fToken == 143) {
            if (this.isWhitespace()) {
                temp = this.fFactory.createPattern2(symbol, null);
                this.getNextToken();
            } else {
                this.getNextToken();
                if (this.isSymbolIdentifier()) {
                    check = this.getSymbol();
                    temp = this.fFactory.createPattern2(symbol, check);
                } else {
                    temp = this.fFactory.createPattern2(symbol, null);
                }
            }
        } else if (this.fToken == 144) {
            if (this.isWhitespace()) {
                temp = this.fFactory.createPattern3(symbol, null);
                this.getNextToken();
            } else {
                this.getNextToken();
                if (this.isSymbolIdentifier()) {
                    check = this.getSymbol();
                    temp = this.fFactory.createPattern3(symbol, check);
                } else {
                    temp = this.fFactory.createPattern3(symbol, null);
                }
            }
        } else if (this.fToken == 145) {
            if (this.isWhitespace()) {
                temp = this.fFactory.createPattern(symbol, null, true);
                this.getNextToken();
            } else {
                this.getNextToken();
                if (this.isSymbolIdentifier()) {
                    check = this.getSymbol();
                    temp = this.fFactory.createPattern(symbol, (ASTNode)check, true);
                } else {
                    temp = this.fFactory.createPattern(symbol, null, true);
                }
            }
        } else if (this.fToken == 146) {
            this.getNextToken();
            defaultValue = this.parseExpression();
            temp = this.fFactory.createFunction(this.fFactory.createSymbol("Optional"), this.fFactory.createPattern(symbol, null, false), defaultValue);
        }
        if (this.fToken == 31 && this.fOperatorString.equals(":")) {
            this.getNextToken();
            defaultValue = this.parseExpression();
            temp = this.fFactory.createFunction(this.fFactory.createSymbol("Optional"), temp, defaultValue);
        }
        return temp;
    }

    private boolean isSymbolIdentifier() {
        return this.fToken == 137 && this.fCurrentPosition < this.fInputString.length && this.fInputString[this.fCurrentPosition] != '_';
    }

    public INodeParserFactory getFactory() {
        return this.fFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionNode getFunction(ASTNode head) throws SyntaxError {
        FunctionNode function = this.fFactory.createAST(head);
        this.getNextToken();
        FunctionNode fun = this.functionNodeClosed(function);
        if (fun != null) {
            return fun;
        }
        ++this.fRecursionDepth;
        try {
            this.getArguments(function);
        }
        finally {
            --this.fRecursionDepth;
        }
        fun = this.functionNodeClosed(function);
        if (fun != null) {
            return fun;
        }
        if (this.fRelaxedSyntax) {
            this.throwSyntaxError("')' expected.");
        } else {
            this.throwSyntaxError("']' expected.");
        }
        return null;
    }

    private FunctionNode functionNodeClosed(FunctionNode function) {
        if (this.fRelaxedSyntax) {
            if (this.fToken == 15) {
                this.getNextToken();
                if (this.fToken == 14) {
                    return function;
                }
                if (this.fToken == 12) {
                    return this.getFunctionArguments(function);
                }
                return function;
            }
        } else if (this.fToken == 13) {
            this.getNextToken();
            if (this.fToken == 12) {
                return this.getFunctionArguments(function);
            }
            return function;
        }
        return null;
    }

    FunctionNode getFunctionArguments(ASTNode head) throws SyntaxError {
        FunctionNode function = this.fFactory.createAST(head);
        ++this.fRecursionDepth;
        this.getNextToken();
        if (this.fToken == 13) {
            --this.fRecursionDepth;
            this.getNextToken();
            if (this.fToken == 12) {
                return this.getFunctionArguments(function);
            }
            return function;
        }
        this.getArguments(function);
        --this.fRecursionDepth;
        if (this.fToken == 13) {
            this.getNextToken();
            if (this.fToken == 12) {
                return this.getFunctionArguments(function);
            }
            return function;
        }
        this.throwSyntaxError("']' expected.");
        return null;
    }

    @Override
    protected boolean isOperatorCharacters() {
        return this.fFactory.isOperatorChar(this.fCurrentChar);
    }

    @Override
    protected boolean isOperatorCharacters(char ch) {
        return this.fFactory.isOperatorChar(ch);
    }

    @Override
    protected final List<Operator> getOperator() {
        int startPosition = this.fCurrentPosition - 1;
        this.fOperatorString = new String(this.fInputString, startPosition, this.fCurrentPosition - startPosition);
        List<Operator> list = this.fFactory.getOperatorList(this.fOperatorString);
        List<Operator> lastList = null;
        int lastOperatorPosition = -1;
        if (list != null) {
            lastList = list;
            lastOperatorPosition = this.fCurrentPosition;
        }
        this.getChar();
        while (!(!this.fFactory.isOperatorChar(this.fCurrentChar) || this.fCurrentChar == '.' && this.isValidPosition() && Character.isDigit(this.charAtPosition()))) {
            char lastChar = this.fCurrentChar;
            this.fOperatorString = new String(this.fInputString, startPosition, this.fCurrentPosition - startPosition);
            list = this.fFactory.getOperatorList(this.fOperatorString);
            if (list != null) {
                lastList = list;
                lastOperatorPosition = this.fCurrentPosition;
            }
            this.getChar();
            if (lastChar != ';' || this.fCurrentChar == ';') continue;
        }
        if (lastOperatorPosition > 0) {
            this.fCurrentPosition = lastOperatorPosition;
            return lastList;
        }
        int endPosition = this.fCurrentPosition--;
        this.fCurrentPosition = startPosition;
        this.throwSyntaxError("Operator token not found: " + new String(this.fInputString, startPosition, endPosition - 1 - startPosition));
        return null;
    }

    private ASTNode getList() throws SyntaxError {
        FunctionNode function = this.fFactory.createFunction(this.fFactory.createSymbol("List"));
        ++this.fRecursionDepth;
        this.getNextToken();
        if (this.fToken == 17) {
            --this.fRecursionDepth;
            this.getNextToken();
            return function;
        }
        this.getArguments(function);
        --this.fRecursionDepth;
        if (this.fToken == 17) {
            this.getNextToken();
            return function;
        }
        this.throwSyntaxError("'}' expected.");
        return null;
    }

    private ASTNode getNumber(boolean negative) throws SyntaxError {
        ASTNode temp;
        block17: {
            temp = null;
            Object numberStr = "";
            try {
                Object[] result = this.getNumberString();
                numberStr = (String)result[0];
                int numFormat = (Integer)result[1];
                String exponentStr = (String)result[2];
                if (negative) {
                    numberStr = "-" + (String)numberStr;
                }
                if (numFormat < 0) {
                    if (this.fCurrentChar == '`' && this.isValidPosition()) {
                        ++this.fCurrentPosition;
                        if (this.isValidPosition() && this.fInputString[this.fCurrentPosition] == '*') {
                            ++this.fCurrentPosition;
                            if (this.isValidPosition() && this.fInputString[this.fCurrentPosition] == '^') {
                                this.fCurrentPosition += 2;
                                long exponent = this.getJavaLong();
                                return this.fFactory.createDouble((String)numberStr + "E" + exponent);
                            }
                        } else {
                            if (this.isValidPosition() && this.fInputString[this.fCurrentPosition] == '`') {
                                this.fCurrentPosition += 2;
                                long precision = this.getJavaLong();
                                if (precision < 16L) {
                                    precision = 16L;
                                }
                                return this.fFactory.createDouble((String)numberStr);
                            }
                            if (this.isValidPosition() && Character.isDigit(this.fInputString[this.fCurrentPosition])) {
                                ++this.fCurrentPosition;
                                long precision = this.getJavaLong();
                                if (precision < 16L) {
                                    precision = 16L;
                                }
                                return this.fFactory.createDouble((String)numberStr);
                            }
                            this.getNextToken();
                            return this.fFactory.createDouble((String)numberStr);
                        }
                        this.throwSyntaxError("Number format error: " + (String)numberStr, ((String)numberStr).length());
                    }
                    temp = this.fFactory.createDouble((String)numberStr);
                    break block17;
                }
                if (exponentStr == null || exponentStr.equals("1")) {
                    temp = this.fFactory.createInteger((String)numberStr, numFormat);
                    break block17;
                }
                if (numFormat == 10) {
                    try {
                        int exponent = Integer.parseInt(exponentStr, 10);
                        if (exponent < 0) {
                            exponent = -exponent;
                            StringBuilder buf = Parser.createPowersOf10(exponent);
                            temp = this.fFactory.createFunction(new SymbolNode("Times"), this.fFactory.createInteger((String)numberStr, numFormat), this.fFactory.createFunction(new SymbolNode("Power"), this.fFactory.createInteger(buf.toString(), numFormat), IntegerNode.CN1));
                            break block17;
                        }
                        StringBuilder buf = Parser.createPowersOf10(exponent);
                        temp = this.fFactory.createFunction(new SymbolNode("Times"), this.fFactory.createInteger((String)numberStr, numFormat), this.fFactory.createInteger(buf.toString(), numFormat));
                    }
                    catch (NumberFormatException e) {
                        this.throwSyntaxError("Number format error (not an int type): " + exponentStr, exponentStr.length());
                    }
                    break block17;
                }
                this.throwSyntaxError("Number format error: " + (String)numberStr, ((String)numberStr).length());
            }
            catch (SyntaxError e) {
                this.throwSyntaxError("Number format error: " + (String)numberStr, ((String)numberStr).length());
            }
        }
        this.getNextToken();
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ASTNode getPart(int min_precedence) throws SyntaxError {
        FunctionNode function = null;
        ASTNode temp = this.getFactor(min_precedence);
        if (this.fToken != 18) {
            return temp;
        }
        do {
            function = function == null ? this.fFactory.createFunction(this.fFactory.createSymbol("Part"), temp) : this.fFactory.createFunction(this.fFactory.createSymbol("Part"), function);
            ++this.fRecursionDepth;
            try {
                do {
                    this.getNextToken();
                    if (this.fToken == 13) {
                        this.skipWhitespace();
                        if (this.fInputString.length > this.fCurrentPosition && this.fInputString[this.fCurrentPosition] == ']') {
                            ++this.fCurrentPosition;
                            this.getNextToken();
                            FunctionNode functionNode = function;
                            return functionNode;
                        }
                    }
                    function.add(this.parseExpression());
                } while (this.fToken == 134);
                if (this.fToken == 13) {
                    this.skipWhitespace();
                    if (this.fInputString.length > this.fCurrentPosition && this.fInputString[this.fCurrentPosition] == ']') {
                        ++this.fCurrentPosition;
                        this.fToken = 19;
                    }
                }
                if (this.fToken != 19) {
                    this.throwSyntaxError("']]' expected.");
                }
            }
            finally {
                --this.fRecursionDepth;
            }
            this.getNextToken();
        } while (this.fToken == 18);
        return this.parseArguments(function);
    }

    private ASTNode getString() throws SyntaxError {
        StringBuilder ident = this.getStringBuilder();
        this.getNextToken();
        return this.fFactory.createString(ident);
    }

    private SymbolNode getSymbol() throws SyntaxError {
        String[] identifierContext = this.getIdentifier();
        if (!this.fFactory.isValidIdentifier(identifierContext[0])) {
            this.throwSyntaxError("Invalid identifier: " + identifierContext[0] + " detected.");
        }
        SymbolNode symbol = this.fFactory.createSymbol(identifierContext[0], identifierContext[1]);
        this.getNextToken();
        return symbol;
    }

    private ASTNode getTimesImplicit(ASTNode temp) throws SyntaxError {
        FunctionNode func = this.fFactory.createAST(new SymbolNode("Times"));
        func.add(temp);
        do {
            this.getNextToken();
            temp = this.parseExpression();
            func.add(temp);
            if (this.fToken != 15) {
                this.throwSyntaxError("')' expected.");
            }
            this.getNextToken();
        } while (this.fToken == 14);
        return func;
    }

    public ASTNode parse(String expression) throws SyntaxError {
        this.initialize(expression);
        if (this.fToken == 0) {
            return this.fFactory.createSymbol("Null");
        }
        ASTNode temp = this.parseExpression();
        if (this.fToken != 0) {
            if (this.fToken == 15) {
                this.throwSyntaxError("Too many closing ')'; End-of-file not reached.");
            }
            if (this.fToken == 17) {
                this.throwSyntaxError("Too many closing '}'; End-of-file not reached.");
            }
            if (this.fToken == 13) {
                this.throwSyntaxError("Too many closing ']'; End-of-file not reached.");
            }
            this.throwSyntaxError("End-of-file not reached.");
        }
        return temp;
    }

    private ASTNode parseArguments(ASTNode lhs) {
        if (this.fRelaxedSyntax) {
            if (this.fToken == 12) {
                lhs = this.getFunctionArguments(lhs);
            } else if (this.fToken == 14) {
                lhs = this.getFunction(lhs);
            }
        } else if (this.fToken == 12) {
            lhs = this.getFunctionArguments(lhs);
        }
        return lhs;
    }

    private ASTNode parseCompoundExpressionNull(InfixOperator infixOperator, ASTNode lhs) {
        if (infixOperator.isOperator(";")) {
            if (this.fToken == 0 || this.fToken == 13 || this.fToken == 17 || this.fToken == 15 || this.fToken == 134) {
                return infixOperator.createFunction(this.fFactory, lhs, this.fFactory.createSymbol("Null"));
            }
            if (this.fPackageMode && this.fRecursionDepth < 1) {
                return infixOperator.createFunction(this.fFactory, lhs, this.fFactory.createSymbol("Null"));
            }
        }
        return null;
    }

    private ASTNode parseExpression() {
        if (this.fToken == 30) {
            FunctionNode span = this.fFactory.createFunction(this.fFactory.createSymbol("Span"));
            span.add(this.fFactory.createInteger(1));
            this.getNextToken();
            if (this.fToken == 30) {
                span.add(this.fFactory.createSymbol("All"));
                this.getNextToken();
                if (this.fToken == 134 || this.fToken == 19 || this.fToken == 13 || this.fToken == 15) {
                    return span;
                }
            } else {
                InfixOperator infixOperator;
                if (this.fToken == 134 || this.fToken == 19 || this.fToken == 13 || this.fToken == 15) {
                    span.add(this.fFactory.createSymbol("All"));
                    return span;
                }
                if (this.fToken == 31 && (infixOperator = this.determineBinaryOperator()) != null && infixOperator.getOperatorString().equals(";")) {
                    span.add(this.fFactory.createSymbol("All"));
                    this.getNextToken();
                    ASTNode compoundExpressionNull = this.parseCompoundExpressionNull(infixOperator, span);
                    if (compoundExpressionNull != null) {
                        return compoundExpressionNull;
                    }
                    while (this.fToken == 150) {
                        this.getNextToken();
                    }
                    return this.parseInfixOperator(span, infixOperator);
                }
            }
            span.add(this.parseExpression(this.parsePrimary(0), 0));
            if (this.fToken == 30) {
                this.getNextToken();
                if (this.fToken == 134 || this.fToken == 19 || this.fToken == 13 || this.fToken == 15) {
                    return span;
                }
                span.add(this.parseExpression(this.parsePrimary(0), 0));
            }
            return span;
        }
        ASTNode temp = this.parseExpression(this.parsePrimary(0), 0);
        if (this.fToken == 30) {
            FunctionNode span = this.fFactory.createFunction(this.fFactory.createSymbol("Span"));
            span.add(temp);
            this.getNextToken();
            if (this.fToken == 30) {
                span.add(this.fFactory.createSymbol("All"));
                this.getNextToken();
                if (this.fToken == 134 || this.fToken == 19 || this.fToken == 13 || this.fToken == 15) {
                    return span;
                }
                if (this.fToken == 31) {
                    FunctionNode times = this.fFactory.createAST(new SymbolNode("Times"));
                    times.add(span);
                    span = this.fFactory.createFunction(this.fFactory.createSymbol("Span"));
                    span.add(this.fFactory.createInteger(1));
                    span.add(this.fFactory.createSymbol("All"));
                    times.add(span);
                    return this.parseExpression(times, 0);
                }
            } else {
                InfixOperator infixOperator;
                if (this.fToken == 134 || this.fToken == 19 || this.fToken == 13 || this.fToken == 15) {
                    span.add(this.fFactory.createSymbol("All"));
                    return span;
                }
                if (this.fToken == 31 && (infixOperator = this.determineBinaryOperator()) != null && infixOperator.getOperatorString().equals(";")) {
                    span.add(this.fFactory.createSymbol("All"));
                    this.getNextToken();
                    ASTNode compoundExpressionNull = this.parseCompoundExpressionNull(infixOperator, span);
                    if (compoundExpressionNull != null) {
                        return compoundExpressionNull;
                    }
                    while (this.fToken == 150) {
                        this.getNextToken();
                    }
                    return this.parseInfixOperator(span, infixOperator);
                }
            }
            if (this.fToken == 150 || this.fToken == 0) {
                span.add(new SymbolNode("All"));
                this.getNextToken();
            } else {
                span.add(this.parseExpression(this.parsePrimary(0), 0));
            }
            if (this.fToken == 30) {
                this.getNextToken();
                if (this.fToken == 134 || this.fToken == 19 || this.fToken == 13 || this.fToken == 15) {
                    return span;
                }
                span.add(this.parseExpression(this.parsePrimary(0), 0));
            }
            return span;
        }
        return temp;
    }

    private ASTNode parseExpression(ASTNode lhs, int min_precedence) {
        while (true) {
            if (this.fToken == 150) {
                return lhs;
            }
            if (this.fToken == 16 || this.fToken == 14 || this.fToken == 137 || this.fToken == 136 || this.fToken == 138 || this.fToken == 140 || this.fToken == 141) {
                if (ParserConfig.EXPLICIT_TIMES_OPERATOR) break;
                Operator oper = this.fFactory.get("Times");
                if (!ParserConfig.DOMINANT_IMPLICIT_TIMES && oper.getPrecedence() < min_precedence) break;
                ASTNode rhs = this.parseLookaheadOperator(oper.getPrecedence());
                lhs = this.fFactory.createFunction(this.fFactory.createSymbol(oper.getFunctionName()), lhs, rhs);
                continue;
            }
            if (this.fToken == 147) {
                lhs = this.parseDerivative(lhs);
            }
            if (this.fToken != 31) break;
            InfixOperator infixOperator = this.determineBinaryOperator();
            if (infixOperator != null) {
                if (infixOperator.getPrecedence() < min_precedence) break;
                this.getNextToken();
                ASTNode compoundExpressionNull = this.parseCompoundExpressionNull(infixOperator, lhs);
                if (compoundExpressionNull != null) {
                    return compoundExpressionNull;
                }
                while (this.fToken == 150) {
                    this.getNextToken();
                }
                lhs = this.parseInfixOperator(lhs, infixOperator);
                continue;
            }
            PostfixOperator postfixOperator = this.determinePostfixOperator();
            if (postfixOperator == null || postfixOperator.getPrecedence() < min_precedence) break;
            lhs = this.parsePostfixOperator(lhs, postfixOperator);
        }
        return lhs;
    }

    private final ASTNode parsePostfixOperator(ASTNode lhs, PostfixOperator postfixOperator) {
        this.getNextToken();
        lhs = postfixOperator.createFunction(this.fFactory, lhs);
        lhs = this.parseArguments(lhs);
        if (this.fToken == 12) {
            return this.getFunctionArguments(lhs);
        }
        return lhs;
    }

    private final ASTNode parseInfixOperator(ASTNode lhs, InfixOperator infixOperator) {
        ASTNode rhs = this.parseLookaheadOperator(infixOperator.getPrecedence());
        if ((lhs = infixOperator.createFunction(this.fFactory, lhs, rhs)) instanceof FunctionNode) {
            FunctionNode ast = (FunctionNode)lhs;
            String infixOperatorString = infixOperator.getOperatorString();
            if (Parser.isComparatorOperator(infixOperatorString)) {
                while (this.fToken == 31 && infixOperator.getGrouping() == 0 && Parser.isComparatorOperator(this.fOperatorString)) {
                    if (!infixOperator.isOperator(this.fOperatorString)) {
                        return this.parseInequality(ast, infixOperator);
                    }
                    this.getNextToken();
                    while (this.fToken == 150) {
                        this.getNextToken();
                    }
                    rhs = this.parseLookaheadOperator(infixOperator.getPrecedence());
                    ast.add(rhs);
                }
                return ast;
            }
            while (this.fToken == 31 && infixOperator.getGrouping() == 0 && infixOperatorString.equals(this.fOperatorString)) {
                this.getNextToken();
                if (";".equals(infixOperatorString) && (this.fToken == 0 || this.fToken == 13 || this.fToken == 17 || this.fToken == 15 || this.fToken == 134)) {
                    ((FunctionNode)lhs).add(this.fFactory.createSymbol("Null"));
                    break;
                }
                while (this.fToken == 150) {
                    this.getNextToken();
                }
                rhs = this.parseLookaheadOperator(infixOperator.getPrecedence());
                ast.add(rhs);
            }
            lhs = infixOperator.endFunction(this.fFactory, ast, this);
        } else if (this.fToken == 31 && infixOperator.getGrouping() == 0 && infixOperator.isOperator(this.fOperatorString)) {
            this.throwSyntaxError("Operator: '" + this.fOperatorString + "' not created properly (no grouping defined)");
        }
        return lhs;
    }

    private ASTNode parseInequality(FunctionNode ast, InfixOperator infixOperator) {
        SymbolNode head = (SymbolNode)ast.get(0);
        FunctionNode result = this.fFactory.createFunction(this.fFactory.createSymbol("Inequality"));
        for (int i = 1; i < ast.size(); ++i) {
            result.add(ast.get(i));
            result.add(head);
        }
        InfixOperator compareOperator = this.determineBinaryOperator();
        result.set(result.size() - 1, this.fFactory.createSymbol(compareOperator.getFunctionName()));
        this.getNextToken();
        while (this.fToken == 150) {
            this.getNextToken();
        }
        int precedence = infixOperator.getPrecedence();
        result.add(this.parseLookaheadOperator(precedence));
        while (this.fToken == 31 && Parser.isComparatorOperator(this.fOperatorString)) {
            compareOperator = this.determineBinaryOperator();
            result.add(this.fFactory.createSymbol(compareOperator.getFunctionName()));
            this.getNextToken();
            while (this.fToken == 150) {
                this.getNextToken();
            }
            result.add(this.parseLookaheadOperator(precedence));
        }
        return result;
    }

    private ASTNode parseLookaheadOperator(int min_precedence) {
        ASTNode rhs = this.parsePrimary(min_precedence);
        while (true) {
            int lookahead = this.fToken;
            if (this.fToken == 150) break;
            if (this.fToken == 16 || this.fToken == 14 || this.fToken == 137 || this.fToken == 136 || this.fToken == 138 || this.fToken == 140) {
                if (ParserConfig.EXPLICIT_TIMES_OPERATOR) break;
                InfixOperator timesOperator = (InfixOperator)this.fFactory.get("Times");
                if (ParserConfig.DOMINANT_IMPLICIT_TIMES || timesOperator.getPrecedence() > min_precedence) {
                    rhs = this.parseExpression(rhs, timesOperator.getPrecedence());
                    continue;
                }
                if (timesOperator.getPrecedence() != min_precedence || timesOperator.getGrouping() != 1) break;
                rhs = this.parseExpression(rhs, timesOperator.getPrecedence());
                continue;
            }
            if (this.fToken == 147) {
                rhs = this.parseDerivative(rhs);
            }
            if (lookahead != 31) break;
            InfixOperator infixOperator = this.determineBinaryOperator();
            if (infixOperator != null) {
                if (infixOperator.getPrecedence() <= min_precedence && (!this.fOperatorString.equals(":") || !(rhs instanceof SymbolNode)) && (infixOperator.getPrecedence() != min_precedence || infixOperator.getGrouping() != 1)) break;
                if (infixOperator.isOperator(";") && this.fPackageMode && this.fRecursionDepth < 1) {
                    return infixOperator.createFunction(this.fFactory, rhs, this.fFactory.createSymbol("Null"));
                }
                rhs = this.parseExpression(rhs, infixOperator.getPrecedence());
                continue;
            }
            PostfixOperator postfixOperator = this.determinePostfixOperator();
            if (postfixOperator == null || postfixOperator.getPrecedence() < min_precedence) break;
            rhs = this.parsePostfixOperator(rhs, postfixOperator);
        }
        if (this.fToken == 12) {
            rhs = this.parseArguments(rhs);
        }
        return rhs;
    }

    private ASTNode parseDerivative(ASTNode expr) {
        int derivativeCounter = 1;
        this.getNextToken();
        while (this.fToken == 147) {
            ++derivativeCounter;
            this.getNextToken();
        }
        FunctionNode head = this.fFactory.createFunction(DERIVATIVE, new IntegerNode(derivativeCounter));
        FunctionNode deriv = this.fFactory.unaryAST(head, expr);
        expr = this.parseArguments(deriv);
        return expr;
    }

    public List<ASTNode> parsePackage(String expression) throws SyntaxError {
        String input = expression.trim();
        this.initialize(input);
        if (this.fToken == 0) {
            return new ArrayList<ASTNode>(1);
        }
        while (this.fToken == 150) {
            this.getNextToken();
        }
        ASTNode temp = this.parseExpression();
        this.fNodeList.add(temp);
        while (this.fToken != 0) {
            if (this.fToken == 15) {
                this.throwSyntaxError("Too many closing ')'; End-of-file not reached.");
            }
            if (this.fToken == 17) {
                this.throwSyntaxError("Too many closing '}'; End-of-file not reached.");
            }
            if (this.fToken == 13) {
                this.throwSyntaxError("Too many closing ']'; End-of-file not reached.");
            }
            while (this.fToken == 150) {
                this.getNextToken();
            }
            if (this.fToken == 0) {
                return this.fNodeList;
            }
            temp = this.parseExpression();
            this.fNodeList.add(temp);
        }
        return this.fNodeList;
    }

    private ASTNode parsePrimary(int min_precedence) {
        if (this.fToken == 31) {
            if (".".equals(this.fOperatorString)) {
                this.fCurrentChar = (char)46;
                return this.getNumber(false);
            }
            PrefixOperator prefixOperator = this.determinePrefixOperator();
            if (prefixOperator != null) {
                return this.parsePrefixOperator(prefixOperator);
            }
            this.throwSyntaxError("Operator: " + this.fOperatorString + " is no prefix operator.");
        }
        return this.getPart(min_precedence);
    }

    private final ASTNode parsePrefixOperator(PrefixOperator prefixOperator) {
        this.getNextToken();
        ASTNode temp = this.parseLookaheadOperator(prefixOperator.getPrecedence());
        if ("PreMinus".equals(prefixOperator.getFunctionName()) && temp instanceof NumberNode) {
            ((NumberNode)temp).toggleSign();
            return temp;
        }
        return prefixOperator.createFunction(this.fFactory, temp);
    }

    public void setFactory(INodeParserFactory factory) {
        this.fFactory = factory;
    }
}

