/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.matheclipse.parser.client.eval.DoubleEvaluator;
import org.matheclipse.parser.client.math.MathException;

public class Console {
    private File fFile;

    public static void main(String[] args) {
        Console console = new Console();
        String expr = null;
        block2: while (true) {
            try {
                while (true) {
                    if ((expr = console.readString(System.out, ">> ")) == null) {
                        continue;
                    }
                    if (expr.length() >= 4 && expr.toLowerCase().substring(0, 4).equals("exit")) break block2;
                    if (expr.length() >= 6 && expr.toLowerCase().substring(0, 6).equals("double")) {
                        System.out.println("Double evaluation mode (switch to other mode with keyword 'complex')");
                        continue;
                    }
                    System.out.println(console.interpreter(expr));
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                continue;
            }
            break;
        }
    }

    public String interpreter(String strEval) {
        try {
            DoubleEvaluator engine = new DoubleEvaluator(true);
            double d = engine.evaluate(strEval);
            return Double.toString(d);
        }
        catch (MathException e) {
            System.err.println();
            System.err.println(e.getMessage());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return "";
    }

    public void printPrompt(PrintStream out, String prompt) {
        out.print(prompt);
        out.flush();
    }

    public String readString(PrintStream out) {
        StringBuffer input = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        boolean done = false;
        try {
            while (!done) {
                String s = in.readLine();
                if (s == null) continue;
                if (s.length() > 0 && s.charAt(s.length() - 1) != '\\') {
                    input.append(s);
                    done = true;
                    continue;
                }
                if (s.length() > 1) {
                    input.append(s.substring(0, s.length() - 1));
                    continue;
                }
                input.append(' ');
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return input.toString();
    }

    public String readString(PrintStream out, String prompt) {
        this.printPrompt(out, prompt);
        return this.readString(out);
    }

    public void setFile(File file) {
        this.fFile = file;
    }

    public File getFile() {
        return this.fFile;
    }
}

