/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.client;

import java.util.Map;
import org.matheclipse.parser.client.ParserConfig;
import org.matheclipse.parser.trie.TrieMatch;

public class Characters {
    public static Map<String, String> NamedCharactersMap = ParserConfig.TRIE_STRING2STRING_BUILDER.withMatch(TrieMatch.EXACT).build();
    private static Map<String, String> ReversedNamedCharactersMap = ParserConfig.TRIE_STRING2STRING_BUILDER.withMatch(TrieMatch.EXACT).build();
    public static Map<String, String> CharacterNamesMap = ParserConfig.TRIE_STRING2STRING_BUILDER.withMatch(TrieMatch.EXACT).build();
    private static final String[] NamedCharacters = new String[]{"AAcute", "\u00e1", "ABar", "\u0101", "ACup", "\u0103", "ADoubleDot", "\u00e4", "AE", "\u00e6", "AGrave", "\u00e0", "AHat", "\u00e2", "ARing", "\u00e5", "ATilde", "\u00e3", "Akuz", "\uf728", "Aleph", "\u2135", "AliasDelimiter", "\uf764", "AliasIndicator", "\uf768", "AlignmentMarker", "\uf760", "Alpha", "\u03b1", "AltKey", "\uf7d1", "And", "\u2227", "Andy", "\uf729", "Angle", "\u2220", "Angstrom", "\u212b", "AquariusSign", "\u2652", "AriesSign", "\u2648", "AscendingEllipsis", "\u22f0", "AutoLeftMatch", "\uf3a8", "AutoOperand", "\uf3ae", "AutoPlaceholder", "\uf3a4", "AutoRightMatch", "\uf3a9", "AutoSpace", "\uf3ad", "Backslash", "\u2216", "BeamedEighthNote", "\u266b", "BeamedSixteenthNote", "\u266c", "Because", "\u2235", "Bet", "\u2136", "Beta", "\u03b2", "BlackBishop", "\u265d", "BlackKing", "\u265a", "BlackKnight", "\u265e", "BlackPawn", "\u265f", "BlackQueen", "\u265b", "BlackRook", "\u265c", "Breve", "\u02d8", "Bullet", "\u2022", "CAcute", "\u0107", "CCedilla", "\u00e7", "CHacek", "\u010d", "COMPATIBILITYKanjiSpace", "\u3000", "COMPATIBILITYNoBreak", "\uf3a2", "CancerSign", "\u264b", "Cap", "\u2322", "CapitalAAcute", "\u00c1", "CapitalABar", "\u0100", "CapitalACup", "\u0102", "CapitalADoubleDot", "\u00c4", "CapitalAE", "\u00c6", "CapitalAGrave", "\u00c0", "CapitalAHat", "\u00c2", "CapitalARing", "\u00c5", "CapitalATilde", "\u00c3", "CapitalAlpha", "\u0391", "CapitalBeta", "\u0392", "CapitalCAcute", "\u0106", "CapitalCCedilla", "\u00c7", "CapitalCHacek", "\u010c", "CapitalChi", "\u03a7", "CapitalDHacek", "\u010e", "CapitalDelta", "\u0394", "CapitalDifferentialD", "\uf74b", "CapitalDigamma", "\u03dc", "CapitalEAcute", "\u00c9", "CapitalEBar", "\u0112", "CapitalECup", "\u0114", "CapitalEDoubleDot", "\u00cb", "CapitalEGrave", "\u00c8", "CapitalEHacek", "\u011a", "CapitalEHat", "\u00ca", "CapitalEpsilon", "\u0395", "CapitalEta", "\u0397", "CapitalEth", "\u00d0", "CapitalGamma", "\u0393", "CapitalIAcute", "\u00cd", "CapitalICup", "\u012c", "CapitalIDoubleDot", "\u00cf", "CapitalIGrave", "\u00cc", "CapitalIHat", "\u00ce", "CapitalIota", "\u0399", "CapitalKappa", "\u039a", "CapitalKoppa", "\u03de", "CapitalLSlash", "\u0141", "CapitalLambda", "\u039b", "CapitalMu", "\u039c", "CapitalNHacek", "\u0147", "CapitalNTilde", "\u00d1", "CapitalNu", "\u039d", "CapitalOAcute", "\u00d3", "CapitalODoubleAcute", "\u0150", "CapitalODoubleDot", "\u00d6", "CapitalOE", "\u0152", "CapitalOGrave", "\u00d2", "CapitalOHat", "\u00d4", "CapitalOSlash", "\u00d8", "CapitalOTilde", "\u00d5", "CapitalOmega", "\u03a9", "CapitalOmicron", "\u039f", "CapitalPhi", "\u03a6", "CapitalPi", "\u03a0", "CapitalPsi", "\u03a8", "CapitalRHacek", "\u0158", "CapitalRho", "\u03a1", "CapitalSHacek", "\u0160", "CapitalSampi", "\u03e0", "CapitalSigma", "\u03a3", "CapitalStigma", "\u03da", "CapitalTHacek", "\u0164", "CapitalTau", "\u03a4", "CapitalTheta", "\u0398", "CapitalThorn", "\u00de", "CapitalUAcute", "\u00da", "CapitalUDoubleAcute", "\u0170", "CapitalUDoubleDot", "\u00dc", "CapitalUGrave", "\u00d9", "CapitalUHat", "\u00db", "CapitalURing", "\u016e", "CapitalUpsilon", "\u03a5", "CapitalXi", "\u039e", "CapitalYAcute", "\u00dd", "CapitalZHacek", "\u017d", "CapitalZeta", "\u0396", "CapricornSign", "\u2651", "Cedilla", "\u00b8", "Cent", "\u00a2", "CenterDot", "\u00b7", "CenterEllipsis", "\u22ef", "CheckedBox", "\u2612", "Checkmark", "\u2713", "CheckedBox", "\u2612", "Chi", "\u03c7", "CircleDot", "\u2299", "CircleMinus", "\u2296", "CirclePlus", "\u2295", "CircleTimes", "\u2297", "ClockwiseContourIntegral", "\u2232", "CloseCurlyDoubleQuote", "\u201d", "CloseCurlyQuote", "\u2019", "CloverLeaf", "\u2318", "ClubSuit", "\u2663", "Colon", "\u2236", "CommandKey", "\uf76a", "Conditioned", "\uf3d3", "Congruent", "\u2261", "Conjugate", "\uf3c8", "ConjugateTranspose", "\uf3c9", "ConstantC", "\uf7da", "Continuation", "\uf3b1", "ContinuedFractionK", "\uf3d9", "ContourIntegral", "\u222e", "ControlKey", "\uf763", "Coproduct", "\u2210", "Copyright", "\u00a9", "CounterClockwiseContourIntegral", "\u2233", "Cross", "\uf4a0", "CubeRoot", "\u221b", "CupCap", "\u224d", "Cup", "\u2323", "Curl", "\uf3d8", "CurlyCapitalUpsilon", "\u03d2", "CurlyEpsilon", "\u03b5", "CurlyKappa", "\u03f0", "CurlyPhi", "\u03c6", "CurlyPi", "\u03d6", "CurlyRho", "\u03f1", "CurlyTheta", "\u03d1", "Currency", "\u00a4", "DHacek", "\u010f", "Dagger", "\u2020", "Dalet", "\u2138", "Dash", "\u2013", "Degree", "\u00b0", "Del", "\u2207", "DeleteKey", "\uf7d0", "Delta", "\u03b4", "DescendingEllipsis", "\u22f1", "Diameter", "\u2300", "Diamond", "\u22c4", "DiamondSuit", "\u2662", "DifferenceDelta", "\u2206", "DifferentialD", "\uf74c", "Digamma", "\u03dd", "DirectedEdge", "\uf3d5", "DiscreteRatio", "\uf4a4", "DiscreteShift", "\uf4a3", "DiscretionaryHyphen", "\u00ad", "DiscretionaryLineSeparator", "\uf76e", "DiscretionaryPageBreakAbove", "\uf3bf", "DiscretionaryPageBreakBelow", "\uf3c6", "DiscretionaryParagraphSeparator", "\uf76f", "Distributed", "\uf3d2", "Divergence", "\uf3d7", "Divide", "\u00f7", "Divides", "\u2223", "DivisionSlash", "\u2215", "DotEqual", "\u2250", "DotlessI", "\u0131", "DotlessJ", "\uf700", "DottedSquare", "\uf751", "DoubleContourIntegral", "\u222f", "DoubleDagger", "\u2021", "DoubleDot", "\u00a8", "DoubleDownArrow", "\u21d3", "DoubleLeftArrow", "\u21d0", "DoubleLeftRightArrow", "\u21d4", "DoubleLeftTee", "\u2ae4", "DoubleLongLeftArrow", "\u27f8", "DoubleLongLeftRightArrow", "\u27fa", "DoubleLongRightArrow", "\u27f9", "DoublePrime", "\u2033", "DoubleRightArrow", "\u21d2", "DoubleRightTee", "\u22a8", "DoubleStruckA", "\uf6e6", "DoubleStruckB", "\uf6e7", "DoubleStruckC", "\uf6e8", "DoubleStruckCapitalA", "\uf7a4", "DoubleStruckCapitalB", "\uf7a5", "DoubleStruckCapitalC", "\uf7a6", "DoubleStruckCapitalD", "\uf7a7", "DoubleStruckCapitalE", "\uf7a8", "DoubleStruckCapitalF", "\uf7a9", "DoubleStruckCapitalG", "\uf7aa", "DoubleStruckCapitalH", "\uf7ab", "DoubleStruckCapitalI", "\uf7ac", "DoubleStruckCapitalJ", "\uf7ad", "DoubleStruckCapitalK", "\uf7ae", "DoubleStruckCapitalL", "\uf7af", "DoubleStruckCapitalM", "\uf7b0", "DoubleStruckCapitalN", "\uf7b1", "DoubleStruckCapitalO", "\uf7b2", "DoubleStruckCapitalP", "\uf7b3", "DoubleStruckCapitalQ", "\uf7b4", "DoubleStruckCapitalR", "\uf7b5", "DoubleStruckCapitalS", "\uf7b6", "DoubleStruckCapitalT", "\uf7b7", "DoubleStruckCapitalU", "\uf7b8", "DoubleStruckCapitalV", "\uf7b9", "DoubleStruckCapitalW", "\uf7ba", "DoubleStruckCapitalX", "\uf7bb", "DoubleStruckCapitalY", "\uf7bc", "DoubleStruckCapitalZ", "\uf7bd", "DoubleStruckD", "\uf6e9", "DoubleStruckE", "\uf6ea", "DoubleStruckEight", "\uf7e3", "DoubleStruckF", "\uf6eb", "DoubleStruckFive", "\uf7e0", "DoubleStruckFour", "\uf7df", "DoubleStruckG", "\uf6ec", "DoubleStruckH", "\uf6ed", "DoubleStruckI", "\uf6ee", "DoubleStruckJ", "\uf6ef", "DoubleStruckK", "\uf6f0", "DoubleStruckL", "\uf6f1", "DoubleStruckM", "\uf6f2", "DoubleStruckN", "\uf6f3", "DoubleStruckNine", "\uf7e4", "DoubleStruckO", "\uf6f4", "DoubleStruckOne", "\uf7dc", "DoubleStruckP", "\uf6f5", "DoubleStruckQ", "\uf6f6", "DoubleStruckR", "\uf6f7", "DoubleStruckS", "\uf6f8", "DoubleStruckSeven", "\uf7e2", "DoubleStruckSix", "\uf7e1", "DoubleStruckT", "\uf6f9", "DoubleStruckThree", "\uf7de", "DoubleStruckTwo", "\uf7dd", "DoubleStruckU", "\uf6fa", "DoubleStruckV", "\uf6fb", "DoubleStruckW", "\uf6fc", "DoubleStruckX", "\uf6fd", "DoubleStruckY", "\uf6fe", "DoubleStruckZ", "\uf6ff", "DoubleStruckZero", "\uf7db", "DoubleUpArrow", "\u21d1", "DoubleUpDownArrow", "\u21d5", "DoubleVerticalBar", "\u2225", "DoubledGamma", "\uf74a", "DoubledPi", "\uf749", "DownArrow", "\u2193", "DownArrowBar", "\u2913", "DownArrowUpArrow", "\u21f5", "DownBreve", "\uf755", "DownExclamation", "\u00a1", "DownLeftRightVector", "\u2950", "DownLeftTeeVector", "\u295e", "DownLeftVector", "\u21bd", "DownLeftVectorBar", "\u2956", "DownPointer", "\u25be", "DownQuestion", "\u00bf", "DownRightTeeVector", "\u295f", "DownRightVector", "\u21c1", "DownRightVectorBar", "\u2957", "DownTee", "\u22a4", "DownTeeArrow", "\u21a7", "EAcute", "\u00e9", "EBar", "\u0113", "ECup", "\u0115", "EDoubleDot", "\u00eb", "EGrave", "\u00e8", "EHacek", "\u011b", "EHat", "\u00ea", "Earth", "\u2641", "EighthNote", "\u266a", "Element", "\u2208", "Ellipsis", "\u2026", "EmptyCircle", "\u25cb", "EmptyDiamond", "\u25c7", "EmptyDownTriangle", "\u25bd", "EmptyRectangle", "\u25af", "EmptySet", "\u2205", "EmptySmallCircle", "\u25e6", "EmptySmallSquare", "\u25fb", "EmptySquare", "\u25a1", "EmptyUpTriangle", "\u25b3", "EmptyVerySmallSquare", "\u25ab", "EnterKey", "\uf7d4", "EntityEnd", "\uf3b9", "EntityStart", "\uf3b8", "Epsilon", "\u03f5", "Equal", "\uf431", "EqualTilde", "\u2242", "Equilibrium", "\u21cc", "Equivalent", "\u29e6", "ErrorIndicator", "\uf767", "EscapeKey", "\uf769", "Eta", "\u03b7", "Eth", "\u00f0", "Euro", "\u20ac", "Exists", "\u2203", "ExpectationE", "\uf3dd", "ExponentialE", "\uf74d", "FiLigature", "\ufb01", "FilledCircle", "\u25cf", "FilledDiamond", "\u25c6", "FilledDownTriangle", "\u25bc", "FilledLeftTriangle", "\u25c0", "FilledRectangle", "\u25ae", "FilledRightTriangle", "\u25b6", "FilledSmallCircle", "\uf750", "FilledSmallSquare", "\u25fc", "FilledSquare", "\u25a0", "FilledUpTriangle", "\u25b2", "FilledVerySmallSquare", "\u25aa", "FinalSigma", "\u03c2", "FirstPage", "\uf7fa", "FivePointedStar", "\u2605", "FlLigature", "\ufb02", "Flat", "\u266d", "Florin", "\u0192", "ForAll", "\u2200", "FormalA", "\uf800", "FormalAlpha", "\uf854", "FormalB", "\uf801", "FormalBeta", "\uf855", "FormalC", "\uf802", "FormalCapitalA", "\uf81a", "FormalCapitalAlpha", "\uf834", "FormalCapitalB", "\uf81b", "FormalCapitalBeta", "\uf835", "FormalCapitalC", "\uf81c", "FormalCapitalChi", "\uf84a", "FormalCapitalD", "\uf81d", "FormalCapitalDelta", "\uf837", "FormalCapitalDigamma", "\uf87f", "FormalCapitalE", "\uf81e", "FormalCapitalEpsilon", "\uf838", "FormalCapitalEta", "\uf83a", "FormalCapitalF", "\uf81f", "FormalCapitalG", "\uf820", "FormalCapitalGamma", "\uf836", "FormalCapitalH", "\uf821", "FormalCapitalI", "\uf822", "FormalCapitalIota", "\uf83c", "FormalCapitalJ", "\uf823", "FormalCapitalK", "\uf824", "FormalCapitalKappa", "\uf83d", "FormalCapitalKoppa", "\uf881", "FormalCapitalL", "\uf825", "FormalCapitalLambda", "\uf83e", "FormalCapitalM", "\uf826", "FormalCapitalMu", "\uf83f", "FormalCapitalN", "\uf827", "FormalCapitalNu", "\uf840", "FormalCapitalO", "\uf828", "FormalCapitalOmega", "\uf84c", "FormalCapitalOmicron", "\uf842", "FormalCapitalP", "\uf829", "FormalCapitalPhi", "\uf849", "FormalCapitalPi", "\uf843", "FormalCapitalPsi", "\uf84b", "FormalCapitalQ", "\uf82a", "FormalCapitalR", "\uf82b", "FormalCapitalRho", "\uf844", "FormalCapitalS", "\uf82c", "FormalCapitalSampi", "\uf883", "FormalCapitalSigma,", "\uf846", "FormalCapitalStigma", "\uf87d", "FormalCapitalT", "\uf82d", "FormalCapitalTau", "\uf847", "FormalCapitalTheta", "\uf83b", "FormalCapitalU", "\uf82e", "FormalCapitalUpsilon", "\uf848", "FormalCapitalV", "\uf82f", "FormalCapitalW", "\uf830", "FormalCapitalX", "\uf831", "FormalCapitalXi", "\uf841", "FormalCapitalY", "\uf832", "FormalCapitalZ", "\uf833", "FormalCapitalZeta", "\uf839", "FormalChi", "\uf86a", "FormalCurlyCapitalUpsilon", "\uf875", "FormalCurlyEpsilon", "\uf858", "FormalCurlyKappa", "\uf885", "FormalCurlyPhi", "\uf869", "FormalCurlyPi", "\uf879", "FormalCurlyRho", "\uf886", "FormalCurlyTheta", "\uf874", "FormalD", "\uf803", "FormalDelta", "\uf857", "FormalDigamma", "\uf880", "FormalE", "\uf804", "FormalEpsilon", "\uf88a", "FormalEta", "\uf85a", "FormalF", "\uf805", "FormalFinalSigma", "\uf865", "FormalG", "\uf806", "FormalGamma", "\uf856", "FormalH", "\uf807", "FormalI", "\uf808", "FormalIota", "\uf85c", "FormalJ", "\uf809", "FormalK", "\uf80a", "FormalKappa", "\uf85d", "FormalKoppa", "\uf882", "FormalL", "\uf80b", "FormalLambda", "\uf85e", "FormalM", "\uf80c", "FormalMu", "\uf85f", "FormalN", "\uf80d", "FormalNu", "\uf860", "FormalO", "\uf80e", "FormalOmega", "\uf86c", "FormalOmicron", "\uf862", "FormalP", "\uf80f", "FormalPhi", "\uf878", "FormalPi", "\uf863", "FormalPsi", "\uf86b", "FormalQ", "\uf810", "FormalR", "\uf811", "FormalRho", "\uf864", "FormalS", "\uf812", "FormalSampi", "\uf884", "FormalSigma", "\uf866", "FormalStigma", "\uf87e", "FormalT", "\uf813", "FormalTau", "\uf867", "FormalTheta", "\uf85b", "FormalU", "\uf814", "FormalUpsilon", "\uf868", "FormalV", "\uf815", "FormalW", "\uf816", "FormalX", "\uf817", "FormalXi", "\uf861", "FormalY", "\uf818", "FormalZ", "\uf819", "FormalZeta", "\uf859", "FreakedSmiley", "\uf721", "FreeformPrompt", "\uf351", "Function", "\uf4a1", "Gamma", "\u03b3", "GeminiSign", "\u264a", "Gimel", "\u2137", "GothicA", "\uf6cc", "GothicB", "\uf6cd", "GothicC", "\uf6ce", "GothicCapitalA", "\uf78a", "GothicCapitalB", "\uf78b", "GothicCapitalC", "\u212d", "GothicCapitalD", "\uf78d", "GothicCapitalE", "\uf78e", "GothicCapitalF", "\uf78f", "GothicCapitalG", "\uf790", "GothicCapitalH", "\u210c", "GothicCapitalI", "\u2111", "GothicCapitalJ", "\uf793", "GothicCapitalK", "\uf794", "GothicCapitalL", "\uf795", "GothicCapitalM", "\uf796", "GothicCapitalN", "\uf797", "GothicCapitalO", "\uf798", "GothicCapitalP", "\uf799", "GothicCapitalQ", "\uf79a", "GothicCapitalR", "\u211c", "GothicCapitalS", "\uf79c", "GothicCapitalT", "\uf79d", "GothicCapitalU", "\uf79e", "GothicCapitalV", "\uf79f", "GothicCapitalW", "\uf7a0", "GothicCapitalX", "\uf7a1", "GothicCapitalY", "\uf7a2", "GothicCapitalZ", "\u2128", "GothicD", "\uf6cf", "GothicE", "\uf6d0", "GothicEight", "\uf7ed", "GothicF", "\uf6d1", "GothicFive", "\uf7ea", "GothicFour", "\uf7e9", "GothicG", "\uf6d2", "GothicH", "\uf6d3", "GothicI", "\uf6d4", "GothicJ", "\uf6d5", "GothicK", "\uf6d6", "GothicL", "\uf6d7", "GothicM", "\uf6d8", "GothicN", "\uf6d9", "GothicNine", "\uf7ef", "GothicO", "\uf6da", "GothicOne", "\uf7e6", "GothicP", "\uf6db", "GothicQ", "\uf6dc", "GothicR", "\uf6dd", "GothicS", "\uf6de", "GothicSeven", "\uf7ec", "GothicSix", "\uf7eb", "GothicT", "\uf6df", "GothicThree", "\uf7e8", "GothicTwo", "\uf7e7", "GothicU", "\uf6e0", "GothicV", "\uf6e1", "GothicW", "\uf6e2", "GothicX", "\uf6e3", "GothicY", "\uf6e4", "GothicZ", "\uf6e5", "GothicZero", "\uf7e5", "Gradient", "\uf3d6", "GrayCircle", "\uf753", "GraySquare", "\uf752", "GreaterEqual", "\u2265", "GreaterEqualLess", "\u22db", "GreaterFullEqual", "\u2267", "GreaterGreater", "\u226b", "GreaterLess", "\u2277", "GreaterSlantEqual", "\u2a7e", "GreaterTilde", "\u2273", "HBar", "\u210f", "Hacek", "\u02c7", "HappySmiley", "\u263a", "HeartSuit", "\u2661", "HermitianConjugate", "\uf3ce", "HorizontalLine", "\u2500", "HumpDownHump", "\u224e", "HumpEqual", "\u224f", "Hyphen", "\u2010", "IAcute", "\u00ed", "ICup", "\u012d", "IDoubleDot", "\u00ef", "IGrave", "\u00ec", "IHat", "\u00ee", "ImaginaryI", "\uf74e", "ImaginaryJ", "\uf74f", "ImplicitPlus", "\uf39e", "Implies", "\uf523", "IndentingNewLine", "\uf3a3", "Infinity", "\u221e", "InlinePart", "\uf51e", "Integral", "\u222b", "Intersection", "\u22c2", "InvisibleApplication", "\uf76d", "InvisibleComma", "\uf765", "InvisiblePostfixScriptBase", "\uf3b4", "InvisiblePrefixScriptBase", "\uf3b3", "InvisibleSpace", "\uf360", "InvisibleTimes", "\u2062", "Iota", "\u03b9", "Jupiter", "\u2643", "Kappa", "\u03ba", "KernelIcon", "\uf756", "KeyBar", "\uf7d3", "Koppa", "\u03df", "LSlash", "\u0142", "Lambda", "\u03bb", "Laplacian", "\u2206", "LastPage", "\uf7fb", "LeftAngleBracket", "\u2329", "LeftArrow", "\u2190", "LeftArrowBar", "\u21e4", "LeftArrowRightArrow", "\u21c6", "LeftAssociation", "\uf113", "LeftBracketingBar", "\uf603", "LeftCeiling", "\u2308", "LeftDoubleBracket", "\u301a", "LeftDoubleBracketingBar", "\uf605", "LeftDownTeeVector", "\u2961", "LeftDownVector", "\u21c3", "LeftDownVectorBar", "\u2959", "LeftFloor", "\u230a", "LeftGuillemet", "\u00ab", "LeftModified", "\uf76b", "LeftPointer", "\u25c2", "LeftRightArrow", "\u2194", "LeftRightVector", "\u294e", "LeftSkeleton", "\uf761", "LeftTee", "\u22a3", "LeftTeeArrow", "\u21a4", "LeftTeeVector", "\u295a", "LeftTriangle", "\u22b2", "LeftTriangleBar", "\u29cf", "LeftTriangleEqual", "\u22b4", "LeftUpDownVector", "\u2951", "LeftUpTeeVector", "\u2960", "LeftUpVector", "\u21bf", "LeftUpVectorBar", "\u2958", "LeftVector", "\u21bc", "LeftVectorBar", "\u2952", "LeoSign", "\u264c", "LessEqual", "\u2264", "LessEqualGreater", "\u22da", "LessFullEqual", "\u2266", "LessGreater", "\u2276", "LessLess", "\u226a", "LessSlantEqual", "\u2a7d", "LessTilde", "\u2272", "LetterSpace", "\uf754", "LibraSign", "\u264e", "LightBulb", "\uf723", "Limit", "\uf438", "LineSeparator", "\u2028", "LongDash", "\u2014", "LongEqual", "\uf7d9", "LongLeftArrow", "\u27f5", "LongLeftRightArrow", "\u27f7", "LongRightArrow", "\u27f6", "LowerLeftArrow", "\u2199", "LowerRightArrow", "\u2198", "Mars", "\u2642", "MathematicaIcon", "\uf757", "MaxLimit", "\uf439", "MeasuredAngle", "\u2221", "MediumSpace", "\u205f", "Mercury", "\u263f", "Mho", "\u2127", "Micro", "\u00b5", "MinLimit", "\uf43a", "Minus", "\u2212", "MinusPlus", "\u2213", "Mod1Key", "\uf7d6", "Mod2Key", "\uf7d7", "Moon", "\u263e", "Mu", "\u03bc", "NHacek", "\u0148", "NTilde", "\u00f1", "Nand", "\u22bc", "Natural", "\u266e", "NegativeMediumSpace", "\uf383", "NegativeThickSpace", "\uf384", "NegativeThinSpace", "\uf382", "NegativeVeryThinSpace", "\uf380", "Neptune", "\u2646", "NestedGreaterGreater", "\u2aa2", "NestedLessLess", "\u2aa1", "NeutralSmiley", "\uf722", "NewLine", "\n", "NoBreak", "\u2060", "NonBreakingSpace", "\u00a0", "Nor", "\u22bd", "Not", "\u00ac", "NotCongruent", "\u2262", "NotCupCap", "\u226d", "NotDoubleVerticalBar", "\u2226", "NotElement", "\u2209", "NotEqual", "\u2260", "NotEqualTilde", "\uf400", "NotExists", "\u2204", "NotGreater", "\u226f", "NotGreaterEqual", "\u2271", "NotGreaterFullEqual", "\u2269", "NotGreaterGreater", "\uf427", "NotGreaterLess", "\u2279", "NotGreaterSlantEqual", "\uf429", "NotGreaterTilde", "\u2275", "NotHumpDownHump", "\uf402", "NotHumpEqual", "\uf401", "NotLeftTriangle", "\u22ea", "NotLeftTriangleBar", "\uf412", "NotLeftTriangleEqual", "\u22ec", "NotLess", "\u226e", "NotLessEqual", "\u2270", "NotLessFullEqual", "\u2268", "NotLessGreater", "\u2278", "NotLessLess", "\uf422", "NotLessSlantEqual", "\uf424", "NotLessTilde", "\u2274", "NotNestedGreaterGreater", "\uf428", "NotNestedLessLess", "\uf423", "NotPrecedes", "\u2280", "NotPrecedesEqual", "\uf42b", "NotPrecedesSlantEqual", "\u22e0", "NotPrecedesTilde", "\u22e8", "NotReverseElement", "\u220c", "NotRightTriangle", "\u22eb", "NotRightTriangleBar", "\uf413", "NotRightTriangleEqual", "\u22ed", "NotSquareSubset", "\uf42e", "NotSquareSubsetEqual", "\u22e2", "NotSquareSuperset", "\uf42f", "NotSquareSupersetEqual", "\u22e3", "NotSubset", "\u2284", "NotSubsetEqual", "\u2288", "NotSucceeds", "\u2281", "NotSucceedsEqual", "\uf42d", "NotSucceedsSlantEqual", "\u22e1", "NotSucceedsTilde", "\u22e9", "NotSuperset", "\u2285", "NotSupersetEqual", "\u2289", "NotTilde", "\u2241", "NotTildeEqual", "\u2244", "NotTildeFullEqual", "\u2247", "NotTildeTilde", "\u2249", "NotVerticalBar", "\u2224", "Nu", "\u03bd", "Null", "\uf3a0", "NumberSign", "\uf724", "OAcute", "\u00f3", "ODoubleAcute", "\u0151", "ODoubleDot", "\u00f6", "OE", "\u0153", "OGrave", "\u00f2", "OHat", "\u00f4", "OSlash", "\u00f8", "OTilde", "\u00f5", "Omega", "\u03c9", "Omicron", "\u03bf", "OpenCurlyDoubleQuote", "\u201c", "OpenCurlyQuote", "\u2018", "OptionKey", "\uf7d2", "Or", "\u2228", "OverBrace", "\ufe37", "OverBracket", "\u23b4", "OverParenthesis", "\ufe35", "PageBreakAbove", "\uf3bd", "PageBreakBelow", "\uf3be", "Paragraph", "\u00b6", "ParagraphSeparator", "\u2029", "PartialD", "\u2202", "PermutationProduct", "\uf3de", "Perpendicular", "\u27c2", "Phi", "\u03d5", "Pi", "\u03c0", "Piecewise", "\uf361", "PiscesSign", "\u2653", "Placeholder", "\uf528", "PlusMinus", "\u00b1", "Pluto", "\u2647", "Precedes", "\u227a", "PrecedesEqual", "\u2aaf", "PrecedesSlantEqual", "\u227c", "PrecedesTilde", "\u227e", "Prime", "\u2032", "ProbabilityPr", "\uf3dc", "Product", "\u220f", "Proportion", "\u2237", "Proportional", "\u221d", "Psi", "\u03c8", "QuarterNote", "\u2669", "RHacek", "\u0159", "RawAmpersand", "&", "RawAt", "@", "RawBackquote", "`", "RawBackslash", "\\", "RawColon", ":", "RawComma", ",", "RawDash", "-", "RawDollar", "$", "RawDot", ".", "RawDoubleQuote", "\"", "RawEqual", "=", "RawEscape", "\u001b", "RawExclamation", "!", "RawGreater", ">", "RawLeftBrace", "{", "RawLeftBracket", "[", "RawLeftParenthesis", "(", "RawLess", "<", "RawNumberSign", "#", "RawPercent", "%", "RawPlus", "+", "RawQuestion", "?", "RawQuote", "'", "RawReturn", "\r", "RawRightBrace", "}", "RawRightBracket", "]", "RawRightParenthesis", ")", "RawSemicolon", ";", "RawSlash", "/", "RawSpace", " ", "RawStar", "*", "RawTab", "\t", "RawTilde", "~", "RawUnderscore", "_", "RawVerticalBar", "|", "RawWedge", "^", "RegisteredTrademark", "\u00ae", "ReturnIndicator", "\u21b5", "ReturnKey", "\uf766", "ReverseDoublePrime", "\u2036", "ReverseElement", "\u220b", "ReverseEquilibrium", "\u21cb", "ReversePrime", "\u2035", "ReverseUpEquilibrium", "\u296f", "Rho", "\u03c1", "RightAngle", "\u221f", "RightAngleBracket", "\u232a", "RightArrow", "\u2192", "RightArrowBar", "\u21e5", "RightArrowLeftArrow", "\u21c4", "RightBracketingBar", "\uf604", "RightCeiling", "\u2309", "RightDoubleBracket", "\u301b", "RightDoubleBracketingBar", "\uf606", "RightDownTeeVector", "\u295d", "RightDownVector", "\u21c2", "RightDownVectorBar", "\u2955", "RightFloor", "\u230b", "RightGuillemet", "\u00bb", "RightModified", "\uf76c", "RightPointer", "\u25b8", "RightSkeleton", "\uf762", "RightTee", "\u22a2", "RightTeeArrow", "\u21a6", "RightTeeVector", "\u295b", "RightTriangle", "\u22b3", "RightTriangleBar", "\u29d0", "RightTriangleEqual", "\u22b5", "RightUpDownVector", "\u294f", "RightUpTeeVector", "\u295c", "RightUpVector", "\u21be", "RightUpVectorBar", "\u2954", "RightVector", "\u21c0", "RightVectorBar", "\u2953", "RoundImplies", "\u2970", "RoundSpaceIndicator", "\uf3b2", "Rule", "\uf522", "RuleDelayed", "\uf51f", "SHacek", "\u0161", "SZ", "\u00df", "SadSmiley", "\u2639", "SagittariusSign", "\u2650", "Sampi", "\u03e0", "Saturn", "\u2644", "ScorpioSign", "\u264f", "ScriptA", "\uf6b2", "ScriptB", "\uf6b3", "ScriptC", "\uf6b4", "ScriptCapitalA", "\uf770", "ScriptCapitalB", "\u212c", "ScriptCapitalC", "\uf772", "ScriptCapitalD", "\uf773", "ScriptCapitalE", "\u2130", "ScriptCapitalF", "\u2131", "ScriptCapitalG", "\uf776", "ScriptCapitalH", "\u210b", "ScriptCapitalI", "\u2110", "ScriptCapitalJ", "\uf779", "ScriptCapitalK", "\uf77a", "ScriptCapitalL", "\u2112", "ScriptCapitalM", "\u2133", "ScriptCapitalN", new StringBuilder().appendCodePoint(119977).toString(), "ScriptCapitalO", "\uf77e", "ScriptCapitalP", "\u2118", "ScriptCapitalQ", "\uf780", "ScriptCapitalR", "\u211b", "ScriptCapitalS", "\uf782", "ScriptCapitalT", "\uf783", "ScriptCapitalU", "\uf784", "ScriptCapitalV", "\uf785", "ScriptCapitalW", "\uf786", "ScriptCapitalX", "\uf787", "ScriptCapitalY", "\uf788", "ScriptCapitalZ", "\uf789", "ScriptD", "\uf6b5", "ScriptDotlessI", "\uf730", "ScriptDotlessJ", "\uf731", "ScriptE", "\u212f", "ScriptEight", "\uf7f8", "ScriptF", "\uf6b7", "ScriptFive", "\uf7f5", "ScriptFour", "\uf7f4", "ScriptG", "\u210a", "ScriptH", "\uf6b9", "ScriptI", "\uf6ba", "ScriptJ", "\uf6bb", "ScriptK", "\uf6bc", "ScriptL", "\u2113", "ScriptM", "\uf6be", "ScriptN", "\uf6bf", "ScriptNine", "\uf7f9", "ScriptO", "\u2134", "ScriptOne", "\uf7f1", "ScriptP", "\uf6c1", "ScriptQ", "\uf6c2", "ScriptR", "\uf6c3", "ScriptS", "\uf6c4", "ScriptSeven", "\uf7f7", "ScriptSix", "\uf7f6", "ScriptT", "\uf6c5", "ScriptThree", "\uf7f3", "ScriptTwo", "\uf7f2", "ScriptU", "\uf6c6", "ScriptV", "\uf6c7", "ScriptW", "\uf6c8", "ScriptX", "\uf6c9", "ScriptY", "\uf6ca", "ScriptZ", "\uf6cb", "ScriptZero", "\uf7f0", "Section", "\u00a7", "SelectionPlaceholder", "\uf527", "Shah", "\uf11d", "Sharp", "\u266f", "ShiftKey", "\uf7d5", "ShortDownArrow", "\uf52b", "ShortLeftArrow", "\uf526", "ShortRightArrow", "\uf525", "Sigma", "\u03c3", "SixPointedStar", "\u2736", "SkeletonIndicator", "\u2043", "SmallCircle", "\u2218", "SpaceIndicator", "\u2423", "SpaceKey", "\uf7bf", "SpadeSuit", "\u2660", "SpanFromAbove", "\uf3bb", "SpanFromBoth", "\uf3bc", "SpanFromLeft", "\uf3ba", "SphericalAngle", "\u2222", "Sqrt", "\u221a", "Square", "\uf520", "SquareIntersection", "\u2293", "SquareSubset", "\u228f", "SquareSubsetEqual", "\u2291", "SquareSuperset", "\u2290", "SquareSupersetEqual", "\u2292", "SquareUnion", "\u2294", "Star", "\u22c6", "StepperDown", "\uf3cd", "StepperLeft", "\uf3cb", "StepperRight", "\uf3ca", "StepperUp", "\uf3cc", "Sterling", "\u00a3", "Stigma", "\u03db", "Subset", "\u2282", "SubsetEqual", "\u2286", "Succeeds", "\u227b", "SucceedsEqual", "\u2ab0", "SucceedsSlantEqual", "\u227d", "SucceedsTilde", "\u227f", "SuchThat", "\u220d", "Sum", "\u2211", "Sun", "\u2609", "Superset", "\u2283", "SupersetEqual", "\u2287", "SystemEnterKey", "\uf75f", "SystemsModelDelay", "\uf3af", "THacek", "\u0165", "TabKey", "\uf7be", "Tau", "\u03c4", "TaurusSign", "\u2649", "TensorProduct", "\uf3da", "TensorWedge", "\uf3db", "Therefore", "\u2234", "Theta", "\u03b8", "ThickSpace", "\u2005", "ThinSpace", "\u2009", "Thorn", "\u00fe", "Tilde", "\u223c", "TildeEqual", "\u2243", "TildeFullEqual", "\u2245", "TildeTilde", "\u2248", "Times", "\u00d7", "Trademark", "\u2122", "Transpose", "\uf3c7", "TripleDot", "\uf758", "TwoWayRule", "\uf120", "UAcute", "\u00fa", "UDoubleAcute", "\u0171", "UDoubleDot", "\u00fc", "UGrave", "\u00f9", "UHat", "\u00fb", "URing", "\u016f", "UnderBrace", "\ufe38", "UnderBracket", "\u23b5", "UnderParenthesis", "\ufe36", "UndirectedEdge", "\uf3d4", "Union", "\u22c3", "UnionPlus", "\u228e", "UnknownGlyph", "\ufffd", "UpArrow", "\u2191", "UpArrowBar", "\u2912", "UpArrowDownArrow", "\u21c5", "UpDownArrow", "\u2195", "UpEquilibrium", "\u296e", "UpPointer", "\u25b4", "UpTee", "\u22a5", "UpTeeArrow", "\u21a5", "UpperLeftArrow", "\u2196", "UpperRightArrow", "\u2197", "Upsilon", "\u03c5", "Uranus", "\u2645", "VectorGreaterEqual", "\uf435", "VectorGreater", "\uf434", "VectorLessEqual", "\uf437", "VectorLess", "\uf436", "Vee", "\u22c1", "Venus", "\u2640", "VerticalBar", "\u2223", "VerticalEllipsis", "\u22ee", "VerticalLine", "\u2502", "VerticalSeparator", "\uf432", "VerticalTilde", "\u2240", "VeryThinSpace", "\u200a", "Villa", "\uf727", "VirgoSign", "\u264d", "WarningSign", "\uf725", "WatchIcon", "\u231a", "Wedge", "\u22c0", "WeierstrassP", "\u2118", "WhiteBishop", "\u2657", "WhiteKing", "\u2654", "WhiteKnight", "\u2658", "WhitePawn", "\u2659", "WhiteQueen", "\u2655", "WhiteRook", "\u2656", "Wolf", "\uf720", "WolframAlphaPrompt", "\uf352", "WolframLanguageLogoCircle", "\uf11f", "WolframLanguageLogo", "\uf11e", "Xi", "\u03be", "Xnor", "\uf4a2", "Xor", "\u22bb", "YAcute", "\u00fd", "YDoubleDot", "\u00ff", "Yen", "\u00a5", "ZHacek", "\u017e", "Zeta", "\u03b6"};

    public static void initialize() {
        Initializer.init();
    }

    public static String unicodeName(char unicode) {
        String str = String.valueOf(unicode);
        if (ReversedNamedCharactersMap.size() == 0) {
            for (int i = 0; i < NamedCharacters.length; i += 2) {
                ReversedNamedCharactersMap.put(NamedCharacters[i + 1], NamedCharacters[i]);
            }
        }
        return ReversedNamedCharactersMap.get(str);
    }

    public static String unicodePoint(int codePoint) {
        String str = new String(Character.toChars(codePoint));
        if (ReversedNamedCharactersMap.size() == 0) {
            for (int i = 0; i < NamedCharacters.length; i += 2) {
                ReversedNamedCharactersMap.put(NamedCharacters[i + 1], NamedCharacters[i]);
            }
        }
        return ReversedNamedCharactersMap.get(str);
    }

    public static String substituteCharacters(String str) {
        String subString;
        String namedCh;
        int endPosition;
        char currentChar;
        StringBuilder buf = null;
        int currentPosition = str.indexOf(92);
        if (currentPosition < 0) {
            return str;
        }
        int strLength = str.length();
        while (currentPosition < strLength) {
            int numberOfUnicodeDigits2;
            if ((currentChar = str.charAt(currentPosition++)) != '\\' || currentPosition >= strLength) continue;
            if (str.charAt(currentPosition) == '[') {
                int startPosition = currentPosition++ - 1;
                if (currentPosition >= strLength) break;
                currentChar = str.charAt(currentPosition++);
                while (Character.isLetterOrDigit(currentChar) && currentPosition < strLength) {
                    currentChar = str.charAt(currentPosition++);
                }
                endPosition = currentPosition;
                if (currentChar != ']' || (namedCh = NamedCharactersMap.get(subString = str.substring(startPosition + 2, endPosition - 1))) == null) continue;
                buf = new StringBuilder(str.length());
                buf.append(str.substring(0, startPosition));
                currentChar = namedCh.charAt(0);
                buf.append(currentChar);
                break;
            }
            if (str.charAt(currentPosition) == '.') {
                try {
                    numberOfUnicodeDigits2 = 2;
                    buf = new StringBuilder(str.length());
                    buf.append(str.substring(0, ++currentPosition - 2));
                    currentPosition = Characters.codePointToUTF16(str, currentPosition, 2, buf);
                }
                catch (NumberFormatException numberOfUnicodeDigits2) {}
                break;
            }
            if (str.charAt(currentPosition) == ':') {
                try {
                    numberOfUnicodeDigits2 = 4;
                    buf = new StringBuilder(str.length());
                    buf.append(str.substring(0, ++currentPosition - 2));
                    currentPosition = Characters.codePointToUTF16(str, currentPosition, 4, buf);
                }
                catch (NumberFormatException numberOfUnicodeDigits3) {}
                break;
            }
            if (str.charAt(currentPosition) == '|') {
                try {
                    numberOfUnicodeDigits2 = 6;
                    buf = new StringBuilder(str.length());
                    buf.append(str.substring(0, ++currentPosition - 2));
                    currentPosition = Characters.codePointToUTF16(str, currentPosition, 6, buf);
                    break;
                }
                catch (NumberFormatException numberOfUnicodeDigits4) {
                    continue;
                }
            }
            ++currentPosition;
        }
        if (buf == null) {
            return str;
        }
        while (currentPosition < strLength) {
            if ((currentChar = str.charAt(currentPosition++)) == '\\') {
                if (currentPosition < strLength) {
                    if (str.charAt(currentPosition) == '[') {
                        int startPosition = currentPosition++ - 1;
                        if (currentPosition >= strLength) break;
                        currentChar = str.charAt(currentPosition++);
                        while (Character.isLetterOrDigit(currentChar) && currentPosition < strLength) {
                            currentChar = str.charAt(currentPosition++);
                        }
                        endPosition = currentPosition;
                        if (currentChar == ']') {
                            subString = str.substring(startPosition + 2, endPosition - 1);
                            namedCh = NamedCharactersMap.get(subString);
                            if (namedCh != null) {
                                buf.append(namedCh);
                                continue;
                            }
                            buf.append("\\[");
                            buf.append(subString);
                            continue;
                        }
                        subString = str.substring(startPosition, endPosition - 1);
                        buf.append(subString);
                        continue;
                    }
                    if (str.charAt(currentPosition) == '.') {
                        try {
                            int numberOfUnicodeDigits = 2;
                            ++currentPosition;
                            currentPosition = Characters.codePointToUTF16(str, currentPosition, 2, buf);
                        }
                        catch (NumberFormatException numberOfUnicodeDigits) {}
                        continue;
                    }
                    if (str.charAt(currentPosition) == ':') {
                        try {
                            int numberOfUnicodeDigits = 4;
                            ++currentPosition;
                            currentPosition = Characters.codePointToUTF16(str, currentPosition, 4, buf);
                        }
                        catch (NumberFormatException numberOfUnicodeDigits) {}
                        continue;
                    }
                    if (str.charAt(currentPosition) == '|') {
                        try {
                            int numberOfUnicodeDigits = 6;
                            ++currentPosition;
                            currentPosition = Characters.codePointToUTF16(str, currentPosition, 6, buf);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    buf.append(currentChar);
                    continue;
                }
                buf.append(currentChar);
                continue;
            }
            buf.append(currentChar);
        }
        return buf.toString();
    }

    private static int codePointToUTF16(String str, int startPosition, int numberOfUnicodeDigits, StringBuilder buffer) throws NumberFormatException {
        if (startPosition + numberOfUnicodeDigits >= str.length()) {
            throw new NumberFormatException("Number length must be exactly: " + numberOfUnicodeDigits);
        }
        String number = str.substring(startPosition, startPosition + numberOfUnicodeDigits);
        int codePoint = Integer.parseInt(number, 16);
        buffer.append(Character.toChars(codePoint));
        return startPosition + numberOfUnicodeDigits;
    }

    public static boolean isSymjaIdentifierStart(char ch) {
        return Character.isJavaIdentifierStart(ch) && ch != '_' || ch >= '\uf800' && ch <= '\uf819';
    }

    public static boolean isSymjaIdentifierPart(char ch) {
        return Character.isJavaIdentifierPart(ch) && ch != '_' || ch == '`' || ch >= '\uf800' && ch <= '\uf819';
    }

    public static String mapWLUnicodeToEquivalent(String operatorString) {
        StringBuilder sb = null;
        for (int i = 0; i < operatorString.length(); ++i) {
            char ch = operatorString.charAt(i);
            int newCh = 0;
            if ('\u0fff' < ch) {
                if ('\uf74b' == ch) {
                    newCh = 8517;
                } else if ('\uf523' == ch) {
                    newCh = 8658;
                } else if ('\u29e6' == ch) {
                    newCh = 8660;
                }
                if (0 != newCh && sb == null) {
                    sb = new StringBuilder(operatorString.length());
                    if (i > 0) {
                        sb.append(operatorString.substring(0, i - 1));
                    }
                }
            }
            if (sb == null) continue;
            sb.append((char)(0 != newCh ? newCh : (int)ch));
        }
        return sb != null ? sb.toString() : operatorString;
    }

    static {
        Characters.initialize();
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            for (int i = 0; i < NamedCharacters.length; i += 2) {
                NamedCharactersMap.put(NamedCharacters[i], NamedCharacters[i + 1]);
            }
            CharacterNamesMap.put(NamedCharactersMap.get("Infinity"), "Infinity");
            CharacterNamesMap.put(NamedCharactersMap.get("ImaginaryI"), "I");
            CharacterNamesMap.put(NamedCharactersMap.get("ImaginaryJ"), "I");
            CharacterNamesMap.put(NamedCharactersMap.get("Pi"), "Pi");
            CharacterNamesMap.put(NamedCharactersMap.get("Degree"), "Degree");
        }
    }
}

