/*
 * Decompiled with CFR 0.152.
 */
package org.antora.maven;

import java.nio.file.Path;
import java.util.regex.Pattern;

public class Platform {
    private static final Pattern FRAGMENTED_COMMAND_LINE_ARGUMENT_RX = Pattern.compile("[ '\"]");
    private final boolean windows = System.getProperty("os.name").toLowerCase().contains("windows");

    public String npmPackageCommandName(String name) {
        return this.windows ? name + ".cmd" : name;
    }

    public String escapeCommandLineArgument(Path value) {
        return this.escapeCommandLineArgument(value.toString());
    }

    public String escapeCommandLineArgument(String value) {
        if (value.isEmpty()) {
            return "\"\"";
        }
        if (!FRAGMENTED_COMMAND_LINE_ARGUMENT_RX.matcher(value).find()) {
            return value;
        }
        String q = "\"";
        if (value.contains(q)) {
            q = "'";
            if (value.contains("'")) {
                q = "\"";
                value = value.replace("\"", "&quot;");
            } else if (this.windows) {
                value = value.replace("\"", "\"\"");
            }
        }
        return q + value + q;
    }
}

