/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.task.sdk.serialize.json.utils;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.tencent.cloud.task.sdk.common.exception.SerializeException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T> T readAsValue(byte[] jsonBytes, Class<T> tClass) {
        try {
            return (T)objectMapper.readValue(jsonBytes, tClass);
        }
        catch (IOException e) {
            LOG.error("json jackson deserialize error: " + new String(jsonBytes, Charset.forName("utf-8")));
            throw new SerializeException(e.getMessage(), (Throwable)e);
        }
    }

    public static <T> T readAsValue(String jsonString, Class<T> tClass) {
        try {
            return (T)objectMapper.readValue(jsonString, tClass);
        }
        catch (IOException e) {
            LOG.error("json jackson deserialize error: " + jsonString, (Throwable)e);
            throw new SerializeException(e.getMessage(), (Throwable)e);
        }
    }

    public static <T> List<T> readAsList(String jsonListContent, Class<T> tClass) {
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{tClass});
        try {
            return (List)objectMapper.readValue(jsonListContent, javaType);
        }
        catch (IOException e) {
            LOG.error("json jackson deserialize error: " + jsonListContent, (Throwable)e);
            throw new SerializeException(e.getMessage(), (Throwable)e);
        }
    }

    public static <T> List<T> readAsList(byte[] jsonBytes, Class<T> tClass) {
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{tClass});
        try {
            return (List)objectMapper.readValue(jsonBytes, javaType);
        }
        catch (IOException e) {
            LOG.error("json jackson deserialize error: " + new String(jsonBytes, Charset.forName("utf-8")), (Throwable)e);
            throw new SerializeException(e.getMessage(), (Throwable)e);
        }
    }

    public static <T> String writeAsString(T object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (Throwable t) {
            LOG.error("json jackson serialize error.");
            throw new SerializeException(t.getMessage(), t);
        }
    }

    public static <T> byte[] writeAsByteArray(T object) {
        try {
            return objectMapper.writeValueAsBytes(object);
        }
        catch (Throwable t) {
            LOG.error("json jackson serialize error.");
            throw new SerializeException(t.getMessage(), t);
        }
    }

    private static <K, V> Map<K, V> readAsMap(String jsonMapContent, Class<K> keyClass, Class<V> valueClass) {
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(Map.class, new Class[]{keyClass, valueClass});
        try {
            return (Map)objectMapper.readValue(jsonMapContent, javaType);
        }
        catch (IOException e) {
            LOG.error("json jackson deserialize error: {}", (Object)jsonMapContent);
            throw new SerializeException(e.getMessage(), (Throwable)e);
        }
    }

    private static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return objectMapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.setVisibility(objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN});
    }
}

