/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.task.sdk.serialize.json;

import com.tencent.cloud.task.sdk.common.exception.SerializeException;
import com.tencent.cloud.task.sdk.serialize.Serialization;
import com.tencent.cloud.task.sdk.serialize.json.utils.JacksonUtil;
import java.util.Collection;
import java.util.List;

public class JacksonSerialization
implements Serialization {
    public byte[] serialize(Object obj) {
        return JacksonUtil.writeAsByteArray(obj);
    }

    public <T> T deserialize(byte[] bytes, Class<T> clz) {
        return JacksonUtil.readAsValue(bytes, clz);
    }

    public byte[] serializeList(Collection<? extends List> data) {
        return JacksonUtil.writeAsByteArray(data);
    }

    public <T> List<T> deserializeList(byte[] data, Class<T> clz) {
        return JacksonUtil.readAsList(data, clz);
    }

    public byte[] serializeMulti(Object[] data) {
        throw new SerializeException("JacksonSerialization can not serializeMulti");
    }

    public Object[] deserializeMulti(byte[] data, Class<?>[] classes) {
        throw new SerializeException("JacksonSerialization can not deserializeMulti");
    }

    public byte getSerializationId() {
        return 2;
    }

    public String getContentType() {
        return "text/json";
    }
}

