/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mybatisflex.autotable;

import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.EnumValue;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.RelationManyToMany;
import com.mybatisflex.annotation.RelationManyToOne;
import com.mybatisflex.annotation.RelationOneToMany;
import com.mybatisflex.annotation.RelationOneToOne;
import com.mybatisflex.annotation.Table;
import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.table.DynamicTableProcessor;
import com.mybatisflex.core.table.TableManager;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.spring.boot.MybatisFlexProperties;
import com.tangzc.autotable.core.AutoTableOrmFrameAdapter;
import com.tangzc.mybatisflex.util.StringHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.ibatis.type.UnknownTypeHandler;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.StringUtils;

public class MybatisFlexAutoTableAdapter
implements AutoTableOrmFrameAdapter {
    private final MybatisFlexProperties mybatisFlexProperties;

    public MybatisFlexAutoTableAdapter(MybatisFlexProperties mybatisFlexProperties) {
        this.mybatisFlexProperties = mybatisFlexProperties;
    }

    public boolean isIgnoreField(Field field, Class<?> clazz) {
        Column tableField = (Column)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, Column.class);
        if (tableField != null && tableField.ignore()) {
            return true;
        }
        RelationOneToOne relationOneToOne = (RelationOneToOne)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, RelationOneToOne.class);
        if (relationOneToOne != null) {
            return true;
        }
        RelationOneToMany relationOneToMany = (RelationOneToMany)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, RelationOneToMany.class);
        if (relationOneToMany != null) {
            return true;
        }
        RelationManyToOne relationManyToOne = (RelationManyToOne)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, RelationManyToOne.class);
        if (relationManyToOne != null) {
            return true;
        }
        RelationManyToMany relationManyToMany = (RelationManyToMany)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, RelationManyToMany.class);
        return relationManyToMany != null;
    }

    public boolean isPrimary(Field field, Class<?> clazz) {
        if (AnnotatedElementUtils.hasMetaAnnotationTypes((AnnotatedElement)field, Id.class)) {
            return true;
        }
        return "id".equals(field.getName());
    }

    public boolean isAutoIncrement(Field field, Class<?> clazz) {
        if (!this.isPrimary(field, clazz)) {
            return false;
        }
        Id tableId = (Id)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, Id.class);
        if (tableId == null || tableId.keyType() == KeyType.None) {
            FlexGlobalConfig.KeyConfig keyConfig = FlexGlobalConfig.getDefaultConfig().getKeyConfig();
            return Optional.ofNullable(keyConfig).map(FlexGlobalConfig.KeyConfig::getKeyType).orElse(KeyType.None) == KeyType.Auto;
        }
        return tableId.keyType() == KeyType.Auto;
    }

    public Class<?> customFieldTypeHandler(Class<?> clazz, Field field) {
        if (field.getType().isEnum()) {
            return String.class;
        }
        Column column = (Column)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, Column.class);
        if (column != null && column.typeHandler() != UnknownTypeHandler.class) {
            return String.class;
        }
        return field.getType();
    }

    public List<String> getEnumValues(Class<?> enumClassType) {
        if (enumClassType.isEnum()) {
            List enumDbValueFields = ClassUtil.getAllFields(enumClassType, f -> f.getAnnotation(EnumValue.class) != null);
            if (!enumDbValueFields.isEmpty()) {
                Field valField = (Field)enumDbValueFields.get(0);
                valField.setAccessible(true);
                return Arrays.stream(enumClassType.getEnumConstants()).map(enumConstant -> {
                    try {
                        return valField.get(enumConstant);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }).map(Objects::toString).collect(Collectors.toList());
            }
            return Arrays.stream(enumClassType.getEnumConstants()).map(Object::toString).collect(Collectors.toList());
        }
        throw new IllegalArgumentException(String.format("Class: %s \u975e\u679a\u4e3e\u7c7b\u578b", enumClassType.getName()));
    }

    public List<Class<? extends Annotation>> scannerAnnotations() {
        return Collections.singletonList(Table.class);
    }

    public String getTableName(Class<?> clazz) {
        String tableName = null;
        Table table = (Table)AnnotatedElementUtils.findMergedAnnotation(clazz, Table.class);
        tableName = table != null && StringUtils.hasText((String)table.value()) ? table.value() : this.smartConvert(table, clazz.getSimpleName());
        DynamicTableProcessor dynamicTableProcessor = TableManager.getDynamicTableProcessor();
        if (dynamicTableProcessor != null) {
            tableName = dynamicTableProcessor.process(tableName);
        }
        return tableName;
    }

    public String getRealColumnName(Class<?> clazz, Field field) {
        Column column = (Column)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, Column.class);
        if (column != null && StringUtils.hasText((String)column.value()) && !column.ignore()) {
            return this.filterSpecialChar(column.value());
        }
        Table table = (Table)AnnotatedElementUtils.findMergedAnnotation(clazz, Table.class);
        return this.smartConvert(table, field.getName());
    }

    public String getTableComment(Class<?> clazz) {
        Table table = (Table)AnnotatedElementUtils.findMergedAnnotation(clazz, Table.class);
        if (table != null && StringUtils.hasText((String)table.comment())) {
            return table.comment();
        }
        return super.getTableComment(clazz);
    }

    public String getTableSchema(Class<?> clazz) {
        Table table = (Table)AnnotatedElementUtils.findMergedAnnotation(clazz, Table.class);
        if (table != null && StringUtils.hasText((String)table.schema())) {
            return table.schema();
        }
        return super.getTableSchema(clazz);
    }

    public String getColumnComment(Field field, Class<?> clazz) {
        Column column = (Column)AnnotatedElementUtils.findMergedAnnotation(clazz, Column.class);
        if (column != null && StringUtils.hasText((String)column.comment())) {
            return column.comment();
        }
        return super.getColumnComment(field, clazz);
    }

    private String filterSpecialChar(String name) {
        return name.replaceAll("`", "");
    }

    public String smartConvert(Table table, String column) {
        boolean camelToUnderline;
        if (table == null) {
            MybatisFlexProperties.CoreConfiguration configuration = this.mybatisFlexProperties.getConfiguration();
            camelToUnderline = Optional.ofNullable(configuration).map(MybatisFlexProperties.CoreConfiguration::getMapUnderscoreToCamelCase).orElse(true);
        } else {
            camelToUnderline = table.camelToUnderline();
        }
        if (camelToUnderline) {
            column = StringHelper.camelToUnderline((String)column);
        }
        return column;
    }
}

