/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.util;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartFuncType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObCollationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObColumn;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObjType;
import com.alipay.oceanbase.rpc.util.ObBytesString;
import com.alipay.oceanbase.rpc.util.hash.MurmurHash;
import com.alipay.oceanbase.rpc.util.hash.ObHashSortBin;
import com.alipay.oceanbase.rpc.util.hash.ObHashSortUtf8mb4;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.Date;

public class ObHashUtils {
    public static long varcharHash(Object varchar, ObCollationType collationType, long hashCode, ObPartFuncType partFuncType) {
        byte[] bytes;
        long seed = -4132994306676758123L;
        if (varchar instanceof String) {
            try {
                bytes = ((String)varchar).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Unsupported Encoding for Object = " + varchar, e);
            }
        } else if (varchar instanceof byte[]) {
            bytes = (byte[])varchar;
        } else if (varchar instanceof ObBytesString) {
            bytes = ((ObBytesString)varchar).bytes;
        } else {
            throw new IllegalArgumentException("varchar not supported , ObCollationType = " + (Object)((Object)collationType) + " Object =" + varchar);
        }
        switch (collationType) {
            case CS_TYPE_UTF8MB4_GENERAL_CI: {
                if (partFuncType == ObPartFuncType.KEY_V3 || partFuncType == ObPartFuncType.KEY_IMPLICIT_V2 || ObGlobal.obVsnMajor() >= 4) {
                    hashCode = ObHashSortUtf8mb4.obHashSortUtf8Mb4(bytes, bytes.length, hashCode, seed, true);
                    break;
                }
                hashCode = ObHashSortUtf8mb4.obHashSortUtf8Mb4(bytes, bytes.length, hashCode, seed, false);
                break;
            }
            case CS_TYPE_UTF8MB4_BIN: {
                if (partFuncType == ObPartFuncType.KEY_V3 || partFuncType == ObPartFuncType.KEY_IMPLICIT_V2 || ObGlobal.obVsnMajor() >= 4) {
                    hashCode = MurmurHash.hash64a(bytes, bytes.length, hashCode);
                    break;
                }
                hashCode = ObHashSortUtf8mb4.obHashSortMbBin(bytes, bytes.length, hashCode, seed);
                break;
            }
            case CS_TYPE_BINARY: {
                if (partFuncType == ObPartFuncType.KEY_V3 || partFuncType == ObPartFuncType.KEY_IMPLICIT_V2 || ObGlobal.obVsnMajor() >= 4) {
                    hashCode = MurmurHash.hash64a(bytes, bytes.length, hashCode);
                    break;
                }
                hashCode = ObHashSortBin.obHashSortBin(bytes, bytes.length, hashCode, seed);
                break;
            }
            default: {
                throw new IllegalArgumentException("not supported collation type, type = " + (Object)((Object)collationType));
            }
        }
        return hashCode;
    }

    public static long toHashcode(Object value, ObColumn refColumn, long hashCode, ObPartFuncType partFuncType) {
        ObObjType type = refColumn.getObObjType();
        int typeValue = type.getValue();
        ObCollationType collationType = refColumn.getObCollationType();
        if (typeValue >= ObObjType.ObTinyIntType.getValue() && typeValue <= ObObjType.ObUInt64Type.getValue()) {
            if (value instanceof Integer) {
                return ObHashUtils.longHash(((Integer)value).longValue(), hashCode);
            }
            if (value instanceof Short) {
                return ObHashUtils.longHash(((Short)value).longValue(), hashCode);
            }
            if (value instanceof Byte) {
                return ObHashUtils.longHash(((Byte)value).longValue(), hashCode);
            }
            if (value instanceof Boolean) {
                return ObHashUtils.longHash((Boolean)value != false ? 1L : 0L, hashCode);
            }
            return ObHashUtils.longHash((Long)value, hashCode);
        }
        if (ObObjType.ObTimestampType.getValue() == typeValue) {
            return ObHashUtils.timeStampHash((Timestamp)value, hashCode);
        }
        if (ObObjType.ObDateTimeType.getValue() == typeValue) {
            return ObHashUtils.dateTimeHash((Date)value, hashCode);
        }
        if (ObObjType.ObDateType.getValue() == typeValue) {
            return ObHashUtils.dateHash((java.sql.Date)value, hashCode);
        }
        if (ObObjType.ObVarcharType.getValue() == typeValue || ObObjType.ObCharType.getValue() == typeValue) {
            return ObHashUtils.varcharHash(value, collationType, hashCode, partFuncType);
        }
        throw new ClassCastException("unexpected type" + (Object)((Object)type));
    }

    private static byte[] longToByteArray(long l) {
        return new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 56 & 0xFFL)};
    }

    public static long longHash(long l, long hashCode) {
        return MurmurHash.hash64a(ObHashUtils.longToByteArray(l), 8, hashCode);
    }

    public static long dateHash(java.sql.Date d, long hashCode) {
        return ObHashUtils.longHash(d.getTime(), hashCode);
    }

    public static long dateTimeHash(Date d, long hashCode) {
        return ObHashUtils.longHash((d.getTime() + (long)OffsetDateTime.now().getOffset().getTotalSeconds() * 1000L) * 1000L, hashCode);
    }

    public static long timeStampHash(Timestamp ts, long hashCode) {
        return ObHashUtils.longHash(ts.getTime(), hashCode);
    }
}

