/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOp;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOpEntity;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableTabletOpFlag;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ObTableTabletOp
extends AbstractPayload {
    private List<ObTableSingleOp> singleOperations = new ArrayList<ObTableSingleOp>();
    private long tabletId = 0L;
    private Set<String> rowKeyNamesSet = new LinkedHashSet<String>();
    private Set<String> propertiesNamesSet = new LinkedHashSet<String>();
    ObTableTabletOpFlag optionFlag = new ObTableTabletOpFlag();
    private static final int tabletIdSize = 8;

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        idx = this.encodeHeader(bytes, idx);
        System.arraycopy(Serialization.encodeI64(this.tabletId), 0, bytes, idx, 8);
        int len = Serialization.getNeedBytes(this.optionFlag.getValue());
        System.arraycopy(Serialization.encodeVi64(this.optionFlag.getValue()), 0, bytes, idx += 8, len);
        idx += len;
        len = Serialization.getNeedBytes(this.singleOperations.size());
        System.arraycopy(Serialization.encodeVi64(this.singleOperations.size()), 0, bytes, idx, len);
        idx += len;
        for (ObTableSingleOp singleOperation : this.singleOperations) {
            len = (int)singleOperation.getPayloadSize();
            System.arraycopy(singleOperation.encode(), 0, bytes, idx, len);
            idx += len;
        }
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        this.tabletId = Serialization.decodeI64(buf);
        long flagsValue = Serialization.decodeVi64(buf);
        this.optionFlag.setValue(flagsValue);
        int len = (int)Serialization.decodeVi64(buf);
        for (int i = 0; i < len; ++i) {
            ObTableSingleOp singleOperation = new ObTableSingleOp();
            singleOperation.decode(buf);
            this.singleOperations.add(singleOperation);
        }
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        long payloadContentSize = 0L;
        payloadContentSize += (long)Serialization.getNeedBytes(this.singleOperations.size());
        for (ObTableSingleOp operation : this.singleOperations) {
            payloadContentSize += operation.getPayloadSize();
        }
        return payloadContentSize + 8L + (long)Serialization.getNeedBytes(this.optionFlag.getValue());
    }

    public List<ObTableSingleOp> getSingleOperations() {
        return this.singleOperations;
    }

    public void setSingleOperations(List<ObTableSingleOp> singleOperations) {
        boolean isHbaseOps;
        this.setIsSameType(true);
        this.setIsSamePropertiesNames(true);
        ObTableOperationType prevType = null;
        List<String> prevPropertiesNames = null;
        for (ObTableSingleOp o : singleOperations) {
            this.rowKeyNamesSet.addAll(o.getQuery().getScanRangeColumns());
            for (ObTableSingleOpEntity e : o.getEntities()) {
                this.rowKeyNamesSet.addAll(e.getRowKeyNames());
                this.propertiesNamesSet.addAll(e.getPropertiesNames());
                if (!this.isSamePropertiesNames()) continue;
                if (prevPropertiesNames != null && this.isSamePropertiesNames() && !prevPropertiesNames.equals(e.getPropertiesNames())) {
                    this.setIsSamePropertiesNames(false);
                    continue;
                }
                prevPropertiesNames = e.getPropertiesNames();
            }
            if (!this.isSameType()) continue;
            if (prevType != null && prevType != o.getSingleOpType()) {
                this.setIsSameType(false);
                continue;
            }
            prevType = o.getSingleOpType();
        }
        if (this.isSameType() && ((isHbaseOps = singleOperations.get(0).getQuery().isHbaseQuery()) && singleOperations.get(0).getSingleOpType() == ObTableOperationType.SCAN || !isHbaseOps && singleOperations.get(0).getSingleOpType() == ObTableOperationType.GET)) {
            this.setIsReadOnly(true);
        }
        this.singleOperations = singleOperations;
    }

    public void setTabletId(long tabletId) {
        this.tabletId = tabletId;
    }

    public long getTabletId() {
        return this.tabletId;
    }

    public boolean isSameType() {
        return this.optionFlag.getFlagIsSameType();
    }

    public boolean isSamePropertiesNames() {
        return this.optionFlag.getFlagIsSamePropertiesNames();
    }

    public void setIsSameType(boolean isSameType) {
        this.optionFlag.setFlagIsSameType(isSameType);
    }

    public void setIsReadOnly(boolean isReadOnly) {
        this.optionFlag.setFlagIsReadOnly(isReadOnly);
    }

    public void setIsSamePropertiesNames(boolean isSamePropertiesNames) {
        this.optionFlag.setFlagIsSamePropertiesNames(isSamePropertiesNames);
    }

    public Set<String> getRowKeyNamesSet() {
        return this.rowKeyNamesSet;
    }

    public Set<String> getPropertiesNamesSet() {
        return this.propertiesNamesSet;
    }
}

