/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObTableSerialUtil;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObHTableFilter;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObScanOrder;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.table.ObKVParams;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ObTableSingleOpQuery
extends ObTableQuery {
    private List<String> scanRangeColumns = new ArrayList<String>();
    private byte[] scanRangeBitMap = null;
    private long scanRangeBitLen = 0L;
    private List<String> aggColumnNames = new ArrayList<String>();

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        idx = this.encodeHeader(bytes, idx);
        int len = Serialization.getNeedBytes(this.indexName);
        System.arraycopy(Serialization.encodeVString(this.indexName), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.scanRangeBitLen);
        System.arraycopy(Serialization.encodeVi64(this.scanRangeBitLen), 0, bytes, idx, len);
        idx += len;
        for (byte b : this.scanRangeBitMap) {
            System.arraycopy(Serialization.encodeI8(b), 0, bytes, idx, 1);
            ++idx;
        }
        len = Serialization.getNeedBytes(this.keyRanges.size());
        System.arraycopy(Serialization.encodeVi64(this.keyRanges.size()), 0, bytes, idx, len);
        idx += len;
        Object object = this.keyRanges.iterator();
        while (object.hasNext()) {
            ObNewRange range = (ObNewRange)object.next();
            len = ObTableSerialUtil.getEncodedSize(range);
            System.arraycopy(ObTableSerialUtil.encode(range), 0, bytes, idx, len);
            idx += len;
        }
        len = Serialization.getNeedBytes(this.filterString);
        System.arraycopy(Serialization.encodeVString(this.filterString), 0, bytes, idx, len);
        idx += len;
        if (this.isHbaseQuery && ObGlobal.isHBaseBatchGetSupport()) {
            len = Serialization.getNeedBytes(this.selectColumns.size());
            System.arraycopy(Serialization.encodeVi64(this.selectColumns.size()), 0, bytes, idx, len);
            idx += len;
            for (String selectColumn : this.selectColumns) {
                len = Serialization.getNeedBytes(selectColumn);
                System.arraycopy(Serialization.encodeVString(selectColumn), 0, bytes, idx, len);
                idx += len;
            }
            System.arraycopy(Serialization.encodeI8(this.scanOrder.getByteValue()), 0, bytes, idx, 1);
            len = (int)this.hTableFilter.getPayloadSize();
            System.arraycopy(this.hTableFilter.encode(), 0, bytes, ++idx, len);
            idx += len;
            if (this.obKVParams != null) {
                len = (int)this.obKVParams.getPayloadSize();
                System.arraycopy(this.obKVParams.encode(), 0, bytes, idx, len);
                idx += len;
            } else {
                len = HTABLE_DUMMY_BYTES.length;
                System.arraycopy(HTABLE_DUMMY_BYTES, 0, bytes, idx, len);
                idx += len;
            }
        }
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        this.indexName = Serialization.decodeVString(buf);
        this.scanRangeBitLen = Serialization.decodeVi64(buf);
        this.scanRangeBitMap = new byte[(int)Math.ceil((double)this.scanRangeBitLen / 8.0)];
        for (int i = 0; i < this.scanRangeBitMap.length; ++i) {
            this.scanRangeBitMap[i] = Serialization.decodeI8(buf);
            int j = 0;
            while (j < 8) {
                if ((this.scanRangeBitMap[i] & 1 << j) != 0 && i * 8 + j < this.aggColumnNames.size()) {
                    this.scanRangeColumns.add(this.aggColumnNames.get(i * 8 + j));
                }
                ++i;
            }
        }
        int len = (int)Serialization.decodeVi64(buf);
        for (int i = 0; i < len; ++i) {
            ObNewRange range = new ObNewRange();
            ObTableSerialUtil.decode(buf, range);
            this.keyRanges.add(range);
        }
        this.filterString = Serialization.decodeVString(buf);
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        long payloadContentSize = 0L;
        payloadContentSize += (long)Serialization.getNeedBytes(this.scanRangeBitLen);
        payloadContentSize += (long)this.scanRangeBitMap.length;
        payloadContentSize += (long)Serialization.getNeedBytes(this.keyRanges.size());
        for (ObNewRange range : this.keyRanges) {
            payloadContentSize += (long)ObTableSerialUtil.getEncodedSize(range);
        }
        payloadContentSize += (long)Serialization.getNeedBytes(this.indexName);
        payloadContentSize += (long)Serialization.getNeedBytes(this.filterString);
        if (this.isHbaseQuery && ObGlobal.isHBaseBatchGetSupport()) {
            payloadContentSize += (long)Serialization.getNeedBytes(this.selectColumns.size());
            for (String selectColumn : this.selectColumns) {
                payloadContentSize += (long)Serialization.getNeedBytes(selectColumn);
            }
            ++payloadContentSize;
            payloadContentSize = this.isHbaseQuery ? (payloadContentSize += this.hTableFilter.getPayloadSize()) : (payloadContentSize += (long)HTABLE_DUMMY_BYTES.length);
            payloadContentSize = this.isHbaseQuery && this.obKVParams != null ? (payloadContentSize += this.obKVParams.getPayloadSize()) : (payloadContentSize += (long)HTABLE_DUMMY_BYTES.length);
        }
        return payloadContentSize;
    }

    public void adjustScanRangeColumns(Map<String, Long> columnNameIdxMap) {
        this.scanRangeBitLen = columnNameIdxMap.size();
        int size = (int)Math.ceil((double)columnNameIdxMap.size() / 8.0);
        byte[] byteArray = new byte[size];
        LinkedList<Long> columnNameIdx = new LinkedList<Long>();
        for (String name : this.scanRangeColumns) {
            Long index = columnNameIdxMap.get(name);
            columnNameIdx.add(index);
            if (index == null) continue;
            int byteIndex = index.intValue() / 8;
            int bitIndex = index.intValue() % 8;
            int n = byteIndex;
            byteArray[n] = (byte)(byteArray[n] | (byte)(1 << bitIndex));
        }
        ArrayList<ColumnNamePair> pairs = new ArrayList<ColumnNamePair>();
        for (int i = 0; i < columnNameIdx.size(); ++i) {
            pairs.add(new ColumnNamePair((Long)columnNameIdx.get(i), i));
        }
        Collections.sort(pairs);
        for (ObNewRange range : this.keyRanges) {
            List<ObObj> startKey = range.getStartKey().getObjs();
            List<ObObj> endKey = range.getStartKey().getObjs();
            ArrayList<ObObj> adjustStartKey = new ArrayList<ObObj>(startKey.size());
            ArrayList<ObObj> adjustEndtKey = new ArrayList<ObObj>(endKey.size());
            for (ColumnNamePair pair : pairs) {
                adjustStartKey.add(startKey.get((int)pair.origin_idx));
                adjustEndtKey.add(endKey.get((int)pair.origin_idx));
            }
            if (adjustStartKey.isEmpty() || adjustEndtKey.isEmpty()) continue;
            range.getStartKey().setObjs(adjustStartKey);
            range.getEndKey().setObjs(adjustEndtKey);
        }
        this.scanRangeBitMap = byteArray;
    }

    public List<ObNewRange> getScanRanges() {
        return this.keyRanges;
    }

    public void setScanRanges(List<ObNewRange> scanRanges) {
        this.keyRanges = scanRanges;
    }

    public void addScanRange(ObNewRange scanRange) {
        this.keyRanges.add(scanRange);
    }

    public void addScanRangeColumns(List<String> scanRangeColumns) {
        this.scanRangeColumns = scanRangeColumns;
    }

    @Override
    public String getFilterString() {
        return this.filterString;
    }

    @Override
    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    @Override
    public List<String> getScanRangeColumns() {
        return this.scanRangeColumns;
    }

    public void setAggColumnNames(List<String> columnNames) {
        this.aggColumnNames = columnNames;
    }

    public static ObTableSingleOpQuery getInstance(String indexName, List<ObNewRange> keyRanges, List<String> selectColumns, ObScanOrder scanOrder, boolean isHbaseQuery, ObHTableFilter obHTableFilter, ObKVParams obKVParams, String filterString) {
        ObTableSingleOpQuery query = new ObTableSingleOpQuery();
        query.setIndexName(indexName);
        query.setScanRanges(keyRanges);
        query.setSelectColumns(selectColumns);
        query.setScanOrder(scanOrder);
        if (isHbaseQuery) {
            query.sethTableFilter(obHTableFilter);
            query.setObKVParams(obKVParams);
        }
        query.setFilterString(filterString);
        return query;
    }

    private static class ColumnNamePair
    implements Comparable<ColumnNamePair> {
        long number;
        long origin_idx;

        ColumnNamePair(long number, long obj) {
            this.number = number;
            this.origin_idx = obj;
        }

        @Override
        public int compareTo(ColumnNamePair other) {
            return Long.compare(this.number, other.number);
        }
    }
}

