/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObTableSerialUtil;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ObTableSingleOpEntity
extends AbstractPayload {
    private List<String> rowKeyNames = new ArrayList<String>();
    private byte[] rowKeyBitMap = null;
    private long rowKeyBitLen = 0L;
    private List<String> aggRowKeyNames = new ArrayList<String>();
    private List<ObObj> rowkey = new ArrayList<ObObj>();
    private List<String> propertiesNames = new ArrayList<String>();
    private byte[] propertiesBitMap = null;
    private long propertiesBitLen = 0L;
    private List<String> aggPropertiesNames = new ArrayList<String>();
    private List<ObObj> propertiesValues = new ArrayList<ObObj>();
    private boolean ignoreEncodePropertiesColumnNames = false;

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        idx = this.encodeHeader(bytes, idx);
        int len = Serialization.getNeedBytes(this.rowKeyBitLen);
        System.arraycopy(Serialization.encodeVi64(this.rowKeyBitLen), 0, bytes, idx, len);
        idx += len;
        for (byte b : this.rowKeyBitMap) {
            System.arraycopy(Serialization.encodeI8(b), 0, bytes, idx, 1);
            ++idx;
        }
        len = Serialization.getNeedBytes(this.rowkey.size());
        System.arraycopy(Serialization.encodeVi64(this.rowkey.size()), 0, bytes, idx, len);
        idx += len;
        Object object = this.rowkey.iterator();
        while (object.hasNext()) {
            ObObj obj = (ObObj)object.next();
            len = ObTableSerialUtil.getEncodedSize(obj);
            System.arraycopy(ObTableSerialUtil.encode(obj), 0, bytes, idx, len);
            idx += len;
        }
        if (this.ignoreEncodePropertiesColumnNames) {
            len = Serialization.getNeedBytes(0L);
            System.arraycopy(Serialization.encodeVi64(0L), 0, bytes, idx, len);
            idx += len;
        } else {
            len = Serialization.getNeedBytes(this.propertiesBitLen);
            System.arraycopy(Serialization.encodeVi64(this.propertiesBitLen), 0, bytes, idx, len);
            idx += len;
            for (byte b : (Object)this.propertiesBitMap) {
                System.arraycopy(Serialization.encodeI8(b), 0, bytes, idx, 1);
                ++idx;
            }
        }
        len = Serialization.getNeedBytes(this.propertiesValues.size());
        System.arraycopy(Serialization.encodeVi64(this.propertiesValues.size()), 0, bytes, idx, len);
        idx += len;
        object = this.propertiesValues.iterator();
        while (object.hasNext()) {
            ObObj obj = (ObObj)object.next();
            len = ObTableSerialUtil.getEncodedSize(obj);
            System.arraycopy(ObTableSerialUtil.encode(obj), 0, bytes, idx, len);
            idx += len;
        }
        return bytes;
    }

    private byte[] parseBitMap(long bitLen, List<String> aggColumnNames, List<String> columnNames, ByteBuf buf) {
        byte[] bitMap = new byte[(int)Math.ceil((double)bitLen / 8.0)];
        if (bitLen == 0L) {
            columnNames.addAll(aggColumnNames);
        } else {
            for (int i = 0; i < bitMap.length; ++i) {
                bitMap[i] = Serialization.decodeI8(buf);
                for (int j = 0; j < 8; ++j) {
                    if ((bitMap[i] & 1 << j) == 0 || i * 8 + j >= aggColumnNames.size()) continue;
                    columnNames.add(aggColumnNames.get(i * 8 + j));
                }
            }
        }
        return bitMap;
    }

    @Override
    public Object decode(ByteBuf buf) {
        ObObj obj;
        int i;
        super.decode(buf);
        this.rowKeyBitLen = Serialization.decodeVi64(buf);
        this.rowKeyBitMap = this.parseBitMap(this.rowKeyBitLen, this.aggRowKeyNames, this.rowKeyNames, buf);
        int len = (int)Serialization.decodeVi64(buf);
        for (i = 0; i < len; ++i) {
            obj = new ObObj();
            ObTableSerialUtil.decode(buf, obj);
            this.rowkey.add(obj);
        }
        this.propertiesBitLen = Serialization.decodeVi64(buf);
        this.propertiesBitMap = this.parseBitMap(this.propertiesBitLen, this.aggPropertiesNames, this.propertiesNames, buf);
        len = (int)Serialization.decodeVi64(buf);
        for (i = 0; i < len; ++i) {
            obj = new ObObj();
            ObTableSerialUtil.decode(buf, obj);
            this.propertiesValues.add(obj);
        }
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        long payloadContentSize = 0L;
        payloadContentSize += (long)Serialization.getNeedBytes(this.rowKeyBitLen);
        payloadContentSize += (long)this.rowKeyBitMap.length;
        payloadContentSize += (long)Serialization.getNeedBytes(this.rowkey.size());
        for (ObObj obj : this.rowkey) {
            payloadContentSize += (long)ObTableSerialUtil.getEncodedSize(obj);
        }
        if (this.ignoreEncodePropertiesColumnNames) {
            payloadContentSize += (long)Serialization.getNeedBytes(0L);
        } else {
            payloadContentSize += (long)Serialization.getNeedBytes(this.propertiesBitLen);
            payloadContentSize += (long)this.propertiesBitMap.length;
        }
        payloadContentSize += (long)Serialization.getNeedBytes(this.propertiesValues.size());
        for (ObObj obj : this.propertiesValues) {
            payloadContentSize += (long)ObTableSerialUtil.getEncodedSize(obj);
        }
        return payloadContentSize;
    }

    public static boolean areArraysSameLengthOrBothNull(Object[] a, Object[] b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && a.length == b.length;
    }

    public static ObTableSingleOpEntity getInstance(String[] rowKeyNames, Object[] rowKey, String[] propertiesNames, Object[] propertiesValues) {
        String name;
        int i;
        ObTableSingleOpEntity entity = new ObTableSingleOpEntity();
        if (!ObTableSingleOpEntity.areArraysSameLengthOrBothNull(rowKeyNames, rowKey)) {
            throw new IllegalArgumentException(String.format("rowKey names length should be equals to rowKey values length, rowkeyNames: %s, rowkey: %s,", rowKeyNames, rowKey));
        }
        if (rowKey != null) {
            for (i = 0; i < rowKey.length; ++i) {
                name = rowKeyNames[i];
                Object rowkey = rowKey[i];
                ObObj obj = ObObj.getInstance(rowkey);
                entity.addRowKeyValue(name, obj);
            }
        }
        if (propertiesNames != null) {
            for (i = 0; i < propertiesNames.length; ++i) {
                name = propertiesNames[i];
                Object value = null;
                if (propertiesValues != null) {
                    value = propertiesValues[i];
                }
                ObObj c = ObObj.getInstance(value);
                entity.addPropertyValue(name, c);
            }
        }
        return entity;
    }

    public boolean isSamePropertiesColumnNamesLen(int columnNameIdxMapLen) {
        return columnNameIdxMapLen == this.propertiesNames.size();
    }

    public void adjustRowkeyColumnName(Map<String, Long> columnNameIdxMap) {
        this.rowKeyBitLen = columnNameIdxMap.size();
        int size = (int)Math.ceil((double)columnNameIdxMap.size() / 8.0);
        byte[] byteArray = new byte[size];
        LinkedList<Long> columnNameIdx = new LinkedList<Long>();
        for (String name : this.rowKeyNames) {
            Long index = columnNameIdxMap.get(name);
            columnNameIdx.add(index);
            if (index == null) continue;
            int byteIndex = index.intValue() / 8;
            int bitIndex = index.intValue() % 8;
            int n = byteIndex;
            byteArray[n] = (byte)(byteArray[n] | (byte)(1 << bitIndex));
        }
        ArrayList<ColumnNamePair> pairs = new ArrayList<ColumnNamePair>();
        for (int i = 0; i < columnNameIdx.size(); ++i) {
            pairs.add(new ColumnNamePair((Long)columnNameIdx.get(i), this.rowkey.get(i)));
        }
        Collections.sort(pairs);
        this.rowkey = new ArrayList<ObObj>(pairs.size());
        for (ColumnNamePair pair : pairs) {
            this.rowkey.add(pair.obj);
        }
        this.rowKeyBitMap = byteArray;
    }

    public void adjustPropertiesColumnName(Map<String, Long> columnNameIdxMap) {
        if (!this.ignoreEncodePropertiesColumnNames) {
            this.propertiesBitLen = columnNameIdxMap.size();
        }
        int size = (int)Math.ceil((double)columnNameIdxMap.size() / 8.0);
        byte[] byteArray = new byte[size];
        LinkedList<Long> columnNameIdx = new LinkedList<Long>();
        for (String name : this.propertiesNames) {
            Long index = columnNameIdxMap.get(name);
            columnNameIdx.add(index);
            if (index == null) continue;
            int byteIndex = index.intValue() / 8;
            int bitIndex = index.intValue() % 8;
            int n = byteIndex;
            byteArray[n] = (byte)(byteArray[n] | (byte)(1 << bitIndex));
        }
        ArrayList<ColumnNameValuePair> pairs = new ArrayList<ColumnNameValuePair>();
        for (int i = 0; i < columnNameIdx.size(); ++i) {
            pairs.add(new ColumnNameValuePair((Long)columnNameIdx.get(i), this.propertiesNames.get(i), this.propertiesValues.get(i)));
        }
        Collections.sort(pairs);
        this.propertiesNames = new ArrayList<String>(pairs.size());
        this.propertiesValues = new ArrayList<ObObj>(pairs.size());
        for (ColumnNameValuePair pair : pairs) {
            this.propertiesNames.add(pair.name);
            this.propertiesValues.add(pair.obj);
        }
        this.propertiesBitMap = byteArray;
    }

    public void addRowKeyValue(String rowKeyName, ObObj rowKeyValue) {
        this.rowKeyNames.add(rowKeyName);
        this.rowkey.add(rowKeyValue);
    }

    public void addPropertyValue(String propertyName, ObObj propertyValue) {
        this.propertiesNames.add(propertyName);
        this.propertiesValues.add(propertyValue);
    }

    public List<String> getRowKeyNames() {
        return this.rowKeyNames;
    }

    public List<String> getPropertiesNames() {
        return this.propertiesNames;
    }

    public void setIgnoreEncodePropertiesColumnNames(boolean ignoreEncodePropertiesColumnNames) {
        this.ignoreEncodePropertiesColumnNames = ignoreEncodePropertiesColumnNames;
    }

    public boolean ignoreEncodePropertiesColumnNames() {
        return this.ignoreEncodePropertiesColumnNames;
    }

    public void setAggRowKeyNames(List<String> columnNames) {
        this.aggRowKeyNames = columnNames;
    }

    public void setAggPropertiesNames(List<String> columnNames) {
        this.aggPropertiesNames = columnNames;
    }

    public Map<String, Object> getSimpleProperties() {
        HashMap<String, Object> values = new HashMap<String, Object>(this.propertiesValues.size());
        for (int i = 0; i < this.propertiesValues.size(); ++i) {
            values.put(this.propertiesNames.get(i), this.propertiesValues.get(i).getValue());
        }
        return values;
    }

    public List<ObObj> getRowkey() {
        return this.rowkey;
    }

    public void setRowkey(List<ObObj> rowkey) {
        this.rowkey = rowkey;
    }

    public List<ObObj> getPropertiesValues() {
        return this.propertiesValues;
    }

    private static class ColumnNameValuePair
    implements Comparable<ColumnNameValuePair> {
        long number;
        String name;
        ObObj obj;

        ColumnNameValuePair(long number, String name, ObObj obj) {
            this.number = number;
            this.name = name;
            this.obj = obj;
        }

        @Override
        public int compareTo(ColumnNameValuePair other) {
            return Long.compare(this.number, other.number);
        }
    }

    private static class ColumnNamePair
    implements Comparable<ColumnNamePair> {
        long number;
        ObObj obj;

        ColumnNamePair(long number, ObObj obj) {
            this.number = number;
            this.obj = obj;
        }

        @Override
        public int compareTo(ColumnNamePair other) {
            return Long.compare(this.number, other.number);
        }
    }
}

