/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ObTableBatchOperation
extends AbstractPayload {
    private List<ObTableOperation> tableOperations = new ArrayList<ObTableOperation>();
    private boolean isReadOnly = true;
    private boolean isSameType = true;
    private boolean isSamePropertiesNames = true;

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        int headerLen = (int)Serialization.getObUniVersionHeaderLength(this.getVersion(), this.getPayloadContentSize());
        System.arraycopy(Serialization.encodeObUniVersionHeader(this.getVersion(), this.getPayloadContentSize()), 0, bytes, idx, headerLen);
        int len = Serialization.getNeedBytes(this.tableOperations.size());
        System.arraycopy(Serialization.encodeVi64(this.tableOperations.size()), 0, bytes, idx += headerLen, len);
        idx += len;
        for (ObTableOperation tableOperation : this.tableOperations) {
            len = (int)tableOperation.getPayloadSize();
            System.arraycopy(tableOperation.encode(), 0, bytes, idx, len);
            idx += len;
        }
        System.arraycopy(Serialization.encodeI8(this.isReadOnly ? (byte)1 : 0), 0, bytes, idx, 1);
        System.arraycopy(Serialization.encodeI8(this.isSameType ? (byte)1 : 0), 0, bytes, ++idx, 1);
        System.arraycopy(Serialization.encodeI8(this.isSamePropertiesNames ? (byte)1 : 0), 0, bytes, ++idx, 1);
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        int len = (int)Serialization.decodeVi64(buf);
        this.tableOperations = new ArrayList<ObTableOperation>(len);
        for (int i = 0; i < len; ++i) {
            ObTableOperation obTableOperation = new ObTableOperation();
            obTableOperation.decode(buf);
            this.tableOperations.add(obTableOperation);
        }
        this.isReadOnly = Serialization.decodeI8(buf) == 1;
        this.isSameType = Serialization.decodeI8(buf) == 1;
        this.isSamePropertiesNames = Serialization.decodeI8(buf) == 1;
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        long payloadContentSize = 0L;
        payloadContentSize += (long)Serialization.getNeedBytes(this.tableOperations.size());
        for (ObTableOperation operation : this.tableOperations) {
            payloadContentSize += operation.getPayloadSize();
        }
        return payloadContentSize + 3L;
    }

    public List<ObTableOperation> getTableOperations() {
        return this.tableOperations;
    }

    public TreeSet<String> mapKeysToSetIgnoringCase(Set<String> keys) {
        TreeSet<String> keySetIgnoreCase = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        keySetIgnoreCase.addAll(keys);
        return keySetIgnoreCase;
    }

    public void addTableOperation(ObTableOperation tableOperation) {
        this.tableOperations.add(tableOperation);
        int length = this.tableOperations.size();
        if (this.isReadOnly && !tableOperation.isReadonly()) {
            this.isReadOnly = false;
        }
        if (this.isSameType && length > 1 && this.tableOperations.get(length - 1).getOperationType() != this.tableOperations.get(length - 2).getOperationType()) {
            this.isSameType = false;
        }
        if (this.isSamePropertiesNames && length > 1) {
            ObTableOperation prev = this.tableOperations.get(length - 2);
            ObTableOperation curr = this.tableOperations.get(length - 1);
            this.isSamePropertiesNames = prev.getEntity() == null || curr.getEntity() == null ? false : (prev.getEntity().getPropertiesCount() != curr.getEntity().getPropertiesCount() ? false : this.mapKeysToSetIgnoringCase(prev.getEntity().getProperties().keySet()).equals(this.mapKeysToSetIgnoringCase(curr.getEntity().getProperties().keySet())));
        }
    }

    public void setTableOperations(List<ObTableOperation> tableOperations) {
        this.tableOperations = tableOperations;
        this.isReadOnly = true;
        this.isSameType = true;
        this.isSamePropertiesNames = true;
        ObTableOperationType prevType = null;
        TreeSet<String> firstKeySetIgnoreCase = null;
        for (ObTableOperation o : tableOperations) {
            if (this.isReadOnly || this.isSameType || this.isSamePropertiesNames) {
                if (!o.isReadonly()) {
                    this.isReadOnly = false;
                }
                if (prevType != null && prevType != o.getOperationType()) {
                    this.isSameType = false;
                } else {
                    prevType = o.getOperationType();
                }
                if (!this.isSamePropertiesNames) continue;
                if (firstKeySetIgnoreCase == null) {
                    firstKeySetIgnoreCase = this.mapKeysToSetIgnoringCase(o.getEntity().getProperties().keySet());
                    continue;
                }
                if ((long)firstKeySetIgnoreCase.size() != o.getEntity().getPropertiesCount()) {
                    this.isSamePropertiesNames = false;
                    continue;
                }
                this.isSamePropertiesNames = firstKeySetIgnoreCase.equals(this.mapKeysToSetIgnoringCase(o.getEntity().getProperties().keySet()));
                continue;
            }
            return;
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
    }

    public boolean isSameType() {
        return this.isSameType;
    }

    public void setSameType(boolean sameType) {
        this.isSameType = sameType;
    }

    public boolean isSamePropertiesNames() {
        return this.isSamePropertiesNames;
    }

    public void setSamePropertiesNames(boolean samePropertiesNames) {
        this.isSamePropertiesNames = samePropertiesNames;
    }
}

