/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.exception.ObTablePartitionInfoRefreshException;
import com.alipay.oceanbase.rpc.location.model.TableEntry;
import com.alipay.oceanbase.rpc.location.model.partition.ObComparableKV;
import com.alipay.oceanbase.rpc.location.model.partition.ObHashPartDesc;
import com.alipay.oceanbase.rpc.location.model.partition.ObKeyPartDesc;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartDesc;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartFuncType;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartitionEntry;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartitionInfo;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartitionKey;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartitionLevel;
import com.alipay.oceanbase.rpc.location.model.partition.ObRangePartDesc;
import com.alipay.oceanbase.rpc.location.model.partition.OdpPartitionData;
import com.alipay.oceanbase.rpc.location.model.partition.OdpSinglePart;
import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObCollationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObColumn;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObjType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.column.ObGeneratedColumn;
import com.alipay.oceanbase.rpc.protocol.payload.impl.column.ObGeneratedColumnSimpleFunc;
import com.alipay.oceanbase.rpc.protocol.payload.impl.column.ObSimpleColumn;
import com.alipay.oceanbase.rpc.protocol.payload.impl.column.OdpSinglePartKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.parser.ObGeneratedColumnExpressParser;
import com.alipay.oceanbase.rpc.util.Serialization;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObFetchPartitionMetaResult
extends AbstractPayload {
    private long routeVersion;
    private long createTime;
    private long tableId;
    private long partitionNum;
    private OdpPartitionData odpPartitionData = new OdpPartitionData();
    private List<OdpSinglePart> odpFirstSingleParts = new ArrayList<OdpSinglePart>();
    private List<OdpSinglePart> odpSubSingleParts = new ArrayList<OdpSinglePart>();
    private Map<Long, Long> tabletLsIdMap = new HashMap<Long, Long>();
    private ObPartitionInfo partitionInfo = null;
    private TableEntry tableEntry = new TableEntry();

    public long getRouteVersion() {
        return this.routeVersion;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public TableEntry getTableEntry() {
        return this.tableEntry;
    }

    @Override
    public int getPcode() {
        return 4368;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        idx = this.encodeHeader(bytes, idx);
        int len = Serialization.getNeedBytes(this.routeVersion);
        System.arraycopy(Serialization.encodeVi64(this.routeVersion), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.createTime);
        System.arraycopy(Serialization.encodeVi64(this.createTime), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.tableId);
        System.arraycopy(Serialization.encodeVi64(this.tableId), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.partitionNum);
        System.arraycopy(Serialization.encodeVi64(this.partitionNum), 0, bytes, idx, len);
        idx += len;
        len = (int)this.odpPartitionData.getPayloadSize();
        System.arraycopy(this.odpPartitionData.encode(), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.odpFirstSingleParts.size());
        System.arraycopy(Serialization.encodeVi64(this.odpFirstSingleParts.size()), 0, bytes, idx, len);
        idx += len;
        for (OdpSinglePart singlePart : this.odpFirstSingleParts) {
            len = (int)singlePart.getPayloadSize();
            System.arraycopy(singlePart.encode(), 0, bytes, idx, len);
            idx += len;
        }
        len = Serialization.getNeedBytes(this.odpSubSingleParts.size());
        System.arraycopy(Serialization.encodeVi64(this.odpSubSingleParts.size()), 0, bytes, idx, len);
        idx += len;
        for (OdpSinglePart singlePart : this.odpSubSingleParts) {
            len = (int)singlePart.getPayloadSize();
            System.arraycopy(singlePart.encode(), 0, bytes, idx, len);
            idx += len;
        }
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        this.routeVersion = Serialization.decodeVi64(buf);
        this.createTime = Serialization.decodeVi64(buf);
        this.tableId = Serialization.decodeVi64(buf);
        this.partitionNum = Serialization.decodeVi64(buf);
        this.odpPartitionData.decode(buf);
        if (this.odpPartitionData.getLevel() == 1L || this.odpPartitionData.getLevel() == 2L) {
            OdpSinglePart odpSinglePart;
            long i;
            long len = Serialization.decodeVi64(buf);
            for (i = 0L; i < len; ++i) {
                odpSinglePart = new OdpSinglePart();
                odpSinglePart.decode(buf);
                this.odpFirstSingleParts.add(odpSinglePart);
            }
            len = Serialization.decodeVi64(buf);
            for (i = 0L; i < len; ++i) {
                odpSinglePart = new OdpSinglePart();
                odpSinglePart.decode(buf);
                this.odpSubSingleParts.add(odpSinglePart);
            }
            this.partitionInfo = this.buildPartitionInfo(this.odpPartitionData);
            Map<Object, Object> tmpTableLsIdMap = new HashMap();
            if (this.partitionInfo != null) {
                if (this.partitionInfo.getFirstPartDesc() != null) {
                    ObPartFuncType firstPartFuncType = this.partitionInfo.getFirstPartDesc().getPartFuncType();
                    this.buildFirstPartFromODP(this.odpFirstSingleParts, this.partitionInfo, firstPartFuncType);
                    if (ObGlobal.obVsnMajor() >= 4) {
                        tmpTableLsIdMap = this.buildTabletLsIdMap(this.odpFirstSingleParts);
                        this.tabletLsIdMap = tmpTableLsIdMap;
                    }
                }
                if (this.partitionInfo.getSubPartDesc() != null) {
                    ObPartFuncType subPartFuncType = this.partitionInfo.getSubPartDesc().getPartFuncType();
                    this.buildSubPartFromODP(this.odpSubSingleParts, this.partitionInfo, subPartFuncType);
                    if (ObGlobal.obVsnMajor() >= 4) {
                        tmpTableLsIdMap = this.buildTabletLsIdMap(this.odpSubSingleParts);
                        this.tabletLsIdMap = tmpTableLsIdMap;
                    }
                }
            }
        } else {
            if (this.odpPartitionData.getLevel() == 0L) {
                this.partitionInfo = new ObPartitionInfo();
                this.partitionInfo.setLevel(ObPartitionLevel.valueOf(this.odpPartitionData.getLevel()));
            }
            this.tabletLsIdMap.put(0L, -1L);
        }
        ObPartitionEntry partitionEntry = new ObPartitionEntry();
        if (ObGlobal.obVsnMajor() >= 4) {
            partitionEntry.setTabletLsIdMap(this.tabletLsIdMap);
        }
        this.tableEntry.setRefreshTimeMills(System.currentTimeMillis());
        this.tableEntry.setPartitionEntry(partitionEntry);
        this.tableEntry.setTableId(this.tableId);
        this.tableEntry.setPartitionNum(this.partitionNum);
        this.tableEntry.setPartitionInfo(this.partitionInfo);
        this.tableEntry.setOdpRefreshTimeMills(this.createTime);
        this.tableEntry.prepare();
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        long payloadContentSize = 0L;
        payloadContentSize += (long)Serialization.getNeedBytes(this.routeVersion);
        payloadContentSize += (long)Serialization.getNeedBytes(this.createTime);
        payloadContentSize += (long)Serialization.getNeedBytes(this.tableId);
        payloadContentSize += (long)Serialization.getNeedBytes(this.partitionNum);
        payloadContentSize += this.odpPartitionData.getPayloadSize();
        payloadContentSize += (long)this.odpFirstSingleParts.size();
        for (OdpSinglePart singlePart : this.odpFirstSingleParts) {
            payloadContentSize += singlePart.getPayloadSize();
        }
        payloadContentSize += (long)this.odpSubSingleParts.size();
        for (OdpSinglePart singlePart : this.odpSubSingleParts) {
            payloadContentSize += singlePart.getPayloadSize();
        }
        return payloadContentSize;
    }

    private ObPartitionInfo buildPartitionInfo(OdpPartitionData odpPartitionData) {
        ObPartitionInfo partitionInfo = new ObPartitionInfo();
        partitionInfo.setLevel(ObPartitionLevel.valueOf(odpPartitionData.getLevel()));
        if (partitionInfo.getLevel().getIndex() >= ObPartitionLevel.LEVEL_ONE.getIndex()) {
            partitionInfo.setFirstPartDesc(this.buildPartDesc(odpPartitionData, false));
        }
        if (partitionInfo.getLevel().getIndex() == ObPartitionLevel.LEVEL_TWO.getIndex()) {
            partitionInfo.setSubPartDesc(this.buildPartDesc(odpPartitionData, true));
        }
        List<OdpSinglePartKey> odpPartColumns = odpPartitionData.getSinglePartKeys();
        for (OdpSinglePartKey odpPartColumn : odpPartColumns) {
            String columnName = odpPartColumn.getColumnName();
            int index = (int)odpPartColumn.getIndex();
            ObObjType obObjType = ObObjType.valueOf((int)odpPartColumn.getObObjTypeIdx());
            ObCollationType obCollationType = ObCollationType.valueOf((int)odpPartColumn.getObCollationTypeIdx());
            String partKeyExtra = odpPartColumn.getPartKeyExtra();
            partKeyExtra = partKeyExtra.replace("`", "");
            if ((partKeyExtra = partKeyExtra.replace(" ", "")).isEmpty()) {
                ObSimpleColumn column = new ObSimpleColumn(columnName, index, obObjType, obCollationType);
                partitionInfo.addColumn(column);
                continue;
            }
            ObGeneratedColumnSimpleFunc columnExpress = new ObGeneratedColumnExpressParser(ObFetchPartitionMetaResult.getPlainString(partKeyExtra)).parse();
            ObGeneratedColumn column = new ObGeneratedColumn(columnName, index, obObjType, obCollationType, columnExpress);
            partitionInfo.addColumn(column);
        }
        ArrayList<ObColumn> firstPartColumns = new ArrayList<ObColumn>();
        ArrayList<ObColumn> subPartColumns = new ArrayList<ObColumn>();
        if (null != partitionInfo.getFirstPartDesc()) {
            block1: for (String partColumnNames : partitionInfo.getFirstPartDesc().getOrderedPartColumnNames()) {
                for (ObColumn curColumn : partitionInfo.getPartColumns()) {
                    if (!curColumn.getColumnName().equalsIgnoreCase(partColumnNames)) continue;
                    firstPartColumns.add(curColumn);
                    continue block1;
                }
            }
        }
        if (null != partitionInfo.getSubPartDesc()) {
            block3: for (String partColumnNames : partitionInfo.getSubPartDesc().getOrderedPartColumnNames()) {
                for (ObColumn curColumn : partitionInfo.getPartColumns()) {
                    if (!curColumn.getColumnName().equalsIgnoreCase(partColumnNames)) continue;
                    subPartColumns.add(curColumn);
                    continue block3;
                }
            }
        }
        this.setPartColumnsToPartDesc(partitionInfo.getFirstPartDesc(), firstPartColumns);
        this.setPartColumnsToPartDesc(partitionInfo.getSubPartDesc(), subPartColumns);
        return partitionInfo;
    }

    private void setPartColumnsToPartDesc(ObPartDesc partDesc, List<ObColumn> partColumns) {
        if (partDesc != null) {
            partDesc.setPartColumns(partColumns);
            ObPartFuncType partType = partDesc.getPartFuncType();
            if (partType.isKeyPart()) {
                if (partColumns == null || partColumns.size() == 0) {
                    TableClientLoggerFactory.RUNTIME.error("key part desc need part ref columns but found " + partColumns);
                    throw new ObTablePartitionInfoRefreshException("key part desc need part ref columns but found " + partColumns);
                }
            } else if (partType.isRangePart()) {
                ((ObRangePartDesc)partDesc).setOrderedCompareColumns(partColumns);
            }
        }
    }

    private static String getPlainString(String str) {
        int start = str.length() > 0 && str.charAt(0) == '\'' ? 1 : 0;
        int end = str.length() > 0 && str.charAt(str.length() - 1) == '\'' ? str.length() - 1 : str.length();
        return str.substring(start, end);
    }

    private ObPartDesc buildPartDesc(OdpPartitionData odpPartitionData, boolean isSubPart) {
        ObPartDesc partDesc = null;
        long partNum = !isSubPart ? odpPartitionData.getPartNum() : odpPartitionData.getSubPartNum();
        String partExpr = !isSubPart ? odpPartitionData.getPartExr() : odpPartitionData.getSubPartExr();
        long partType = !isSubPart ? odpPartitionData.getPartType() : odpPartitionData.getSubPartType();
        long partSpace = !isSubPart ? odpPartitionData.getPartSpace() : odpPartitionData.getSubPartSpace();
        String objTypesStr = !isSubPart ? odpPartitionData.getPartRangeType() : odpPartitionData.getSubPartRangeType();
        ObPartFuncType obPartFuncType = ObPartFuncType.getObPartFuncType(partType);
        partExpr = partExpr.replace("`", "");
        if (obPartFuncType.isRangePart()) {
            ObRangePartDesc rangeDesc = new ObRangePartDesc();
            rangeDesc.setPartExpr(partExpr);
            rangeDesc.setPartNum((int)partNum);
            rangeDesc.setPartSpace((int)partSpace);
            ArrayList<ObObjType> types = new ArrayList<ObObjType>(1);
            for (String typeStr : objTypesStr.split(",")) {
                types.add(ObObjType.valueOf(Integer.valueOf(typeStr)));
            }
            rangeDesc.setOrderedCompareColumnTypes(types);
            partDesc = rangeDesc;
        } else if (obPartFuncType.isHashPart()) {
            ObHashPartDesc hashDesc = new ObHashPartDesc();
            hashDesc.setPartExpr(partExpr);
            hashDesc.setPartNum((int)partNum);
            hashDesc.setPartSpace((int)partSpace);
            partDesc = hashDesc;
        } else if (obPartFuncType.isKeyPart()) {
            ObKeyPartDesc keyDesc = new ObKeyPartDesc();
            keyDesc.setPartExpr(partExpr);
            keyDesc.setPartNum((int)partNum);
            keyDesc.setPartSpace((int)partSpace);
            partDesc = keyDesc;
        } else {
            TableClientLoggerFactory.RUNTIME.error(TableClientLoggerFactory.LCD.convert("01-00015"), (Object)partType);
            throw new IllegalArgumentException(String.format("not supported part type, type = %s", partType));
        }
        return partDesc;
    }

    private void buildFirstPartFromODP(List<OdpSinglePart> odpFirstSingleParts, ObPartitionInfo partitionInfo, ObPartFuncType obPartFuncType) {
        if (obPartFuncType.isRangePart()) {
            ArrayList<List<byte[]>> highBoundVals = new ArrayList<List<byte[]>>();
            List<ObComparableKV<ObPartitionKey, Long>> bounds = this.buildFirstRangePart(odpFirstSingleParts, partitionInfo, highBoundVals);
            ((ObRangePartDesc)partitionInfo.getFirstPartDesc()).setBounds(bounds);
            ((ObRangePartDesc)partitionInfo.getFirstPartDesc()).setHighBoundValues(highBoundVals);
        } else if (ObGlobal.obVsnMajor() >= 4 && (obPartFuncType.isKeyPart() || obPartFuncType.isHashPart())) {
            partitionInfo.setPartTabletIdMap(this.buildFirstKeyHashPart(odpFirstSingleParts, partitionInfo));
        }
    }

    private void buildSubPartFromODP(List<OdpSinglePart> odpSubSingleParts, ObPartitionInfo partitionInfo, ObPartFuncType obPartFuncType) {
        if (obPartFuncType.isRangePart()) {
            ArrayList<List<byte[]>> highBoundVals = new ArrayList<List<byte[]>>();
            List<ObComparableKV<ObPartitionKey, Long>> bounds = this.buildSubRangePart(odpSubSingleParts, partitionInfo, highBoundVals);
            ((ObRangePartDesc)partitionInfo.getSubPartDesc()).setBounds(bounds);
            ((ObRangePartDesc)partitionInfo.getSubPartDesc()).setHighBoundValues(highBoundVals);
        } else if (ObGlobal.obVsnMajor() >= 4 && (obPartFuncType.isKeyPart() || obPartFuncType.isHashPart())) {
            partitionInfo.setPartTabletIdMap(this.buildSubKeyHashPart(odpSubSingleParts, partitionInfo));
        }
    }

    private List<ObComparableKV<ObPartitionKey, Long>> buildFirstRangePart(List<OdpSinglePart> odpFirstSingleParts, ObPartitionInfo partitionInfo, List<List<byte[]>> highBoundVals) {
        return this.buildRangePart(odpFirstSingleParts, partitionInfo, highBoundVals, false);
    }

    private List<ObComparableKV<ObPartitionKey, Long>> buildSubRangePart(List<OdpSinglePart> odpSubSingleParts, ObPartitionInfo partitionInfo, List<List<byte[]>> highBoundVals) {
        return this.buildRangePart(odpSubSingleParts, partitionInfo, highBoundVals, true);
    }

    private List<ObComparableKV<ObPartitionKey, Long>> buildRangePart(List<OdpSinglePart> odpSingleParts, ObPartitionInfo partitionInfo, List<List<byte[]>> highBoundVals, boolean isSubPart) {
        ObPartDesc partDesc = partitionInfo.getFirstPartDesc();
        if (isSubPart) {
            partDesc = partitionInfo.getSubPartDesc();
        }
        List<ObColumn> orderPartColumns = ((ObRangePartDesc)partDesc).getOrderedCompareColumns();
        ArrayList<ObComparableKV<ObPartitionKey, Long>> bounds = new ArrayList<ObComparableKV<ObPartitionKey, Long>>();
        HashMap<String, Long> partNameIdMap = new HashMap<String, Long>();
        HashMap<Long, Long> partTabletIdMap = new HashMap<Long, Long>();
        ObPartDesc subPartDesc = partitionInfo.getSubPartDesc();
        if (ObGlobal.obVsnMajor() >= 4 && subPartDesc != null && !isSubPart && subPartDesc.getPartNum() == 0) {
            long subPartNum = odpSingleParts.get(0).getSubPartNum();
            subPartDesc.setPartNum((int)subPartNum);
        }
        for (long i = 0L; i < (long)odpSingleParts.size(); ++i) {
            String highBoundVal = odpSingleParts.get((int)i).getHighBoundVal();
            String[] splits = highBoundVal.split(",");
            ArrayList<Comparable> partElements = new ArrayList<Comparable>();
            ArrayList<byte[]> singleHighBoundVal = new ArrayList<byte[]>();
            for (int j = 0; j < splits.length; ++j) {
                String elementStr = ObFetchPartitionMetaResult.getPlainString(splits[j]);
                if (elementStr.equalsIgnoreCase("MAXVALUE")) {
                    singleHighBoundVal.add(new byte[0]);
                    partElements.add(ObPartitionKey.MAX_PARTITION_ELEMENT);
                    continue;
                }
                if (elementStr.equalsIgnoreCase("MINVALUE")) {
                    singleHighBoundVal.add(new byte[0]);
                    partElements.add(ObPartitionKey.MIN_PARTITION_ELEMENT);
                    continue;
                }
                ObObjType type = orderPartColumns.get(j).getObObjType();
                partElements.add(type.parseToComparable(elementStr, orderPartColumns.get(j).getObCollationType()));
                singleHighBoundVal.add(type.parseToBytes(elementStr, orderPartColumns.get(j).getObCollationType()));
            }
            ObPartitionKey partitionKey = new ObPartitionKey(orderPartColumns, partElements);
            if (ObGlobal.obVsnMajor() >= 4) {
                long tabletId = odpSingleParts.get((int)i).getTabletId();
                bounds.add(new ObComparableKV<ObPartitionKey, Long>(partitionKey, i));
                highBoundVals.add(singleHighBoundVal);
                partTabletIdMap.put(i, tabletId);
                continue;
            }
            long partId = odpSingleParts.get((int)i).getPartId();
            bounds.add(new ObComparableKV<ObPartitionKey, Long>(partitionKey, partId));
            highBoundVals.add(singleHighBoundVal);
        }
        if (ObGlobal.obVsnMajor() >= 4) {
            partitionInfo.setPartTabletIdMap(partTabletIdMap);
        } else {
            partDesc.setPartNameIdMap(partNameIdMap);
        }
        Collections.sort(bounds);
        return bounds;
    }

    private Map<Long, Long> buildFirstKeyHashPart(List<OdpSinglePart> odpFirstSingleParts, ObPartitionInfo partitionInfo) {
        return this.buildKeyHashPart(odpFirstSingleParts, partitionInfo, false);
    }

    private Map<Long, Long> buildSubKeyHashPart(List<OdpSinglePart> odpSubSingleParts, ObPartitionInfo partitionInfo) {
        return this.buildKeyHashPart(odpSubSingleParts, partitionInfo, true);
    }

    private Map<Long, Long> buildKeyHashPart(List<OdpSinglePart> odpSingleParts, ObPartitionInfo partitionInfo, boolean isSubPart) {
        ObPartDesc subPartDesc = partitionInfo.getSubPartDesc();
        if (null != subPartDesc && !isSubPart) {
            ObHashPartDesc subHashPartDesc;
            OdpSinglePart odpSinglePart = odpSingleParts.get(0);
            long subPartNum = odpSinglePart.getSubPartNum();
            if (subPartDesc.getPartFuncType().isKeyPart()) {
                ObKeyPartDesc subKeyPartDesc = (ObKeyPartDesc)subPartDesc;
                if (subKeyPartDesc.getPartNum() == 0) {
                    subKeyPartDesc.setPartNum((int)subPartNum);
                }
            } else if (subPartDesc.getPartFuncType().isHashPart() && (subHashPartDesc = (ObHashPartDesc)subPartDesc).getPartNum() == 0) {
                subHashPartDesc.setPartNum((int)subPartNum);
            }
        }
        HashMap<Long, Long> partTabletIdMap = new HashMap<Long, Long>();
        for (long i = 0L; i < (long)odpSingleParts.size(); ++i) {
            partTabletIdMap.put(i, odpSingleParts.get((int)i).getTabletId());
        }
        return partTabletIdMap;
    }

    private Map<Long, Long> buildTabletLsIdMap(List<OdpSinglePart> odpSingleParts) {
        HashMap<Long, Long> tabletLsId = new HashMap<Long, Long>();
        for (OdpSinglePart odpSinglePart : odpSingleParts) {
            tabletLsId.put(odpSinglePart.getTabletId(), odpSinglePart.getLsId());
        }
        return tabletLsId;
    }
}

