/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.column;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObColumn;
import com.alipay.oceanbase.rpc.protocol.payload.impl.column.ObGeneratedColumn;
import com.alipay.oceanbase.rpc.protocol.payload.impl.column.ObGeneratedColumnSubStrFunc;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class OdpSinglePartKey
extends AbstractPayload {
    private long columnLevel;
    private long index;
    private long obObjTypeIdx;
    private String columnName = "";
    private String partKeyExtra = "";
    private long obCollationTypeIdx;

    public OdpSinglePartKey() {
    }

    public OdpSinglePartKey(ObColumn column) {
        this.columnLevel = -1L;
        this.index = column.getIndex();
        this.obObjTypeIdx = column.getObObjType().getValue();
        this.columnName = column.getColumnName();
        if (column instanceof ObGeneratedColumn) {
            String str = "";
            ObGeneratedColumn genCol = (ObGeneratedColumn)column;
            ObGeneratedColumnSubStrFunc subStrFunc = (ObGeneratedColumnSubStrFunc)genCol.getObGeneratedColumnSimpleFunc();
            this.partKeyExtra = str = str + "substr(" + subStrFunc.getRefColumnNames().get(0) + "," + subStrFunc.getPos() + "," + subStrFunc.getPos() + ")";
        }
        this.obCollationTypeIdx = column.getObCollationType().getValue();
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        idx = this.encodeHeader(bytes, idx);
        int len = Serialization.getNeedBytes(this.columnLevel);
        System.arraycopy(Serialization.encodeVi64(this.columnLevel), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.index);
        System.arraycopy(Serialization.encodeVi64(this.index), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.obObjTypeIdx);
        System.arraycopy(Serialization.encodeVi64(this.obObjTypeIdx), 0, bytes, idx, len);
        byte[] strbytes = Serialization.encodeVString(this.columnName);
        System.arraycopy(strbytes, 0, bytes, idx += len, strbytes.length);
        idx += strbytes.length;
        strbytes = Serialization.encodeVString(this.partKeyExtra);
        System.arraycopy(strbytes, 0, bytes, idx, strbytes.length);
        len = Serialization.getNeedBytes(this.obCollationTypeIdx);
        System.arraycopy(Serialization.encodeVi64(this.obObjTypeIdx), 0, bytes, idx += strbytes.length, len);
        return bytes;
    }

    @Override
    public OdpSinglePartKey decode(ByteBuf buf) {
        super.decode(buf);
        this.columnLevel = Serialization.decodeVi64(buf);
        this.index = Serialization.decodeVi64(buf);
        this.obObjTypeIdx = Serialization.decodeVi64(buf);
        this.columnName = Serialization.decodeVString(buf);
        this.partKeyExtra = Serialization.decodeVString(buf);
        this.obCollationTypeIdx = Serialization.decodeVi64(buf);
        return this;
    }

    public long getColumnLevel() {
        return this.columnLevel;
    }

    public long getIndex() {
        return this.index;
    }

    public long getObObjTypeIdx() {
        return this.obObjTypeIdx;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getPartKeyExtra() {
        return this.partKeyExtra;
    }

    public long getObCollationTypeIdx() {
        return this.obCollationTypeIdx;
    }

    @Override
    public long getPayloadContentSize() {
        return Serialization.getNeedBytes(this.columnLevel) + Serialization.getNeedBytes(this.index) + Serialization.getNeedBytes(this.obObjTypeIdx) + Serialization.getNeedBytes(this.columnName) + Serialization.getNeedBytes(this.partKeyExtra) + Serialization.getNeedBytes(this.obCollationTypeIdx);
    }
}

