/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.mutation;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.mutation.ColumnValue;
import com.alipay.oceanbase.rpc.mutation.Mutation;
import com.alipay.oceanbase.rpc.mutation.Row;
import com.alipay.oceanbase.rpc.mutation.result.MutationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.table.api.Table;
import java.util.ArrayList;
import java.util.Map;

public class Replace
extends Mutation<Replace> {
    public Replace() {
        this.columns = new ArrayList();
        this.values = new ArrayList();
    }

    public Replace(Table client, String tableName) {
        super(client, tableName);
        this.columns = new ArrayList();
        this.values = new ArrayList();
    }

    public String[] getColumns() {
        return this.columns.toArray(new String[0]);
    }

    public Object[] getValues() {
        return this.values.toArray();
    }

    @Override
    public ObTableOperationType getOperationType() {
        return ObTableOperationType.REPLACE;
    }

    public Replace addMutateRow(Row rows) {
        if (null == rows) {
            throw new IllegalArgumentException("Invalid null rowKey set into Insert");
        }
        if (0 == rows.getMap().size()) {
            throw new IllegalArgumentException("input row key should not be empty");
        }
        for (Map.Entry<String, Object> entry : rows.getMap().entrySet()) {
            this.columns.add(entry.getKey());
            this.values.add(entry.getValue());
        }
        return this;
    }

    public Replace addMutateColVal(ColumnValue ... columnValues) {
        if (null == columnValues) {
            throw new IllegalArgumentException("Invalid null columnValues set into Insert");
        }
        for (ColumnValue columnValue : columnValues) {
            if (this.columns.contains(columnValue.getColumnName())) {
                throw new ObTableException("Duplicate column in Row Key");
            }
            this.columns.add(columnValue.getColumnName());
            this.values.add(columnValue.getValue());
        }
        return this;
    }

    public Replace removeRowkeyFromMutateColval() {
        Replace.removeRowkeyFromMutateColval(this.columns, this.values, this.rowKeyNames);
        return this;
    }

    public MutationResult execute() throws Exception {
        if (null == this.getTableName() || this.getTableName().isEmpty()) {
            throw new ObTableException("table name is null");
        }
        if (null == this.getClient()) {
            throw new ObTableException("client is null");
        }
        Replace.removeRowkeyFromMutateColval(this.columns, this.values, this.rowKeyNames);
        if (null == this.getQuery()) {
            return new MutationResult(((ObTableClient)this.getClient()).replaceWithResult(this.getTableName(), this.getRowKey(), this.getKeyRanges(), this.columns.toArray(new String[0]), this.values.toArray()));
        }
        throw new ObTableException("Replace with query(filter) is not supported yet");
    }
}

