/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.mutation;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTableUnexpectedException;
import com.alipay.oceanbase.rpc.filter.ObTableFilter;
import com.alipay.oceanbase.rpc.mutation.ColumnValue;
import com.alipay.oceanbase.rpc.mutation.Mutation;
import com.alipay.oceanbase.rpc.mutation.Row;
import com.alipay.oceanbase.rpc.mutation.result.MutationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.table.api.Table;
import java.util.ArrayList;
import java.util.Map;

public class Put
extends Mutation<Put> {
    public Put() {
        this.columns = new ArrayList();
        this.values = new ArrayList();
    }

    public Put(Table client, String tableName) {
        super(client, tableName);
        this.columns = new ArrayList();
        this.values = new ArrayList();
    }

    @Override
    public Put setRowKey(Row rowKey) {
        return (Put)this.setRowKeyOnly(rowKey);
    }

    @Override
    public Put setRowKey(ColumnValue ... rowKey) {
        return (Put)this.setRowKeyOnly(rowKey);
    }

    @Override
    public Put setFilter(ObTableFilter filter) throws Exception {
        return (Put)this.setFilterOnly(filter);
    }

    @Override
    public ObTableOperationType getOperationType() {
        return ObTableOperationType.PUT;
    }

    public Put addMutateRow(Row rows) {
        if (null == rows) {
            throw new IllegalArgumentException("Invalid null rowKey set into Put");
        }
        if (0 == rows.getMap().size()) {
            throw new IllegalArgumentException("input row key should not be empty");
        }
        for (Map.Entry<String, Object> entry : rows.getMap().entrySet()) {
            this.columns.add(entry.getKey());
            this.values.add(entry.getValue());
        }
        return this;
    }

    public String[] getColumns() {
        return this.columns.toArray(new String[0]);
    }

    public Object[] getValues() {
        return this.values.toArray();
    }

    public Put addMutateColVal(ColumnValue ... columnValues) throws Exception {
        if (null == columnValues) {
            throw new IllegalArgumentException("Invalid null columnValues set into Put");
        }
        for (ColumnValue columnValue : columnValues) {
            if (this.columns.contains(columnValue.getColumnName())) {
                throw new ObTableException("Duplicate column in Row Key");
            }
            this.columns.add(columnValue.getColumnName());
            this.values.add(columnValue.getValue());
        }
        return this;
    }

    public Put removeRowkeyFromMutateColval() {
        Put.removeRowkeyFromMutateColval(this.columns, this.values, this.rowKeyNames);
        return this;
    }

    public MutationResult execute() throws Exception {
        if (null == this.getTableName()) {
            throw new ObTableException("table name is null");
        }
        if (null == this.getClient()) {
            throw new ObTableException("client is null");
        }
        Put.removeRowkeyFromMutateColval(this.columns, this.values, this.rowKeyNames);
        if (null == this.getQuery()) {
            return new MutationResult(((ObTableClient)this.getClient()).putWithResult(this.getTableName(), this.getRowKey(), this.getKeyRanges(), this.columns.toArray(new String[0]), this.values.toArray()));
        }
        if (this.checkMutationWithFilter()) {
            ObTableOperation operation = ObTableOperation.getInstance(ObTableOperationType.PUT, this.getRowKeyValues().toArray(), this.columns.toArray(new String[0]), this.values.toArray());
            return new MutationResult(((ObTableClient)this.getClient()).mutationWithFilter(this.getQuery(), this.getRowKey(), this.getKeyRanges(), operation, true));
        }
        throw new ObTableUnexpectedException("should set filter and scan range both");
    }
}

