/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model.partition;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class OdpSinglePart
extends AbstractPayload {
    private long partId = -1L;
    private long tabletId = -1L;
    private long lsId = -1L;
    private long subPartNum = -1L;
    private String highBoundVal = "";

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        idx = this.encodeHeader(bytes, idx);
        int len = Serialization.getNeedBytes(this.partId);
        System.arraycopy(Serialization.encodeVi64(this.partId), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.tabletId);
        System.arraycopy(Serialization.encodeVi64(this.tabletId), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.lsId);
        System.arraycopy(Serialization.encodeVi64(this.lsId), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.subPartNum);
        System.arraycopy(Serialization.encodeVi64(this.subPartNum), 0, bytes, idx, len);
        byte[] strbytes = Serialization.encodeVString(this.highBoundVal);
        System.arraycopy(strbytes, 0, bytes, idx += len, strbytes.length);
        return bytes;
    }

    @Override
    public OdpSinglePart decode(ByteBuf buf) {
        super.decode(buf);
        this.partId = Serialization.decodeVi64(buf);
        this.tabletId = Serialization.decodeVi64(buf);
        this.lsId = Serialization.decodeVi64(buf);
        this.subPartNum = Serialization.decodeVi64(buf);
        this.highBoundVal = Serialization.decodeVString(buf);
        return this;
    }

    public long getPartId() {
        return this.partId;
    }

    public long getTabletId() {
        return this.tabletId;
    }

    public long getLsId() {
        return this.lsId;
    }

    public long getSubPartNum() {
        return this.subPartNum;
    }

    public String getHighBoundVal() {
        return this.highBoundVal;
    }

    @Override
    public long getPayloadContentSize() {
        return Serialization.getNeedBytes(this.partId) + Serialization.getNeedBytes(this.tabletId) + Serialization.getNeedBytes(this.lsId) + Serialization.getNeedBytes(this.subPartNum) + Serialization.getNeedBytes(this.highBoundVal);
    }
}

