/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model.partition;

import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTablePartitionConsistentException;
import com.alipay.oceanbase.rpc.location.model.partition.ObComparableKV;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartDesc;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartFuncType;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartitionKey;
import com.alipay.oceanbase.rpc.mutation.Row;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObColumn;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObjType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.column.ObGeneratedColumn;
import com.alipay.oceanbase.rpc.protocol.payload.impl.column.ObSimpleColumn;
import com.alipay.oceanbase.rpc.util.RandomUtil;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;

public class ObRangePartDesc
extends ObPartDesc {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObRangePartDesc.class);
    private int partSpace = 0;
    private int partNum = 0;
    private List<ObColumn> orderedCompareColumns = null;
    private List<ObObjType> orderedCompareColumnTypes = null;
    private List<ObComparableKV<ObPartitionKey, Long>> bounds = null;
    private List<List<byte[]>> highBoundValues = null;
    private List<Long> completeWorks;

    public ObRangePartDesc() {
        this.setPartFuncType(ObPartFuncType.RANGE);
    }

    public List<ObObjType> getOrderedCompareColumnTypes() {
        return this.orderedCompareColumnTypes;
    }

    public void setOrderedCompareColumnTypes(List<ObObjType> orderedPartColumnTypes) {
        this.orderedCompareColumnTypes = orderedPartColumnTypes;
    }

    public void setOrderedCompareColumns(List<ObColumn> orderedPartColumn) {
        this.orderedCompareColumns = orderedPartColumn;
    }

    public List<ObColumn> getOrderedCompareColumns() {
        return this.orderedCompareColumns;
    }

    public void setBounds(List<ObComparableKV<ObPartitionKey, Long>> bounds) {
        this.bounds = bounds;
    }

    public List<ObComparableKV<ObPartitionKey, Long>> getBounds() {
        return this.bounds;
    }

    public void setHighBoundValues(List<List<byte[]>> highBoundValues) {
        this.highBoundValues = highBoundValues;
    }

    public List<List<byte[]>> getHighBoundValues() {
        return this.highBoundValues;
    }

    @Override
    public Long getRandomPartId() {
        if (null == this.bounds) {
            return null;
        }
        int randomIndex = RandomUtil.getRandomNum(0, this.bounds.size());
        return (Long)this.bounds.get((int)randomIndex).value;
    }

    @Override
    public void prepare() throws IllegalArgumentException {
        if (this.bounds == null || this.bounds.size() == 0) {
            throw new IllegalArgumentException("prepare ObRangePartDesc failed. partition bounds is empty " + this.bounds);
        }
        if (this.orderedCompareColumnTypes == null || this.orderedCompareColumnTypes.size() == 0) {
            throw new IllegalArgumentException("prepare ObRangePartDesc failed. partition orderedCompareColumnTypes is empty " + this.orderedCompareColumnTypes);
        }
        if (this.orderedCompareColumns == null || this.orderedCompareColumns.size() == 0) {
            throw new IllegalArgumentException("prepare ObRangePartDesc failed. partition orderedCompareColumns is empty " + this.orderedCompareColumnTypes);
        }
        if (this.orderedCompareColumns.size() != this.orderedCompareColumnTypes.size()) {
            throw new IllegalArgumentException("prepare ObRangePartDesc failed. the size of orderedCompareColumns  is as same as  the size of orderedCompareColumnTypes" + this.orderedCompareColumnTypes);
        }
        ArrayList<ObColumn> orderedPartColumnTmp = new ArrayList<ObColumn>(this.orderedCompareColumns.size());
        for (int i = 0; i < this.orderedCompareColumns.size(); ++i) {
            ObColumn obColumn = this.orderedCompareColumns.get(i);
            ObColumn convert = obColumn.getObGeneratedColumnSimpleFunc() != null ? new ObGeneratedColumn(obColumn.getColumnName(), obColumn.getIndex(), this.orderedCompareColumnTypes.get(i), obColumn.getObCollationType(), obColumn.getObGeneratedColumnSimpleFunc()) : new ObSimpleColumn(obColumn.getColumnName(), obColumn.getIndex(), this.orderedCompareColumnTypes.get(i), obColumn.getObCollationType());
            orderedPartColumnTmp.add(convert);
        }
        this.orderedCompareColumns = orderedPartColumnTmp;
        if (this.orderedCompareColumnTypes.size() != this.orderedPartColumnNames.size()) {
            throw new IllegalArgumentException("prepare ObRangePartDesc failed. the size of orderedCompareColumnTypes is not equal with the size of orderedCompareColumns. types " + this.orderedCompareColumnTypes + " columns" + this.orderedPartColumnNames);
        }
        super.prepare();
    }

    public int getPartSpace() {
        return this.partSpace;
    }

    public void setPartSpace(int partSpace) {
        this.partSpace = partSpace;
    }

    @Override
    public int getPartNum() {
        return this.partNum;
    }

    @Override
    public void setPartNum(int partNum) {
        this.partNum = partNum;
        ArrayList<Long> partIds = new ArrayList<Long>();
        for (long i = 0L; i < (long)partNum; ++i) {
            partIds.add(i);
        }
        this.completeWorks = Collections.unmodifiableList(partIds);
    }

    @Override
    public List<Long> getPartIds(Object startRowObj, boolean startInclusive, Object endRowObj, boolean endInclusive) {
        if (!(startRowObj instanceof Row) || !(endRowObj instanceof Row)) {
            throw new ObTableException("invalid format of rowObj: " + startRowObj + ", " + endRowObj);
        }
        Row startRow = (Row)startRowObj;
        Row endRow = (Row)endRowObj;
        if (startRow.size() != endRow.size()) {
            throw new IllegalArgumentException("length of start key and end key is not equal");
        }
        if (startRow.size() == 1L && startRow.getValues()[0] instanceof ObObj && ((ObObj)startRow.getValues()[0]).isMinObj() && endRow.size() == 1L && endRow.getValues()[0] instanceof ObObj && ((ObObj)endRow.getValues()[0]).isMaxObj()) {
            return this.completeWorks;
        }
        int startIdx = this.getBoundsIdx(true, startRow);
        int stopIdx = this.getBoundsIdx(true, endRow);
        ArrayList<Long> partIds = new ArrayList<Long>();
        for (int i = startIdx; i <= stopIdx; ++i) {
            partIds.add((Long)this.bounds.get((int)i).value);
        }
        return partIds;
    }

    @Override
    public Long getPartId(Object ... row) {
        try {
            ArrayList<Object> rows = new ArrayList<Object>();
            rows.addAll(Arrays.asList(row));
            return (Long)this.bounds.get((int)this.getBoundsIdx((boolean)false, rows)).value;
        }
        catch (IllegalArgumentException e) {
            TableClientLoggerFactory.RUNTIME.error(TableClientLoggerFactory.LCD.convert("01-00025"), (Throwable)e);
            throw new IllegalArgumentException("ObRangePartDesc get part id come across illegal params", e);
        }
    }

    public int getBoundsIdx(boolean isScan, List<Object> rowObj) {
        if (!(rowObj.get(0) instanceof Row)) {
            throw new ObTableException("invalid format of rowObj: " + rowObj);
        }
        Row row = (Row)rowObj.get(0);
        if (row.size() < (long)this.partColumns.size()) {
            throw new IllegalArgumentException("Input row key should at least include " + this.partColumns + "but found" + Arrays.toString(row.getValues()));
        }
        try {
            List<Object> evalParams = this.evalRowKeyValues(row);
            List<Comparable> comparableElement = super.initComparableElementByTypes(evalParams, this.orderedCompareColumns);
            ObPartitionKey searchKey = ObPartitionKey.getInstance(this.orderedCompareColumns, comparableElement);
            int pos = ObRangePartDesc.upperBound(this.bounds, new ObComparableKV<ObPartitionKey, Long>(searchKey, -1L));
            if (pos >= this.bounds.size()) {
                if (isScan) {
                    return this.bounds.size() - 1;
                }
                throw new ArrayIndexOutOfBoundsException("Table has no partition for value in " + this.getPartExpr());
            }
            return pos;
        }
        catch (IllegalArgumentException e) {
            TableClientLoggerFactory.RUNTIME.error(TableClientLoggerFactory.LCD.convert("01-00025"), (Throwable)e);
            throw new IllegalArgumentException("ObRangePartDesc get getBoundsIdx error", e);
        }
    }

    public int getBoundsIdx(boolean isScan, Row rowKey) {
        try {
            List<Object> evalParams = this.evalRowKeyValues(rowKey);
            List<Comparable> comparableElement = super.initComparableElementByTypes(evalParams, this.orderedCompareColumns);
            ObPartitionKey searchKey = ObPartitionKey.getInstance(this.orderedCompareColumns, comparableElement);
            int pos = ObRangePartDesc.upperBound(this.bounds, new ObComparableKV<ObPartitionKey, Long>(searchKey, -1L));
            if (pos >= this.bounds.size()) {
                if (isScan) {
                    return this.bounds.size() - 1;
                }
                throw new ArrayIndexOutOfBoundsException("Table has no partition for value in " + this.getPartExpr());
            }
            return pos;
        }
        catch (IllegalArgumentException e) {
            TableClientLoggerFactory.RUNTIME.error(TableClientLoggerFactory.LCD.convert("01-00025"), (Throwable)e);
            throw new IllegalArgumentException("ObRangePartDesc get getBoundsIdx error", e);
        }
    }

    @Override
    public Long getPartId(List<Object> rows, boolean consistency) {
        if (rows == null || rows.size() == 0) {
            throw new IllegalArgumentException("invalid row keys :" + rows);
        }
        Long partId = null;
        for (Object rowObj : rows) {
            if (!(rowObj instanceof Row)) {
                throw new ObTableException("invalid format of rowObj: " + rowObj);
            }
            Row row = (Row)rowObj;
            long currentPartId = this.getPartId(row);
            if (partId == null) {
                partId = currentPartId;
            }
            if (!consistency) break;
            if (partId.equals(currentPartId)) continue;
            throw new ObTablePartitionConsistentException("across partition operation may cause consistent problem " + rows);
        }
        return partId;
    }

    private static <T extends Comparable<? super T>> int upperBound(List<T> list, T key) {
        int first = 0;
        int len = list.size();
        int half = 0;
        int middle = 0;
        while (len > 0) {
            half = len >> 1;
            middle = first + half;
            if (((Comparable)list.get(middle)).compareTo(key) > 0) {
                len = half;
                continue;
            }
            first = middle + 1;
            len = len - half - 1;
        }
        return first;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("orderedCompareColumnTypes", this.orderedCompareColumnTypes).append("bounds", this.bounds).append("partFuncType", (Object)this.getPartFuncType()).append("partExpr", (Object)this.getPartExpr()).toString();
    }
}

