/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model.partition;

import com.alipay.oceanbase.rpc.location.model.ObServerLdcLocation;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartitionLocation;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartitionLocationInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ObPartitionEntry {
    private Map<Long, ObPartitionLocation> partitionLocation = new HashMap<Long, ObPartitionLocation>();
    private Map<Long, Long> tabletLsIdMap = new HashMap<Long, Long>();
    private ConcurrentHashMap<Long, ObPartitionLocationInfo> partitionInfos = new ConcurrentHashMap();

    public ObPartitionLocationInfo getPartitionInfo(long tabletId) {
        return this.partitionInfos.computeIfAbsent(tabletId, id -> new ObPartitionLocationInfo());
    }

    public Map<Long, ObPartitionLocation> getPartitionLocation() {
        return this.partitionLocation;
    }

    public void setPartitionLocation(Map<Long, ObPartitionLocation> partitionLocation) {
        this.partitionLocation = partitionLocation;
    }

    public Map<Long, Long> getTabletLsIdMap() {
        return this.tabletLsIdMap;
    }

    public void setTabletLsIdMap(Map<Long, Long> tabletLsIdMap) {
        this.tabletLsIdMap = tabletLsIdMap;
    }

    public long getLsId(long tabletId) {
        return this.tabletLsIdMap.get(tabletId);
    }

    public ObPartitionLocation getPartitionLocationWithPartId(long partId) {
        return this.partitionLocation.get(partId);
    }

    public ObPartitionLocation getPartitionLocationWithTabletId(long tabletId) {
        return this.partitionLocation.get(tabletId);
    }

    public ObPartitionLocation putPartitionLocationWithPartId(long partId, ObPartitionLocation ObpartitionLocation) {
        return this.partitionLocation.put(partId, ObpartitionLocation);
    }

    public ObPartitionLocation putPartitionLocationWithTabletId(long tabletId, ObPartitionLocation ObpartitionLocation) {
        return this.partitionLocation.put(tabletId, ObpartitionLocation);
    }

    public void prepareForWeakRead(ObServerLdcLocation ldcLocation) {
        for (Map.Entry<Long, ObPartitionLocation> entry : this.partitionLocation.entrySet()) {
            entry.getValue().prepareForWeakRead(ldcLocation);
        }
    }

    public String toString() {
        return "ObPartitionEntry{partitionLocation=" + this.partitionLocation + '}';
    }
}

