/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model.partition;

import com.alipay.oceanbase.rpc.exception.ObTablePartitionConsistentException;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartFuncType;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartitionKey;
import com.alipay.oceanbase.rpc.mutation.Row;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObColumn;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.column.ObSimpleColumn;
import com.alipay.oceanbase.rpc.util.StringUtil;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public abstract class ObPartDesc {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObPartDesc.class);
    private ObPartFuncType partFuncType = ObPartFuncType.UNKNOWN;
    private String partExpr = "";
    protected List<String> orderedPartColumnNames = Collections.EMPTY_LIST;
    protected List<ObPair<ObColumn, List<Integer>>> orderedPartRefColumnRowKeyRelations = Collections.EMPTY_LIST;
    protected List<ObColumn> partColumns = Collections.EMPTY_LIST;
    private Map<String, Long> partNameIdMap = null;
    public static final ObPartitionKey DEFAULT_PART_KEY = ObPartitionKey.getInstance(Collections.singletonList(ObSimpleColumn.DEFAULT_UTF8MB4_GENERAL_CI), new Comparable[]{"default"});
    protected Map<String, Integer> rowKeyElement = Collections.EMPTY_MAP;

    public ObPartFuncType getPartFuncType() {
        return this.partFuncType;
    }

    public void setPartFuncType(ObPartFuncType partFuncType) {
        this.partFuncType = partFuncType;
    }

    public String getPartExpr() {
        return this.partExpr;
    }

    public void setPartExpr(String partExpr) {
        if (StringUtil.isBlank(partExpr)) {
            throw new IllegalArgumentException("ObKeyPartDesc part express is blank");
        }
        this.partExpr = partExpr.replace(" ", "");
        this.orderedPartColumnNames = Collections.unmodifiableList(Arrays.asList(this.partExpr.split(",")));
    }

    public int getPartNum() {
        return -1;
    }

    public List<String> getOrderedPartColumnNames() {
        return this.orderedPartColumnNames;
    }

    public List<ObColumn> getPartColumns() {
        return this.partColumns;
    }

    public void setPartColumns(List<ObColumn> partColumns) {
        this.partColumns = partColumns;
    }

    public Map<String, Long> getPartNameIdMap() {
        return this.partNameIdMap;
    }

    public void setPartNameIdMap(Map<String, Long> partNameIdMap) {
        this.partNameIdMap = partNameIdMap;
    }

    public Map<String, Integer> getRowKeyElement() {
        return this.rowKeyElement;
    }

    public void setRowKeyElement(Map<String, Integer> rowKeyElement) {
        this.rowKeyElement = rowKeyElement;
    }

    protected List<Comparable> initComparableElementByTypes(List<Object> objects, List<ObColumn> obColumns) {
        ArrayList<Comparable> comparableElement = new ArrayList<Comparable>(objects.size());
        try {
            for (int i = 0; i < objects.size(); ++i) {
                ObColumn obColumn = obColumns.get(i);
                if (objects.get(i) instanceof ObObj) {
                    ObObj obj = (ObObj)objects.get(i);
                    if (obj.isMinObj()) {
                        comparableElement.add(ObPartitionKey.MIN_PARTITION_ELEMENT);
                        continue;
                    }
                    if (obj.isMaxObj()) {
                        comparableElement.add(ObPartitionKey.MAX_PARTITION_ELEMENT);
                        continue;
                    }
                    throw new IllegalArgumentException(String.format("failed to cast obj, obj=%s, types=%s", objects, obColumns));
                }
                comparableElement.add(obColumn.getObObjType().parseToComparable(objects.get(i), obColumn.getObCollationType()));
            }
        }
        catch (Exception e) {
            logger.error(TableClientLoggerFactory.LCD.convert("01-00024"), new Object[]{objects, obColumns, e});
            throw new IllegalArgumentException(String.format("failed to cast obj, obj=%s, types=%s", objects, obColumns), e);
        }
        return comparableElement;
    }

    public void prepare() throws IllegalArgumentException {
    }

    public List<Object> evalRowKeyValues(Row row) throws IllegalArgumentException {
        int partColumnSize = this.partColumns.size();
        ArrayList<Object> evalValues = new ArrayList<Object>(partColumnSize);
        Object[] rowValues = row.getValues();
        String[] rowColumnNames = row.getColumns();
        if (rowValues.length < partColumnSize) {
            throw new IllegalArgumentException("Input row key should at least include " + this.partColumns + "but found" + Arrays.toString(rowValues));
        }
        boolean needEval = true;
        for (int i = 0; i < this.partColumns.size(); ++i) {
            ObColumn curObColumn = this.partColumns.get(i);
            List<String> curObRefColumnNames = curObColumn.getRefColumnNames();
            Object[] evalParams = new Object[curObRefColumnNames.size()];
            block1: for (int j = 0; j < curObRefColumnNames.size(); ++j) {
                for (int k = 0; k < rowColumnNames.length; ++k) {
                    ObObj obj;
                    if (!rowColumnNames[k].equalsIgnoreCase(curObRefColumnNames.get(j))) continue;
                    if (curObRefColumnNames.size() == 1 && rowValues[k] instanceof ObObj && ((obj = (ObObj)rowValues[k]).isMaxObj() || obj.isMinObj())) {
                        evalValues.add(obj);
                        needEval = false;
                        continue block1;
                    }
                    evalParams[j] = rowValues[k];
                    continue block1;
                }
            }
            if (!needEval) continue;
            evalValues.add(curObColumn.evalValue(evalParams));
        }
        return evalValues;
    }

    public abstract List<Long> getPartIds(Object var1, boolean var2, Object var3, boolean var4) throws IllegalArgumentException;

    public abstract Long getPartId(Object ... var1) throws IllegalArgumentException;

    public abstract Long getPartId(List<Object> var1, boolean var2) throws IllegalArgumentException, ObTablePartitionConsistentException;

    public abstract Long getRandomPartId();

    public abstract void setPartNum(int var1);
}

