/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model;

import com.alipay.oceanbase.rpc.exception.ObTableServerCacheExpiredException;
import com.alipay.oceanbase.rpc.location.model.ObServerAddr;
import com.alipay.oceanbase.rpc.location.model.ObServerLdcLocation;
import com.alipay.oceanbase.rpc.util.RandomUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class ServerRoster {
    private AtomicInteger maxPriority = new AtomicInteger(0);
    private AtomicReference<List<ObServerAddr>> roster = new AtomicReference(new ArrayList());
    private AtomicReference<ObServerLdcLocation> serverLdc = new AtomicReference();

    public void reset(List<ObServerAddr> members) {
        this.maxPriority.set(0);
        this.roster.set(members);
    }

    public void resetServerLdc(ObServerLdcLocation serverLdc) {
        this.serverLdc.set(serverLdc);
    }

    public void upgradeMaxPriority(long priority) {
        if ((long)this.maxPriority.get() >= priority) {
            return;
        }
        if (priority == 0L) {
            this.maxPriority.set(0);
            return;
        }
        this.resetMaxPriority();
    }

    public void downgradeMaxPriority(long priority) {
        if ((long)this.maxPriority.get() <= priority) {
            return;
        }
        this.resetMaxPriority();
    }

    public void resetMaxPriority() {
        if (this.roster.get().size() == 0) {
            this.maxPriority.set(0);
        }
        int priority = Integer.MIN_VALUE;
        for (ObServerAddr obServerAddr : this.roster.get()) {
            if (obServerAddr.getPriority().get() <= priority) continue;
            priority = obServerAddr.getPriority().get();
        }
        this.maxPriority.set(priority);
    }

    public int getMaxPriority() {
        return this.maxPriority.get();
    }

    public List<ObServerAddr> getMembers() {
        return this.roster.get();
    }

    public AtomicReference<List<ObServerAddr>> getRoster() {
        return this.roster;
    }

    public ObServerLdcLocation getServerLdcLocation() {
        return this.serverLdc.get();
    }

    public ObServerAddr getServer(long priorityTimeout, long cachingTimeout) {
        long gradeTime = System.currentTimeMillis();
        ArrayList<ObServerAddr> randomList = new ArrayList<ObServerAddr>();
        int maxPriority = this.getMaxPriority();
        for (ObServerAddr obServerAddr : this.getMembers()) {
            if (obServerAddr.getPriority().get() != maxPriority && gradeTime - obServerAddr.getGrantPriorityTime() <= priorityTimeout) continue;
            randomList.add(obServerAddr);
        }
        ObServerAddr addr = (ObServerAddr)randomList.get(RandomUtil.getRandomNum(0, randomList.size()));
        if (addr.isExpired(cachingTimeout)) {
            throw new ObTableServerCacheExpiredException("server addr is expired : " + addr);
        }
        addr.recordAccess();
        return addr;
    }

    public void resetPriority(ObServerAddr addr) {
        if (addr.getPriority().get() != 0) {
            long grantPriorityTime = System.currentTimeMillis();
            addr.setGrantPriorityTime(grantPriorityTime);
            addr.getPriority().set(0);
            this.upgradeMaxPriority(0L);
        }
    }

    public void downgradePriority(ObServerAddr addr) {
        long grantPriorityTime = System.currentTimeMillis();
        addr.setGrantPriorityTime(grantPriorityTime);
        this.downgradeMaxPriority(addr.getPriority().decrementAndGet());
    }

    public String toString() {
        return "ServerRoster{maxPriority=" + this.maxPriority + ", roster=" + this.roster + ", serverLdc=" + this.serverLdc + '}';
    }
}

