/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load.protocol.v0.payload.impl;

import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObTableLoadClientStatus;
import com.alipay.oceanbase.rpc.protocol.payload.ObSimplePayload;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import com.alipay.oceanbase.rpc.util.ObByteBuf;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;

public class ObTableDirectLoadBeginRes
implements ObSimplePayload {
    private long tableId = 0L;
    private long taskId = 0L;
    private String[] columnNames = new String[0];
    private ObTableLoadClientStatus status = ObTableLoadClientStatus.MAX_STATUS;
    private int errorCode;

    public ObTableDirectLoadBeginRes() {
        this.errorCode = ResultCodes.OB_SUCCESS.errorCode;
    }

    public long getTableId() {
        return this.tableId;
    }

    public void setTableId(long tableId) {
        this.tableId = tableId;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        if (columnNames == null) {
            throw new NullPointerException();
        }
        this.columnNames = columnNames;
    }

    public ObTableLoadClientStatus getStatus() {
        return this.status;
    }

    public void setStatus(ObTableLoadClientStatus status) {
        this.status = status;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String toString() {
        return String.format("{tableId:%d, taskId:%d, columnNames:%s, status:%s, errorCode:%d}", new Object[]{this.tableId, this.taskId, Arrays.toString(this.columnNames), this.status, this.errorCode});
    }

    @Override
    public byte[] encode() {
        int needBytes = this.getEncodedSize();
        ObByteBuf buf = new ObByteBuf(needBytes);
        this.encode(buf);
        return buf.bytes;
    }

    @Override
    public void encode(ObByteBuf buf) {
        Serialization.encodeVi64(buf, this.tableId);
        Serialization.encodeVi64(buf, this.taskId);
        Serialization.encodeVStringArray(buf, this.columnNames);
        Serialization.encodeI8(buf, this.status.getByteValue());
        Serialization.encodeVi32(buf, this.errorCode);
    }

    @Override
    public ObTableDirectLoadBeginRes decode(ByteBuf buf) {
        this.tableId = Serialization.decodeVi64(buf);
        this.taskId = Serialization.decodeVi64(buf);
        this.columnNames = Serialization.decodeVStringArray(buf);
        this.status = ObTableLoadClientStatus.valueOf(Serialization.decodeI8(buf));
        this.errorCode = Serialization.decodeVi32(buf);
        return this;
    }

    @Override
    public int getEncodedSize() {
        int len = 0;
        len += Serialization.getNeedBytes(this.tableId);
        len += Serialization.getNeedBytes(this.taskId);
        len += Serialization.getNeedBytes(this.columnNames);
        ++len;
        return len += Serialization.getNeedBytes(this.errorCode);
    }
}

