/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load.execution;

import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadConnection;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadStatement;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadExceptionUtil;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadRpcException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadRpcTimeoutException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadServerException;
import com.alipay.oceanbase.rpc.direct_load.execution.ObDirectLoadStatementExecutor;
import com.alipay.oceanbase.rpc.direct_load.future.ObDirectLoadStatementAsyncPromiseTask;
import com.alipay.oceanbase.rpc.direct_load.protocol.ObDirectLoadProtocol;
import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObDirectLoadGetStatusRpc;
import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObDirectLoadHeartBeatRpc;
import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObTableLoadClientStatus;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import com.alipay.oceanbase.rpc.table.ObTable;
import java.util.concurrent.TimeUnit;

public class ObDirectLoadStatementHeartBeatTask
extends ObDirectLoadStatementAsyncPromiseTask {
    private final ObDirectLoadConnection connection;
    private final ObDirectLoadProtocol protocol;
    private final ObDirectLoadStatementExecutor executor;
    private final ObDirectLoadStatementExecutor.HeartBeatProxy proxy;
    private boolean isRunning = false;
    private boolean isCancel = false;

    public ObDirectLoadStatementHeartBeatTask(ObDirectLoadStatement statement, ObDirectLoadStatementExecutor executor) {
        super(statement);
        this.connection = statement.getConnection();
        this.protocol = this.connection.getProtocol();
        this.executor = executor;
        this.proxy = executor.getHeartBeatProxy();
    }

    public synchronized boolean cancel() {
        this.isCancel = true;
        return !this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            ObDirectLoadStatementHeartBeatTask obDirectLoadStatementHeartBeatTask = this;
            synchronized (obDirectLoadStatementHeartBeatTask) {
                this.isRunning = true;
                if (this.isCancel) {
                    this.setSuccess();
                    return;
                }
            }
            this.proxy.checkStatus();
            this.sendHeartBeat();
            obDirectLoadStatementHeartBeatTask = this;
            synchronized (obDirectLoadStatementHeartBeatTask) {
                if (!this.isCancel) return;
                this.setSuccess();
                return;
            }
        }
        catch (ObDirectLoadException e) {
            this.logger.warn("statement heart beat task run failed", e);
            this.proxy.setFailure(e);
            this.setFailure(e);
            return;
        }
        finally {
            ObDirectLoadStatementHeartBeatTask obDirectLoadStatementHeartBeatTask = this;
            synchronized (obDirectLoadStatementHeartBeatTask) {
                this.isRunning = false;
            }
        }
    }

    private void sendHeartBeat() throws ObDirectLoadException {
        block15: {
            try {
                int errorCode;
                ObTableLoadClientStatus status;
                block14: {
                    status = ObTableLoadClientStatus.MAX_STATUS;
                    errorCode = ResultCodes.OB_SUCCESS.errorCode;
                    try {
                        ObDirectLoadHeartBeatRpc rpc = this.doSendHeartBeat();
                        status = rpc.getStatus();
                        errorCode = rpc.getErrorCode();
                    }
                    catch (ObDirectLoadException e) {
                        int ret;
                        this.logger.warn("statement send heart beat rpc failed", e);
                        boolean sendGetStatus = false;
                        if (e instanceof ObDirectLoadServerException && (ret = ((ObDirectLoadServerException)e).getErrorCode()) == ResultCodes.OB_ENTRY_NOT_EXIST.errorCode) {
                            sendGetStatus = true;
                            try {
                                ObDirectLoadGetStatusRpc rpc2 = this.doSendGetStatus();
                                status = rpc2.getStatus();
                                errorCode = rpc2.getErrorCode();
                            }
                            catch (ObDirectLoadException e2) {
                                this.logger.warn("statement send get status rpc failed", e2);
                                throw e2;
                            }
                        }
                        if (sendGetStatus) break block14;
                        throw e;
                    }
                }
                switch (status) {
                    case INITIALIZING: 
                    case WAITTING: 
                    case RUNNING: 
                    case COMMITTING: 
                    case COMMIT: {
                        this.schedule(this.connection.getHeartBeatInterval(), TimeUnit.MILLISECONDS);
                        break;
                    }
                    case ERROR: {
                        this.logger.warn("statement server status is error, errorCode:" + errorCode);
                        throw ObDirectLoadExceptionUtil.convertException(status, errorCode);
                    }
                    case ABORT: {
                        this.logger.warn("statement server status is abort, errorCode:" + errorCode);
                        if (errorCode == ResultCodes.OB_SUCCESS.errorCode) {
                            errorCode = ResultCodes.OB_CANCELED.errorCode;
                        }
                        throw ObDirectLoadExceptionUtil.convertException(status, errorCode);
                    }
                    default: {
                        this.logger.warn("statement server status is unexpected, status:" + (Object)((Object)status));
                        throw ObDirectLoadExceptionUtil.convertException(status, errorCode);
                    }
                }
            }
            catch (ObDirectLoadException e) {
                this.logger.warn("statement send heart beat failed", e);
                boolean canRetry = false;
                if (e instanceof ObDirectLoadRpcException && e instanceof ObDirectLoadRpcTimeoutException) {
                    canRetry = true;
                    this.schedule(500L, TimeUnit.MILLISECONDS);
                }
                if (canRetry) break block15;
                throw e;
            }
        }
    }

    private ObDirectLoadHeartBeatRpc doSendHeartBeat() throws ObDirectLoadException {
        ObTable table = this.statement.getObTablePool().getHighPrioObTable();
        long timeoutMillis = this.statement.getTimeoutRemain();
        ObDirectLoadHeartBeatRpc rpc = this.protocol.getHeartBeatRpc(this.executor.getTraceId());
        rpc.setSvrAddr(this.executor.getSvrAddr());
        rpc.setTableId(this.executor.getTableId());
        rpc.setTaskId(this.executor.getTaskId());
        this.logger.info("statement send heart beat rpc, arg:" + rpc.getArg());
        this.connection.executeWithConnection(rpc, table, timeoutMillis);
        this.logger.info("statement heart beat rpc response successful, res:" + rpc.getRes());
        return rpc;
    }

    private ObDirectLoadGetStatusRpc doSendGetStatus() throws ObDirectLoadException {
        ObTable table = this.statement.getObTablePool().getControlObTable();
        long timeoutMillis = this.statement.getTimeoutRemain();
        ObDirectLoadGetStatusRpc rpc = this.protocol.getGetStatusRpc(this.executor.getTraceId());
        rpc.setSvrAddr(this.executor.getSvrAddr());
        rpc.setTableId(this.executor.getTableId());
        rpc.setTaskId(this.executor.getTaskId());
        this.logger.debug("statement send get status rpc, arg:" + rpc.getArg());
        this.connection.executeWithConnection(rpc, table, timeoutMillis);
        this.logger.debug("statement get status rpc response successful, res:" + rpc.getRes());
        return rpc;
    }
}

