/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.web.annotation.RoleEnum;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.SystemUpdateUserPasswordRequestVO;
import com.aizuda.snailjob.server.web.model.request.SystemUserQueryVO;
import com.aizuda.snailjob.server.web.model.request.SystemUserRequestVO;
import com.aizuda.snailjob.server.web.model.request.UserPermissionRequestVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.response.PermissionsResponseVO;
import com.aizuda.snailjob.server.web.model.response.SystemUserResponseVO;
import com.aizuda.snailjob.server.web.service.SystemUserService;
import com.aizuda.snailjob.server.web.service.convert.NamespaceResponseVOConverter;
import com.aizuda.snailjob.server.web.service.convert.PermissionsResponseVOConverter;
import com.aizuda.snailjob.server.web.service.convert.SystemUserResponseVOConverter;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.persistence.mapper.NamespaceMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.SystemUserMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.SystemUserPermissionMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Namespace;
import com.aizuda.snailjob.template.datasource.persistence.po.SystemUser;
import com.aizuda.snailjob.template.datasource.persistence.po.SystemUserPermission;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SystemUserServiceImpl
implements SystemUserService {
    public static final long EXPIRE_TIME = 86400000L;
    private final SystemUserMapper systemUserMapper;
    private final SystemUserPermissionMapper systemUserPermissionMapper;
    private final NamespaceMapper namespaceMapper;

    private static void validateUserPassword(SystemUserRequestVO requestVO, SystemUser systemUser) {
        if (Objects.isNull(systemUser)) {
            throw new SnailJobServerException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        if (!SecureUtil.sha256((String)requestVO.getPassword()).equals(systemUser.getPassword())) {
            throw new SnailJobServerException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
    }

    @Override
    public SystemUserResponseVO login(SystemUserRequestVO requestVO) {
        SystemUser systemUser = (SystemUser)this.systemUserMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SystemUser::getUsername, (Object)requestVO.getUsername().trim()));
        SystemUserServiceImpl.validateUserPassword(requestVO, systemUser);
        String token = this.getToken(systemUser);
        SystemUserResponseVO systemUserResponseVO = SystemUserResponseVOConverter.INSTANCE.convert(systemUser);
        systemUserResponseVO.setToken(token);
        this.getPermission(systemUser.getRole(), systemUser.getId(), systemUserResponseVO);
        return systemUserResponseVO;
    }

    private void getPermission(Integer role, Long userId, SystemUserResponseVO systemUserResponseVO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select(new SFunction[]{Namespace::getId, Namespace::getUniqueId, Namespace::getName});
        if (RoleEnum.USER.getRoleId().equals(role)) {
            List systemUserPermissions = this.systemUserPermissionMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{SystemUserPermission::getNamespaceId}).eq(SystemUserPermission::getSystemUserId, (Object)userId)).groupBy(SystemUserPermission::getNamespaceId));
            queryWrapper.in(Namespace::getUniqueId, (Collection)StreamUtils.toSet((Collection)systemUserPermissions, SystemUserPermission::getNamespaceId));
        }
        List namespaces = this.namespaceMapper.selectList((Wrapper)queryWrapper);
        systemUserResponseVO.setNamespaceIds(NamespaceResponseVOConverter.INSTANCE.convertList(namespaces));
    }

    @Override
    public SystemUserResponseVO getUserInfo(UserSessionVO systemUser) {
        SystemUserResponseVO systemUserResponseVO = SystemUserResponseVOConverter.INSTANCE.convert(systemUser);
        this.getPermission(systemUser.getRole(), systemUser.getId(), systemUserResponseVO);
        return systemUserResponseVO;
    }

    @Override
    @Transactional
    public void addUser(SystemUserRequestVO requestVO) {
        long count = this.systemUserMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SystemUser::getUsername, (Object)requestVO.getUsername()));
        if (count > 0L) {
            throw new SnailJobServerException("\u8be5\u7528\u6237\u5df2\u5b58\u5728");
        }
        SystemUser systemUser = new SystemUser();
        systemUser.setUsername(requestVO.getUsername());
        systemUser.setPassword(SecureUtil.sha256((String)requestVO.getPassword()));
        systemUser.setRole(requestVO.getRole());
        Assert.isTrue((1 == this.systemUserMapper.insert((Object)systemUser) ? 1 : 0) != 0, () -> new SnailJobServerException("\u65b0\u589e\u7528\u6237\u5931\u8d25"));
        List<UserPermissionRequestVO> groupNameList = requestVO.getPermissions();
        if (CollUtil.isEmpty(groupNameList) || RoleEnum.ADMIN.getRoleId().equals(requestVO.getRole())) {
            return;
        }
        for (UserPermissionRequestVO permission : groupNameList) {
            SystemUserPermission systemUserPermission = new SystemUserPermission();
            systemUserPermission.setSystemUserId(systemUser.getId());
            systemUserPermission.setGroupName(permission.getGroupName());
            systemUserPermission.setNamespaceId(permission.getNamespaceId());
            Assert.isTrue((1 == this.systemUserPermissionMapper.insert((Object)systemUserPermission) ? 1 : 0) != 0, () -> new SnailJobServerException("\u65b0\u589e\u7528\u6237\u6743\u9650\u5931\u8d25"));
        }
    }

    @Override
    @Transactional
    public void update(SystemUserRequestVO requestVO) {
        long count;
        SystemUser systemUser = (SystemUser)this.systemUserMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SystemUser::getId, (Object)requestVO.getId()));
        if (Objects.isNull(systemUser)) {
            throw new SnailJobServerException("\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (!systemUser.getUsername().equals(requestVO.getUsername()) && (count = this.systemUserMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SystemUser::getUsername, (Object)requestVO.getUsername())).longValue()) > 0L) {
            throw new SnailJobServerException("\u8be5\u7528\u6237\u5df2\u5b58\u5728");
        }
        systemUser.setUsername(requestVO.getUsername());
        if (StrUtil.isNotBlank((CharSequence)requestVO.getPassword())) {
            systemUser.setPassword(SecureUtil.sha256((String)requestVO.getPassword()));
        }
        systemUser.setRole(requestVO.getRole());
        Assert.isTrue((1 == this.systemUserMapper.updateById((Object)systemUser) ? 1 : 0) != 0, () -> new SnailJobServerException("\u66f4\u65b0\u7528\u6237\u5931\u8d25"));
        List<UserPermissionRequestVO> permissions = requestVO.getPermissions();
        if (CollUtil.isEmpty(permissions) || RoleEnum.ADMIN.getRoleId().equals(requestVO.getRole())) {
            return;
        }
        this.systemUserPermissionMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SystemUserPermission::getSystemUserId, (Object)systemUser.getId()));
        for (UserPermissionRequestVO permission : permissions) {
            SystemUserPermission systemUserPermission = new SystemUserPermission();
            systemUserPermission.setSystemUserId(systemUser.getId());
            systemUserPermission.setGroupName(permission.getGroupName());
            systemUserPermission.setNamespaceId(permission.getNamespaceId());
            Assert.isTrue((1 == this.systemUserPermissionMapper.insert((Object)systemUserPermission) ? 1 : 0) != 0, () -> new SnailJobServerException("\u66f4\u65b0\u7528\u6237\u6743\u9650\u5931\u8d25"));
        }
    }

    @Override
    public PageResult<List<SystemUserResponseVO>> getSystemUserPageList(SystemUserQueryVO queryVO) {
        PageDTO userPageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        if (CollUtil.isEmpty((Collection)(userPageDTO = (PageDTO)this.systemUserMapper.selectPage((IPage)userPageDTO, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().likeRight(StrUtil.isNotBlank((CharSequence)queryVO.getUsername()), SystemUser::getUsername, (Object)queryVO.getUsername())).orderByDesc(SystemUser::getId))).getRecords())) {
            return new PageResult<List<SystemUserResponseVO>>(userPageDTO, Collections.emptyList());
        }
        List<SystemUserResponseVO> userResponseVOList = SystemUserResponseVOConverter.INSTANCE.convertList(userPageDTO.getRecords());
        List userPermissions = this.systemUserPermissionMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(SystemUserPermission::getSystemUserId, (Collection)StreamUtils.toSet(userResponseVOList, SystemUserResponseVO::getId)));
        Set uniqueIds = StreamUtils.toSet((Collection)userPermissions, SystemUserPermission::getNamespaceId);
        List namespaces = Lists.newArrayList();
        if (CollUtil.isNotEmpty((Collection)uniqueIds)) {
            namespaces = this.namespaceMapper.selectList((Wrapper)Wrappers.lambdaQuery().select(new SFunction[]{Namespace::getId, Namespace::getUniqueId, Namespace::getName}).in(Namespace::getUniqueId, (Collection)uniqueIds));
        }
        Map namespaceMap = StreamUtils.toMap((Collection)namespaces, Namespace::getUniqueId, Namespace::getName);
        Map userPermissionsMap = StreamUtils.groupByKey((Collection)userPermissions, SystemUserPermission::getSystemUserId);
        userResponseVOList.stream().filter(systemUserResponseVO -> systemUserResponseVO.getRole().equals(RoleEnum.USER.getRoleId())).forEach(systemUserResponseVO -> {
            List userPermissions1 = userPermissionsMap.getOrDefault(systemUserResponseVO.getId(), Lists.newArrayList());
            ArrayList permissionsResponseVOS = Lists.newArrayList();
            for (SystemUserPermission systemUserPermission : userPermissions1) {
                PermissionsResponseVO responseVO = new PermissionsResponseVO();
                responseVO.setGroupName(systemUserPermission.getGroupName());
                responseVO.setNamespaceId(systemUserPermission.getNamespaceId());
                responseVO.setNamespaceName((String)namespaceMap.get(systemUserPermission.getNamespaceId()));
                permissionsResponseVOS.add(responseVO);
            }
            systemUserResponseVO.setPermissions(permissionsResponseVOS);
        });
        return new PageResult<List<SystemUserResponseVO>>(userPageDTO, userResponseVOList);
    }

    @Override
    public SystemUserResponseVO getSystemUserByUserName(String username) {
        SystemUser systemUser = (SystemUser)this.systemUserMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SystemUser::getUsername, (Object)username));
        if (Objects.isNull(systemUser)) {
            throw new SnailJobServerException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        SystemUserResponseVO responseVO = SystemUserResponseVOConverter.INSTANCE.convert(systemUser);
        this.getPermission(systemUser.getRole(), systemUser.getId(), responseVO);
        List systemUserPermissions = this.systemUserPermissionMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SystemUserPermission::getNamespaceId, SystemUserPermission::getGroupName}).eq(SystemUserPermission::getSystemUserId, (Object)responseVO.getId()));
        responseVO.setPermissions(PermissionsResponseVOConverter.INSTANCE.convertList(systemUserPermissions));
        return responseVO;
    }

    @Override
    public List<PermissionsResponseVO> getSystemUserPermissionByUserName(Long id) {
        List systemUserPermissions = this.systemUserPermissionMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SystemUserPermission::getNamespaceId, SystemUserPermission::getGroupName}).eq(SystemUserPermission::getSystemUserId, (Object)id));
        if (CollUtil.isEmpty((Collection)systemUserPermissions)) {
            return Lists.newArrayList();
        }
        Map permissionsMap = StreamUtils.groupByKey((Collection)systemUserPermissions, SystemUserPermission::getNamespaceId);
        List namespaces = this.namespaceMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{Namespace::getId, Namespace::getUniqueId, Namespace::getName}).in(Namespace::getUniqueId, permissionsMap.keySet()));
        Map map = StreamUtils.toMap((Collection)namespaces, Namespace::getUniqueId, Namespace::getName);
        ArrayList<PermissionsResponseVO> response = new ArrayList<PermissionsResponseVO>();
        permissionsMap.forEach((namespaceId, values) -> {
            PermissionsResponseVO responseVO = new PermissionsResponseVO();
            responseVO.setNamespaceName((String)map.get(namespaceId));
            responseVO.setNamespaceId((String)namespaceId);
            responseVO.setGroupNames(StreamUtils.toSet((Collection)values, SystemUserPermission::getGroupName));
            response.add(responseVO);
        });
        return response;
    }

    @Override
    public void updateUserPassword(SystemUpdateUserPasswordRequestVO requestVO) {
        Long userId = UserSessionUtils.currentUserSession().getId();
        SystemUser systemUser = (SystemUser)this.systemUserMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SystemUser::getId, (Object)userId));
        if (Objects.isNull(systemUser)) {
            throw new SnailJobServerException("\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (!SecureUtil.sha256((String)requestVO.getOldPassword()).equals(systemUser.getPassword())) {
            throw new SnailJobServerException("\u7528\u6237\u539f\u5bc6\u7801\u9519\u8bef");
        }
        systemUser.setPassword(SecureUtil.sha256((String)requestVO.getNewPassword()));
        Assert.isTrue((1 == this.systemUserMapper.updateById((Object)systemUser) ? 1 : 0) != 0, () -> new SnailJobServerException("\u66f4\u65b0\u7528\u6237\u5bc6\u7801\u5931\u8d25"));
    }

    @Override
    public List<SystemUserResponseVO> getSystemUserList() {
        List systemUsers = this.systemUserMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SystemUser::getId, SystemUser::getUsername}));
        return SystemUserResponseVOConverter.INSTANCE.convertList(systemUsers);
    }

    @Override
    @Transactional
    public boolean delUser(Long id) {
        this.systemUserPermissionMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SystemUserPermission::getSystemUserId, (Object)id));
        return 1 == this.systemUserMapper.deleteById((Serializable)id);
    }

    private String getToken(SystemUser systemUser) {
        String sign = systemUser.getPassword();
        return JWT.create().withExpiresAt(new Date(System.currentTimeMillis() + 86400000L)).withAudience(new String[]{JsonUtil.toJsonString((Object)SystemUserResponseVOConverter.INSTANCE.convert(systemUser))}).sign(Algorithm.HMAC256((String)sign));
    }

    @Generated
    public SystemUserServiceImpl(SystemUserMapper systemUserMapper, SystemUserPermissionMapper systemUserPermissionMapper, NamespaceMapper namespaceMapper) {
        this.systemUserMapper = systemUserMapper;
        this.systemUserPermissionMapper = systemUserPermissionMapper;
        this.namespaceMapper = namespaceMapper;
    }
}

