/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.NotifyConfigQueryVO;
import com.aizuda.snailjob.server.web.model.request.NotifyConfigRequestVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.response.NotifyConfigResponseVO;
import com.aizuda.snailjob.server.web.service.NotifyConfigService;
import com.aizuda.snailjob.server.web.service.convert.NotifyConfigConverter;
import com.aizuda.snailjob.server.web.service.convert.NotifyConfigResponseVOConverter;
import com.aizuda.snailjob.server.web.service.handler.SyncConfigHandler;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.ConfigAccess;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyConfig;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class NotifyConfigServiceImpl
implements NotifyConfigService {
    private final AccessTemplate accessTemplate;

    @Override
    public PageResult<List<NotifyConfigResponseVO>> getNotifyConfigList(NotifyConfigQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        List<String> groupNames = UserSessionUtils.getGroupNames(queryVO.getGroupName());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        List notifyConfigs = this.accessTemplate.getNotifyConfigAccess().listPage(pageDTO, (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NotifyConfig::getNamespaceId, (Object)userSessionVO.getNamespaceId())).in(CollUtil.isNotEmpty(groupNames), NotifyConfig::getGroupName, groupNames)).eq(StrUtil.isNotBlank((CharSequence)queryVO.getGroupName()), NotifyConfig::getGroupName, (Object)queryVO.getGroupName())).eq(Objects.nonNull(queryVO.getNotifyStatus()), NotifyConfig::getNotifyStatus, (Object)queryVO.getNotifyStatus())).eq(Objects.nonNull(queryVO.getSystemTaskType()), NotifyConfig::getSystemTaskType, (Object)queryVO.getSystemTaskType())).likeRight(StrUtil.isNotBlank((CharSequence)queryVO.getNotifyName()), NotifyConfig::getNotifyName, (Object)queryVO.getNotifyName())).orderByDesc(NotifyConfig::getId)).getRecords();
        if (CollUtil.isEmpty((Collection)notifyConfigs)) {
            return new PageResult<List<NotifyConfigResponseVO>>(pageDTO, Lists.newArrayList());
        }
        List<NotifyConfigResponseVO> notifyConfigResponseVOS = NotifyConfigResponseVOConverter.INSTANCE.convertList(notifyConfigs);
        return new PageResult<List<NotifyConfigResponseVO>>(pageDTO, notifyConfigResponseVOS);
    }

    @Override
    public List<NotifyConfig> getNotifyConfigBySystemTaskTypeList(Integer systemTaskType) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        List notifyConfigList = this.accessTemplate.getNotifyConfigAccess().list((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{NotifyConfig::getId, NotifyConfig::getNotifyName}).eq(NotifyConfig::getNamespaceId, (Object)namespaceId)).eq(NotifyConfig::getSystemTaskType, (Object)systemTaskType)).orderByDesc(NotifyConfig::getId));
        return notifyConfigList;
    }

    @Override
    public Boolean saveNotify(NotifyConfigRequestVO requestVO) {
        NotifyConfig notifyConfig = NotifyConfigConverter.INSTANCE.convert(requestVO);
        notifyConfig.setCreateDt(LocalDateTime.now());
        notifyConfig.setRecipientIds(JsonUtil.toJsonString(requestVO.getRecipientIds()));
        notifyConfig.setNamespaceId(UserSessionUtils.currentUserSession().getNamespaceId());
        ConfigAccess notifyConfigAccess = this.accessTemplate.getNotifyConfigAccess();
        Assert.isTrue((1 == notifyConfigAccess.insert((Object)notifyConfig) ? 1 : 0) != 0, () -> new SnailJobServerException("failed to insert notify. sceneConfig:[{}]", new Object[]{JsonUtil.toJsonString((Object)notifyConfig)}));
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateNotify(NotifyConfigRequestVO requestVO) {
        Assert.notNull((Object)requestVO.getId(), () -> new SnailJobServerException("\u53c2\u6570\u5f02\u5e38"));
        NotifyConfig notifyConfig = NotifyConfigConverter.INSTANCE.convert(requestVO);
        notifyConfig.setRecipientIds(JsonUtil.toJsonString(requestVO.getRecipientIds()));
        notifyConfig.setNamespaceId(null);
        Assert.isTrue((1 == this.accessTemplate.getNotifyConfigAccess().updateById((Object)notifyConfig) ? 1 : 0) != 0, () -> new SnailJobServerException("failed to update notify. sceneConfig:[{}]", new Object[]{JsonUtil.toJsonString((Object)notifyConfig)}));
        return Boolean.TRUE;
    }

    @Override
    public NotifyConfigResponseVO getNotifyConfigDetail(Long id) {
        NotifyConfig notifyConfig = (NotifyConfig)this.accessTemplate.getNotifyConfigAccess().one((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NotifyConfig::getId, (Object)id));
        return NotifyConfigResponseVOConverter.INSTANCE.convert(notifyConfig);
    }

    @Override
    public Boolean updateStatus(Long id, Integer status) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        NotifyConfig notifyConfig = (NotifyConfig)this.accessTemplate.getNotifyConfigAccess().one((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NotifyConfig::getId, (Object)id)).eq(NotifyConfig::getNamespaceId, (Object)namespaceId));
        Assert.notNull((Object)notifyConfig, () -> new SnailJobServerException("\u901a\u77e5\u914d\u7f6e\u4e0d\u5b58\u5728"));
        SyncConfigHandler.addSyncTask(notifyConfig.getGroupName(), namespaceId);
        NotifyConfig config = new NotifyConfig();
        config.setNotifyStatus(status);
        config.setUpdateDt(LocalDateTime.now());
        int update = this.accessTemplate.getNotifyConfigAccess().update((Object)config, (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(NotifyConfig::getNamespaceId, (Object)namespaceId)).eq(NotifyConfig::getId, (Object)id));
        return 1 == update;
    }

    @Override
    public Boolean batchDeleteNotify(Set<Long> ids) {
        return ids.size() == this.accessTemplate.getNotifyConfigAccess().delete((LambdaQueryWrapper)new LambdaQueryWrapper().in(NotifyConfig::getId, ids));
    }

    @Generated
    public NotifyConfigServiceImpl(AccessTemplate accessTemplate) {
        this.accessTemplate = accessTemplate;
    }
}

