/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.web.model.request.JobLogQueryVO;
import com.aizuda.snailjob.server.web.model.response.JobLogResponseVO;
import com.aizuda.snailjob.server.web.service.JobLogService;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobLogMessageMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobLogMessage;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class JobLogServiceImpl
implements JobLogService {
    private final JobLogMessageMapper jobLogMessageMapper;
    private final JobTaskBatchMapper jobTaskBatchMapper;

    @Override
    public JobLogResponseVO getJobLogPage(JobLogQueryVO queryVO) {
        JobLogMessage record;
        PageDTO pageDTO = new PageDTO(1L, (long)queryVO.getSize());
        PageDTO selectPage = (PageDTO)this.jobLogMessageMapper.selectPage((IPage)pageDTO, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{JobLogMessage::getId, JobLogMessage::getLogNum}).ge(JobLogMessage::getId, (Object)queryVO.getStartId())).ge(JobLogMessage::getTaskBatchId, (Object)queryVO.getTaskBatchId())).ge(JobLogMessage::getJobId, (Object)queryVO.getJobId())).eq(JobLogMessage::getTaskId, (Object)queryVO.getTaskId())).orderByAsc(JobLogMessage::getId)).orderByAsc(JobLogMessage::getRealTime));
        List records = selectPage.getRecords();
        if (CollUtil.isEmpty((Collection)records)) {
            JobTaskBatch jobTaskBatch = (JobTaskBatch)this.jobTaskBatchMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(JobTaskBatch::getId, (Object)queryVO.getTaskBatchId()));
            JobLogResponseVO jobLogResponseVO = new JobLogResponseVO();
            if (Objects.isNull(jobTaskBatch) || jobTaskBatch.getUpdateDt().plusSeconds(15L).isBefore(LocalDateTime.now())) {
                jobLogResponseVO.setFinished(Boolean.TRUE);
            }
            jobLogResponseVO.setNextStartId(queryVO.getStartId());
            jobLogResponseVO.setFromIndex(0);
            return jobLogResponseVO;
        }
        Integer fromIndex = Optional.ofNullable(queryVO.getFromIndex()).orElse(0);
        JobLogMessage firstRecord = (JobLogMessage)records.get(0);
        ArrayList ids = Lists.newArrayList((Object[])new Long[]{firstRecord.getId()});
        int total = firstRecord.getLogNum() - fromIndex;
        for (int i = 1; i < records.size() && total + (record = (JobLogMessage)records.get(i)).getLogNum() <= queryVO.getSize(); ++i) {
            total += record.getLogNum().intValue();
            ids.add(record.getId());
        }
        long nextStartId = 0L;
        List<Object> messages = Lists.newArrayList();
        List jobLogMessages = this.jobLogMessageMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(JobLogMessage::getId, (Collection)ids)).orderByAsc(JobLogMessage::getId)).orderByAsc(JobLogMessage::getRealTime));
        for (JobLogMessage jobLogMessage : jobLogMessages) {
            List originalList = (List)JsonUtil.parseObject((String)jobLogMessage.getMessage(), List.class);
            int size = originalList.size() - fromIndex;
            List pageList = originalList.stream().skip(fromIndex.intValue()).limit(queryVO.getSize()).collect(Collectors.toList());
            if (messages.size() + size >= queryVO.getSize()) {
                messages.addAll(pageList);
                nextStartId = jobLogMessage.getId();
                fromIndex = Math.min(fromIndex + queryVO.getSize(), originalList.size() - 1) + 1;
                break;
            }
            messages.addAll(pageList);
            nextStartId = jobLogMessage.getId() + 1L;
            fromIndex = 0;
        }
        messages = messages.stream().sorted(Comparator.comparingLong(o -> Long.parseLong((String)o.get("time_stamp")))).collect(Collectors.toList());
        JobLogResponseVO jobLogResponseVO = new JobLogResponseVO();
        jobLogResponseVO.setMessage(messages);
        jobLogResponseVO.setNextStartId(nextStartId);
        jobLogResponseVO.setFromIndex(fromIndex);
        return jobLogResponseVO;
    }

    @Generated
    public JobLogServiceImpl(JobLogMessageMapper jobLogMessageMapper, JobTaskBatchMapper jobTaskBatchMapper) {
        this.jobLogMessageMapper = jobLogMessageMapper;
        this.jobTaskBatchMapper = jobTaskBatchMapper;
    }
}

