/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transcribe.TranscribeAsyncClient;
import software.amazon.awssdk.services.transcribe.internal.UserAgentUtils;
import software.amazon.awssdk.services.transcribe.model.ListMedicalScribeJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListMedicalScribeJobsResponse;

public class ListMedicalScribeJobsPublisher
implements SdkPublisher<ListMedicalScribeJobsResponse> {
    private final TranscribeAsyncClient client;
    private final ListMedicalScribeJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMedicalScribeJobsPublisher(TranscribeAsyncClient client, ListMedicalScribeJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMedicalScribeJobsPublisher(TranscribeAsyncClient client, ListMedicalScribeJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMedicalScribeJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMedicalScribeJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMedicalScribeJobsResponseFetcher
    implements AsyncPageFetcher<ListMedicalScribeJobsResponse> {
        private ListMedicalScribeJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListMedicalScribeJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMedicalScribeJobsResponse> nextPage(ListMedicalScribeJobsResponse previousPage) {
            if (previousPage == null) {
                return ListMedicalScribeJobsPublisher.this.client.listMedicalScribeJobs(ListMedicalScribeJobsPublisher.this.firstRequest);
            }
            return ListMedicalScribeJobsPublisher.this.client.listMedicalScribeJobs((ListMedicalScribeJobsRequest)((Object)ListMedicalScribeJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

