/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.ssooidc.SsoOidcAsyncClient;
import software.amazon.awssdk.services.ssooidc.SsoOidcServiceClientConfiguration;
import software.amazon.awssdk.services.ssooidc.internal.SsoOidcServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.ssooidc.model.AccessDeniedException;
import software.amazon.awssdk.services.ssooidc.model.AuthorizationPendingException;
import software.amazon.awssdk.services.ssooidc.model.CreateTokenRequest;
import software.amazon.awssdk.services.ssooidc.model.CreateTokenResponse;
import software.amazon.awssdk.services.ssooidc.model.CreateTokenWithIamRequest;
import software.amazon.awssdk.services.ssooidc.model.CreateTokenWithIamResponse;
import software.amazon.awssdk.services.ssooidc.model.ExpiredTokenException;
import software.amazon.awssdk.services.ssooidc.model.InternalServerException;
import software.amazon.awssdk.services.ssooidc.model.InvalidClientException;
import software.amazon.awssdk.services.ssooidc.model.InvalidClientMetadataException;
import software.amazon.awssdk.services.ssooidc.model.InvalidGrantException;
import software.amazon.awssdk.services.ssooidc.model.InvalidRedirectUriException;
import software.amazon.awssdk.services.ssooidc.model.InvalidRequestException;
import software.amazon.awssdk.services.ssooidc.model.InvalidRequestRegionException;
import software.amazon.awssdk.services.ssooidc.model.InvalidScopeException;
import software.amazon.awssdk.services.ssooidc.model.RegisterClientRequest;
import software.amazon.awssdk.services.ssooidc.model.RegisterClientResponse;
import software.amazon.awssdk.services.ssooidc.model.SlowDownException;
import software.amazon.awssdk.services.ssooidc.model.SsoOidcException;
import software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationRequest;
import software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationResponse;
import software.amazon.awssdk.services.ssooidc.model.UnauthorizedClientException;
import software.amazon.awssdk.services.ssooidc.model.UnsupportedGrantTypeException;
import software.amazon.awssdk.services.ssooidc.transform.CreateTokenRequestMarshaller;
import software.amazon.awssdk.services.ssooidc.transform.CreateTokenWithIamRequestMarshaller;
import software.amazon.awssdk.services.ssooidc.transform.RegisterClientRequestMarshaller;
import software.amazon.awssdk.services.ssooidc.transform.StartDeviceAuthorizationRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultSsoOidcAsyncClient
implements SsoOidcAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSsoOidcAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSsoOidcAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"SSO_OIDC#2.35.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CreateTokenResponse> createToken(CreateTokenRequest createTokenRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoOidcAsyncClient.resolveMetricPublishers(clientConfiguration, createTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SSO OIDC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTokenResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRedirectUriException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRedirectUriException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRedirectUriException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ExpiredTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredTokenException::builder).build());
                    }
                    case "UnauthorizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidScopeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidScopeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidScopeException::builder).build());
                    }
                    case "InvalidRequestRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestRegionException::builder).build());
                    }
                    case "SlowDownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SlowDownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SlowDownException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "InvalidClientMetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientMetadataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientMetadataException::builder).build());
                    }
                    case "InvalidGrantException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantException::builder).build());
                    }
                    case "InvalidClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidClientException::builder).build());
                    }
                    case "AuthorizationPendingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationPendingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationPendingException::builder).build());
                    }
                    case "UnsupportedGrantTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedGrantTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedGrantTypeException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateToken").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createTokenRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSsoOidcAsyncClient.lambda$createToken$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSsoOidcAsyncClient.lambda$createToken$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTokenWithIamResponse> createTokenWithIAM(CreateTokenWithIamRequest createTokenWithIamRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTokenWithIamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoOidcAsyncClient.resolveMetricPublishers(clientConfiguration, createTokenWithIamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SSO OIDC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTokenWithIAM");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTokenWithIamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRedirectUriException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRedirectUriException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRedirectUriException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ExpiredTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredTokenException::builder).build());
                    }
                    case "UnauthorizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidScopeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidScopeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidScopeException::builder).build());
                    }
                    case "InvalidRequestRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestRegionException::builder).build());
                    }
                    case "SlowDownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SlowDownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SlowDownException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "InvalidClientMetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientMetadataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientMetadataException::builder).build());
                    }
                    case "InvalidGrantException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantException::builder).build());
                    }
                    case "InvalidClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidClientException::builder).build());
                    }
                    case "AuthorizationPendingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationPendingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationPendingException::builder).build());
                    }
                    case "UnsupportedGrantTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedGrantTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedGrantTypeException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTokenWithIAM").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateTokenWithIamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createTokenWithIamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSsoOidcAsyncClient.lambda$createTokenWithIAM$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSsoOidcAsyncClient.lambda$createTokenWithIAM$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterClientResponse> registerClient(RegisterClientRequest registerClientRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerClientRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoOidcAsyncClient.resolveMetricPublishers(clientConfiguration, registerClientRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SSO OIDC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterClient");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterClientResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRedirectUriException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRedirectUriException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRedirectUriException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ExpiredTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredTokenException::builder).build());
                    }
                    case "UnauthorizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidScopeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidScopeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidScopeException::builder).build());
                    }
                    case "InvalidRequestRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestRegionException::builder).build());
                    }
                    case "SlowDownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SlowDownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SlowDownException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "InvalidClientMetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientMetadataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientMetadataException::builder).build());
                    }
                    case "InvalidGrantException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantException::builder).build());
                    }
                    case "InvalidClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidClientException::builder).build());
                    }
                    case "AuthorizationPendingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationPendingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationPendingException::builder).build());
                    }
                    case "UnsupportedGrantTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedGrantTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedGrantTypeException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterClient").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterClientRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerClientRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSsoOidcAsyncClient.lambda$registerClient$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSsoOidcAsyncClient.lambda$registerClient$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartDeviceAuthorizationResponse> startDeviceAuthorization(StartDeviceAuthorizationRequest startDeviceAuthorizationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDeviceAuthorizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoOidcAsyncClient.resolveMetricPublishers(clientConfiguration, startDeviceAuthorizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SSO OIDC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDeviceAuthorization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDeviceAuthorizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRedirectUriException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRedirectUriException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRedirectUriException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ExpiredTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredTokenException::builder).build());
                    }
                    case "UnauthorizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidScopeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidScopeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidScopeException::builder).build());
                    }
                    case "InvalidRequestRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestRegionException::builder).build());
                    }
                    case "SlowDownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SlowDownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SlowDownException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "InvalidClientMetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientMetadataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientMetadataException::builder).build());
                    }
                    case "InvalidGrantException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantException::builder).build());
                    }
                    case "InvalidClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidClientException::builder).build());
                    }
                    case "AuthorizationPendingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationPendingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationPendingException::builder).build());
                    }
                    case "UnsupportedGrantTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedGrantTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedGrantTypeException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDeviceAuthorization").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartDeviceAuthorizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startDeviceAuthorizationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSsoOidcAsyncClient.lambda$startDeviceAuthorization$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSsoOidcAsyncClient.lambda$startDeviceAuthorization$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final SsoOidcServiceClientConfiguration serviceClientConfiguration() {
        return new SsoOidcServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "sso-oauth";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SsoOidcException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        SsoOidcServiceClientConfigurationBuilder serviceConfigBuilder = new SsoOidcServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$startDeviceAuthorization$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDeviceAuthorization$14(List metricPublishers, MetricCollector apiCallMetricCollector, StartDeviceAuthorizationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerClient$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerClient$10(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterClientResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createTokenWithIAM$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTokenWithIAM$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateTokenWithIamResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createToken$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createToken$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateTokenResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

