/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.KafkaSchemaRegistryAccessConfig;
import software.amazon.awssdk.services.lambda.model.KafkaSchemaRegistryAccessConfigListCopier;
import software.amazon.awssdk.services.lambda.model.KafkaSchemaValidationConfig;
import software.amazon.awssdk.services.lambda.model.KafkaSchemaValidationConfigListCopier;
import software.amazon.awssdk.services.lambda.model.SchemaRegistryEventRecordFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KafkaSchemaRegistryConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KafkaSchemaRegistryConfig> {
    private static final SdkField<String> SCHEMA_REGISTRY_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaRegistryURI").getter(KafkaSchemaRegistryConfig.getter(KafkaSchemaRegistryConfig::schemaRegistryURI)).setter(KafkaSchemaRegistryConfig.setter(Builder::schemaRegistryURI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaRegistryURI").build()}).build();
    private static final SdkField<String> EVENT_RECORD_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventRecordFormat").getter(KafkaSchemaRegistryConfig.getter(KafkaSchemaRegistryConfig::eventRecordFormatAsString)).setter(KafkaSchemaRegistryConfig.setter(Builder::eventRecordFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventRecordFormat").build()}).build();
    private static final SdkField<List<KafkaSchemaRegistryAccessConfig>> ACCESS_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessConfigs").getter(KafkaSchemaRegistryConfig.getter(KafkaSchemaRegistryConfig::accessConfigs)).setter(KafkaSchemaRegistryConfig.setter(Builder::accessConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KafkaSchemaRegistryAccessConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<KafkaSchemaValidationConfig>> SCHEMA_VALIDATION_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SchemaValidationConfigs").getter(KafkaSchemaRegistryConfig.getter(KafkaSchemaRegistryConfig::schemaValidationConfigs)).setter(KafkaSchemaRegistryConfig.setter(Builder::schemaValidationConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaValidationConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KafkaSchemaValidationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_REGISTRY_URI_FIELD, EVENT_RECORD_FORMAT_FIELD, ACCESS_CONFIGS_FIELD, SCHEMA_VALIDATION_CONFIGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KafkaSchemaRegistryConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String schemaRegistryURI;
    private final String eventRecordFormat;
    private final List<KafkaSchemaRegistryAccessConfig> accessConfigs;
    private final List<KafkaSchemaValidationConfig> schemaValidationConfigs;

    private KafkaSchemaRegistryConfig(BuilderImpl builder) {
        this.schemaRegistryURI = builder.schemaRegistryURI;
        this.eventRecordFormat = builder.eventRecordFormat;
        this.accessConfigs = builder.accessConfigs;
        this.schemaValidationConfigs = builder.schemaValidationConfigs;
    }

    public final String schemaRegistryURI() {
        return this.schemaRegistryURI;
    }

    public final SchemaRegistryEventRecordFormat eventRecordFormat() {
        return SchemaRegistryEventRecordFormat.fromValue(this.eventRecordFormat);
    }

    public final String eventRecordFormatAsString() {
        return this.eventRecordFormat;
    }

    public final boolean hasAccessConfigs() {
        return this.accessConfigs != null && !(this.accessConfigs instanceof SdkAutoConstructList);
    }

    public final List<KafkaSchemaRegistryAccessConfig> accessConfigs() {
        return this.accessConfigs;
    }

    public final boolean hasSchemaValidationConfigs() {
        return this.schemaValidationConfigs != null && !(this.schemaValidationConfigs instanceof SdkAutoConstructList);
    }

    public final List<KafkaSchemaValidationConfig> schemaValidationConfigs() {
        return this.schemaValidationConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaRegistryURI());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventRecordFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessConfigs() ? this.accessConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchemaValidationConfigs() ? this.schemaValidationConfigs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KafkaSchemaRegistryConfig)) {
            return false;
        }
        KafkaSchemaRegistryConfig other = (KafkaSchemaRegistryConfig)obj;
        return Objects.equals(this.schemaRegistryURI(), other.schemaRegistryURI()) && Objects.equals(this.eventRecordFormatAsString(), other.eventRecordFormatAsString()) && this.hasAccessConfigs() == other.hasAccessConfigs() && Objects.equals(this.accessConfigs(), other.accessConfigs()) && this.hasSchemaValidationConfigs() == other.hasSchemaValidationConfigs() && Objects.equals(this.schemaValidationConfigs(), other.schemaValidationConfigs());
    }

    public final String toString() {
        return ToString.builder((String)"KafkaSchemaRegistryConfig").add("SchemaRegistryURI", (Object)this.schemaRegistryURI()).add("EventRecordFormat", (Object)this.eventRecordFormatAsString()).add("AccessConfigs", this.hasAccessConfigs() ? this.accessConfigs() : null).add("SchemaValidationConfigs", this.hasSchemaValidationConfigs() ? this.schemaValidationConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaRegistryURI": {
                return Optional.ofNullable(clazz.cast(this.schemaRegistryURI()));
            }
            case "EventRecordFormat": {
                return Optional.ofNullable(clazz.cast(this.eventRecordFormatAsString()));
            }
            case "AccessConfigs": {
                return Optional.ofNullable(clazz.cast(this.accessConfigs()));
            }
            case "SchemaValidationConfigs": {
                return Optional.ofNullable(clazz.cast(this.schemaValidationConfigs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SchemaRegistryURI", SCHEMA_REGISTRY_URI_FIELD);
        map.put("EventRecordFormat", EVENT_RECORD_FORMAT_FIELD);
        map.put("AccessConfigs", ACCESS_CONFIGS_FIELD);
        map.put("SchemaValidationConfigs", SCHEMA_VALIDATION_CONFIGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KafkaSchemaRegistryConfig, T> g) {
        return obj -> g.apply((KafkaSchemaRegistryConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String schemaRegistryURI;
        private String eventRecordFormat;
        private List<KafkaSchemaRegistryAccessConfig> accessConfigs = DefaultSdkAutoConstructList.getInstance();
        private List<KafkaSchemaValidationConfig> schemaValidationConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KafkaSchemaRegistryConfig model) {
            this.schemaRegistryURI(model.schemaRegistryURI);
            this.eventRecordFormat(model.eventRecordFormat);
            this.accessConfigs(model.accessConfigs);
            this.schemaValidationConfigs(model.schemaValidationConfigs);
        }

        public final String getSchemaRegistryURI() {
            return this.schemaRegistryURI;
        }

        public final void setSchemaRegistryURI(String schemaRegistryURI) {
            this.schemaRegistryURI = schemaRegistryURI;
        }

        @Override
        public final Builder schemaRegistryURI(String schemaRegistryURI) {
            this.schemaRegistryURI = schemaRegistryURI;
            return this;
        }

        public final String getEventRecordFormat() {
            return this.eventRecordFormat;
        }

        public final void setEventRecordFormat(String eventRecordFormat) {
            this.eventRecordFormat = eventRecordFormat;
        }

        @Override
        public final Builder eventRecordFormat(String eventRecordFormat) {
            this.eventRecordFormat = eventRecordFormat;
            return this;
        }

        @Override
        public final Builder eventRecordFormat(SchemaRegistryEventRecordFormat eventRecordFormat) {
            this.eventRecordFormat(eventRecordFormat == null ? null : eventRecordFormat.toString());
            return this;
        }

        public final List<KafkaSchemaRegistryAccessConfig.Builder> getAccessConfigs() {
            List<KafkaSchemaRegistryAccessConfig.Builder> result = KafkaSchemaRegistryAccessConfigListCopier.copyToBuilder(this.accessConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessConfigs(Collection<KafkaSchemaRegistryAccessConfig.BuilderImpl> accessConfigs) {
            this.accessConfigs = KafkaSchemaRegistryAccessConfigListCopier.copyFromBuilder(accessConfigs);
        }

        @Override
        public final Builder accessConfigs(Collection<KafkaSchemaRegistryAccessConfig> accessConfigs) {
            this.accessConfigs = KafkaSchemaRegistryAccessConfigListCopier.copy(accessConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessConfigs(KafkaSchemaRegistryAccessConfig ... accessConfigs) {
            this.accessConfigs(Arrays.asList(accessConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessConfigs(Consumer<KafkaSchemaRegistryAccessConfig.Builder> ... accessConfigs) {
            this.accessConfigs(Stream.of(accessConfigs).map(c -> (KafkaSchemaRegistryAccessConfig)((KafkaSchemaRegistryAccessConfig.Builder)KafkaSchemaRegistryAccessConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<KafkaSchemaValidationConfig.Builder> getSchemaValidationConfigs() {
            List<KafkaSchemaValidationConfig.Builder> result = KafkaSchemaValidationConfigListCopier.copyToBuilder(this.schemaValidationConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchemaValidationConfigs(Collection<KafkaSchemaValidationConfig.BuilderImpl> schemaValidationConfigs) {
            this.schemaValidationConfigs = KafkaSchemaValidationConfigListCopier.copyFromBuilder(schemaValidationConfigs);
        }

        @Override
        public final Builder schemaValidationConfigs(Collection<KafkaSchemaValidationConfig> schemaValidationConfigs) {
            this.schemaValidationConfigs = KafkaSchemaValidationConfigListCopier.copy(schemaValidationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaValidationConfigs(KafkaSchemaValidationConfig ... schemaValidationConfigs) {
            this.schemaValidationConfigs(Arrays.asList(schemaValidationConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaValidationConfigs(Consumer<KafkaSchemaValidationConfig.Builder> ... schemaValidationConfigs) {
            this.schemaValidationConfigs(Stream.of(schemaValidationConfigs).map(c -> (KafkaSchemaValidationConfig)((KafkaSchemaValidationConfig.Builder)KafkaSchemaValidationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public KafkaSchemaRegistryConfig build() {
            return new KafkaSchemaRegistryConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KafkaSchemaRegistryConfig> {
        public Builder schemaRegistryURI(String var1);

        public Builder eventRecordFormat(String var1);

        public Builder eventRecordFormat(SchemaRegistryEventRecordFormat var1);

        public Builder accessConfigs(Collection<KafkaSchemaRegistryAccessConfig> var1);

        public Builder accessConfigs(KafkaSchemaRegistryAccessConfig ... var1);

        public Builder accessConfigs(Consumer<KafkaSchemaRegistryAccessConfig.Builder> ... var1);

        public Builder schemaValidationConfigs(Collection<KafkaSchemaValidationConfig> var1);

        public Builder schemaValidationConfigs(KafkaSchemaValidationConfig ... var1);

        public Builder schemaValidationConfigs(Consumer<KafkaSchemaValidationConfig.Builder> ... var1);
    }
}

