/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.ListOfNonEmptyStringsWithoutWhitespaceCopier;
import software.amazon.awssdk.services.firehose.model.OrcCompression;
import software.amazon.awssdk.services.firehose.model.OrcFormatVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrcSerDe
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrcSerDe> {
    private static final SdkField<Integer> STRIPE_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StripeSizeBytes").getter(OrcSerDe.getter(OrcSerDe::stripeSizeBytes)).setter(OrcSerDe.setter(Builder::stripeSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StripeSizeBytes").build()}).build();
    private static final SdkField<Integer> BLOCK_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BlockSizeBytes").getter(OrcSerDe.getter(OrcSerDe::blockSizeBytes)).setter(OrcSerDe.setter(Builder::blockSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockSizeBytes").build()}).build();
    private static final SdkField<Integer> ROW_INDEX_STRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RowIndexStride").getter(OrcSerDe.getter(OrcSerDe::rowIndexStride)).setter(OrcSerDe.setter(Builder::rowIndexStride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowIndexStride").build()}).build();
    private static final SdkField<Boolean> ENABLE_PADDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnablePadding").getter(OrcSerDe.getter(OrcSerDe::enablePadding)).setter(OrcSerDe.setter(Builder::enablePadding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePadding").build()}).build();
    private static final SdkField<Double> PADDING_TOLERANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("PaddingTolerance").getter(OrcSerDe.getter(OrcSerDe::paddingTolerance)).setter(OrcSerDe.setter(Builder::paddingTolerance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaddingTolerance").build()}).build();
    private static final SdkField<String> COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Compression").getter(OrcSerDe.getter(OrcSerDe::compressionAsString)).setter(OrcSerDe.setter(Builder::compression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compression").build()}).build();
    private static final SdkField<List<String>> BLOOM_FILTER_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BloomFilterColumns").getter(OrcSerDe.getter(OrcSerDe::bloomFilterColumns)).setter(OrcSerDe.setter(Builder::bloomFilterColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BloomFilterColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> BLOOM_FILTER_FALSE_POSITIVE_PROBABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("BloomFilterFalsePositiveProbability").getter(OrcSerDe.getter(OrcSerDe::bloomFilterFalsePositiveProbability)).setter(OrcSerDe.setter(Builder::bloomFilterFalsePositiveProbability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BloomFilterFalsePositiveProbability").build()}).build();
    private static final SdkField<Double> DICTIONARY_KEY_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DictionaryKeyThreshold").getter(OrcSerDe.getter(OrcSerDe::dictionaryKeyThreshold)).setter(OrcSerDe.setter(Builder::dictionaryKeyThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DictionaryKeyThreshold").build()}).build();
    private static final SdkField<String> FORMAT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FormatVersion").getter(OrcSerDe.getter(OrcSerDe::formatVersionAsString)).setter(OrcSerDe.setter(Builder::formatVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRIPE_SIZE_BYTES_FIELD, BLOCK_SIZE_BYTES_FIELD, ROW_INDEX_STRIDE_FIELD, ENABLE_PADDING_FIELD, PADDING_TOLERANCE_FIELD, COMPRESSION_FIELD, BLOOM_FILTER_COLUMNS_FIELD, BLOOM_FILTER_FALSE_POSITIVE_PROBABILITY_FIELD, DICTIONARY_KEY_THRESHOLD_FIELD, FORMAT_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrcSerDe.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer stripeSizeBytes;
    private final Integer blockSizeBytes;
    private final Integer rowIndexStride;
    private final Boolean enablePadding;
    private final Double paddingTolerance;
    private final String compression;
    private final List<String> bloomFilterColumns;
    private final Double bloomFilterFalsePositiveProbability;
    private final Double dictionaryKeyThreshold;
    private final String formatVersion;

    private OrcSerDe(BuilderImpl builder) {
        this.stripeSizeBytes = builder.stripeSizeBytes;
        this.blockSizeBytes = builder.blockSizeBytes;
        this.rowIndexStride = builder.rowIndexStride;
        this.enablePadding = builder.enablePadding;
        this.paddingTolerance = builder.paddingTolerance;
        this.compression = builder.compression;
        this.bloomFilterColumns = builder.bloomFilterColumns;
        this.bloomFilterFalsePositiveProbability = builder.bloomFilterFalsePositiveProbability;
        this.dictionaryKeyThreshold = builder.dictionaryKeyThreshold;
        this.formatVersion = builder.formatVersion;
    }

    public final Integer stripeSizeBytes() {
        return this.stripeSizeBytes;
    }

    public final Integer blockSizeBytes() {
        return this.blockSizeBytes;
    }

    public final Integer rowIndexStride() {
        return this.rowIndexStride;
    }

    public final Boolean enablePadding() {
        return this.enablePadding;
    }

    public final Double paddingTolerance() {
        return this.paddingTolerance;
    }

    public final OrcCompression compression() {
        return OrcCompression.fromValue(this.compression);
    }

    public final String compressionAsString() {
        return this.compression;
    }

    public final boolean hasBloomFilterColumns() {
        return this.bloomFilterColumns != null && !(this.bloomFilterColumns instanceof SdkAutoConstructList);
    }

    public final List<String> bloomFilterColumns() {
        return this.bloomFilterColumns;
    }

    public final Double bloomFilterFalsePositiveProbability() {
        return this.bloomFilterFalsePositiveProbability;
    }

    public final Double dictionaryKeyThreshold() {
        return this.dictionaryKeyThreshold;
    }

    public final OrcFormatVersion formatVersion() {
        return OrcFormatVersion.fromValue(this.formatVersion);
    }

    public final String formatVersionAsString() {
        return this.formatVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stripeSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowIndexStride());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePadding());
        hashCode = 31 * hashCode + Objects.hashCode(this.paddingTolerance());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBloomFilterColumns() ? this.bloomFilterColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.bloomFilterFalsePositiveProbability());
        hashCode = 31 * hashCode + Objects.hashCode(this.dictionaryKeyThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatVersionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrcSerDe)) {
            return false;
        }
        OrcSerDe other = (OrcSerDe)obj;
        return Objects.equals(this.stripeSizeBytes(), other.stripeSizeBytes()) && Objects.equals(this.blockSizeBytes(), other.blockSizeBytes()) && Objects.equals(this.rowIndexStride(), other.rowIndexStride()) && Objects.equals(this.enablePadding(), other.enablePadding()) && Objects.equals(this.paddingTolerance(), other.paddingTolerance()) && Objects.equals(this.compressionAsString(), other.compressionAsString()) && this.hasBloomFilterColumns() == other.hasBloomFilterColumns() && Objects.equals(this.bloomFilterColumns(), other.bloomFilterColumns()) && Objects.equals(this.bloomFilterFalsePositiveProbability(), other.bloomFilterFalsePositiveProbability()) && Objects.equals(this.dictionaryKeyThreshold(), other.dictionaryKeyThreshold()) && Objects.equals(this.formatVersionAsString(), other.formatVersionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OrcSerDe").add("StripeSizeBytes", (Object)this.stripeSizeBytes()).add("BlockSizeBytes", (Object)this.blockSizeBytes()).add("RowIndexStride", (Object)this.rowIndexStride()).add("EnablePadding", (Object)this.enablePadding()).add("PaddingTolerance", (Object)this.paddingTolerance()).add("Compression", (Object)this.compressionAsString()).add("BloomFilterColumns", this.hasBloomFilterColumns() ? this.bloomFilterColumns() : null).add("BloomFilterFalsePositiveProbability", (Object)this.bloomFilterFalsePositiveProbability()).add("DictionaryKeyThreshold", (Object)this.dictionaryKeyThreshold()).add("FormatVersion", (Object)this.formatVersionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StripeSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.stripeSizeBytes()));
            }
            case "BlockSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.blockSizeBytes()));
            }
            case "RowIndexStride": {
                return Optional.ofNullable(clazz.cast(this.rowIndexStride()));
            }
            case "EnablePadding": {
                return Optional.ofNullable(clazz.cast(this.enablePadding()));
            }
            case "PaddingTolerance": {
                return Optional.ofNullable(clazz.cast(this.paddingTolerance()));
            }
            case "Compression": {
                return Optional.ofNullable(clazz.cast(this.compressionAsString()));
            }
            case "BloomFilterColumns": {
                return Optional.ofNullable(clazz.cast(this.bloomFilterColumns()));
            }
            case "BloomFilterFalsePositiveProbability": {
                return Optional.ofNullable(clazz.cast(this.bloomFilterFalsePositiveProbability()));
            }
            case "DictionaryKeyThreshold": {
                return Optional.ofNullable(clazz.cast(this.dictionaryKeyThreshold()));
            }
            case "FormatVersion": {
                return Optional.ofNullable(clazz.cast(this.formatVersionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StripeSizeBytes", STRIPE_SIZE_BYTES_FIELD);
        map.put("BlockSizeBytes", BLOCK_SIZE_BYTES_FIELD);
        map.put("RowIndexStride", ROW_INDEX_STRIDE_FIELD);
        map.put("EnablePadding", ENABLE_PADDING_FIELD);
        map.put("PaddingTolerance", PADDING_TOLERANCE_FIELD);
        map.put("Compression", COMPRESSION_FIELD);
        map.put("BloomFilterColumns", BLOOM_FILTER_COLUMNS_FIELD);
        map.put("BloomFilterFalsePositiveProbability", BLOOM_FILTER_FALSE_POSITIVE_PROBABILITY_FIELD);
        map.put("DictionaryKeyThreshold", DICTIONARY_KEY_THRESHOLD_FIELD);
        map.put("FormatVersion", FORMAT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrcSerDe, T> g) {
        return obj -> g.apply((OrcSerDe)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer stripeSizeBytes;
        private Integer blockSizeBytes;
        private Integer rowIndexStride;
        private Boolean enablePadding;
        private Double paddingTolerance;
        private String compression;
        private List<String> bloomFilterColumns = DefaultSdkAutoConstructList.getInstance();
        private Double bloomFilterFalsePositiveProbability;
        private Double dictionaryKeyThreshold;
        private String formatVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(OrcSerDe model) {
            this.stripeSizeBytes(model.stripeSizeBytes);
            this.blockSizeBytes(model.blockSizeBytes);
            this.rowIndexStride(model.rowIndexStride);
            this.enablePadding(model.enablePadding);
            this.paddingTolerance(model.paddingTolerance);
            this.compression(model.compression);
            this.bloomFilterColumns(model.bloomFilterColumns);
            this.bloomFilterFalsePositiveProbability(model.bloomFilterFalsePositiveProbability);
            this.dictionaryKeyThreshold(model.dictionaryKeyThreshold);
            this.formatVersion(model.formatVersion);
        }

        public final Integer getStripeSizeBytes() {
            return this.stripeSizeBytes;
        }

        public final void setStripeSizeBytes(Integer stripeSizeBytes) {
            this.stripeSizeBytes = stripeSizeBytes;
        }

        @Override
        public final Builder stripeSizeBytes(Integer stripeSizeBytes) {
            this.stripeSizeBytes = stripeSizeBytes;
            return this;
        }

        public final Integer getBlockSizeBytes() {
            return this.blockSizeBytes;
        }

        public final void setBlockSizeBytes(Integer blockSizeBytes) {
            this.blockSizeBytes = blockSizeBytes;
        }

        @Override
        public final Builder blockSizeBytes(Integer blockSizeBytes) {
            this.blockSizeBytes = blockSizeBytes;
            return this;
        }

        public final Integer getRowIndexStride() {
            return this.rowIndexStride;
        }

        public final void setRowIndexStride(Integer rowIndexStride) {
            this.rowIndexStride = rowIndexStride;
        }

        @Override
        public final Builder rowIndexStride(Integer rowIndexStride) {
            this.rowIndexStride = rowIndexStride;
            return this;
        }

        public final Boolean getEnablePadding() {
            return this.enablePadding;
        }

        public final void setEnablePadding(Boolean enablePadding) {
            this.enablePadding = enablePadding;
        }

        @Override
        public final Builder enablePadding(Boolean enablePadding) {
            this.enablePadding = enablePadding;
            return this;
        }

        public final Double getPaddingTolerance() {
            return this.paddingTolerance;
        }

        public final void setPaddingTolerance(Double paddingTolerance) {
            this.paddingTolerance = paddingTolerance;
        }

        @Override
        public final Builder paddingTolerance(Double paddingTolerance) {
            this.paddingTolerance = paddingTolerance;
            return this;
        }

        public final String getCompression() {
            return this.compression;
        }

        public final void setCompression(String compression) {
            this.compression = compression;
        }

        @Override
        public final Builder compression(String compression) {
            this.compression = compression;
            return this;
        }

        @Override
        public final Builder compression(OrcCompression compression) {
            this.compression(compression == null ? null : compression.toString());
            return this;
        }

        public final Collection<String> getBloomFilterColumns() {
            if (this.bloomFilterColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bloomFilterColumns;
        }

        public final void setBloomFilterColumns(Collection<String> bloomFilterColumns) {
            this.bloomFilterColumns = ListOfNonEmptyStringsWithoutWhitespaceCopier.copy(bloomFilterColumns);
        }

        @Override
        public final Builder bloomFilterColumns(Collection<String> bloomFilterColumns) {
            this.bloomFilterColumns = ListOfNonEmptyStringsWithoutWhitespaceCopier.copy(bloomFilterColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bloomFilterColumns(String ... bloomFilterColumns) {
            this.bloomFilterColumns(Arrays.asList(bloomFilterColumns));
            return this;
        }

        public final Double getBloomFilterFalsePositiveProbability() {
            return this.bloomFilterFalsePositiveProbability;
        }

        public final void setBloomFilterFalsePositiveProbability(Double bloomFilterFalsePositiveProbability) {
            this.bloomFilterFalsePositiveProbability = bloomFilterFalsePositiveProbability;
        }

        @Override
        public final Builder bloomFilterFalsePositiveProbability(Double bloomFilterFalsePositiveProbability) {
            this.bloomFilterFalsePositiveProbability = bloomFilterFalsePositiveProbability;
            return this;
        }

        public final Double getDictionaryKeyThreshold() {
            return this.dictionaryKeyThreshold;
        }

        public final void setDictionaryKeyThreshold(Double dictionaryKeyThreshold) {
            this.dictionaryKeyThreshold = dictionaryKeyThreshold;
        }

        @Override
        public final Builder dictionaryKeyThreshold(Double dictionaryKeyThreshold) {
            this.dictionaryKeyThreshold = dictionaryKeyThreshold;
            return this;
        }

        public final String getFormatVersion() {
            return this.formatVersion;
        }

        public final void setFormatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
        }

        @Override
        public final Builder formatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
            return this;
        }

        @Override
        public final Builder formatVersion(OrcFormatVersion formatVersion) {
            this.formatVersion(formatVersion == null ? null : formatVersion.toString());
            return this;
        }

        public OrcSerDe build() {
            return new OrcSerDe(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrcSerDe> {
        public Builder stripeSizeBytes(Integer var1);

        public Builder blockSizeBytes(Integer var1);

        public Builder rowIndexStride(Integer var1);

        public Builder enablePadding(Boolean var1);

        public Builder paddingTolerance(Double var1);

        public Builder compression(String var1);

        public Builder compression(OrcCompression var1);

        public Builder bloomFilterColumns(Collection<String> var1);

        public Builder bloomFilterColumns(String ... var1);

        public Builder bloomFilterFalsePositiveProbability(Double var1);

        public Builder dictionaryKeyThreshold(Double var1);

        public Builder formatVersion(String var1);

        public Builder formatVersion(OrcFormatVersion var1);
    }
}

