/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockruntime.model.BedrockRuntimeResponse;
import software.amazon.awssdk.services.bedrockruntime.model.PerformanceConfigLatency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeModelWithResponseStreamResponse
extends BedrockRuntimeResponse
implements ToCopyableBuilder<Builder, InvokeModelWithResponseStreamResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(InvokeModelWithResponseStreamResponse.getter(InvokeModelWithResponseStreamResponse::contentType)).setter(InvokeModelWithResponseStreamResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-Content-Type").build()}).build();
    private static final SdkField<String> PERFORMANCE_CONFIG_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("performanceConfigLatency").getter(InvokeModelWithResponseStreamResponse.getter(InvokeModelWithResponseStreamResponse::performanceConfigLatencyAsString)).setter(InvokeModelWithResponseStreamResponse.setter(Builder::performanceConfigLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-PerformanceConfig-Latency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, PERFORMANCE_CONFIG_LATENCY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeModelWithResponseStreamResponse.memberNameToFieldInitializer();
    private final String contentType;
    private final String performanceConfigLatency;

    private InvokeModelWithResponseStreamResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.performanceConfigLatency = builder.performanceConfigLatency;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final PerformanceConfigLatency performanceConfigLatency() {
        return PerformanceConfigLatency.fromValue(this.performanceConfigLatency);
    }

    public final String performanceConfigLatencyAsString() {
        return this.performanceConfigLatency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceConfigLatencyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeModelWithResponseStreamResponse)) {
            return false;
        }
        InvokeModelWithResponseStreamResponse other = (InvokeModelWithResponseStreamResponse)((Object)obj);
        return Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.performanceConfigLatencyAsString(), other.performanceConfigLatencyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeModelWithResponseStreamResponse").add("ContentType", (Object)this.contentType()).add("PerformanceConfigLatency", (Object)this.performanceConfigLatencyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "performanceConfigLatency": {
                return Optional.ofNullable(clazz.cast(this.performanceConfigLatencyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("X-Amzn-Bedrock-Content-Type", CONTENT_TYPE_FIELD);
        map.put("X-Amzn-Bedrock-PerformanceConfig-Latency", PERFORMANCE_CONFIG_LATENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeModelWithResponseStreamResponse, T> g) {
        return obj -> g.apply((InvokeModelWithResponseStreamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRuntimeResponse.BuilderImpl
    implements Builder {
        private String contentType;
        private String performanceConfigLatency;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeModelWithResponseStreamResponse model) {
            super(model);
            this.contentType(model.contentType);
            this.performanceConfigLatency(model.performanceConfigLatency);
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getPerformanceConfigLatency() {
            return this.performanceConfigLatency;
        }

        public final void setPerformanceConfigLatency(String performanceConfigLatency) {
            this.performanceConfigLatency = performanceConfigLatency;
        }

        @Override
        public final Builder performanceConfigLatency(String performanceConfigLatency) {
            this.performanceConfigLatency = performanceConfigLatency;
            return this;
        }

        @Override
        public final Builder performanceConfigLatency(PerformanceConfigLatency performanceConfigLatency) {
            this.performanceConfigLatency(performanceConfigLatency == null ? null : performanceConfigLatency.toString());
            return this;
        }

        @Override
        public InvokeModelWithResponseStreamResponse build() {
            return new InvokeModelWithResponseStreamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeModelWithResponseStreamResponse> {
        public Builder contentType(String var1);

        public Builder performanceConfigLatency(String var1);

        public Builder performanceConfigLatency(PerformanceConfigLatency var1);
    }
}

