/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.NameVirtualHostHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.error.SimpleErrorPageHandler;
import io.undertow.util.Headers;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.UndertowListener;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class Server
implements Service<Server> {
    private final Consumer<Server> serverConsumer;
    private final Supplier<ServletContainerService> servletContainer;
    private final Supplier<UndertowService> undertowService;
    private final String defaultHost;
    private final String name;
    private final NameVirtualHostHandler virtualHostHandler = new NameVirtualHostHandler();
    private final List<ListenerService> listeners = new CopyOnWriteArrayList<ListenerService>();
    private final Set<Host> hosts = new CopyOnWriteArraySet<Host>();
    private final HashMap<Integer, Integer> securePortMappings = new HashMap();
    private volatile HttpHandler root;

    protected Server(Consumer<Server> serverConsumer, Supplier<ServletContainerService> servletContainer, Supplier<UndertowService> undertowService, String name, String defaultHost) {
        this.serverConsumer = serverConsumer;
        this.servletContainer = servletContainer;
        this.undertowService = undertowService;
        this.name = name;
        this.defaultHost = defaultHost;
    }

    public void start(StartContext startContext) throws StartException {
        this.root = this.virtualHostHandler;
        this.root = new SimpleErrorPageHandler(this.root);
        this.root = new CanonicalPathHandler(this.root);
        this.root = new DefaultHostHandler(this.root);
        UndertowLogger.ROOT_LOGGER.startedServer(this.name);
        this.undertowService.get().registerServer(this);
        this.serverConsumer.accept(this);
    }

    public void stop(StopContext stopContext) {
        this.serverConsumer.accept(null);
        this.undertowService.get().unregisterServer(this);
    }

    public Server getValue() {
        return this;
    }

    protected void registerListener(ListenerService listener) {
        this.listeners.add(listener);
        if (!listener.isSecure()) {
            SocketBinding redirectBinding;
            SocketBinding binding = (SocketBinding)listener.getBinding().get();
            SocketBinding socketBinding = redirectBinding = listener.getRedirectSocket() != null ? (SocketBinding)listener.getRedirectSocket().get() : null;
            if (redirectBinding != null) {
                this.securePortMappings.put(binding.getAbsolutePort(), redirectBinding.getAbsolutePort());
            } else {
                this.securePortMappings.put(binding.getAbsolutePort(), -1);
            }
        }
    }

    protected void unregisterListener(ListenerService listener) {
        this.listeners.remove(listener);
        if (!listener.isSecure()) {
            SocketBinding binding = (SocketBinding)listener.getBinding().get();
            this.securePortMappings.remove(binding.getAbsolutePort());
        }
    }

    protected void registerHost(Host host) {
        this.hosts.add(host);
        for (String hostName : host.getAllAliases()) {
            this.virtualHostHandler.addHost(hostName, host.getRootHandler());
        }
        if (host.getName().equals(this.getDefaultHost())) {
            this.virtualHostHandler.setDefaultHandler(host.getRootHandler());
        }
    }

    protected void unregisterHost(Host host) {
        for (String hostName : host.getAllAliases()) {
            this.virtualHostHandler.removeHost(hostName);
            this.hosts.remove(host);
        }
        if (host.getName().equals(this.getDefaultHost())) {
            this.virtualHostHandler.setDefaultHandler((HttpHandler)ResponseCodeHandler.HANDLE_404);
        }
    }

    public int lookupSecurePort(int unsecurePort) {
        return this.securePortMappings.get(unsecurePort);
    }

    public ServletContainerService getServletContainer() {
        return this.servletContainer.get();
    }

    protected HttpHandler getRoot() {
        return this.root;
    }

    UndertowService getUndertowService() {
        return this.undertowService.get();
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public Set<Host> getHosts() {
        return Collections.unmodifiableSet(this.hosts);
    }

    public List<UndertowListener> getListeners() {
        return this.listeners;
    }

    public String getRoute() {
        UndertowService service = this.undertowService.get();
        String defaultServerRoute = service.getInstanceId();
        if (service.isObfuscateSessionRoute()) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(this.name.getBytes(StandardCharsets.UTF_8));
                byte[] digestedBytes = md.digest(defaultServerRoute.getBytes(StandardCharsets.UTF_8));
                Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
                String encodedRoute = new String(encoder.encode(digestedBytes), StandardCharsets.UTF_8);
                UndertowLogger.ROOT_LOGGER.obfuscatedSessionRoute(encodedRoute, defaultServerRoute);
                return encodedRoute;
            }
            catch (NoSuchAlgorithmException e) {
                UndertowLogger.ROOT_LOGGER.unableToObfuscateSessionRoute(defaultServerRoute, e);
            }
        }
        return this.name.equals(service.getDefaultServer()) ? defaultServerRoute : String.join((CharSequence)"-", defaultServerRoute, this.name);
    }

    private final class DefaultHostHandler
    implements HttpHandler {
        private final HttpHandler next;

        private DefaultHostHandler(HttpHandler next) {
            this.next = next;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (!exchange.getRequestHeaders().contains(Headers.HOST)) {
                exchange.getRequestHeaders().put(Headers.HOST, Server.this.defaultHost + ":" + exchange.getDestinationAddress().getPort());
            }
            this.next.handleRequest(exchange);
        }
    }
}

